/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.velocity;

import com.velocitypowered.api.proxy.Player;
import dev.brighten.antivpn.api.APIPlayer;
import dev.brighten.antivpn.api.PlayerExecutor;
import dev.brighten.antivpn.velocity.VelocityPlayer;
import dev.brighten.antivpn.velocity.VelocityPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class VelocityPlayerExecutor
implements PlayerExecutor {
    private final Map<UUID, VelocityPlayer> cachedPlayers = new HashMap<UUID, VelocityPlayer>();

    @Override
    public Optional<APIPlayer> getPlayer(String name) {
        Optional player = VelocityPlugin.INSTANCE.getServer().getPlayer(name);
        return player.map(value -> this.cachedPlayers.computeIfAbsent(value.getUniqueId(), key -> new VelocityPlayer((Player)value)));
    }

    @Override
    public Optional<APIPlayer> getPlayer(UUID uuid) {
        Optional player = VelocityPlugin.INSTANCE.getServer().getPlayer(uuid);
        return player.map(value -> this.cachedPlayers.computeIfAbsent(value.getUniqueId(), key -> new VelocityPlayer((Player)value)));
    }

    @Override
    public void unloadPlayer(UUID uuid) {
        this.cachedPlayers.remove(uuid);
    }

    @Override
    public List<APIPlayer> getOnlinePlayers() {
        return VelocityPlugin.INSTANCE.getServer().getAllPlayers().stream().map(pl -> this.cachedPlayers.computeIfAbsent(pl.getUniqueId(), key -> new VelocityPlayer((Player)pl))).collect(Collectors.toList());
    }
}

