/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.command.Command;
import dev.brighten.antivpn.database.VPNDatabase;
import dev.brighten.antivpn.database.local.H2VPN;
import dev.brighten.antivpn.database.mongo.MongoVPN;
import dev.brighten.antivpn.database.sql.MySqlVPN;
import dev.brighten.antivpn.velocity.VelocityListener;
import dev.brighten.antivpn.velocity.VelocityPlayerExecutor;
import dev.brighten.antivpn.velocity.command.VelocityCommand;
import dev.brighten.antivpn.velocity.org.bstats.charts.SimplePie;
import dev.brighten.antivpn.velocity.org.bstats.velocity.Metrics;
import java.nio.file.Path;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Plugin(id="kaurivpn", name="KauriVPN", version="1.7.1", authors={"funkemunky"})
public class VelocityPlugin {
    private final ProxyServer server;
    private final Logger logger;
    private final Metrics.Factory metricsFactory;
    private final Path configDir;
    @Nullable
    private Metrics metrics;
    public static VelocityPlugin INSTANCE;

    @Inject
    public VelocityPlugin(ProxyServer server, Logger logger, @DataDirectory Path path, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.configDir = path;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onInit(ProxyInitializeEvent event) {
        INSTANCE = this;
        this.logger.info("Loading config...");
        this.logger.info("Starting AntiVPN services...");
        AntiVPN.start(new VelocityListener(), new VelocityPlayerExecutor(), this.configDir.toFile());
        if (AntiVPN.getInstance().getVpnConfig().metrics()) {
            this.logger.info("Starting metrics...");
            this.metrics = this.metricsFactory.make(this, 12791);
            this.metrics.addCustomChart(new SimplePie("database_used", this::getDatabaseType));
        }
        this.logger.info("Registering commands...");
        for (Command command : AntiVPN.getInstance().getCommands()) {
            this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(command.name()).aliases(command.aliases()).build(), (com.velocitypowered.api.command.Command)new VelocityCommand(command));
        }
    }

    @Subscribe
    public void onDisable(ProxyShutdownEvent event) {
        this.logger.info("Disabling AntiVPN...");
        AntiVPN.getInstance().getExecutor().log("Disabling AntiVPN...", new Object[0]);
        if (AntiVPN.getInstance().getDatabase() != null) {
            AntiVPN.getInstance().stop();
        }
        if (this.metrics != null) {
            this.metrics = null;
        }
        INSTANCE = null;
        this.logger.info("Disabled AntiVPN.");
    }

    private String getDatabaseType() {
        VPNDatabase database = AntiVPN.getInstance().getDatabase();
        if (database instanceof H2VPN) {
            return "H2";
        }
        if (database instanceof MySqlVPN) {
            return "MySQL";
        }
        if (database instanceof MongoVPN) {
            return "MongoDB";
        }
        return "No-Database";
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    public Path getConfigDir() {
        return this.configDir;
    }

    @Nullable
    public Metrics getMetrics() {
        return this.metrics;
    }
}

