/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.velocity.command;

import com.velocitypowered.api.command.CommandInvocation;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.command.Command;
import dev.brighten.antivpn.velocity.command.VelocityCommandExecutor;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class VelocityCommand
implements SimpleCommand {
    private final Command command;

    public VelocityCommand(Command command) {
        this.command = command;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        if (!invocation.source().hasPermission("antivpn.command.*") && !invocation.source().hasPermission(this.command.permission())) {
            invocation.source().sendMessage((Component)LegacyComponentSerializer.builder().character('&').build().deserialize(AntiVPN.getInstance().getMessageHandler().getString("no-permission").getMessage()));
            return;
        }
        Command[] children = this.command.children();
        String[] args = (String[])invocation.arguments();
        if (children.length > 0 && args.length > 0) {
            for (Command child : children) {
                if (!child.name().equalsIgnoreCase(args[0]) && !Arrays.stream(child.aliases()).anyMatch(alias -> alias.equalsIgnoreCase(args[0]))) continue;
                if (!sender.hasPermission("antivpn.command.*") && !sender.hasPermission(child.permission())) {
                    invocation.source().sendMessage((Component)LegacyComponentSerializer.builder().character('&').build().deserialize(AntiVPN.getInstance().getMessageHandler().getString("no-permission").getMessage()));
                    invocation.source().sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text((String)"No permission").toBuilder()).color(TextColor.color((int)255, (int)0, (int)0))).build());
                    return;
                }
                sender.sendMessage((Component)LegacyComponentSerializer.builder().character('&').build().deserialize(child.execute(new VelocityCommandExecutor(sender), (String[])IntStream.range(0, args.length - 1).mapToObj(i -> args[i + 1]).toArray(String[]::new))));
                return;
            }
        }
        sender.sendMessage((Component)LegacyComponentSerializer.builder().character('&').build().deserialize(this.command.execute(new VelocityCommandExecutor(sender), args)));
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        Command[] children = this.command.children();
        if (children.length > 0 && args.length > 0) {
            for (Command child : children) {
                if (!child.name().equalsIgnoreCase(args[0]) && !Arrays.stream(child.aliases()).anyMatch(alias2 -> alias2.equalsIgnoreCase(args[0]))) continue;
                return child.tabComplete(new VelocityCommandExecutor(sender), "alias", (String[])IntStream.range(0, args.length - 1).mapToObj(i -> args[i + 1]).toArray(String[]::new));
            }
        } else if (children.length > 0) {
            return Arrays.stream(children).map(Command::name).collect(Collectors.toList());
        }
        return this.command.tabComplete(new VelocityCommandExecutor(sender), "alias", args);
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.supplyAsync(() -> this.suggest(invocation));
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return super.hasPermission((CommandInvocation)invocation);
    }
}

