/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.web.objects;

import dev.brighten.antivpn.utils.json.JSONException;
import dev.brighten.antivpn.utils.json.JSONObject;

public class QueryResponse {
    private boolean validPlan;
    private String planType;
    private long queries;
    private long queriesMax;

    public static QueryResponse fromJson(JSONObject object) throws JSONException {
        boolean validPlan = object.getBoolean("validPlan");
        if (!validPlan) {
            return QueryResponse.builder().validPlan(false).build();
        }
        return QueryResponse.builder().validPlan(object.getBoolean("validPlan")).planType(object.getString("planType")).queries(object.getLong("queries")).queriesMax(object.getLong("queryLimit")).build();
    }

    QueryResponse(boolean validPlan, String planType, long queries, long queriesMax) {
        this.validPlan = validPlan;
        this.planType = planType;
        this.queries = queries;
        this.queriesMax = queriesMax;
    }

    public static QueryResponseBuilder builder() {
        return new QueryResponseBuilder();
    }

    public QueryResponseBuilder toBuilder() {
        return new QueryResponseBuilder().validPlan(this.validPlan).planType(this.planType).queries(this.queries).queriesMax(this.queriesMax);
    }

    public boolean isValidPlan() {
        return this.validPlan;
    }

    public String getPlanType() {
        return this.planType;
    }

    public long getQueries() {
        return this.queries;
    }

    public long getQueriesMax() {
        return this.queriesMax;
    }

    public void setValidPlan(boolean validPlan) {
        this.validPlan = validPlan;
    }

    public void setPlanType(String planType) {
        this.planType = planType;
    }

    public void setQueries(long queries) {
        this.queries = queries;
    }

    public void setQueriesMax(long queriesMax) {
        this.queriesMax = queriesMax;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValidPlan() != other.isValidPlan()) {
            return false;
        }
        if (this.getQueries() != other.getQueries()) {
            return false;
        }
        if (this.getQueriesMax() != other.getQueriesMax()) {
            return false;
        }
        String this$planType = this.getPlanType();
        String other$planType = other.getPlanType();
        return !(this$planType == null ? other$planType != null : !this$planType.equals(other$planType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValidPlan() ? 79 : 97);
        long $queries = this.getQueries();
        result = result * 59 + (int)($queries >>> 32 ^ $queries);
        long $queriesMax = this.getQueriesMax();
        result = result * 59 + (int)($queriesMax >>> 32 ^ $queriesMax);
        String $planType = this.getPlanType();
        result = result * 59 + ($planType == null ? 43 : $planType.hashCode());
        return result;
    }

    public String toString() {
        return "QueryResponse(validPlan=" + this.isValidPlan() + ", planType=" + this.getPlanType() + ", queries=" + this.getQueries() + ", queriesMax=" + this.getQueriesMax() + ")";
    }

    public static class QueryResponseBuilder {
        private boolean validPlan;
        private String planType;
        private long queries;
        private long queriesMax;

        QueryResponseBuilder() {
        }

        public QueryResponseBuilder validPlan(boolean validPlan) {
            this.validPlan = validPlan;
            return this;
        }

        public QueryResponseBuilder planType(String planType) {
            this.planType = planType;
            return this;
        }

        public QueryResponseBuilder queries(long queries) {
            this.queries = queries;
            return this;
        }

        public QueryResponseBuilder queriesMax(long queriesMax) {
            this.queriesMax = queriesMax;
            return this;
        }

        public QueryResponse build() {
            return new QueryResponse(this.validPlan, this.planType, this.queries, this.queriesMax);
        }

        public String toString() {
            return "QueryResponse.QueryResponseBuilder(validPlan=" + this.validPlan + ", planType=" + this.planType + ", queries=" + this.queries + ", queriesMax=" + this.queriesMax + ")";
        }
    }
}

