/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.antiRedstoneLag;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private int chunkThreshold;
    private int blockThreshold;
    private Set<Material> redstoneMaterials;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.chunkThreshold = config.getInt("chunk-threshold", 500);
        this.blockThreshold = config.getInt("block-threshold", 15);
        this.redstoneMaterials = new HashSet<Material>();
        for (String materialName : config.getStringList("redstone-components")) {
            try {
                this.redstoneMaterials.add(Material.valueOf((String)materialName));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material: " + materialName);
            }
        }
    }

    public int getChunkThreshold() {
        return this.chunkThreshold;
    }

    public int getBlockThreshold() {
        return this.blockThreshold;
    }

    public Set<Material> getRedstoneMaterials() {
        return this.redstoneMaterials;
    }
}

