/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.antiRedstoneLag;

import java.util.HashMap;
import java.util.Map;
import org.ayosynk.antiRedstoneLag.ConfigManager;
import org.bukkit.Chunk;
import org.bukkit.Location;

public class CounterManager {
    private final Map<Chunk, Integer> chunkCounters = new HashMap<Chunk, Integer>();
    private final Map<Location, Integer> blockCounters = new HashMap<Location, Integer>();
    private final ConfigManager configManager;

    public CounterManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void incrementCounters(Chunk chunk, Location location) {
        this.chunkCounters.put(chunk, this.chunkCounters.getOrDefault(chunk, 0) + 1);
        this.blockCounters.put(location, this.blockCounters.getOrDefault(location, 0) + 1);
    }

    public boolean shouldDisable(Chunk chunk, Location location) {
        return this.chunkCounters.getOrDefault(chunk, 0) > this.configManager.getChunkThreshold() && this.blockCounters.getOrDefault(location, 0) > this.configManager.getBlockThreshold();
    }

    public void resetCounters() {
        this.chunkCounters.clear();
        this.blockCounters.clear();
    }
}

