/*
 * Decompiled with CFR 0.152.
 */
package invasivezombies.goal;

import invasivezombies.VersionHelper;
import invasivezombies.config.ModConfig;
import invasivezombies.goal.KeepTargetGoal;
import invasivezombies.mixin.MobEntityAccessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1409;
import net.minecraft.class_1642;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockBreakGoal
extends class_1352 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"invasivezombies");
    private static final ModConfig.ZombieSettings settings = ModConfig.getZombieSettings();
    private static final float MINING_SPEED = settings.getMiningSpeed();
    private static final float HORIZONTAL_MINING_RANGE = 2.0f;
    private static final float VERTICAL_MINING_RANGE = 3.0f;
    private final class_1642 zombie;
    private class_2338 targetBlock;
    private int miningTicks;
    private float breakProgress;
    private int noPathTicks;
    private int failedBlockFindings;
    private int blockFindingIdleTicks;
    private int prevfailedBlockFindings;
    private int prevblockFindingIdleTicks;
    private final boolean debug = false;
    private final boolean blockdebug = false;
    private class_11 cachedPath = null;
    private int pathUpdateCounter = 0;
    private static final int PATH_UPDATE_INTERVAL = 3;
    private class_2338 lastTargetPos = null;
    private static final int MAX_MINING_POSITIONS = 50;
    private static final int MAX_IDLE_TICKS_DURING_BLOCK_FINDING = 20;
    private static final Set<class_2338> currentlyMining = Collections.newSetFromMap(new ConcurrentHashMap(50));
    private static final Map<class_1642, BlockBreakGoal> goalMap = new ConcurrentHashMap<class_1642, BlockBreakGoal>();
    private static final Map<String, class_6862<class_2248>> tagCache = new ConcurrentHashMap<String, class_6862<class_2248>>();
    private static volatile Set<String> breakableBlocks;
    private static final Object INIT_LOCK;

    public BlockBreakGoal(class_1642 zombie) {
        this.zombie = zombie;
        goalMap.put(zombie, this);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
        this.loadBreakableBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBreakableBlocks() {
        Object object = INIT_LOCK;
        synchronized (object) {
            if (breakableBlocks == null) {
                breakableBlocks = ModConfig.getMineableBlocks();
            }
        }
    }

    public static void resetAllMiningStates() {
        currentlyMining.clear();
    }

    public boolean method_6264() {
        class_2338 blockToBreak;
        if (this.zombie == null || this.zombie.method_5968() == null) {
            return false;
        }
        if (this.zombie.method_6109() && !settings.getBabyZombiesEnabled()) {
            return false;
        }
        if (this.zombie.method_5942().method_23966()) {
            return false;
        }
        class_11 path = this.getCachedPathToTarget();
        if (path != null && path.method_21655() && path.method_46()) {
            return false;
        }
        if (path != null && !path.method_21655() && (blockToBreak = this.findBlockToBreak()) != null && !currentlyMining.contains(blockToBreak)) {
            this.targetBlock = blockToBreak;
            currentlyMining.add(this.targetBlock);
            this.miningTicks = 0;
            this.breakProgress = 0.0f;
            this.blockFindingIdleTicks = 0;
            return true;
        }
        return false;
    }

    private boolean isBlockAccessibleFromDirection(class_1937 world, class_2338 targetBlock, class_2338 startPos) {
        class_243 startPosBottom = new class_243((double)startPos.method_10263() + (double)this.zombie.method_17681() / 2.0, (double)startPos.method_10264() + 0.5, (double)startPos.method_10260() + (double)this.zombie.method_17681() / 2.0);
        class_243 startPosTop = new class_243((double)startPos.method_10263() + (double)this.zombie.method_17681() / 2.0, (double)((float)startPos.method_10264() + this.zombie.method_17682()) - 0.5, (double)startPos.method_10260() + (double)this.zombie.method_17681() / 2.0);
        class_243 targetPos = new class_243((double)targetBlock.method_10263() + 0.5, (double)targetBlock.method_10264() + 0.5, (double)targetBlock.method_10260() + 0.5);
        return this.hasLineOfSight(world, startPosBottom, targetPos, targetBlock) || this.hasLineOfSight(world, startPosTop, targetPos, targetBlock);
    }

    private boolean hasLineOfSight(class_1937 world, class_243 start, class_243 end, class_2338 targetBlock) {
        double distance = start.method_1022(end);
        class_243 ray = end.method_1020(start).method_1029();
        for (double d = 0.3; d < distance - 0.3; d += 0.3) {
            class_243 checkPoint = start.method_1019(ray.method_1021(d));
            class_2338 checkPos = new class_2338((int)Math.floor(checkPoint.field_1352), (int)Math.floor(checkPoint.field_1351), (int)Math.floor(checkPoint.field_1350));
            if (checkPos.equals((Object)targetBlock) || world.method_8320(checkPos).method_26215()) continue;
            return false;
        }
        return true;
    }

    private int[] getminYmaxYAtEndNode(class_243 endPos, class_243 targetpos) {
        int zombieBelowTarget;
        int maxY;
        int minY;
        double yDiff = targetpos.field_1351 - endPos.field_1351;
        if (Math.abs(yDiff) < 0.5) {
            minY = 0;
            maxY = 1;
            zombieBelowTarget = 0;
        } else if (yDiff < -1.0) {
            minY = -1;
            maxY = 1;
            zombieBelowTarget = 0;
        } else if (yDiff < 0.0) {
            minY = 0;
            maxY = 1;
            zombieBelowTarget = 0;
        } else if (yDiff <= 1.0) {
            minY = 0;
            maxY = 1;
            zombieBelowTarget = 1;
        } else if (yDiff <= 2.0) {
            minY = 0;
            maxY = 2;
            zombieBelowTarget = 1;
        } else {
            minY = 0;
            maxY = 3;
            zombieBelowTarget = 1;
        }
        return new int[]{minY, maxY, zombieBelowTarget};
    }

    private class_2338 findBlockToBreak() {
        class_2338 pos;
        if (new Random().nextInt(2) == 0) {
            return null;
        }
        class_1937 world = this.zombie.method_73183();
        class_1309 target = this.zombie.method_5968();
        class_243 zombiePos = this.zombie.method_73189();
        class_2350 facing = this.zombie.method_5735();
        if (!(world instanceof class_3218) || target == null || zombiePos == null || target.method_73189() == null || facing == null) {
            return null;
        }
        class_243 targetPos = target.method_73189();
        int[] heightRange = this.getminYmaxYAtEndNode(zombiePos, targetPos);
        int minY = heightRange[0];
        int maxY = heightRange[1];
        int zombieBelowTarget = heightRange[2];
        double distanceToTarget = Math.sqrt(this.zombie.method_5858((class_1297)target));
        class_2338 zombieBlockPos = new class_2338((int)Math.round(zombiePos.field_1352), (int)Math.round(zombiePos.field_1351), (int)Math.round(zombiePos.field_1350));
        int checkRadius = distanceToTarget > 8.0 ? 2 : 1;
        int doorSearchRadius = settings.getDoorSearchDistance();
        int FarBlockRange = settings.getFarBlockSearchDistance();
        ArrayList<class_2338> directPathBlocks = new ArrayList<class_2338>();
        class_243 directionVec = targetPos.method_1020(zombiePos).method_1029();
        int maxCheckDistance = (int)Math.min(distanceToTarget, 3.0);
        for (int i = 1; i <= maxCheckDistance; ++i) {
            class_243 checkVec = zombiePos.method_1019(directionVec.method_1021((double)i));
            int checkX = (int)Math.floor(checkVec.field_1352);
            int checkZ = (int)Math.floor(checkVec.field_1350);
            int startY = zombieBelowTarget == 1 ? maxY : minY;
            int endY = zombieBelowTarget == 1 ? minY : maxY;
            int step = zombieBelowTarget == 1 ? -1 : 1;
            int y = startY;
            while (zombieBelowTarget == 1 ? y >= endY : y <= endY) {
                class_2338 checkPos = new class_2338(checkX, (int)zombiePos.field_1351 + y, checkZ);
                class_2680 blockState = world.method_8320(checkPos);
                if (!blockState.method_26215() && BlockBreakGoal.isBreakableBlock(world, checkPos) && this.isBlockAccessibleFromDirection(world, checkPos, zombieBlockPos) && !currentlyMining.contains(checkPos)) {
                    directPathBlocks.add(checkPos);
                }
                y += step;
            }
        }
        if (!directPathBlocks.isEmpty() && !currentlyMining.contains(pos = (class_2338)directPathBlocks.get(new Random().nextInt(directPathBlocks.size())))) {
            this.failedBlockFindings = 0;
            return pos;
        }
        ArrayList<int[]> offsets = new ArrayList<int[]>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                offsets.add(new int[]{x, z});
            }
        }
        Collections.shuffle(offsets);
        for (int i = 1; i <= maxCheckDistance; ++i) {
            class_243 checkVec = zombiePos.method_1019(directionVec.method_1021((double)i));
            int checkX = (int)Math.floor(checkVec.field_1352);
            int checkZ = (int)Math.floor(checkVec.field_1350);
            for (int[] offset : offsets) {
                int xOffset = offset[0];
                int zOffset = offset[1];
                if (xOffset == 0 && zOffset == 0) continue;
                int startY = zombieBelowTarget == 1 ? maxY : minY;
                int endY = zombieBelowTarget == 1 ? minY : maxY;
                int step = zombieBelowTarget == 1 ? -1 : 1;
                int y = startY;
                while (zombieBelowTarget == 1 ? y >= endY : y <= endY) {
                    class_2338 adjacentPos = new class_2338(checkX + xOffset, (int)zombiePos.field_1351 + y, checkZ + zOffset);
                    class_2680 blockState = world.method_8320(adjacentPos);
                    if (!blockState.method_26215() && BlockBreakGoal.isBreakableBlock(world, adjacentPos) && !currentlyMining.contains(adjacentPos) && this.isBlockAccessibleFromDirection(world, adjacentPos, zombieBlockPos)) {
                        this.failedBlockFindings = 0;
                        return adjacentPos;
                    }
                    y += step;
                }
            }
        }
        ArrayList<int[]> offsets2 = new ArrayList<int[]>();
        for (int x = -1; x <= 1; ++x) {
            int z = -1;
            while (z <= 1) {
                offsets2.add(new int[]{x, z++});
            }
        }
        Collections.shuffle(offsets2);
        class_11 path = this.getCachedPathToTarget();
        if (path != null) {
            class_9 endNode = path.method_45();
            class_243 endPos = endNode.method_35496();
            class_2338 endNodeBlockPos = new class_2338((int)Math.round(endPos.field_1352), (int)Math.round(endPos.field_1351), (int)Math.round(endPos.field_1350));
            int[] nodeHeightRange = this.getminYmaxYAtEndNode(endPos, targetPos);
            int minYatNode = nodeHeightRange[0];
            int maxYatNode = nodeHeightRange[1];
            int zombieBelowTargetatNode = nodeHeightRange[2];
            for (int[] offset : offsets2) {
                int xOffset = offset[0];
                int zOffset = offset[1];
                int startY = zombieBelowTargetatNode == 1 ? maxYatNode : minYatNode;
                int endY = zombieBelowTargetatNode == 1 ? minYatNode : maxYatNode;
                int step = zombieBelowTargetatNode == 1 ? -1 : 1;
                int y = startY;
                while (zombieBelowTargetatNode == 1 ? y >= endY : y <= endY) {
                    class_2338 checkPos = new class_2338(endNodeBlockPos.method_10263() + xOffset, endNodeBlockPos.method_10264() + y, endNodeBlockPos.method_10260() + zOffset);
                    class_2680 blockState = world.method_8320(checkPos);
                    if (!blockState.method_26215() && BlockBreakGoal.isBreakableBlock(world, checkPos) && !currentlyMining.contains(checkPos) && this.isBlockAccessibleFromDirection(world, checkPos, endNodeBlockPos)) {
                        this.failedBlockFindings = 0;
                        return checkPos;
                    }
                    y += step;
                }
            }
        }
        if (this.failedBlockFindings % 10 == 0) {
            ArrayList<class_2338> doorBlocks = new ArrayList<class_2338>();
            for (int x = -doorSearchRadius; x <= doorSearchRadius; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -doorSearchRadius; z <= doorSearchRadius; ++z) {
                        class_2680 state;
                        class_2338 doorPos = zombieBlockPos.method_10069(x, y, z);
                        if (x * x + y * y + z * z > doorSearchRadius * doorSearchRadius || (state = world.method_8320(doorPos)).method_26215() || !state.method_26164(class_3481.field_15495) || !BlockBreakGoal.isBreakableBlock(world, doorPos) || !this.canPathToBlockAndIsAccessible(doorPos)) continue;
                        doorBlocks.add(doorPos);
                    }
                }
            }
            for (class_2338 doorPos : doorBlocks) {
                if (currentlyMining.contains(doorPos)) continue;
                this.failedBlockFindings = 0;
                return doorPos;
            }
        }
        ArrayList<class_2338> facingBlocks = new ArrayList<class_2338>();
        for (int dist = 1; dist <= checkRadius; ++dist) {
            for (int y = minY; y <= maxY; ++y) {
                class_2338 checkPos = new class_2338(zombieBlockPos.method_10263() + facing.method_10148() * dist, zombieBlockPos.method_10264() + y, zombieBlockPos.method_10260() + facing.method_10165() * dist);
                class_2680 blockState = world.method_8320(checkPos);
                if (blockState.method_26215() || !BlockBreakGoal.isBreakableBlock(world, checkPos) || !this.isBlockAccessibleFromDirection(world, checkPos, zombieBlockPos) || currentlyMining.contains(checkPos)) continue;
                facingBlocks.add(checkPos);
            }
        }
        for (class_2338 pos2 : facingBlocks) {
            if (currentlyMining.contains(pos2)) continue;
            this.failedBlockFindings = 0;
            return pos2;
        }
        int perpX = facing.method_10165();
        int perpZ = -facing.method_10148();
        for (int dist = 1; dist <= checkRadius; ++dist) {
            for (int y = minY; y <= maxY; ++y) {
                for (int offset = -1; offset <= 1; offset += 2) {
                    class_2338 adjacentPos = new class_2338(zombieBlockPos.method_10263() + facing.method_10148() * dist + perpX * offset, zombieBlockPos.method_10264() + y, zombieBlockPos.method_10260() + facing.method_10165() * dist + perpZ * offset);
                    class_2680 blockState = world.method_8320(adjacentPos);
                    if (blockState.method_26215() || !BlockBreakGoal.isBreakableBlock(world, adjacentPos) || currentlyMining.contains(adjacentPos) || !this.isBlockAccessibleFromDirection(world, adjacentPos, zombieBlockPos)) continue;
                    this.failedBlockFindings = 0;
                    return adjacentPos;
                }
            }
        }
        if (this.failedBlockFindings % 20 == 0) {
            double zZ;
            double dZ;
            PriorityQueue<Map.Entry> topCandidates = new PriorityQueue<Map.Entry>(5, Comparator.comparingDouble(Map.Entry::getValue));
            double tX = targetPos.method_10216();
            double tZ = targetPos.method_10215();
            double zX = zombieBlockPos.method_10263();
            double dX = tX - zX;
            double distance = Math.sqrt(dX * dX + (dZ = tZ - (zZ = (double)zombieBlockPos.method_10260())) * dZ);
            if (distance > 0.1) {
                dX /= distance;
                dZ /= distance;
            }
            ArrayList<Map.Entry> potentialCandidates = new ArrayList<Map.Entry>();
            Random random = new Random();
            int stepSize = 2;
            int myOffsetX = random.nextInt(stepSize);
            int myOffsetZ = random.nextInt(stepSize);
            for (int x = -FarBlockRange + myOffsetX; x <= FarBlockRange; x += stepSize) {
                for (int y = maxY; y >= minY; --y) {
                    for (int z = -FarBlockRange + myOffsetZ; z <= FarBlockRange; z += stepSize) {
                        class_2680 blockState;
                        double behindDistance;
                        double relZ;
                        double relX;
                        double dotProduct;
                        class_2338 blockPos = zombieBlockPos.method_10069(x, y, z);
                        double distanceSquared = zombieBlockPos.method_10262((class_2382)blockPos);
                        if (distanceSquared > (double)(FarBlockRange * FarBlockRange) || distanceSquared < 4.0 || (dotProduct = (relX = (double)blockPos.method_10263() - zX) * dX + (relZ = (double)blockPos.method_10260() - zZ) * dZ) < 0.0 && (behindDistance = Math.abs(dotProduct)) > 3.0 || (blockState = world.method_8320(blockPos)).method_26215() || blockState.method_27852(class_2246.field_10219) || currentlyMining.contains(blockPos) || !BlockBreakGoal.isBreakableBlock(world, blockPos) || !this.canPathToBlockAndIsAccessible(blockPos)) continue;
                        potentialCandidates.add(new AbstractMap.SimpleEntry<class_2338, Double>(blockPos, distanceSquared));
                    }
                }
            }
            potentialCandidates.sort(Comparator.comparingDouble(Map.Entry::getValue));
            List shortlistCandidates = potentialCandidates.stream().limit(15L).toList();
            for (Map.Entry candidate : shortlistCandidates) {
                class_2338 candidateBlock = (class_2338)candidate.getKey();
                class_11 pathToBlock = this.zombie.method_5942().method_6348(candidateBlock, 0);
                if (pathToBlock == null) continue;
                double distanceToBlock = Math.sqrt(zombieBlockPos.method_10262((class_2382)candidateBlock));
                topCandidates.offer(new AbstractMap.SimpleEntry<class_2338, Double>(candidateBlock, distanceToBlock));
                if (topCandidates.size() <= 5) continue;
                topCandidates.poll();
            }
            ArrayList<class_2338> candidateBlocks = new ArrayList<class_2338>();
            while (!topCandidates.isEmpty()) {
                candidateBlocks.addFirst((class_2338)topCandidates.poll().getKey());
            }
            if (!candidateBlocks.isEmpty()) {
                return (class_2338)candidateBlocks.getFirst();
            }
            return null;
        }
        ++this.failedBlockFindings;
        return null;
    }

    private boolean canPathToBlockAndIsAccessible(class_2338 blockpos) {
        if (this.zombie == null || this.zombie.method_73183() == null || blockpos == null) {
            return false;
        }
        class_1937 world = this.zombie.method_73183();
        class_1309 target = this.zombie.method_5968();
        class_243 targetPos = target.method_73189();
        class_11 blockPath = this.zombie.method_5942().method_6348(blockpos, 0);
        if (blockPath == null || blockPath.method_45() == null) {
            return false;
        }
        class_9 endNode = blockPath.method_45();
        class_243 endPos = endNode.method_35496();
        class_2338 endNodeBlockPos = new class_2338((int)Math.round(endPos.field_1352), (int)Math.round(endPos.field_1351), (int)Math.round(endPos.field_1350));
        int[] heightRange = this.getminYmaxYAtEndNode(endPos, targetPos);
        int minYatNode = heightRange[0];
        int maxYatNode = heightRange[1];
        int blockYRelativeToNode = blockpos.method_10264() - endNodeBlockPos.method_10264();
        if (blockYRelativeToNode < minYatNode || blockYRelativeToNode > maxYatNode) {
            return false;
        }
        double xDistance = Math.abs(endPos.method_10216() + (double)this.zombie.method_17681() / 2.0 - ((double)blockpos.method_10263() + 0.5));
        double yDistance = Math.abs(endPos.method_10214() + (double)this.zombie.method_17682() / 2.0 - ((double)blockpos.method_10264() + 0.5));
        double zDistance = Math.abs(endPos.method_10215() + (double)this.zombie.method_17681() / 2.0 - ((double)blockpos.method_10260() + 0.5));
        return xDistance <= 2.0 && zDistance <= 2.0 && yDistance <= 3.0 && this.isBlockAccessibleFromDirection(world, blockpos, endNodeBlockPos);
    }

    public static boolean isBreakableBlock(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            return false;
        }
        try {
            class_2680 state = world.method_8320(pos);
            class_2248 block = state.method_26204();
            if (state.method_26215() || state.method_26214((class_1922)world, pos) < 0.0f) {
                return false;
            }
            class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
            for (String entry : breakableBlocks) {
                if (entry.startsWith("#") || !VersionHelper.CustomIdentifier(entry).equals((Object)blockId)) continue;
                return true;
            }
            for (String entry : breakableBlocks) {
                if (!entry.startsWith("#")) continue;
                String tagPath = entry.substring(1);
                class_6862 tagKey = tagCache.computeIfAbsent(tagPath, path -> class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)VersionHelper.CustomIdentifier(path)));
                if (!block.method_9564().method_26164(tagKey)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error checking block breakability at {}: {}", (Object)pos, (Object)e.getMessage());
            return false;
        }
    }

    private float getBlockStrength(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        float hardness = state.method_26214((class_1922)world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        return 2.0f / hardness / 250.0f * MINING_SPEED;
    }

    public void method_6269() {
        this.zombie.method_5942().method_6340();
        this.miningTicks = 0;
        this.breakProgress = 0.0f;
        goalMap.put(this.zombie, this);
    }

    public void method_6270() {
        class_1937 world = this.zombie.method_73183();
        if (world != null && this.targetBlock != null && this.zombie != null) {
            world.method_8517(this.zombie.method_5628(), this.targetBlock, -1);
            currentlyMining.remove(this.targetBlock);
        }
        this.targetBlock = null;
        this.breakProgress = 0.0f;
        goalMap.remove(this.zombie);
    }

    public static synchronized void resetMiningState(class_1642 zombie) {
        BlockBreakGoal goal = goalMap.get(zombie);
        if (goal != null) {
            class_1937 world = zombie.method_73183();
            if (world != null && goal.targetBlock != null) {
                world.method_8517(zombie.method_5628(), goal.targetBlock, -1);
                currentlyMining.remove(goal.targetBlock);
            }
            goal.targetBlock = null;
            goal.breakProgress = 0.0f;
            goal.blockFindingIdleTicks = 0;
            goalMap.remove(zombie);
        }
    }

    public void setAndValidateTargetAgain() {
        class_1355 goalSelector = ((MobEntityAccessor)this.zombie).getGoalSelector();
        for (class_1352 goal : goalSelector.method_35115()) {
            if (!(goal instanceof KeepTargetGoal)) continue;
            KeepTargetGoal keepTargetGoal = (KeepTargetGoal)goal;
            keepTargetGoal.method_6264();
        }
    }

    public boolean method_6266() {
        class_11 path;
        if (this.zombie == null || this.zombie.method_73183() == null) {
            return false;
        }
        if (this.zombie.method_5968() == null) {
            this.setAndValidateTargetAgain();
            if (this.zombie.method_5968() == null) {
                return false;
            }
        }
        if ((path = this.zombie.method_5942().method_6349((class_1297)this.zombie.method_5968(), 0)) == null) {
            ++this.noPathTicks;
        }
        if (this.noPathTicks > 5) {
            this.noPathTicks = 0;
            return false;
        }
        this.noPathTicks = 0;
        if (this.failedBlockFindings > 100) {
            this.failedBlockFindings = 0;
            return false;
        }
        if (this.isPathingBetterThanBlockBreaking()) {
            return false;
        }
        if (path == null && this.noPathTicks < 5) {
            return true;
        }
        return path != null && !path.method_21655() && !path.method_46();
    }

    private boolean isPathingBetterThanBlockBreaking() {
        class_11 path = this.getCachedPathToTarget();
        if (path == null || path.method_45() == null || path.method_38() < 30 || this.zombie.method_5968().method_24515() == null) {
            return false;
        }
        class_2338 targetPos = this.zombie.method_5968().method_24515();
        if (targetPos == null) {
            return false;
        }
        class_2338 zombieBlockPos = this.zombie.method_24515();
        class_9 endNode = path.method_45();
        class_243 endPos = endNode.method_35496();
        class_2338 nodeBlockPos = new class_2338((int)Math.round(endPos.field_1352), (int)Math.round(endPos.field_1351), (int)Math.round(endPos.field_1350));
        double zombieDistanceToTarget = zombieBlockPos.method_10262((class_2382)targetPos);
        double zombieDistanceFromEndNodeToTarget = nodeBlockPos.method_10262((class_2382)targetPos);
        if (zombieDistanceFromEndNodeToTarget < zombieDistanceToTarget * 0.2) {
            System.out.println("Stoping GOAL, path found to get closer");
            return true;
        }
        return false;
    }

    private class_11 getCachedPathToTarget() {
        class_1309 target = this.zombie.method_5968();
        if (target == null) {
            this.cachedPath = null;
            this.lastTargetPos = null;
            return null;
        }
        class_2338 targetPos = target.method_24515();
        ++this.pathUpdateCounter;
        if (this.pathUpdateCounter >= 3 || this.cachedPath == null || this.cachedPath.method_46() || this.lastTargetPos != null && !this.lastTargetPos.equals((Object)targetPos) && this.lastTargetPos.method_10262((class_2382)targetPos) > 1.0) {
            this.cachedPath = this.zombie.method_5942().method_6349((class_1297)target, 0);
            this.pathUpdateCounter = 0;
            this.lastTargetPos = targetPos;
        }
        return this.cachedPath;
    }

    private void completeBlockBreak() {
        if (this.zombie == null || this.zombie.method_73183() == null || this.zombie.method_73183() == null || this.targetBlock == null) {
            return;
        }
        this.zombie.method_73183().method_22352(this.targetBlock, true);
        this.zombie.method_73183().method_8517(this.zombie.method_5628(), this.targetBlock, -1);
        currentlyMining.remove(this.targetBlock);
        this.targetBlock = null;
        this.breakProgress = 0.0f;
        this.failedBlockFindings = 0;
        this.blockFindingIdleTicks = 0;
    }

    public void method_6268() {
        class_1937 world = this.zombie.method_73183();
        if (this.zombie == null || world == null || !this.zombie.method_5805()) {
            this.method_6270();
            return;
        }
        if (settings.getTargetBlockPathingParticlesEnabled()) {
            this.visualizePathToBlock(this.targetBlock);
        }
        if (this.targetBlock == null) {
            this.targetBlock = this.findBlockToBreak();
            if (this.targetBlock != null) {
                currentlyMining.add(this.targetBlock);
                this.miningTicks = 0;
                this.breakProgress = 0.0f;
                this.blockFindingIdleTicks = 0;
            } else {
                class_11 path = this.getCachedPathToTarget();
                if (path != null) {
                    this.zombie.method_5942().method_6334(path, 1.0);
                    this.zombie.method_5951((class_1297)this.zombie.method_5968(), 1.0f, 1.0f);
                }
                return;
            }
        }
        if (this.zombie.method_73183().method_8320(this.targetBlock).method_26215()) {
            this.completeBlockBreak();
            return;
        }
        if (this.blockFindingIdleTicks > 20 && this.targetBlock != null) {
            currentlyMining.remove(this.targetBlock);
            this.targetBlock = null;
            this.targetBlock = this.findBlockToBreak();
            if (this.targetBlock != null) {
                currentlyMining.add(this.targetBlock);
                this.miningTicks = 0;
                this.breakProgress = 0.0f;
                this.blockFindingIdleTicks = 0;
            }
            return;
        }
        if (this.targetBlock != null && !world.method_8393(this.targetBlock.method_10263() >> 4, this.targetBlock.method_10260() >> 4)) {
            this.method_6270();
            return;
        }
        if (world.method_8320(this.targetBlock).method_26214((class_1922)world, this.targetBlock) <= 0.0f) {
            this.method_6270();
            return;
        }
        if (settings.getTargetBlockParticlesEnabled()) {
            this.spawnTargetBlockParticles(world);
        }
        if (this.isWithinMiningRange(this.targetBlock)) {
            this.performMining(world);
        } else {
            this.navigateToTargetBlock();
        }
    }

    private void performMining(class_1937 world) {
        this.zombie.method_5942().method_6340();
        if (!this.zombie.method_5942().method_6357() || this.zombie.method_5942().method_23966()) {
            this.zombie.method_18800(0.0, this.zombie.method_18798().field_1351, 0.0);
        }
        this.failedBlockFindings = 0;
        this.zombie.method_5988().method_20248((double)this.targetBlock.method_10263() + 0.5, (double)this.targetBlock.method_10264(), (double)this.targetBlock.method_10260() + 0.5);
        this.zombie.method_6104(class_1268.field_5808);
        this.zombie.method_6104(class_1268.field_5810);
        ++this.miningTicks;
        float strength = this.getBlockStrength(world, this.targetBlock);
        this.breakProgress += strength;
        int progress = (int)(this.breakProgress * 10.0f);
        world.method_8517(this.zombie.method_5628(), this.targetBlock, progress);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_65096((class_2394)new class_2388(class_2398.field_11217, world.method_8320(this.targetBlock)), (double)this.targetBlock.method_10263() + 0.5, (double)this.targetBlock.method_10264() + 0.5, (double)this.targetBlock.method_10260() + 0.5, 20, 0.25, 0.25, 0.25, 0.05);
        }
        if (this.miningTicks % 2 == 0) {
            class_2680 blockState = world.method_8320(this.targetBlock);
            class_2498 soundGroup = blockState.method_26231();
            float volume = 0.7f;
            float pitch = 0.4f + world.field_9229.method_43057() * 0.4f;
            world.method_43128(null, (double)this.targetBlock.method_10263() + 0.5, (double)this.targetBlock.method_10264() + 0.5, (double)this.targetBlock.method_10260() + 0.5, soundGroup.method_10596(), class_3419.field_15248, volume, pitch);
        }
        if (this.breakProgress >= 1.0f) {
            this.completeBlockBreak();
        }
    }

    private void spawnTargetBlockParticles(class_1937 world) {
        if (this.targetBlock != null && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_65096((class_2394)class_2398.field_11211, (double)this.targetBlock.method_10263() + 0.5, (double)this.targetBlock.method_10264() + 0.5, (double)this.targetBlock.method_10260() + 0.5, 30, 0.3, 0.3, 0.3, 0.0);
        }
    }

    private boolean isWithinMiningRange(class_2338 blockpos) {
        if (blockpos == null) {
            return false;
        }
        class_2338 zombiePos = this.zombie.method_24515();
        int xDiff = Math.abs(blockpos.method_10263() - zombiePos.method_10263());
        int yDiff = Math.abs(blockpos.method_10264() - zombiePos.method_10264());
        int zDiff = Math.abs(blockpos.method_10260() - zombiePos.method_10260());
        if ((float)xDiff > 4.0f || (float)zDiff > 4.0f || (float)yDiff > 5.0f) {
            return false;
        }
        double zombieCenterX = this.zombie.method_23317() + (double)this.zombie.method_17681() / 2.0;
        double zombieCenterY = this.zombie.method_23318() + (double)this.zombie.method_17682() / 2.0;
        double zombieCenterZ = this.zombie.method_23321() + (double)this.zombie.method_17681() / 2.0;
        double targetX = (double)blockpos.method_10263() + 0.5;
        double targetY = (double)blockpos.method_10264() + 0.5;
        double targetZ = (double)blockpos.method_10260() + 0.5;
        double xDistance = Math.abs(targetX - zombieCenterX);
        double yDistance = Math.abs(targetY - zombieCenterY);
        double zDistance = Math.abs(targetZ - zombieCenterZ);
        double effectiveHorizontalRange = 2.0 + (this.miningTicks > 0 ? 1.0 : 0.0);
        double effectiveVerticalRange = 3.0 + (this.miningTicks > 0 ? 1.0 : 0.0);
        return xDistance <= effectiveHorizontalRange && zDistance <= effectiveHorizontalRange && yDistance <= effectiveVerticalRange;
    }

    private void navigateToTargetBlock() {
        double targetX = (double)this.targetBlock.method_10263() + 0.5;
        double targetY = (double)this.targetBlock.method_10264() + 0.5;
        double targetZ = (double)this.targetBlock.method_10260() + 0.5;
        this.zombie.method_5942().method_6337(targetX, targetY, targetZ, 1.0);
        this.zombie.method_5988().method_20248(targetX, targetY, targetZ);
        this.blockFindingIdleTicks = (this.zombie.method_5942().method_6357() || !this.zombie.method_5942().method_23966()) && this.targetBlock != null ? ++this.blockFindingIdleTicks : Math.max(0, this.blockFindingIdleTicks - 1);
    }

    public void visualizePathToBlock(class_2338 targetBlockPos) {
        class_1409 navigation;
        class_11 path;
        if (targetBlockPos != null && (path = (navigation = (class_1409)this.zombie.method_5942()).method_6348(targetBlockPos, 0)) != null && path.method_45() != null) {
            class_3218 serverWorld = (class_3218)this.zombie.method_73183();
            class_9 endNode = path.method_45();
            class_2338 endPos = new class_2338((int)endNode.method_35496().method_10216(), (int)endNode.method_35496().method_10214(), (int)endNode.method_35496().method_10215());
            serverWorld.method_65096((class_2394)class_2398.field_11240, (double)endPos.method_10263() + 0.5, (double)endPos.method_10264() + 0.5, (double)endPos.method_10260() + 0.5, 10, 0.2, 0.2, 0.2, 0.0);
            int nodeCount = path.method_38();
            for (int i = 0; i < nodeCount; ++i) {
                class_9 node = path.method_40(i);
                class_2338 nodePos = new class_2338((int)node.method_35496().method_10216(), (int)node.method_35496().method_10214(), (int)node.method_35496().method_10215());
                serverWorld.method_65096((class_2394)class_2398.field_22246, (double)nodePos.method_10263() + 0.5, (double)nodePos.method_10264() + 0.5, (double)nodePos.method_10260() + 0.5, 5, 0.1, 0.1, 0.1, 0.0);
            }
        }
    }

    static {
        INIT_LOCK = new Object();
    }
}

