/*
 * Decompiled with CFR 0.152.
 */
package invasivezombies.client;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import invasivezombies.config.ModConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class ModMenuClient
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43470((String)"Invasive Zombies Client Configuration").method_10852((class_2561)class_2561.method_43470((String)"   ---   Restart game for changes to take effect!").method_27692(class_124.field_1054).method_27692(class_124.field_1056)));
            builder.setSavingRunnable(() -> {
                if (!ModConfig.getConfigErrorsInternalList().isEmpty()) {
                    ModConfig.LOGGER.warn("Saving ZombieSettings with existing general config errors: {}", (Object)String.join((CharSequence)", ", ModConfig.getConfigErrorsInternalList()));
                }
                ModConfig.saveSettings();
            });
            ConfigCategory generalCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Blocks"));
            ConfigCategory zombieSettingsCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Zombie"));
            ConfigCategory debugSettingsCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Debug"));
            ConfigEntryBuilder entryBuilder = builder.entryBuilder();
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            if (!ModConfig.isInitialized) {
                tooltipLines.add(class_2561.method_43470((String)"\u26a0 Configuration system not initialized!").method_10862(class_2583.field_24360.method_10977(class_124.field_1079)));
            }
            tooltipLines.add(class_2561.method_43470((String)("Current block count: " + ModConfig.getMineableBlocks().size() + "/1000")).method_10862(class_2583.field_24360.method_10977(ModConfig.getMineableBlocks().size() >= 1000 ? class_124.field_1061 : class_124.field_1060)));
            ArrayList<String> currentErrorsSnapshot = new ArrayList<String>(ModConfig.getConfigErrorsInternalList());
            if (!currentErrorsSnapshot.isEmpty()) {
                tooltipLines.add(class_2561.method_43470((String)""));
                tooltipLines.add(class_2561.method_43470((String)"Current Configuration Errors:").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
                for (String error : currentErrorsSnapshot) {
                    tooltipLines.add(class_2561.method_43470((String)("\u2022 " + error)).method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
                }
            }
            ArrayList<String> currentBlockListForGui = new ArrayList<String>(ModConfig.getMineableBlocksInternalList());
            generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startStrList((class_2561)class_2561.method_43470((String)"Mineable Blocks").method_10862(class_2583.field_24360.method_10977(!ModConfig.isInitialized || !currentErrorsSnapshot.isEmpty() ? class_124.field_1061 : class_124.field_1068)), currentBlockListForGui).setDefaultValue(ModConfig.loadDefaultBlocks()).setSaveConsumer(newValue -> {
                List<String> modConfigMineableBlocks = ModConfig.getMineableBlocksInternalList();
                List<String> modConfigConfigErrors = ModConfig.getConfigErrorsInternalList();
                if (!newValue.equals(currentBlockListForGui)) {
                    modConfigMineableBlocks.clear();
                    modConfigConfigErrors.clear();
                    HashSet<String> seen = new HashSet<String>();
                    for (String block : newValue) {
                        if (modConfigMineableBlocks.size() >= 1000) {
                            modConfigConfigErrors.add("Max block limit (1000) reached. Some entries not added.");
                            break;
                        }
                        if (!seen.add(block)) {
                            modConfigConfigErrors.add("Duplicate block removed: " + block);
                            continue;
                        }
                        String validationError = ModConfig.validateBlockId(block);
                        if (validationError == null) {
                            modConfigMineableBlocks.add(block);
                            continue;
                        }
                        modConfigConfigErrors.add("Invalid block ID: " + block + " (" + validationError + ")");
                    }
                    ModConfig.saveBlockConfig();
                }
            }).setErrorSupplier(value -> {
                if (value.isEmpty() && ModConfig.getMineableBlocks().isEmpty()) {
                    return Optional.empty();
                }
                if (value.size() > 1000) {
                    return Optional.of(class_2561.method_43470((String)"Too many blocks. Limit: 1000").method_27692(class_124.field_1061));
                }
                HashSet<String> seenInGui = new HashSet<String>();
                for (String entry : value) {
                    String validationError;
                    if (entry.isEmpty() && value.size() > 1 && value.indexOf(entry) != value.size() - 1) {
                        return Optional.of(class_2561.method_43470((String)"Empty entries before the last are invalid.").method_27692(class_124.field_1061));
                    }
                    if (!entry.isEmpty() && !seenInGui.add(entry)) {
                        return Optional.of(class_2561.method_43470((String)("Duplicate entry: " + entry)).method_27692(class_124.field_1065));
                    }
                    if (entry.isEmpty() || (validationError = ModConfig.validateBlockId(entry)) == null) continue;
                    if (validationError.startsWith("Block does not exist")) {
                        return Optional.of(class_2561.method_43470((String)validationError).method_27692(class_124.field_1061));
                    }
                    return Optional.of(class_2561.method_43470((String)("Invalid format: " + entry + " (" + validationError + ")")).method_27692(class_124.field_1061));
                }
                return Optional.empty();
            }).setTooltip(tooltipLines.toArray(new class_2561[0])).setInsertInFront(true).setExpanded(true).build());
            ModConfig.ZombieSettings settings = ModConfig.getZombieSettings();
            ModConfig.ZombieSettings defaults = new ModConfig.ZombieSettings();
            zombieSettingsCategory.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)class_2561.method_43470((String)"Follow Range"), settings.getFollowRange()).setDefaultValue(defaults.getFollowRange()).setMin(5.0).setMax(200.0).setSaveConsumer(settings::setFollowRange).setTooltip(new class_2561[]{class_2561.method_43470((String)"How far zombies can detect, follow players and keep their target locked once seen (vanilla default: 35)")}).build());
            zombieSettingsCategory.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((class_2561)class_2561.method_43470((String)"Movement Speed"), settings.getMovementSpeed()).setDefaultValue(defaults.getMovementSpeed()).setMin(0.1).setMax(1.0).setSaveConsumer(settings::setMovementSpeed).setTooltip(new class_2561[]{class_2561.method_43470((String)"How fast zombies can move (vanilla default: 0.23)")}).build());
            zombieSettingsCategory.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)class_2561.method_43470((String)"Mining Speed Multiplier"), settings.getMiningSpeed()).setDefaultValue(defaults.getMiningSpeed()).setMin(0.1f).setMax(50.0f).setSaveConsumer(settings::setMiningSpeed).setTooltip(new class_2561[]{class_2561.method_43470((String)"How quickly zombies can break blocks")}).build());
            zombieSettingsCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43470((String)"Zombie Lock-Target Range"), settings.getTargetRange()).setDefaultValue(defaults.getTargetRange()).setMin(1).setMax(100).setSaveConsumer(settings::setTargetRange).setTooltip(new class_2561[]{class_2561.method_43470((String)"In what radius zombies will keep their target, even without line-of-sight (X-Ray vision)")}).build());
            zombieSettingsCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Baby Zombies Block Breaking"), settings.getBabyZombiesEnabled()).setDefaultValue(defaults.getBabyZombiesEnabled()).setSaveConsumer(settings::setBabyZombiesEnabled).setTooltip(new class_2561[]{class_2561.method_43470((String)"Toggle whether baby zombies should be able to break blocks")}).build());
            debugSettingsCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable TargetBlock Particles"), settings.getTargetBlockParticlesEnabled()).setDefaultValue(defaults.getTargetBlockParticlesEnabled()).setSaveConsumer(settings::setTargetBlockParticlesEnabled).setTooltip(new class_2561[]{class_2561.method_43470((String)"Toggle green particle effects for selected target blocks, used for debugging")}).build());
            debugSettingsCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable TargetBlock Pathing Visibility"), settings.getTargetBlockPathingParticlesEnabled()).setDefaultValue(defaults.getTargetBlockPathingParticlesEnabled()).setSaveConsumer(settings::setTargetBlockPathingParticlesEnabled).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show the path to the target block, used for debugging")}).build());
            zombieSettingsCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Far Block Search Distance"), settings.getFarBlockSearchDistance(), 6, 24).setDefaultValue(defaults.getFarBlockSearchDistance()).setSaveConsumer(value -> {
                int adjustedValue = value / 6 * 6;
                if (adjustedValue < 6) {
                    adjustedValue = 6;
                }
                if (adjustedValue > 24) {
                    adjustedValue = 24;
                }
                settings.setFarBlockSearchDistance(adjustedValue);
            }).setTooltip(new class_2561[]{class_2561.method_43470((String)"Square search distance for breakable blocks when no near blocks are found. Blocks behind the zombies facing direction are culled.")}).setTextGetter(value -> class_2561.method_43470((String)(value / 6 * 6 * 2 + "x" + value / 6 * 6 * 2 + " blocks"))).setMin(6).setMax(24).build());
            zombieSettingsCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Door Search Distance"), settings.getDoorSearchDistance(), 6, 24).setDefaultValue(defaults.getDoorSearchDistance()).setSaveConsumer(value -> {
                int adjustedValue = value / 6 * 6;
                if (adjustedValue < 6) {
                    adjustedValue = 6;
                }
                if (adjustedValue > 24) {
                    adjustedValue = 24;
                }
                settings.setDoorSearchDistance(adjustedValue);
            }).setTooltip(new class_2561[]{class_2561.method_43470((String)"Square search distance for breakable doors around the zombie. NO blocks behind are culled.")}).setTextGetter(value -> class_2561.method_43470((String)(value / 6 * 6 * 2 + "x" + value / 6 * 6 * 2 + " blocks"))).setMin(6).setMax(24).build());
            return builder.build();
        };
    }
}

