/*
 * Decompiled with CFR 0.152.
 */
package invasivezombies.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import invasivezombies.VersionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModConfig {
    public static final Logger LOGGER;
    private static final String MODIFIABLE_BLOCK_CONFIG_FILE = "invasivezombies/mineable.json";
    private static final String INTERNAL_BLOCK_CONFIG_FILE = "/data/mineable.json";
    private static final String MODIFIABLE_SETTINGS_CONFIG_FILE = "invasivezombies/settings.json";
    private static final String INTERNAL_SETTINGS_CONFIG_FILE = "/data/settings.json";
    private static ZombieSettings zombieSettings;
    private static final Gson GSON;
    public static final int MAX_BLOCKS = 1000;
    private static final int MAX_FILE_SIZE = 0x100000;
    private static List<String> mineableBlocks;
    private static List<String> configErrors;
    private static Path configPath;
    public static boolean isInitialized;

    public static List<String> getMineableBlocksInternalList() {
        return mineableBlocks;
    }

    public static List<String> getConfigErrorsInternalList() {
        return configErrors;
    }

    private static void loadOrCreateSettingsConfig() {
        Path settingsPath = FabricLoader.getInstance().getConfigDir().resolve(MODIFIABLE_SETTINGS_CONFIG_FILE);
        try {
            Path configDir = settingsPath.getParent();
            if (configDir != null && !Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            if (!Files.exists(settingsPath, new LinkOption[0])) {
                ModConfig.createDefaultSettingsConfig(settingsPath);
            } else {
                ModConfig.loadSettingsFromFile(settingsPath);
            }
        }
        catch (Exception e) {
            String error = "Failed to load or create settings config: " + e.getMessage();
            LOGGER.error(error, (Throwable)e);
            configErrors.add(error);
            zombieSettings = new ZombieSettings();
        }
    }

    private static void createDefaultSettingsConfig(Path settingsPath) throws IOException {
        try (InputStream input = ModConfig.class.getResourceAsStream(INTERNAL_SETTINGS_CONFIG_FILE);){
            if (input != null) {
                try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                    zombieSettings = (ZombieSettings)GSON.fromJson((Reader)reader, ZombieSettings.class);
                    if (zombieSettings == null) {
                        LOGGER.warn("Default settings config resource was empty or malformed, using new ZombieSettings() defaults.");
                        zombieSettings = new ZombieSettings();
                    }
                }
                catch (JsonSyntaxException e) {
                    LOGGER.error("Default settings config file is malformed: " + e.getMessage() + ". Using new ZombieSettings() defaults.", (Throwable)e);
                    zombieSettings = new ZombieSettings();
                    configErrors.add("Default settings config resource (/data/settings.json) is malformed: " + e.getMessage());
                }
            } else {
                zombieSettings = new ZombieSettings();
                configErrors.add("Default settings config resource (/data/settings.json) not found - using default values");
            }
            ModConfig.saveSettingsConfig(settingsPath);
        }
    }

    private static void loadSettingsFromFile(Path settingsPath) throws IOException {
        String content = Files.readString(settingsPath, StandardCharsets.UTF_8);
        try {
            zombieSettings = (ZombieSettings)GSON.fromJson(content, ZombieSettings.class);
            if (zombieSettings == null) {
                LOGGER.warn("Settings file was empty or corrupted, creating new default settings.");
                configErrors.add("Settings file " + String.valueOf(settingsPath.getFileName()) + " was empty or corrupted. Reverted to defaults.");
                ModConfig.createDefaultSettingsConfig(settingsPath);
            }
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Malformed JSON in settings file: " + e.getMessage() + ". Reverting to defaults.", (Throwable)e);
            configErrors.add("Malformed JSON in " + String.valueOf(settingsPath.getFileName()) + ": " + e.getMessage() + ". Reverted to defaults.");
            ModConfig.createDefaultSettingsConfig(settingsPath);
        }
    }

    private static void saveSettingsConfig(Path settingsPath) throws IOException {
        if (zombieSettings == null) {
            LOGGER.warn("Attempted to save null zombieSettings, initializing to defaults first.");
            zombieSettings = new ZombieSettings();
        }
        try {
            Path parentDir = settingsPath.getParent();
            if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            if (Files.exists(settingsPath, new LinkOption[0])) {
                Path backupPath = settingsPath.resolveSibling(String.valueOf(settingsPath.getFileName()) + ".backup");
                Files.copy(settingsPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            }
            String jsonString = GSON.toJson((Object)zombieSettings);
            Path tempFile = settingsPath.resolveSibling(String.valueOf(settingsPath.getFileName()) + ".tmp");
            Files.writeString(tempFile, (CharSequence)jsonString, StandardCharsets.UTF_8, new OpenOption[0]);
            Files.move(tempFile, settingsPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            String error = "Failed to save settings config: " + e.getMessage();
            LOGGER.error(error, (Throwable)e);
            configErrors.add(error);
            throw e;
        }
    }

    public static void saveSettings() {
        Path settingsPath = FabricLoader.getInstance().getConfigDir().resolve(MODIFIABLE_SETTINGS_CONFIG_FILE);
        try {
            ModConfig.saveSettingsConfig(settingsPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static ZombieSettings getZombieSettings() {
        if (zombieSettings == null) {
            LOGGER.warn("ZombieSettings accessed while null. Attempting to load/create.");
            ModConfig.loadOrCreateSettingsConfig();
            if (zombieSettings == null) {
                LOGGER.error("CRITICAL: ZombieSettings is still null after attempting reload. Using emergency hardcoded defaults.");
                zombieSettings = new ZombieSettings();
            }
        }
        return zombieSettings;
    }

    private static void loadOrCreateBlockConfig() {
        configErrors.clear();
        try {
            HashSet<String> uniqueBlocks;
            Path dir = configPath.getParent();
            if (dir != null && !Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            if (dir != null && !Files.isWritable(dir)) {
                throw new IOException("Config directory is not writable: " + String.valueOf(dir));
            }
            if (!Files.exists(configPath, new LinkOption[0])) {
                ModConfig.createDefaultBlockListFile();
            } else {
                if (!Files.isReadable(configPath)) {
                    throw new IOException("Config file is not readable: " + String.valueOf(configPath));
                }
                if (Files.size(configPath) > 0x100000L) {
                    throw new IOException("Config file " + String.valueOf(configPath.getFileName()) + " exceeds maximum size limit of 1MB");
                }
                ModConfig.loadBlockConfigFromFile();
            }
            if (mineableBlocks.size() > 1000) {
                String error = "Too many blocks in config (limit: 1000)";
                configErrors.add(error);
                LOGGER.warn(error);
                mineableBlocks = mineableBlocks.subList(0, 1000);
            }
            if ((uniqueBlocks = new HashSet<String>(mineableBlocks)).size() < mineableBlocks.size()) {
                List duplicates = mineableBlocks.stream().filter(block -> Collections.frequency(mineableBlocks, block) > 1).distinct().collect(Collectors.toList());
                String error = "Duplicate blocks found and removed from list: " + String.join((CharSequence)", ", duplicates);
                configErrors.add(error);
                LOGGER.warn(error);
                mineableBlocks = new ArrayList<String>(uniqueBlocks);
            }
        }
        catch (Exception e) {
            String error = "Failed to load or create block config (" + String.valueOf(configPath.getFileName()) + "): " + e.getMessage();
            LOGGER.error(error, (Throwable)e);
            configErrors.add(error);
            mineableBlocks = new ArrayList<String>(ModConfig.loadDefaultBlocks());
        }
    }

    private static void createDefaultBlockListFile() throws IOException {
        JsonArray defaultValuesArray;
        JsonObject defaultConfigJsonOutput;
        block18: {
            mineableBlocks.clear();
            defaultConfigJsonOutput = new JsonObject();
            defaultValuesArray = new JsonArray();
            try (InputStream input = ModConfig.class.getResourceAsStream(INTERNAL_BLOCK_CONFIG_FILE);){
                if (input != null) {
                    try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                        JsonObject parsedDefaults = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        if (parsedDefaults != null && parsedDefaults.has("values") && parsedDefaults.get("values").isJsonArray()) {
                            JsonArray valuesFromJar = parsedDefaults.getAsJsonArray("values");
                            for (int i = 0; i < valuesFromJar.size(); ++i) {
                                JsonObject blockObj;
                                if (!valuesFromJar.get(i).isJsonObject() || !(blockObj = valuesFromJar.get(i).getAsJsonObject()).has("id") || !blockObj.get("id").isJsonPrimitive() || !blockObj.get("id").getAsJsonPrimitive().isString()) continue;
                                String id = blockObj.get("id").getAsString();
                                mineableBlocks.add(id);
                                defaultValuesArray.add((JsonElement)blockObj);
                            }
                        } else {
                            configErrors.add("Default block config resource (/data/mineable.json) is malformed. Using empty list.");
                        }
                        break block18;
                    }
                    catch (JsonSyntaxException e) {
                        configErrors.add("Default block config resource (/data/mineable.json) is malformed: " + e.getMessage() + ". Using empty list.");
                    }
                    break block18;
                }
                configErrors.add("Default block config resource (/data/mineable.json) not found - using empty config");
            }
        }
        defaultConfigJsonOutput.add("values", (JsonElement)defaultValuesArray);
        if (Files.exists(configPath, new LinkOption[0])) {
            Path backupPath = configPath.resolveSibling(String.valueOf(configPath.getFileName()) + ".backup");
            Files.copy(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
        }
        Files.writeString(configPath, (CharSequence)GSON.toJson((JsonElement)defaultConfigJsonOutput), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static void loadBlockConfigFromFile() throws IOException {
        JsonArray values;
        JsonObject configJson;
        String content = Files.readString(configPath, StandardCharsets.UTF_8);
        try {
            configJson = (JsonObject)GSON.fromJson(content, JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            throw new IOException("Malformed JSON in block config file: " + e.getMessage(), e);
        }
        mineableBlocks.clear();
        if (configJson == null) {
            throw new IOException("Block config file " + String.valueOf(configPath.getFileName()) + " is empty or corrupted (parsed to null)");
        }
        if (!configJson.has("values")) {
            throw new IOException("Invalid block config format in " + String.valueOf(configPath.getFileName()) + " - missing 'values' array");
        }
        try {
            values = configJson.getAsJsonArray("values");
        }
        catch (ClassCastException e) {
            throw new IOException("'values' is not an array in block config (" + String.valueOf(configPath.getFileName()) + ")");
        }
        for (int i = 0; i < values.size(); ++i) {
            try {
                if (!values.get(i).isJsonObject()) {
                    configErrors.add("Block entry at index " + i + " in " + String.valueOf(configPath.getFileName()) + " is not an object.");
                    continue;
                }
                JsonObject blockObj = values.get(i).getAsJsonObject();
                if (!(blockObj.has("id") && blockObj.get("id").isJsonPrimitive() && blockObj.get("id").getAsJsonPrimitive().isString())) {
                    configErrors.add("Block at index " + i + " in " + String.valueOf(configPath.getFileName()) + " is missing 'id' field or it's not a string.");
                    continue;
                }
                String id = blockObj.get("id").getAsString();
                if (id.startsWith("#")) {
                    mineableBlocks.add(id);
                    continue;
                }
                try {
                    class_2960 identifier = VersionHelper.CustomIdentifier(id);
                    if (class_7923.field_41175.method_10250(identifier)) {
                        mineableBlocks.add(id);
                        continue;
                    }
                    configErrors.add("Block does not exist in game registry (during load of " + String.valueOf(configPath.getFileName()) + "): " + id);
                }
                catch (class_151 e) {
                    configErrors.add("Invalid block ID format at index " + i + " (during load of " + String.valueOf(configPath.getFileName()) + "): " + id + " (" + e.getMessage() + ")");
                }
                continue;
            }
            catch (Exception e) {
                configErrors.add("Error parsing block at index " + i + " in " + String.valueOf(configPath.getFileName()) + ": " + e.getMessage());
            }
        }
    }

    public static String validateBlockId(String blockId) {
        if (blockId == null) {
            return "Block ID cannot be null";
        }
        if ((blockId = blockId.trim()).isEmpty()) {
            return "Block ID cannot be empty";
        }
        if (blockId.length() > 100) {
            return "Block ID is too long (max 100 characters)";
        }
        if (blockId.contains(" ")) {
            return "Block ID cannot contain spaces";
        }
        if (blockId.startsWith("#")) {
            String[] parts = blockId.substring(1).split(":", 2);
            if (parts.length != 2 || parts[0].isEmpty() || parts[1].isEmpty()) {
                return "Invalid tag format. Expected: #namespace:path";
            }
            if (!parts[0].matches("[a-z0-9_.-]+")) {
                return "Invalid tag namespace. Must only contain [a-z0-9_.-]";
            }
            if (!parts[1].matches("[a-z0-9/._-]+")) {
                return "Invalid tag path. Must only contain [a-z0-9/._-]";
            }
            return null;
        }
        try {
            class_2960 identifier = VersionHelper.CustomIdentifier(blockId);
            if (isInitialized && !class_7923.field_41175.method_10250(identifier)) {
                return "Block does not exist in game registry: " + blockId;
            }
        }
        catch (class_151 e) {
            return "Invalid block identifier: " + e.getMessage();
        }
        return null;
    }

    public static void saveBlockConfig() {
        if (!isInitialized) {
            LOGGER.error("Attempted to save block config before initialization");
            return;
        }
        ArrayList<Object> tempSaveErrors = new ArrayList<Object>();
        try {
            Path parentDir = configPath.getParent();
            if (parentDir != null && !Files.isWritable(parentDir)) {
                throw new IOException("Config directory is not writable for " + String.valueOf(configPath.getFileName()));
            }
            if (Files.exists(configPath, new LinkOption[0])) {
                Path backupPath = configPath.resolveSibling(String.valueOf(configPath.getFileName()) + ".backup");
                Files.copy(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            }
            JsonObject configOut = new JsonObject();
            JsonArray valuesOut = new JsonArray();
            ArrayList<String> blocksToActuallySave = new ArrayList<String>();
            HashSet<String> seenInSave = new HashSet<String>();
            for (String block : mineableBlocks) {
                if (blocksToActuallySave.size() >= 1000) {
                    tempSaveErrors.add("Max block limit (1000) reached during save. Some blocks were not saved.");
                    break;
                }
                String validationError = ModConfig.validateBlockId(block);
                if (validationError == null) {
                    if (seenInSave.add(block)) {
                        blocksToActuallySave.add(block);
                        continue;
                    }
                    tempSaveErrors.add("Skipping duplicate block during save: " + block);
                    continue;
                }
                String error = "Skipping invalid block ID during save: " + block + " (" + validationError + ")";
                LOGGER.warn(error);
                tempSaveErrors.add(error);
            }
            for (String blockIdToSave : blocksToActuallySave) {
                JsonObject blockObj = new JsonObject();
                blockObj.addProperty("id", blockIdToSave);
                valuesOut.add((JsonElement)blockObj);
            }
            configOut.add("values", (JsonElement)valuesOut);
            String jsonString = GSON.toJson((JsonElement)configOut);
            if (jsonString.getBytes(StandardCharsets.UTF_8).length > 0x100000) {
                throw new IOException("Config file " + String.valueOf(configPath.getFileName()) + " would exceed maximum size limit of 1MB");
            }
            Path tempFile = configPath.resolveSibling(String.valueOf(configPath.getFileName()) + ".tmp");
            Files.writeString(tempFile, (CharSequence)jsonString, StandardCharsets.UTF_8, new OpenOption[0]);
            Files.move(tempFile, configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            if (!tempSaveErrors.isEmpty()) {
                LOGGER.warn("Some issues occurred during block config save: " + String.join((CharSequence)"; ", tempSaveErrors));
                configErrors.addAll(tempSaveErrors);
            }
        }
        catch (IOException e) {
            String error = "Failed to save block config (" + String.valueOf(configPath.getFileName()) + "): " + e.getMessage();
            LOGGER.error(error, (Throwable)e);
            configErrors.add(error);
        }
    }

    public static Set<String> getMineableBlocks() {
        return new HashSet<String>(mineableBlocks);
    }

    public static List<String> loadDefaultBlocks() {
        ArrayList<String> defaults;
        block18: {
            defaults = new ArrayList<String>();
            try (InputStream input = ModConfig.class.getResourceAsStream(INTERNAL_BLOCK_CONFIG_FILE);){
                if (input != null) {
                    try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                        JsonObject defaultConfig = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        if (defaultConfig != null && defaultConfig.has("values") && defaultConfig.get("values").isJsonArray()) {
                            JsonArray values = defaultConfig.getAsJsonArray("values");
                            for (int i = 0; i < values.size(); ++i) {
                                JsonObject blockObj;
                                if (!values.get(i).isJsonObject() || !(blockObj = values.get(i).getAsJsonObject()).has("id") || !blockObj.get("id").isJsonPrimitive() || !blockObj.get("id").getAsJsonPrimitive().isString()) continue;
                                defaults.add(blockObj.get("id").getAsString());
                            }
                        }
                        break block18;
                    }
                    catch (JsonSyntaxException e) {
                        LOGGER.error("Failed to parse default block config resource: " + e.getMessage(), (Throwable)e);
                        configErrors.add("Failed to parse default block config resource (/data/mineable.json): " + e.getMessage());
                    }
                    break block18;
                }
                LOGGER.warn("Default block config resource (/data/mineable.json) not found.");
                configErrors.add("Default block config resource (/data/mineable.json) not found.");
            }
            catch (Exception e) {
                LOGGER.error("Failed to load default blocks from resources", (Throwable)e);
                configErrors.add("Failed to load default blocks (/data/mineable.json): " + e.getMessage());
            }
        }
        return defaults;
    }

    static {
        block6: {
            LOGGER = LoggerFactory.getLogger((String)"invasivezombies");
            GSON = new GsonBuilder().setPrettyPrinting().create();
            mineableBlocks = new ArrayList<String>();
            configErrors = new ArrayList<String>();
            isInitialized = false;
            try {
                configPath = FabricLoader.getInstance().getConfigDir().resolve(MODIFIABLE_BLOCK_CONFIG_FILE);
                ModConfig.loadOrCreateSettingsConfig();
                ModConfig.loadOrCreateBlockConfig();
                isInitialized = true;
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize config", (Throwable)e);
                configErrors.add("Critical initialization error: " + e.getMessage());
                if (zombieSettings == null) {
                    zombieSettings = new ZombieSettings();
                }
                if (mineableBlocks.isEmpty() && configPath != null) {
                    try {
                        mineableBlocks = new ArrayList<String>(ModConfig.loadDefaultBlocks());
                    }
                    catch (Exception ex) {
                        LOGGER.error("Fallback to default blocks failed", (Throwable)ex);
                    }
                }
                if (!mineableBlocks.isEmpty()) break block6;
                mineableBlocks = new ArrayList<String>();
            }
        }
    }

    public static class ZombieSettings {
        private double followRange = 50.0;
        private double movementSpeed = 0.23;
        private float miningSpeed = 1.0f;
        private int TargetRange = 15;
        private boolean BabyZombiesEnabled = false;
        private boolean TargetBlockParticlesEnabled = false;
        private boolean TargetBlockPathingParticlesEnabled = false;
        private int FarBlockSearchDistance = 12;
        private int DoorSearchDistance = 12;

        public double getFollowRange() {
            return this.followRange;
        }

        public void setFollowRange(double followRange) {
            this.followRange = followRange;
        }

        public double getMovementSpeed() {
            return this.movementSpeed;
        }

        public void setMovementSpeed(double movementSpeed) {
            this.movementSpeed = movementSpeed;
        }

        public float getMiningSpeed() {
            return this.miningSpeed;
        }

        public void setMiningSpeed(float miningSpeed) {
            this.miningSpeed = miningSpeed;
        }

        public int getTargetRange() {
            return this.TargetRange;
        }

        public void setTargetRange(int TargetRange) {
            this.TargetRange = TargetRange;
        }

        public boolean getBabyZombiesEnabled() {
            return this.BabyZombiesEnabled;
        }

        public void setBabyZombiesEnabled(boolean BabyZombiesEnabled) {
            this.BabyZombiesEnabled = BabyZombiesEnabled;
        }

        public boolean getTargetBlockParticlesEnabled() {
            return this.TargetBlockParticlesEnabled;
        }

        public void setTargetBlockParticlesEnabled(boolean TargetBlockParticlesEnabled) {
            this.TargetBlockParticlesEnabled = TargetBlockParticlesEnabled;
        }

        public boolean getTargetBlockPathingParticlesEnabled() {
            return this.TargetBlockPathingParticlesEnabled;
        }

        public void setTargetBlockPathingParticlesEnabled(boolean TargetBlockPathingParticlesEnabled) {
            this.TargetBlockPathingParticlesEnabled = TargetBlockPathingParticlesEnabled;
        }

        public int getFarBlockSearchDistance() {
            return this.FarBlockSearchDistance;
        }

        public void setFarBlockSearchDistance(int FarBlockSearchDistance) {
            this.FarBlockSearchDistance = FarBlockSearchDistance;
        }

        public int getDoorSearchDistance() {
            return this.DoorSearchDistance;
        }

        public void setDoorSearchDistance(int DoorSearchDistance) {
            this.DoorSearchDistance = DoorSearchDistance;
        }
    }
}

