/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.events;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.AttributeManager;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.DatabaseManager;
import com.github.ob_yekt.simpleskills.managers.NamePrefixManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.requirements.SkillRequirement;
import com.github.ob_yekt.simpleskills.ui.SkillTabMenu;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8111;

public class EventHandlers {
    public static void registerAll() {
        EventHandlers.registerBlockHandlers();
        EventHandlers.registerCombatHandlers();
        EventHandlers.registerJoinLeaveHandlers();
        EventHandlers.registerPrayerHandlers();
    }

    private static void registerBlockHandlers() {
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            boolean isFarmingBlock;
            SkillRequirement requirement;
            if (world.method_8608() || !(player instanceof class_3222)) {
                return true;
            }
            class_3222 serverPlayer = (class_3222)player;
            String blockTranslationKey = state.method_26204().method_63499();
            String toolId = "minecraft:air";
            class_1799 mainHandStack = serverPlayer.method_6047();
            if (!mainHandStack.method_7960()) {
                toolId = class_7923.field_41178.method_10221((Object)mainHandStack.method_7909()).toString();
            }
            if ((requirement = ConfigManager.getToolRequirement(toolId)) != null) {
                Skills requiredSkill = requirement.getSkill();
                int requiredLevel = requirement.getLevel();
                int playerLevel = XPManager.getSkillLevel(serverPlayer.method_5845(), requiredSkill);
                if (playerLevel < requiredLevel) {
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a76[simpleskills]\u00a7f You need %s level %d to use this tool!", requiredSkill.getDisplayName(), requiredLevel)), true);
                    return false;
                }
            }
            Skills relevantSkill = ConfigManager.getBlockSkill(blockTranslationKey);
            boolean bl = isFarmingBlock = ConfigManager.getFarmingBlockXP(blockTranslationKey) > 0;
            if (relevantSkill != null && EventHandlers.isCrop(blockTranslationKey) || isFarmingBlock) {
                return true;
            }
            return true;
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (world.method_8608() || !(player instanceof class_3222)) {
                return;
            }
            class_3222 serverPlayer = (class_3222)player;
            String blockTranslationKey = state.method_26204().method_63499();
            Skills relevantSkill = ConfigManager.getBlockSkill(blockTranslationKey);
            if (ConfigManager.getFarmingBlockXP(blockTranslationKey) > 0) {
                EventHandlers.grantFarmingXP((class_3218)world, serverPlayer, state, blockTranslationKey);
                return;
            }
            if (relevantSkill == null) {
                return;
            }
            if ((blockTranslationKey.contains("_ore") || blockTranslationKey.contains("melon")) && EventHandlers.hasSilkTouch(serverPlayer)) {
                Simpleskills.LOGGER.debug("No XP granted for {} to player {} due to Silk Touch", (Object)blockTranslationKey, (Object)serverPlayer.method_5477().getString());
                return;
            }
            if (relevantSkill == Skills.FARMING) {
                EventHandlers.grantFarmingXP((class_3218)world, serverPlayer, state, blockTranslationKey);
            } else {
                int xp = ConfigManager.getBlockXP(blockTranslationKey, relevantSkill);
                XPManager.addXPWithNotification(serverPlayer, relevantSkill, xp);
            }
        });
    }

    private static boolean isCrop(String blockTranslationKey) {
        return blockTranslationKey.contains("wheat") || blockTranslationKey.contains("carrots") || blockTranslationKey.contains("potatoes") || blockTranslationKey.contains("beetroots") || blockTranslationKey.contains("nether_wart") || blockTranslationKey.contains("cocoa") || blockTranslationKey.contains("melon");
    }

    private static void grantFarmingXP(class_3218 world, class_3222 serverPlayer, class_2680 state, String blockTranslationKey) {
        if (EventHandlers.isCrop(blockTranslationKey)) {
            if (state.method_28498((class_2769)class_2741.field_12550)) {
                int age = (Integer)state.method_11654((class_2769)class_2741.field_12550);
                if (age == 7 && (blockTranslationKey.contains("wheat") || blockTranslationKey.contains("carrots") || blockTranslationKey.contains("potatoes"))) {
                    int xp = ConfigManager.getFarmingBlockXP(blockTranslationKey);
                    XPManager.addXPWithNotification(serverPlayer, Skills.FARMING, xp);
                    Simpleskills.LOGGER.debug("Granted {} XP for harvesting {} to player {}", new Object[]{xp, blockTranslationKey, serverPlayer.method_5477().getString()});
                }
            } else if (state.method_28498((class_2769)class_2741.field_12497)) {
                int age = (Integer)state.method_11654((class_2769)class_2741.field_12497);
                if (age == 3 && (blockTranslationKey.contains("nether_wart") || blockTranslationKey.contains("beetroots"))) {
                    int xp = ConfigManager.getFarmingBlockXP(blockTranslationKey);
                    XPManager.addXPWithNotification(serverPlayer, Skills.FARMING, xp);
                    Simpleskills.LOGGER.debug("Granted {} XP for harvesting {} to player {}", new Object[]{xp, blockTranslationKey, serverPlayer.method_5477().getString()});
                }
            } else if (state.method_28498((class_2769)class_2741.field_12556)) {
                int age = (Integer)state.method_11654((class_2769)class_2741.field_12556);
                if (age == 2 && blockTranslationKey.contains("cocoa")) {
                    int xp = ConfigManager.getFarmingBlockXP(blockTranslationKey);
                    XPManager.addXPWithNotification(serverPlayer, Skills.FARMING, xp);
                    Simpleskills.LOGGER.debug("Granted {} XP for harvesting {} to player {}", new Object[]{xp, blockTranslationKey, serverPlayer.method_5477().getString()});
                }
            } else if (blockTranslationKey.contains("melon")) {
                int xp = ConfigManager.getFarmingBlockXP(blockTranslationKey);
                XPManager.addXPWithNotification(serverPlayer, Skills.FARMING, xp);
                Simpleskills.LOGGER.debug("Granted {} XP for harvesting {} to player {}", new Object[]{xp, blockTranslationKey, serverPlayer.method_5477().getString()});
            }
        }
    }

    private static void registerCombatHandlers() {
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_3222 serverPlayer;
            block7: {
                block6: {
                    if (world.method_8608() || !(player instanceof class_3222)) break block6;
                    serverPlayer = (class_3222)player;
                    if (entity instanceof class_1309) break block7;
                }
                return class_1269.field_5811;
            }
            class_1799 weapon = serverPlayer.method_6047();
            if (weapon.method_7960()) {
                return class_1269.field_5811;
            }
            String weaponId = class_7923.field_41178.method_10221((Object)weapon.method_7909()).toString();
            SkillRequirement requirement = ConfigManager.getWeaponRequirement(weaponId);
            if (requirement == null) {
                return class_1269.field_5811;
            }
            Skills skill = requirement.getSkill();
            int playerLevel = XPManager.getSkillLevel(serverPlayer.method_5845(), skill);
            if (playerLevel < requirement.getLevel()) {
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a76[simpleskills]\u00a7f You need %s level %d to use this weapon!", skill.getDisplayName(), requirement.getLevel())), true);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (world.method_8608() || !(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 serverPlayer = (class_3222)player;
            class_1799 stack = player.method_5998(hand);
            if (stack.method_7960()) {
                return class_1269.field_5811;
            }
            String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
            SkillRequirement requirement = ConfigManager.getWeaponRequirement(itemId);
            if (requirement == null) {
                return class_1269.field_5811;
            }
            Skills skill = requirement.getSkill();
            int playerLevel = XPManager.getSkillLevel(serverPlayer.method_5845(), skill);
            if (playerLevel < requirement.getLevel()) {
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a76[simpleskills]\u00a7f You need %s level %d to use this!", skill.getDisplayName(), requirement.getLevel())), true);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            class_1309 target;
            float minDamageRanged;
            if (entity.method_73183().method_8608() || amount <= 0.0f) {
                return true;
            }
            if (source.method_49708(class_8111.field_42331) || source.method_49708(class_8111.field_42332)) {
                return true;
            }
            JsonObject config = ConfigManager.getCombatConfig();
            float xpPerDamageSlaying = config.get("slaying_xp_per_damage") != null ? config.get("slaying_xp_per_damage").getAsFloat() : 100.0f;
            float xpPerDamageRanged = config.get("ranged_xp_per_damage") != null ? config.get("ranged_xp_per_damage").getAsFloat() : 100.0f;
            float minDamageSlaying = config.get("slaying_min_damage_threshold") != null ? config.get("slaying_min_damage_threshold").getAsFloat() : 2.0f;
            float f = minDamageRanged = config.get("ranged_min_damage_threshold") != null ? config.get("ranged_min_damage_threshold").getAsFloat() : 2.0f;
            if (entity instanceof class_1309 && !((target = entity) instanceof class_1657) && !(entity instanceof class_1531)) {
                class_3222 attacker = null;
                Skills skill = null;
                float xpMultiplier = 0.0f;
                float minDamage = 0.0f;
                int xp = 0;
                if (source.method_5529() instanceof class_3222) {
                    attacker = (class_3222)source.method_5529();
                    class_1799 weapon = attacker.method_6047();
                    String weaponId = weapon.method_7960() ? "minecraft:empty" : class_7923.field_41178.method_10221((Object)weapon.method_7909()).toString();
                    SkillRequirement requirement = ConfigManager.getWeaponRequirement(weaponId);
                    skill = requirement != null && requirement.getSkill() == Skills.RANGED ? Skills.RANGED : Skills.SLAYING;
                    xpMultiplier = skill == Skills.RANGED ? xpPerDamageRanged : xpPerDamageSlaying;
                    minDamage = skill == Skills.RANGED ? minDamageRanged : minDamageSlaying;
                    xp = (int)(amount * xpMultiplier);
                } else {
                    class_1676 projectile;
                    class_1297 patt0$temp = source.method_5526();
                    if (patt0$temp instanceof class_1676 && (projectile = (class_1676)patt0$temp).method_24921() instanceof class_3222) {
                        attacker = (class_3222)projectile.method_24921();
                        skill = Skills.RANGED;
                        xpMultiplier = xpPerDamageRanged;
                        minDamage = minDamageRanged;
                        xp = (int)(amount * xpMultiplier);
                    }
                }
                if (attacker != null && amount >= minDamage) {
                    XPManager.addXPWithNotification(attacker, skill, xp);
                    Simpleskills.LOGGER.debug("Granted {} XP in {} to {} for dealing {} damage to {}", new Object[]{xp, skill.getId(), attacker.method_5477().getString(), Float.valueOf(amount), target.method_5864().toString()});
                }
            }
            return true;
        });
        ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, originalAmount, actualAmount, blocked) -> {
            if (entity.method_73183().method_8608()) {
                return;
            }
            if (source.method_49708(class_8111.field_42331) || source.method_49708(class_8111.field_42332)) {
                return;
            }
            if (entity instanceof class_3222) {
                class_1309 attacker;
                class_3222 defender = (class_3222)entity;
                class_1297 patt0$temp = source.method_5529();
                if (patt0$temp instanceof class_1309 && !((attacker = (class_1309)patt0$temp) instanceof class_1657)) {
                    float shieldXPMultiplier;
                    JsonObject config = ConfigManager.getCombatConfig();
                    float xpPerDamageDefense = config.get("defense_xp_per_damage") != null ? config.get("defense_xp_per_damage").getAsFloat() : 100.0f;
                    float minDamageDefense = config.get("defense_min_damage_threshold") != null ? config.get("defense_min_damage_threshold").getAsFloat() : 2.0f;
                    float armorMultiplierPerPiece = config.get("defense_xp_armor_multiplier_per_piece") != null ? config.get("defense_xp_armor_multiplier_per_piece").getAsFloat() : 0.25f;
                    float f = shieldXPMultiplier = config.get("defense_shield_xp_multiplier") != null ? config.get("defense_shield_xp_multiplier").getAsFloat() : 0.3f;
                    if (originalAmount >= minDamageDefense) {
                        boolean wasBlocked;
                        boolean bl = wasBlocked = blocked || originalAmount > actualAmount && defender.method_6039() && defender.method_6030().method_7909() == class_1802.field_8255;
                        if (wasBlocked) {
                            int xp = (int)(originalAmount * xpPerDamageDefense * shieldXPMultiplier);
                            XPManager.addXPWithNotification(defender, Skills.DEFENSE, xp);
                            Simpleskills.LOGGER.debug("Granted {} XP in {} to {} for blocking {} damage from {} with shield", new Object[]{xp, Skills.DEFENSE.getId(), defender.method_5477().getString(), Float.valueOf(originalAmount), attacker.method_5864().toString()});
                        } else {
                            int armorCount = 0;
                            for (class_1304 slot : class_1304.values()) {
                                if (!slot.method_46643() || defender.method_6118(slot).method_7960()) continue;
                                ++armorCount;
                            }
                            if (armorCount > 0) {
                                float armorMultiplier = (float)armorCount * armorMultiplierPerPiece;
                                int xp = (int)(actualAmount * xpPerDamageDefense * armorMultiplier);
                                XPManager.addXPWithNotification(defender, Skills.DEFENSE, xp);
                                Simpleskills.LOGGER.debug("Granted {} XP in {} to {} for taking {} damage from {} with {} armor pieces", new Object[]{xp, Skills.DEFENSE.getId(), defender.method_5477().getString(), Float.valueOf(actualAmount), attacker.method_5864().toString(), armorCount});
                            }
                        }
                    }
                }
            }
        });
    }

    private static void registerJoinLeaveHandlers() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (player == null) {
                Simpleskills.LOGGER.warn("Null player in join event.");
                return;
            }
            String playerUuid = player.method_5845();
            String playerName = player.method_5477().getString();
            DatabaseManager db = DatabaseManager.getInstance();
            db.ensurePlayerInitialized(playerUuid);
            db.updatePlayerName(playerUuid, playerName);
            AttributeManager.refreshAllAttributes(player);
            SkillTabMenu.updateTabMenu(player);
            NamePrefixManager.updatePlayerNameDecorations(player);
            Simpleskills.LOGGER.debug("Processed join for player: {}", (Object)playerName);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            if (player == null) {
                Simpleskills.LOGGER.warn("Null player in disconnect event.");
                return;
            }
            String playerUuid = player.method_5845();
            AttributeManager.clearSkillAttributes(player);
            AttributeManager.clearIronmanAttributes(player);
            SkillTabMenu.clearPlayerVisibility(player.method_5667());
            Simpleskills.LOGGER.debug("Processed disconnect for player: {}", (Object)player.method_5477().getString());
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (newPlayer == null) {
                Simpleskills.LOGGER.warn("Null newPlayer in respawn event.");
                return;
            }
            String playerUuid = newPlayer.method_5845();
            DatabaseManager db = DatabaseManager.getInstance();
            if (!alive) {
                if (db.isPlayerInIronmanMode(playerUuid)) {
                    int totalLevels = db.getAllSkills(playerUuid).values().stream().mapToInt(DatabaseManager.SkillData::level).sum();
                    int prestige = db.getPrestige(playerUuid);
                    db.setIronmanMode(playerUuid, false);
                    db.resetPlayerSkills(playerUuid);
                    db.ensurePlayerInitialized(playerUuid);
                    AttributeManager.clearSkillAttributes(newPlayer);
                    AttributeManager.clearIronmanAttributes(newPlayer);
                    newPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Your deal with death has cost you all skill levels. Ironman mode has been disabled.").method_27692(class_124.field_1054), false);
                    if (ConfigManager.getFeatureConfig().get("broadcast_ironman_death") != null && ConfigManager.getFeatureConfig().get("broadcast_ironman_death").getAsBoolean()) {
                        String prestigePart = prestige > 0 ? String.format(" at \u00a76\u2605%d\u00a7f", prestige) : "";
                        Objects.requireNonNull(newPlayer.method_51469().method_8503()).method_3760().method_43514((class_2561)class_2561.method_43470((String)String.format("\u00a76[simpleskills]\u00a7f %s has died in Ironman mode with a total level of \u00a76%d\u00a7f%s.", newPlayer.method_5477().getString(), totalLevels, prestigePart)), false);
                    }
                    Simpleskills.LOGGER.debug("Disabled Ironman mode and reset skills for player: {}", (Object)newPlayer.method_5477().getString());
                } else {
                    AttributeManager.clearSkillAttributes(newPlayer);
                    AttributeManager.clearIronmanAttributes(newPlayer);
                }
            }
            AttributeManager.refreshAllAttributes(newPlayer);
            SkillTabMenu.updateTabMenu(newPlayer);
            NamePrefixManager.updatePlayerNameDecorations(newPlayer);
            Simpleskills.LOGGER.debug("Processed respawn for player: {}, alive: {}", (Object)newPlayer.method_5477().getString(), (Object)alive);
        });
    }

    private static void registerPrayerHandlers() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (world.method_8608() || !(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 serverPlayer = (class_3222)player;
            class_2680 state = world.method_8320(hitResult.method_17777());
            if (state.method_26164(class_3481.field_26983) && ((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                class_1799 stack = serverPlayer.method_5998(hand);
                String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
                ConfigManager.PrayerSacrifice sacrifice = ConfigManager.getPrayerSacrifice(itemId);
                if (sacrifice == null) {
                    return class_1269.field_5811;
                }
                SkillRequirement requirement = sacrifice.requirement();
                int playerLevel = XPManager.getSkillLevel(serverPlayer.method_5845(), Skills.PRAYER);
                if (playerLevel < requirement.getLevel()) {
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f You need Prayer level " + requirement.getLevel() + " to offer this sacrifice!")), true);
                    return class_1269.field_5814;
                }
                for (ConfigManager.PrayerSacrifice existingSacrifice : ConfigManager.PRAYER_SACRIFICES.values()) {
                    class_7923.field_41174.method_10223(class_2960.method_60654((String)existingSacrifice.effect())).ifPresent(arg_0 -> ((class_3222)serverPlayer).method_6016(arg_0));
                }
                stack.method_7934(1);
                XPManager.addXPWithNotification(serverPlayer, Skills.PRAYER, sacrifice.xp());
                class_6880 effectEntry = class_7923.field_41174.method_10223(class_2960.method_60654((String)sacrifice.effect())).orElse(null);
                if (effectEntry != null) {
                    serverPlayer.method_6092(new class_1293(effectEntry, sacrifice.durationTicks(), sacrifice.effectLevel() - 1, sacrifice.isAmbient(), true));
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f You offer a sacrifice and gain " + sacrifice.displayName() + "!")), false);
                } else {
                    Simpleskills.LOGGER.warn("Invalid status effect {} for item {} in prayer_sacrifices.json", (Object)sacrifice.effect(), (Object)itemId);
                }
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_65096((class_2394)class_2398.field_22246, (double)hitResult.method_17777().method_10263() + 0.4, (double)hitResult.method_17777().method_10264() + 1.0, (double)hitResult.method_17777().method_10260() + 0.5, 20, 0.2, 0.2, 0.2, 0.05);
                serverWorld.method_65096((class_2394)class_2398.field_61966, (double)hitResult.method_17777().method_10263() + 0.5, (double)hitResult.method_17777().method_10264() + 1.0, (double)hitResult.method_17777().method_10260() + 0.4, 20, 0.2, 0.2, 0.2, 0.05);
                serverWorld.method_8396(null, hitResult.method_17777(), class_3417.field_26980, class_3419.field_15245, 1.0f, 1.0f);
                Simpleskills.LOGGER.debug("Player {} offered {} for {} XP and {} effect (level {}, ambient {})", new Object[]{serverPlayer.method_5477().getString(), itemId, sacrifice.xp(), sacrifice.displayName(), sacrifice.effectLevel(), sacrifice.isAmbient()});
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }

    private static boolean hasSilkTouch(class_3222 player) {
        class_1799 toolStack = player.method_6118(class_1304.field_6173);
        class_2378 enchantmentRegistry = Objects.requireNonNull(player.method_51469().method_8503()).method_30611().method_30530(class_7924.field_41265);
        class_6880 silkTouchEntry = enchantmentRegistry.method_46746(class_1893.field_9099).orElse(null);
        if (silkTouchEntry == null) {
            Simpleskills.LOGGER.warn("Silk Touch enchantment not found in registry for player {}", (Object)player.method_5477().getString());
            return false;
        }
        return class_1890.method_8225((class_6880)silkTouchEntry, (class_1799)toolStack) > 0;
    }
}

