/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.managers;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.requirements.SkillRequirement;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.util.StringUtil;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ConfigManager {
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("simpleskills");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<Skills, Integer> BASE_XP_MAP = new HashMap<Skills, Integer>();
    private static final Map<String, Skills> BLOCK_SKILL_MAP = new HashMap<String, Skills>();
    private static final Map<String, Integer> BLOCK_XP_MAP = new HashMap<String, Integer>();
    private static final Map<String, SkillRequirement> TOOL_REQUIREMENTS = new HashMap<String, SkillRequirement>();
    private static final Map<String, SkillRequirement> ARMOR_REQUIREMENTS = new HashMap<String, SkillRequirement>();
    private static final Map<String, SkillRequirement> WEAPON_REQUIREMENTS = new HashMap<String, SkillRequirement>();
    private static final Map<String, SkillRequirement> ENCHANTMENT_REQUIREMENTS = new HashMap<String, SkillRequirement>();
    public static final Map<String, PrayerSacrifice> PRAYER_SACRIFICES = new HashMap<String, PrayerSacrifice>();
    private static final Map<String, Integer> COOKING_XP_MAP = new HashMap<String, Integer>();
    private static final Map<String, Float> COOKING_MULTIPLIER_MAP = new HashMap<String, Float>();
    private static final Map<String, Integer> CRAFTING_XP_MAP = new HashMap<String, Integer>();
    private static final Map<String, Integer> SMELTING_CRAFTING_XP_MAP = new HashMap<String, Integer>();
    private static JsonObject craftingMultipliersConfig = new JsonObject();
    private static final Set<String> CRAFTING_RECOVERY_BLACKLIST = new HashSet<String>();
    private static final Map<String, Integer> ALCHEMY_XP_MAP = new HashMap<String, Integer>();
    private static final Map<String, Float> ALCHEMY_MULTIPLIER_MAP = new HashMap<String, Float>();
    private static final Map<String, Integer> AGILITY_XP_MAP = new HashMap<String, Integer>();
    private static final Map<String, Float> SMITHING_XP_MAP = new HashMap<String, Float>();
    private static final Map<String, Integer> FARMING_ACTION_XP_MAP = new HashMap<String, Integer>();
    private static final Map<String, Integer> FARMING_BLOCK_XP_MAP = new HashMap<String, Integer>();
    private static final Map<String, Float> SMITHING_MULTIPLIER_MAP = new HashMap<String, Float>();
    private static final Map<String, Integer> FISHING_XP_MAP = new HashMap<String, Integer>();
    private static final Map<String, class_2960> FISHING_LOOT_TABLES = new HashMap<String, class_2960>();
    private static JsonObject featureConfig = new JsonObject();
    private static JsonObject combatConfig = new JsonObject();

    public static void initialize() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            ConfigManager.loadBaseXPConfig();
            ConfigManager.loadFeatureConfig();
            ConfigManager.loadAgilityXPConfig();
            ConfigManager.loadBlockMappings();
            ConfigManager.loadToolRequirements();
            ConfigManager.loadArmorRequirements();
            ConfigManager.loadWeaponRequirements();
            ConfigManager.loadEnchantmentRequirements();
            ConfigManager.loadPrayerSacrifices();
            ConfigManager.loadCookingXPConfig();
            ConfigManager.loadCookingMultipliersConfig();
            ConfigManager.loadCraftingXPConfig();
            ConfigManager.loadCraftingMultipliersConfig();
            ConfigManager.loadCraftingRecoveryBlacklist();
            ConfigManager.loadSmeltingCraftingXPConfig();
            ConfigManager.loadAlchemyXPConfig();
            ConfigManager.loadAlchemyMultiplierConfig();
            ConfigManager.loadSmithingXPConfig();
            ConfigManager.loadSmithingMultiplierConfig();
            ConfigManager.loadFishingXPConfig();
            ConfigManager.loadFishingLootConfig();
            ConfigManager.loadFarmingXPConfig();
            ConfigManager.loadCombatConfig();
            Simpleskills.LOGGER.info("All configurations initialized successfully.");
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error initializing configurations: {}", (Object)e.getMessage());
        }
    }

    private static void loadBaseXPConfig() {
        Path filePath = CONFIG_DIR.resolve("base_xp.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultBaseXPConfig());
            for (Skills skill : Skills.values()) {
                String skillId = skill.getId();
                if (json.has(skillId)) {
                    int xp = json.get(skillId).getAsInt();
                    if (xp >= 0) {
                        BASE_XP_MAP.put(skill, xp);
                        continue;
                    }
                    Simpleskills.LOGGER.warn("Invalid XP value for skill {} in base_xp.json, using default", (Object)skillId);
                    continue;
                }
                Simpleskills.LOGGER.warn("Skill {} missing in base_xp.json, using default XP", (Object)skillId);
            }
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in base_xp.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading base_xp.json: {}", (Object)e.getMessage());
        }
    }

    private static void loadFeatureConfig() {
        Path filePath = CONFIG_DIR.resolve("config.json");
        try {
            JsonObject defaultConfig = ConfigManager.getDefaultFeatureConfig();
            JsonObject loadedConfig = ConfigManager.loadJsonFile(filePath, defaultConfig);
            for (Map.Entry entry : defaultConfig.entrySet()) {
                if (loadedConfig.has((String)entry.getKey())) continue;
                loadedConfig.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            featureConfig = loadedConfig;
            try (FileWriter writer = new FileWriter(filePath.toFile());){
                GSON.toJson((JsonElement)loadedConfig, (Appendable)writer);
            }
            Simpleskills.LOGGER.info("Loaded and merged config.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in config.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading config.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultBaseXPConfig() {
        JsonObject json = new JsonObject();
        for (Skills skill : Skills.values()) {
            json.addProperty(skill.getId(), (Number)100);
        }
        return json;
    }

    private static JsonObject getDefaultFeatureConfig() {
        JsonObject json = new JsonObject();
        json.addProperty("xp_notifications_enabled", Boolean.valueOf(true));
        json.addProperty("xp_notification_threshold", (Number)10);
        json.addProperty("standard_xp_multiplier", (Number)2.0);
        json.addProperty("ironman_xp_multiplier", (Number)0.8);
        json.addProperty("ironman_health_reduction", (Number)-6.0);
        json.addProperty("broadcast_ironman_death", Boolean.valueOf(true));
        json.addProperty("level_up_effects_enabled", Boolean.valueOf(true));
        json.addProperty("level_up_notifications_enabled", Boolean.valueOf(true));
        json.addProperty("item_requirements_in_tooltips_enabled", Boolean.valueOf(true));
        json.addProperty("crafting_lore_in_tooltips_enabled", Boolean.valueOf(true));
        json.addProperty("custom_fishing_loot_enabled", Boolean.valueOf(true));
        json.addProperty("fishing_speed_bonus_enabled", Boolean.valueOf(true));
        return json;
    }

    private static void loadBlockMappings() {
        Path filePath = CONFIG_DIR.resolve("block_mappings.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultBlockMappings());
            JsonArray mappings = json.getAsJsonArray("block_mappings");
            BLOCK_SKILL_MAP.clear();
            BLOCK_XP_MAP.clear();
            for (JsonElement element : mappings) {
                JsonObject mapping = element.getAsJsonObject();
                String block = mapping.get("block").getAsString();
                String skillId = mapping.get("skill").getAsString();
                int xp = mapping.get("xp").getAsInt();
                try {
                    Skills skill = Skills.valueOf(skillId.toUpperCase());
                    if (xp < 0) {
                        Simpleskills.LOGGER.warn("Invalid XP value {} for block {} in block_mappings.json, skipping", (Object)xp, (Object)block);
                        continue;
                    }
                    if (block.contains("*")) {
                        String regex = block.replace("*", ".*");
                        for (Map.Entry blockEntry : class_7923.field_41175.method_29722()) {
                            String translationKey = ((class_2248)blockEntry.getValue()).method_63499();
                            if (!translationKey.matches(regex)) continue;
                            BLOCK_SKILL_MAP.put(translationKey, skill);
                            BLOCK_XP_MAP.put(translationKey, xp);
                        }
                        continue;
                    }
                    BLOCK_SKILL_MAP.put(block, skill);
                    BLOCK_XP_MAP.put(block, xp);
                }
                catch (IllegalArgumentException e) {
                    Simpleskills.LOGGER.warn("Invalid skill {} for block {} in block_mappings.json, skipping", (Object)skillId, (Object)block);
                }
            }
            Simpleskills.LOGGER.info("Loaded {} block mappings.", (Object)BLOCK_SKILL_MAP.size());
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in block_mappings.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading block_mappings.json: {}", (Object)e.getMessage());
        }
    }

    private static void loadAgilityXPConfig() {
        Path filePath = CONFIG_DIR.resolve("agility_xp.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultAgilityXPConfig());
            JsonArray mappings = json.getAsJsonArray("agility_mappings");
            AGILITY_XP_MAP.clear();
            for (JsonElement element : mappings) {
                JsonObject mapping = element.getAsJsonObject();
                String action = mapping.get("action").getAsString();
                int xp = mapping.get("xp").getAsInt();
                if (xp < 0) {
                    Simpleskills.LOGGER.warn("Invalid XP value {} for action {} in agility_xp.json, skipping", (Object)xp, (Object)action);
                    continue;
                }
                AGILITY_XP_MAP.put(action, xp);
            }
            Simpleskills.LOGGER.info("Loaded agility_xp.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in agility_xp.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading agility_xp.json: {}", (Object)e.getMessage());
        }
    }

    private static void loadToolRequirements() {
        Path filePath = CONFIG_DIR.resolve("tool_requirements.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultToolRequirements());
            for (Map.Entry entry : json.entrySet()) {
                String toolId = (String)entry.getKey();
                JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                String skillId = data.get("skill").getAsString();
                int level = data.get("level").getAsInt();
                try {
                    Skills skill = Skills.valueOf(skillId.toUpperCase());
                    if (level >= 0) {
                        TOOL_REQUIREMENTS.put(toolId, new SkillRequirement(skill, level, null));
                        continue;
                    }
                    Simpleskills.LOGGER.warn("Invalid level for tool {} in tool_requirements.json", (Object)toolId);
                }
                catch (IllegalArgumentException e) {
                    Simpleskills.LOGGER.warn("Invalid skill {} for tool {} in tool_requirements.json", (Object)skillId, (Object)toolId);
                }
            }
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in tool_requirements.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading tool_requirements.json: {}", (Object)e.getMessage());
        }
    }

    private static void loadArmorRequirements() {
        Path filePath = CONFIG_DIR.resolve("armor_requirements.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultArmorRequirements());
            for (Map.Entry entry : json.entrySet()) {
                String armorId = (String)entry.getKey();
                JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                String skillId = data.get("skill").getAsString();
                int level = data.get("level").getAsInt();
                try {
                    Skills skill = Skills.valueOf(skillId.toUpperCase());
                    if (level >= 0) {
                        ARMOR_REQUIREMENTS.put(armorId, new SkillRequirement(skill, level, null));
                        continue;
                    }
                    Simpleskills.LOGGER.warn("Invalid level for armor {} in armor_requirements.json", (Object)armorId);
                }
                catch (IllegalArgumentException e) {
                    Simpleskills.LOGGER.warn("Invalid skill {} for armor {} in armor_requirements.json", (Object)skillId, (Object)armorId);
                }
            }
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in armor_requirements.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading armor_requirements.json: {}", (Object)e.getMessage());
        }
    }

    private static void loadWeaponRequirements() {
        Path filePath = CONFIG_DIR.resolve("weapon_requirements.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultWeaponRequirements());
            for (Map.Entry entry : json.entrySet()) {
                String weaponId = (String)entry.getKey();
                JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                String skillId = data.get("skill").getAsString();
                int level = data.get("level").getAsInt();
                try {
                    Skills skill = Skills.valueOf(skillId.toUpperCase());
                    if (level >= 0) {
                        WEAPON_REQUIREMENTS.put(weaponId, new SkillRequirement(skill, level, null));
                        continue;
                    }
                    Simpleskills.LOGGER.warn("Invalid level for weapon {} in weapon_requirements.json", (Object)weaponId);
                }
                catch (IllegalArgumentException e) {
                    Simpleskills.LOGGER.warn("Invalid skill {} for weapon {} in weapon_requirements.json", (Object)skillId, (Object)weaponId);
                }
            }
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in weapon_requirements.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading weapon_requirements.json: {}", (Object)e.getMessage());
        }
    }

    private static void loadEnchantmentRequirements() {
        Path filePath = CONFIG_DIR.resolve("enchantment_requirements.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultEnchantmentRequirements());
            for (Map.Entry entry : json.entrySet()) {
                String enchantmentId = (String)entry.getKey();
                JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                String skillId = data.get("skill").getAsString();
                int level = data.get("level").getAsInt();
                Integer enchantmentLevel = data.has("enchantmentLevel") ? Integer.valueOf(data.get("enchantmentLevel").getAsInt()) : null;
                try {
                    Skills skill = Skills.valueOf(skillId.toUpperCase());
                    if (level >= 0) {
                        ENCHANTMENT_REQUIREMENTS.put(enchantmentId, new SkillRequirement(skill, level, enchantmentLevel));
                        continue;
                    }
                    Simpleskills.LOGGER.warn("Invalid level for enchantment {} in enchantment_requirements.json", (Object)enchantmentId);
                }
                catch (IllegalArgumentException e) {
                    Simpleskills.LOGGER.warn("Invalid skill {} for enchantment {} in enchantment_requirements.json", (Object)skillId, (Object)enchantmentId);
                }
            }
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in enchantment_requirements.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading enchantment_requirements.json: {}", (Object)e.getMessage());
        }
    }

    private static void loadCombatConfig() {
        Path filePath = CONFIG_DIR.resolve("combat_config.json");
        try {
            combatConfig = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultCombatConfig());
            Simpleskills.LOGGER.info("Loaded combat_config.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in combat_config.json: {}", (Object)e.getMessage());
            combatConfig = ConfigManager.getDefaultCombatConfig();
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading combat_config.json: {}", (Object)e.getMessage());
            combatConfig = ConfigManager.getDefaultCombatConfig();
        }
    }

    private static JsonObject getDefaultCombatConfig() {
        JsonObject json = new JsonObject();
        json.addProperty("slaying_xp_per_damage", (Number)Float.valueOf(100.0f));
        json.addProperty("ranged_xp_per_damage", (Number)Float.valueOf(250.0f));
        json.addProperty("defense_xp_per_damage", (Number)Float.valueOf(400.0f));
        json.addProperty("slaying_min_damage_threshold", (Number)Float.valueOf(2.0f));
        json.addProperty("ranged_min_damage_threshold", (Number)Float.valueOf(2.0f));
        json.addProperty("defense_min_damage_threshold", (Number)Float.valueOf(2.0f));
        json.addProperty("defense_xp_armor_multiplier_per_piece", (Number)Float.valueOf(0.25f));
        json.addProperty("defense_shield_xp_multiplier", (Number)Float.valueOf(0.04f));
        return json;
    }

    public static JsonObject getCombatConfig() {
        if (combatConfig == null) {
            Simpleskills.LOGGER.warn("Combat config is null, returning default config");
            return ConfigManager.getDefaultCombatConfig();
        }
        return combatConfig;
    }

    private static void loadCookingMultipliersConfig() {
        Path filePath = CONFIG_DIR.resolve("cooking_multipliers.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultCookingMultipliersConfig());
            COOKING_MULTIPLIER_MAP.clear();
            for (Map.Entry entry : json.entrySet()) {
                String range = (String)entry.getKey();
                float multiplier = ((JsonElement)entry.getValue()).getAsFloat();
                if (multiplier >= 0.0f) {
                    COOKING_MULTIPLIER_MAP.put(range, Float.valueOf(multiplier));
                    continue;
                }
                Simpleskills.LOGGER.warn("Invalid multiplier {} for range {} in cooking_multipliers.json, skipping", (Object)Float.valueOf(multiplier), (Object)range);
            }
            Simpleskills.LOGGER.info("Loaded cooking_multipliers.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in cooking_multipliers.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading cooking_multipliers.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultCookingMultipliersConfig() {
        JsonObject json = new JsonObject();
        json.addProperty("0-24", (Number)Float.valueOf(0.875f));
        json.addProperty("25-49", (Number)Float.valueOf(1.0f));
        json.addProperty("50-74", (Number)Float.valueOf(1.125f));
        json.addProperty("75-98", (Number)Float.valueOf(1.25f));
        json.addProperty("99-99", (Number)Float.valueOf(1.5f));
        return json;
    }

    public static float getCookingMultiplier(int level) {
        if (level >= 99) {
            return COOKING_MULTIPLIER_MAP.getOrDefault("99-99", Float.valueOf(1.5f)).floatValue();
        }
        if (level >= 75) {
            return COOKING_MULTIPLIER_MAP.getOrDefault("75-98", Float.valueOf(1.25f)).floatValue();
        }
        if (level >= 50) {
            return COOKING_MULTIPLIER_MAP.getOrDefault("50-74", Float.valueOf(1.125f)).floatValue();
        }
        if (level >= 25) {
            return COOKING_MULTIPLIER_MAP.getOrDefault("25-49", Float.valueOf(1.0f)).floatValue();
        }
        return COOKING_MULTIPLIER_MAP.getOrDefault("0-24", Float.valueOf(0.875f)).floatValue();
    }

    private static void loadCookingXPConfig() {
        Path filePath = CONFIG_DIR.resolve("cooking_xp.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultCookingXPConfig());
            JsonArray mappings = json.getAsJsonArray("cooking_mappings");
            COOKING_XP_MAP.clear();
            for (JsonElement element : mappings) {
                JsonObject mapping = element.getAsJsonObject();
                String item = mapping.get("item").getAsString();
                int xp = mapping.get("xp").getAsInt();
                if (xp < 0) {
                    Simpleskills.LOGGER.warn("Invalid XP value {} for item {} in cooking_xp.json, skipping", (Object)xp, (Object)item);
                    continue;
                }
                COOKING_XP_MAP.put(item, xp);
            }
            Simpleskills.LOGGER.info("Loaded cooking_xp.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in cooking_xp.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading cooking_xp.json: {}", (Object)e.getMessage());
        }
    }

    private static void loadCraftingXPConfig() {
        Path filePath = CONFIG_DIR.resolve("crafting_xp.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultCraftingXPConfig());
            JsonArray mappings = json.getAsJsonArray("crafting_mappings");
            CRAFTING_XP_MAP.clear();
            for (JsonElement element : mappings) {
                JsonObject mapping = element.getAsJsonObject();
                String item = mapping.get("item").getAsString();
                int xp = mapping.get("xp").getAsInt();
                if (xp < 0) {
                    Simpleskills.LOGGER.warn("Invalid XP value {} for item {} in crafting_xp.json, skipping", (Object)xp, (Object)item);
                    continue;
                }
                CRAFTING_XP_MAP.put(item, xp);
            }
            Simpleskills.LOGGER.info("Loaded crafting_xp.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in crafting_xp.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading crafting_xp.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultCookingXPConfig() {
        record CookingMapping(String item, int xp) {
        }
        CookingMapping[] defaults;
        JsonObject json = new JsonObject();
        JsonArray mappings = new JsonArray();
        for (CookingMapping mapping : defaults = new CookingMapping[]{new CookingMapping("item.minecraft.cooked_porkchop", 180), new CookingMapping("item.minecraft.cooked_beef", 180), new CookingMapping("item.minecraft.cooked_mutton", 180), new CookingMapping("item.minecraft.cooked_chicken", 225), new CookingMapping("item.minecraft.cooked_salmon", 150), new CookingMapping("item.minecraft.cooked_cod", 150), new CookingMapping("item.minecraft.cooked_rabbit", 285), new CookingMapping("item.minecraft.baked_potato", 130), new CookingMapping("item.minecraft.golden_carrot", 230), new CookingMapping("item.minecraft.golden_apple", 450), new CookingMapping("item.minecraft.bread", 130), new CookingMapping("item.minecraft.cookie", 40), new CookingMapping("item.minecraft.cake", 750), new CookingMapping("item.minecraft.pumpkin_pie", 350), new CookingMapping("item.minecraft.mushroom_stew", 285), new CookingMapping("item.minecraft.beetroot_soup", 285), new CookingMapping("item.minecraft.rabbit_stew", 350)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("item", mapping.item);
            entry.addProperty("xp", (Number)mapping.xp);
            mappings.add((JsonElement)entry);
        }
        json.add("cooking_mappings", (JsonElement)mappings);
        return json;
    }

    public static int getCookingXP(String itemTranslationKey, Skills skill) {
        return COOKING_XP_MAP.getOrDefault(itemTranslationKey, 0);
    }

    private static JsonObject getDefaultCraftingXPConfig() {
        record CraftingMapping(String item, int xp) {
        }
        CraftingMapping[] defaults;
        JsonObject json = new JsonObject();
        JsonArray mappings = new JsonArray();
        for (CraftingMapping mapping : defaults = new CraftingMapping[]{new CraftingMapping("minecraft:wood_shovel", 100), new CraftingMapping("minecraft:wood_hoe", 200), new CraftingMapping("minecraft:wood_sword", 200), new CraftingMapping("minecraft:wood_pickaxe", 300), new CraftingMapping("minecraft:wood_axe", 300), new CraftingMapping("minecraft:leather_helmet", 2500), new CraftingMapping("minecraft:leather_chestplate", 4000), new CraftingMapping("minecraft:leather_leggings", 3500), new CraftingMapping("minecraft:leather_boots", 2000), new CraftingMapping("minecraft:stone_shovel", 150), new CraftingMapping("minecraft:stone_hoe", 300), new CraftingMapping("minecraft:stone_sword", 300), new CraftingMapping("minecraft:stone_pickaxe", 450), new CraftingMapping("minecraft:stone_axe", 450), new CraftingMapping("minecraft:golden_helmet", 4000), new CraftingMapping("minecraft:golden_chestplate", 6400), new CraftingMapping("minecraft:golden_leggings", 5600), new CraftingMapping("minecraft:golden_boots", 3200), new CraftingMapping("minecraft:golden_shovel", 800), new CraftingMapping("minecraft:golden_hoe", 1600), new CraftingMapping("minecraft:golden_sword", 1600), new CraftingMapping("minecraft:golden_pickaxe", 2400), new CraftingMapping("minecraft:golden_axe", 2400), new CraftingMapping("minecraft:copper_helmet", 1750), new CraftingMapping("minecraft:copper_chestplate", 2800), new CraftingMapping("minecraft:copper_leggings", 2450), new CraftingMapping("minecraft:copper_boots", 1400), new CraftingMapping("minecraft:copper_shovel", 350), new CraftingMapping("minecraft:copper_hoe", 700), new CraftingMapping("minecraft:copper_sword", 700), new CraftingMapping("minecraft:copper_pickaxe", 1050), new CraftingMapping("minecraft:copper_axe", 1050), new CraftingMapping("minecraft:iron_helmet", 3500), new CraftingMapping("minecraft:iron_chestplate", 5600), new CraftingMapping("minecraft:iron_leggings", 4900), new CraftingMapping("minecraft:iron_boots", 2800), new CraftingMapping("minecraft:iron_shovel", 700), new CraftingMapping("minecraft:iron_hoe", 1400), new CraftingMapping("minecraft:iron_sword", 1400), new CraftingMapping("minecraft:iron_pickaxe", 2100), new CraftingMapping("minecraft:iron_axe", 2100), new CraftingMapping("minecraft:diamond_helmet", 7500), new CraftingMapping("minecraft:diamond_chestplate", 12000), new CraftingMapping("minecraft:diamond_leggings", 10500), new CraftingMapping("minecraft:diamond_boots", 6000), new CraftingMapping("minecraft:diamond_shovel", 1500), new CraftingMapping("minecraft:diamond_hoe", 3000), new CraftingMapping("minecraft:diamond_sword", 3000), new CraftingMapping("minecraft:diamond_pickaxe", 4500), new CraftingMapping("minecraft:diamond_axe", 4500), new CraftingMapping("minecraft:mace", 7500), new CraftingMapping("minecraft:crossbow", 1500), new CraftingMapping("minecraft:bow", 700)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("item", mapping.item);
            entry.addProperty("xp", (Number)mapping.xp);
            mappings.add((JsonElement)entry);
        }
        json.add("crafting_mappings", (JsonElement)mappings);
        return json;
    }

    public static int getCraftingXP(String itemTranslationKey, Skills skill) {
        return CRAFTING_XP_MAP.getOrDefault(itemTranslationKey, ConfigManager.getBaseXP(skill));
    }

    private static JsonObject loadJsonFile(Path filePath, JsonObject defaultJson) throws IOException {
        if (Files.exists(filePath, new LinkOption[0])) {
            try (BufferedReader reader = new BufferedReader(new FileReader(filePath.toFile()));){
                JsonObject jsonObject = (JsonObject)GSON.fromJson(reader.lines().collect(Collectors.joining("\n")), JsonObject.class);
                return jsonObject;
            }
        }
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        try (FileWriter writer = new FileWriter(filePath.toFile());){
            GSON.toJson((JsonElement)defaultJson, (Appendable)writer);
        }
        return defaultJson;
    }

    private static void loadCraftingMultipliersConfig() {
        Path filePath = CONFIG_DIR.resolve("crafting_multipliers.json");
        try {
            craftingMultipliersConfig = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultCraftingMultipliersConfig());
            Simpleskills.LOGGER.info("Loaded crafting_multipliers.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in crafting_multipliers.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading crafting_multipliers.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultCraftingMultipliersConfig() {
        JsonObject json = new JsonObject();
        JsonObject durability = new JsonObject();
        durability.addProperty("level_25", (Number)Float.valueOf(1.05f));
        durability.addProperty("level_50", (Number)Float.valueOf(1.1f));
        durability.addProperty("level_75", (Number)Float.valueOf(1.15f));
        durability.addProperty("level_99", (Number)Float.valueOf(1.25f));
        JsonObject recovery = new JsonObject();
        recovery.addProperty("level_25", (Number)Float.valueOf(0.05f));
        recovery.addProperty("level_50", (Number)Float.valueOf(0.1f));
        recovery.addProperty("level_75", (Number)Float.valueOf(0.15f));
        recovery.addProperty("level_99", (Number)Float.valueOf(0.25f));
        json.add("durability_multipliers", (JsonElement)durability);
        json.add("recovery_chances", (JsonElement)recovery);
        return json;
    }

    public static float getCraftingDurabilityMultiplier(int level) {
        JsonObject durability = craftingMultipliersConfig.getAsJsonObject("durability_multipliers");
        if (durability == null) {
            Simpleskills.LOGGER.warn("Missing durability_multipliers in crafting_multipliers.json, using defaults");
            return level >= 99 ? 1.2f : (level >= 75 ? 1.15f : (level >= 50 ? 1.1f : (level >= 25 ? 1.05f : 1.0f)));
        }
        if (level >= 99 && durability.has("level_99")) {
            return durability.get("level_99").getAsFloat();
        }
        if (level >= 75 && durability.has("level_75")) {
            return durability.get("level_75").getAsFloat();
        }
        if (level >= 50 && durability.has("level_50")) {
            return durability.get("level_50").getAsFloat();
        }
        if (level >= 25 && durability.has("level_25")) {
            return durability.get("level_25").getAsFloat();
        }
        return 1.0f;
    }

    public static float getCraftingRecoveryChance(int level) {
        JsonObject recovery = craftingMultipliersConfig.getAsJsonObject("recovery_chances");
        if (recovery == null) {
            Simpleskills.LOGGER.warn("Missing recovery_chances in crafting_multipliers.json, using defaults");
            return level >= 99 ? 0.15f : (level >= 75 ? 0.075f : (level >= 50 ? 0.05f : (level >= 25 ? 0.025f : 0.0f)));
        }
        if (level >= 99 && recovery.has("level_99")) {
            return recovery.get("level_99").getAsFloat();
        }
        if (level >= 75 && recovery.has("level_75")) {
            return recovery.get("level_75").getAsFloat();
        }
        if (level >= 50 && recovery.has("level_50")) {
            return recovery.get("level_50").getAsFloat();
        }
        if (level >= 25 && recovery.has("level_25")) {
            return recovery.get("level_25").getAsFloat();
        }
        return 0.0f;
    }

    private static void loadCraftingRecoveryBlacklist() {
        Path filePath = CONFIG_DIR.resolve("crafting_recovery_blacklist.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultCraftingRecoveryBlacklist());
            CRAFTING_RECOVERY_BLACKLIST.clear();
            JsonArray blacklist = json.getAsJsonArray("blacklist");
            if (blacklist != null) {
                for (JsonElement element : blacklist) {
                    String itemId = element.getAsString();
                    CRAFTING_RECOVERY_BLACKLIST.add(itemId);
                }
            }
            Simpleskills.LOGGER.info("Loaded crafting_recovery_blacklist.json with {} entries", (Object)CRAFTING_RECOVERY_BLACKLIST.size());
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in crafting_recovery_blacklist.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading crafting_recovery_blacklist.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultCraftingRecoveryBlacklist() {
        String[] blacklistedItems;
        JsonObject json = new JsonObject();
        JsonArray blacklist = new JsonArray();
        for (String item : blacklistedItems = new String[]{"minecraft:gold_nugget", "minecraft:gold_ingot", "minecraft:gold_block", "minecraft:iron_nugget", "minecraft:iron_ingot", "minecraft:iron_block", "minecraft:copper_ingot", "minecraft:copper_block", "minecraft:copper_nugget", "minecraft:waxed_copper_block", "minecraft:netherite_ingot", "minecraft:netherite_block", "minecraft:raw_iron", "minecraft:raw_iron_block", "minecraft:raw_gold", "minecraft:raw_gold_block", "minecraft:raw_copper", "minecraft:raw_copper_block", "minecraft:diamond", "minecraft:diamond_block", "minecraft:emerald", "minecraft:emerald_block", "minecraft:coal", "minecraft:coal_block", "minecraft:lapis_lazuli", "minecraft:lapis_lazuli_block", "minecraft:resin", "minecraft:resin_block", "minecraft:redstone", "minecraft:redstone_block", "minecraft:amethyst_shard", "minecraft:amethyst_block", "minecraft:wheat", "minecraft:hay_block", "minecraft:slime_ball", "minecraft:slime_block", "minecraft:honey_bottle", "minecraft:honey_block", "minecraft:dried_kelp", "minecraft:dried_kelp_block", "minecraft:bamboo", "minecraft:bamboo_block", "minecraft:snowball", "minecraft:snow_block", "minecraft:clay_ball", "minecraft:clay", "minecraft:glowstone_dust", "minecraft:glowstone", "minecraft:bone_meal", "minecraft:bone_block", "minecraft:wool", "minecraft:string", "minecraft:quartz_block", "minecraft:quartz,", "minecraft:nether_wart", "minecraft:nether_wart_block", "minecraft:ice", "minecraft:packed_ice", "minecraft:blue_ice"}) {
            blacklist.add(item);
        }
        json.add("blacklist", (JsonElement)blacklist);
        return json;
    }

    public static boolean isRecipeBlacklisted(String itemId) {
        return CRAFTING_RECOVERY_BLACKLIST.contains(itemId);
    }

    private static void loadSmeltingCraftingXPConfig() {
        Path filePath = CONFIG_DIR.resolve("smelting_crafting_xp.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultSmeltingCraftingXPConfig());
            JsonArray mappings = json.getAsJsonArray("smelting_crafting_mappings");
            SMELTING_CRAFTING_XP_MAP.clear();
            for (JsonElement element : mappings) {
                JsonObject mapping = element.getAsJsonObject();
                String item = mapping.get("item").getAsString();
                int xp = mapping.get("xp").getAsInt();
                if (xp < 0) {
                    Simpleskills.LOGGER.warn("Invalid XP value {} for item {} in smelting_crafting_xp.json, skipping", (Object)xp, (Object)item);
                    continue;
                }
                SMELTING_CRAFTING_XP_MAP.put(item, xp);
            }
            Simpleskills.LOGGER.info("Loaded smelting_crafting_xp.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in smelting_crafting_xp.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading smelting_crafting_xp.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultSmeltingCraftingXPConfig() {
        record SmeltingCraftingXP(String item, int xp) {
        }
        SmeltingCraftingXP[] defaults;
        JsonObject json = new JsonObject();
        JsonArray mappings = new JsonArray();
        for (SmeltingCraftingXP config : defaults = new SmeltingCraftingXP[]{new SmeltingCraftingXP("item.minecraft.copper_ingot", 125), new SmeltingCraftingXP("item.minecraft.copper_nugget", 50), new SmeltingCraftingXP("item.minecraft.iron_ingot", 150), new SmeltingCraftingXP("item.minecraft.iron_nugget", 62), new SmeltingCraftingXP("item.minecraft.gold_ingot", 200), new SmeltingCraftingXP("item.minecraft.gold_nugget", 75), new SmeltingCraftingXP("item.minecraft.netherite_scrap", 625), new SmeltingCraftingXP("item.minecraft.redstone", 80), new SmeltingCraftingXP("item.minecraft.coal", 50), new SmeltingCraftingXP("item.minecraft.emerald", 225), new SmeltingCraftingXP("item.minecraft.lapis_lazuli", 125), new SmeltingCraftingXP("item.minecraft.diamond", 250), new SmeltingCraftingXP("item.minecraft.quartz", 75)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("item", config.item);
            entry.addProperty("xp", (Number)config.xp);
            mappings.add((JsonElement)entry);
        }
        json.add("smelting_crafting_mappings", (JsonElement)mappings);
        return json;
    }

    public static int getSmeltingCraftingXP(String itemKey, Skills skill) {
        return SMELTING_CRAFTING_XP_MAP.getOrDefault(itemKey, 0);
    }

    private static JsonObject getDefaultBlockMappings() {
        JsonObject json = new JsonObject();
        JsonArray mappings = new JsonArray();
        String[] woodTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "pale_oak", "crimson", "warped"};
        String[] stoneTypes = new String[]{"stone", "cobblestone", "mossy_cobblestone", "smooth_stone", "granite", "polished_granite", "diorite", "polished_diorite", "andesite", "polished_andesite", "deepslate", "cobbled_deepslate", "polished_deepslate", "deepslate_bricks", "cracked_deepslate_bricks", "deepslate_tiles", "cracked_deepslate_tiles", "chiseled_deepslate", "tuff", "polished_tuff", "tuff_bricks", "chiseled_tuff", "basalt", "smooth_basalt", "polished_basalt", "blackstone", "polished_blackstone", "polished_blackstone_bricks", "chiseled_polished_blackstone", "cracked_polished_blackstone", "gilded_blackstone", "obsidian", "crying_obsidian", "quartz_block", "smooth_quartz", "chiseled_quartz_block", "quartz_bricks", "prismarine", "prismarine_bricks", "dark_prismarine", "purpur_block", "purpur_pillar", "end_stone", "end_stone_bricks", "sandstone", "red_sandstone", "smooth_sandstone", "smooth_red_sandstone", "chiseled_sandstone", "chiseled_red_sandstone", "cut_sandstone", "cut_red_sandstone", "calcite", "dripstone_block"};
        record BlockMapping(String block, String skill, int xp) {
        }
        ArrayList<BlockMapping> defaults = new ArrayList<BlockMapping>();
        for (String wood : woodTypes) {
            if (wood.equals("crimson") || wood.equals("warped")) {
                defaults.add(new BlockMapping("block.minecraft." + wood + "_stem", "WOODCUTTING", 150));
                defaults.add(new BlockMapping("block.minecraft.stripped_" + wood + "_stem", "WOODCUTTING", 150));
                continue;
            }
            defaults.add(new BlockMapping("block.minecraft." + wood + "_log", "WOODCUTTING", 150));
            defaults.add(new BlockMapping("block.minecraft.stripped_" + wood + "_log", "WOODCUTTING", 150));
        }
        for (String wood : woodTypes) {
            defaults.add(new BlockMapping("block.minecraft." + wood + "_planks", "WOODCUTTING", 100));
            defaults.add(new BlockMapping("block.minecraft." + wood + "_stairs", "WOODCUTTING", 100));
            defaults.add(new BlockMapping("block.minecraft." + wood + "_slab", "WOODCUTTING", 100));
            defaults.add(new BlockMapping("block.minecraft." + wood + "_fence", "WOODCUTTING", 100));
            defaults.add(new BlockMapping("block.minecraft." + wood + "_fence_gate", "WOODCUTTING", 100));
            defaults.add(new BlockMapping("block.minecraft." + wood + "_door", "WOODCUTTING", 100));
            defaults.add(new BlockMapping("block.minecraft." + wood + "_trapdoor", "WOODCUTTING", 100));
            defaults.add(new BlockMapping("block.minecraft." + wood + "_shelf", "WOODCUTTING", 100));
            if (!wood.equals("crimson") && !wood.equals("warped")) {
                defaults.add(new BlockMapping("block.minecraft." + wood + "_wood", "WOODCUTTING", 100));
                defaults.add(new BlockMapping("block.minecraft.stripped_" + wood + "_wood", "WOODCUTTING", 100));
                continue;
            }
            defaults.add(new BlockMapping("block.minecraft." + wood + "_hyphae", "WOODCUTTING", 100));
            defaults.add(new BlockMapping("block.minecraft.stripped_" + wood + "_hyphae", "WOODCUTTING", 100));
        }
        defaults.add(new BlockMapping("block.minecraft.bamboo_block", "WOODCUTTING", 100));
        defaults.add(new BlockMapping("block.minecraft.stripped_bamboo_block", "WOODCUTTING", 100));
        for (String stone : stoneTypes) {
            int xp = 100;
            if (stone.contains("sandstone")) {
                xp = 30;
            }
            defaults.add(new BlockMapping("block.minecraft." + stone, "MINING", xp));
            if (!stone.equals("crying_obsidian") && !stone.equals("calcite")) {
                defaults.add(new BlockMapping("block.minecraft." + stone + "_slab", "MINING", xp));
            }
            if (!(stone.equals("crying_obsidian") || stone.equals("calcite") || stone.equals("obsidian") || stone.endsWith("_pillar"))) {
                defaults.add(new BlockMapping("block.minecraft." + stone + "_stairs", "MINING", xp));
            }
            if (stone.equals("crying_obsidian") || stone.equals("calcite") || stone.equals("obsidian") || stone.endsWith("_pillar") || stone.contains("smooth") || stone.contains("cut")) continue;
            defaults.add(new BlockMapping("block.minecraft." + stone + "_wall", "MINING", xp));
        }
        defaults.add(new BlockMapping("block.minecraft.netherrack", "MINING", 10));
        defaults.add(new BlockMapping("block.minecraft.coal_ore", "MINING", 250));
        defaults.add(new BlockMapping("block.minecraft.deepslate_coal_ore", "MINING", 250));
        defaults.add(new BlockMapping("block.minecraft.copper_ore", "MINING", 250));
        defaults.add(new BlockMapping("block.minecraft.deepslate_copper_ore", "MINING", 250));
        defaults.add(new BlockMapping("block.minecraft.iron_ore", "MINING", 350));
        defaults.add(new BlockMapping("block.minecraft.deepslate_iron_ore", "MINING", 350));
        defaults.add(new BlockMapping("block.minecraft.redstone_ore", "MINING", 450));
        defaults.add(new BlockMapping("block.minecraft.deepslate_redstone_ore", "MINING", 450));
        defaults.add(new BlockMapping("block.minecraft.gold_ore", "MINING", 550));
        defaults.add(new BlockMapping("block.minecraft.deepslate_gold_ore", "MINING", 550));
        defaults.add(new BlockMapping("block.minecraft.lapis_ore", "MINING", 550));
        defaults.add(new BlockMapping("block.minecraft.deepslate_lapis_ore", "MINING", 550));
        defaults.add(new BlockMapping("block.minecraft.emerald_ore", "MINING", 850));
        defaults.add(new BlockMapping("block.minecraft.deepslate_emerald_ore", "MINING", 850));
        defaults.add(new BlockMapping("block.minecraft.diamond_ore", "MINING", 1500));
        defaults.add(new BlockMapping("block.minecraft.deepslate_diamond_ore", "MINING", 1500));
        defaults.add(new BlockMapping("block.minecraft.nether_quartz_ore", "MINING", 150));
        defaults.add(new BlockMapping("block.minecraft.nether_gold_ore", "MINING", 150));
        defaults.add(new BlockMapping("block.minecraft.dirt", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.grass_block", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.podzol", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.coarse_dirt", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.rooted_dirt", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.mycelium", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.farmland", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.dirt_path", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.mud", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.clay", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.sand", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.gravel", "EXCAVATING", 50));
        defaults.add(new BlockMapping("block.minecraft.red_sand", "EXCAVATING", 50));
        String[] colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        for (String color : colors) {
            defaults.add(new BlockMapping("block.minecraft." + color + "_concrete_powder", "EXCAVATING", 50));
        }
        for (BlockMapping mapping : defaults) {
            JsonObject entry = new JsonObject();
            entry.addProperty("block", mapping.block);
            entry.addProperty("skill", mapping.skill);
            entry.addProperty("xp", (Number)mapping.xp);
            mappings.add((JsonElement)entry);
        }
        json.add("block_mappings", (JsonElement)mappings);
        return json;
    }

    private static void loadSmithingXPConfig() {
        Path filePath = CONFIG_DIR.resolve("smithing_xp.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultSmithingXPConfig());
            JsonArray mappings = json.getAsJsonArray("smithing_mappings");
            SMITHING_XP_MAP.clear();
            for (JsonElement element : mappings) {
                JsonObject mapping = element.getAsJsonObject();
                String action = mapping.get("action").getAsString();
                if (!(mapping.has("xp") && mapping.get("xp").isJsonPrimitive() && mapping.get("xp").getAsJsonPrimitive().isNumber())) {
                    Simpleskills.LOGGER.warn("Invalid or missing 'xp' value for action {} in smithing_xp.json, skipping", (Object)action);
                    continue;
                }
                float xp = mapping.get("xp").getAsFloat();
                if (xp < 0.0f) {
                    Simpleskills.LOGGER.warn("Negative XP value {} for action {} in smithing_xp.json, skipping", (Object)Float.valueOf(xp), (Object)action);
                    continue;
                }
                SMITHING_XP_MAP.put(action, Float.valueOf(xp));
            }
            Simpleskills.LOGGER.info("Loaded {} smithing XP mappings.", (Object)SMITHING_XP_MAP.size());
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in smithing_xp.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading smithing_xp.json: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            Simpleskills.LOGGER.error("Unexpected error loading smithing_xp.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultSmithingXPConfig() {
        record SmithingMapping(String action, float xp) {
        }
        SmithingMapping[] defaults;
        JsonObject json = new JsonObject();
        JsonArray mappings = new JsonArray();
        for (SmithingMapping mapping : defaults = new SmithingMapping[]{new SmithingMapping("repair:minecraft:oak_planks", 100.0f), new SmithingMapping("repair:minecraft:spruce_planks", 100.0f), new SmithingMapping("repair:minecraft:birch_planks", 100.0f), new SmithingMapping("repair:minecraft:jungle_planks", 100.0f), new SmithingMapping("repair:minecraft:acacia_planks", 100.0f), new SmithingMapping("repair:minecraft:dark_oak_planks", 100.0f), new SmithingMapping("repair:minecraft:mangrove_planks", 100.0f), new SmithingMapping("repair:minecraft:cherry_planks", 100.0f), new SmithingMapping("repair:minecraft:bamboo_planks", 100.0f), new SmithingMapping("repair:minecraft:crimson_planks", 100.0f), new SmithingMapping("repair:minecraft:warped_planks", 100.0f), new SmithingMapping("repair:minecraft:pale_oak_planks", 100.0f), new SmithingMapping("repair:minecraft:cobblestone", 100.0f), new SmithingMapping("repair:minecraft:cobbled_deepslate", 100.0f), new SmithingMapping("repair:minecraft:blackstone", 100.0f), new SmithingMapping("repair:minecraft:leather", 100.0f), new SmithingMapping("repair:minecraft:copper_ingot", 100.0f), new SmithingMapping("repair:minecraft:gold_ingot", 100.0f), new SmithingMapping("repair:minecraft:turtle_scute", 100.0f), new SmithingMapping("repair:minecraft:iron_ingot", 100.0f), new SmithingMapping("repair:minecraft:phantom_membrane", 100.0f), new SmithingMapping("repair:minecraft:diamond", 100.0f), new SmithingMapping("repair:minecraft:netherite_ingot", 100.0f)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("action", mapping.action);
            entry.addProperty("xp", (Number)Float.valueOf(mapping.xp));
            mappings.add((JsonElement)entry);
        }
        json.add("smithing_mappings", (JsonElement)mappings);
        return json;
    }

    public static JsonObject getSmithingMultiplierConfig() {
        record SmithingMultiplierMapping(String levelRange, float multiplier) {
        }
        SmithingMultiplierMapping[] defaults;
        JsonObject json = new JsonObject();
        JsonArray mappings = new JsonArray();
        for (SmithingMultiplierMapping mapping : defaults = new SmithingMultiplierMapping[]{new SmithingMultiplierMapping("1-24", 1.0f), new SmithingMultiplierMapping("25-49", 1.05f), new SmithingMultiplierMapping("50-74", 1.075f), new SmithingMultiplierMapping("75-98", 1.1f), new SmithingMultiplierMapping("99-99", 1.2f)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("level_range", mapping.levelRange);
            entry.addProperty("multiplier", (Number)Float.valueOf(mapping.multiplier));
            mappings.add((JsonElement)entry);
        }
        json.add("multiplier_mappings", (JsonElement)mappings);
        return json;
    }

    private static void loadSmithingMultiplierConfig() {
        Path filePath = CONFIG_DIR.resolve("smithing_multipliers.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getSmithingMultiplierConfig());
            JsonArray mappings = json.getAsJsonArray("multiplier_mappings");
            SMITHING_MULTIPLIER_MAP.clear();
            for (JsonElement element : mappings) {
                JsonObject mapping = element.getAsJsonObject();
                String levelRange = mapping.get("level_range").getAsString();
                float multiplier = mapping.get("multiplier").getAsFloat();
                if (multiplier < 0.0f) {
                    Simpleskills.LOGGER.warn("Invalid multiplier value {} for level range {} in smithing_multipliers.json, skipping", (Object)Float.valueOf(multiplier), (Object)levelRange);
                    continue;
                }
                SMITHING_MULTIPLIER_MAP.put(levelRange, Float.valueOf(multiplier));
            }
            Simpleskills.LOGGER.info("Loaded smithing_multipliers.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in smithing_multipliers.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading smithing_multipliers.json: {}", (Object)e.getMessage());
        }
    }

    public static float getSmithingMultiplier(int level) {
        for (Map.Entry<String, Float> entry : SMITHING_MULTIPLIER_MAP.entrySet()) {
            String[] range = entry.getKey().split("-");
            int minLevel = Integer.parseInt(range[0]);
            int maxLevel = Integer.parseInt(range[1]);
            if (level < minLevel || level > maxLevel) continue;
            return entry.getValue().floatValue();
        }
        return 1.0f;
    }

    public static float getSmithingXP(String action, Skills skill) {
        return SMITHING_XP_MAP.getOrDefault(action, Float.valueOf(ConfigManager.getBaseXP(skill))).floatValue();
    }

    public static Map<String, Float> getSmithingXPMap() {
        return SMITHING_XP_MAP;
    }

    private static JsonObject getDefaultAgilityXPConfig() {
        record AgilityMapping(String action, int xp) {
        }
        AgilityMapping[] defaults;
        JsonObject json = new JsonObject();
        JsonArray mappings = new JsonArray();
        for (AgilityMapping mapping : defaults = new AgilityMapping[]{new AgilityMapping("fall_damage", 60), new AgilityMapping("jump", 20), new AgilityMapping("sprint", 20), new AgilityMapping("swim", 25), new AgilityMapping("sneak", 20)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("action", mapping.action);
            entry.addProperty("xp", (Number)mapping.xp);
            mappings.add((JsonElement)entry);
        }
        json.add("agility_mappings", (JsonElement)mappings);
        return json;
    }

    private static void loadAlchemyMultiplierConfig() {
        Path filePath = CONFIG_DIR.resolve("alchemy_multipliers.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultAlchemyMultiplierConfig());
            JsonArray mappings = json.getAsJsonArray("multiplier_mappings");
            ALCHEMY_MULTIPLIER_MAP.clear();
            for (JsonElement element : mappings) {
                JsonObject mapping = element.getAsJsonObject();
                String levelRange = mapping.get("level_range").getAsString();
                float multiplier = mapping.get("multiplier").getAsFloat();
                if (multiplier < 0.0f) {
                    Simpleskills.LOGGER.warn("Invalid multiplier value {} for level range {} in alchemy_multipliers.json, skipping", (Object)Float.valueOf(multiplier), (Object)levelRange);
                    continue;
                }
                ALCHEMY_MULTIPLIER_MAP.put(levelRange, Float.valueOf(multiplier));
            }
            Simpleskills.LOGGER.info("Loaded alchemy_multipliers.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in alchemy_multipliers.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading alchemy_multipliers.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultAlchemyMultiplierConfig() {
        record AlchemyMultiplierMapping(String levelRange, float multiplier) {
        }
        AlchemyMultiplierMapping[] defaults;
        JsonObject json = new JsonObject();
        JsonArray mappings = new JsonArray();
        for (AlchemyMultiplierMapping mapping : defaults = new AlchemyMultiplierMapping[]{new AlchemyMultiplierMapping("1-24", 1.0f), new AlchemyMultiplierMapping("25-49", 1.25f), new AlchemyMultiplierMapping("50-74", 1.5f), new AlchemyMultiplierMapping("75-98", 1.75f), new AlchemyMultiplierMapping("99-99", 3.0f)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("level_range", mapping.levelRange);
            entry.addProperty("multiplier", (Number)Float.valueOf(mapping.multiplier));
            mappings.add((JsonElement)entry);
        }
        json.add("multiplier_mappings", (JsonElement)mappings);
        return json;
    }

    public static float getAlchemyMultiplier(int level) {
        if (level >= 99) {
            return ALCHEMY_MULTIPLIER_MAP.getOrDefault("99-99", Float.valueOf(2.0f)).floatValue();
        }
        if (level >= 75) {
            return ALCHEMY_MULTIPLIER_MAP.getOrDefault("75-98", Float.valueOf(1.75f)).floatValue();
        }
        if (level >= 50) {
            return ALCHEMY_MULTIPLIER_MAP.getOrDefault("50-74", Float.valueOf(1.5f)).floatValue();
        }
        if (level >= 25) {
            return ALCHEMY_MULTIPLIER_MAP.getOrDefault("25-49", Float.valueOf(1.25f)).floatValue();
        }
        return ALCHEMY_MULTIPLIER_MAP.getOrDefault("1-24", Float.valueOf(1.0f)).floatValue();
    }

    private static void loadAlchemyXPConfig() {
        Path filePath = CONFIG_DIR.resolve("alchemy_xp.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultAlchemyXPConfig());
            JsonArray mappings = json.getAsJsonArray("alchemy_mappings");
            ALCHEMY_XP_MAP.clear();
            for (JsonElement element : mappings) {
                JsonObject mapping = element.getAsJsonObject();
                String potion = mapping.get("potion").getAsString();
                int xp = mapping.get("xp").getAsInt();
                if (xp < 0) {
                    Simpleskills.LOGGER.warn("Invalid XP value {} for potion {} in alchemy_xp.json, skipping", (Object)xp, (Object)potion);
                    continue;
                }
                ALCHEMY_XP_MAP.put(potion, xp);
            }
            Simpleskills.LOGGER.info("Loaded alchemy_xp.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in alchemy_xp.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading alchemy_xp.json: {}", (Object)e.getMessage());
        }
    }

    public static int getAlchemyXP(String potionTranslationKey, Skills skill) {
        return ALCHEMY_XP_MAP.getOrDefault(potionTranslationKey, ConfigManager.getBaseXP(skill));
    }

    private static JsonObject getDefaultAlchemyXPConfig() {
        record AlchemyMapping(String potion, int xp) {
        }
        AlchemyMapping[] defaults;
        JsonObject json = new JsonObject();
        JsonArray mappings = new JsonArray();
        for (AlchemyMapping mapping : defaults = new AlchemyMapping[]{new AlchemyMapping("potion.minecraft.turtle_master", 2500), new AlchemyMapping("potion.minecraft.long_turtle_master", 2600), new AlchemyMapping("potion.minecraft.strong_turtle_master", 2900), new AlchemyMapping("potion.minecraft.oozing", 2400), new AlchemyMapping("potion.minecraft.wind_charged", 2250), new AlchemyMapping("potion.minecraft.weaving", 2150), new AlchemyMapping("potion.minecraft.slow_falling", 2000), new AlchemyMapping("potion.minecraft.long_slow_falling", 2150), new AlchemyMapping("potion.minecraft.invisibility", 1850), new AlchemyMapping("potion.minecraft.long_invisibility", 2000), new AlchemyMapping("potion.minecraft.regeneration", 1750), new AlchemyMapping("potion.minecraft.long_regeneration", 1850), new AlchemyMapping("potion.minecraft.strong_regeneration", 2150), new AlchemyMapping("potion.minecraft.fire_resistance", 1600), new AlchemyMapping("potion.minecraft.long_fire_resistance", 1750), new AlchemyMapping("potion.minecraft.leaping", 1500), new AlchemyMapping("potion.minecraft.long_leaping", 1600), new AlchemyMapping("potion.minecraft.strong_leaping", 1900), new AlchemyMapping("potion.minecraft.night_vision", 1400), new AlchemyMapping("potion.minecraft.long_night_vision", 1500), new AlchemyMapping("potion.minecraft.slowness", 1250), new AlchemyMapping("potion.minecraft.long_slowness", 1400), new AlchemyMapping("potion.minecraft.strong_slowness", 1600), new AlchemyMapping("potion.minecraft.healing", 1150), new AlchemyMapping("potion.minecraft.strong_healing", 1500), new AlchemyMapping("potion.minecraft.harming", 1150), new AlchemyMapping("potion.minecraft.strong_harming", 1500), new AlchemyMapping("potion.minecraft.swiftness", 1150), new AlchemyMapping("potion.minecraft.long_swiftness", 1250), new AlchemyMapping("potion.minecraft.strong_swiftness", 1500), new AlchemyMapping("potion.minecraft.poison", 1150), new AlchemyMapping("potion.minecraft.long_poison", 1250), new AlchemyMapping("potion.minecraft.strong_poison", 1500), new AlchemyMapping("potion.minecraft.strength", 1150), new AlchemyMapping("potion.minecraft.long_strength", 1250), new AlchemyMapping("potion.minecraft.strong_strength", 1500), new AlchemyMapping("splash_potion.minecraft.turtle_master", 2750), new AlchemyMapping("splash_potion.minecraft.long_turtle_master", 2900), new AlchemyMapping("splash_potion.minecraft.strong_turtle_master", 3150), new AlchemyMapping("splash_potion.minecraft.oozing", 2600), new AlchemyMapping("splash_potion.minecraft.wind_charged", 2500), new AlchemyMapping("splash_potion.minecraft.weaving", 2400), new AlchemyMapping("splash_potion.minecraft.slow_falling", 2250), new AlchemyMapping("splash_potion.minecraft.long_slow_falling", 2400), new AlchemyMapping("splash_potion.minecraft.invisibility", 2150), new AlchemyMapping("splash_potion.minecraft.long_invisibility", 2250), new AlchemyMapping("splash_potion.minecraft.regeneration", 2000), new AlchemyMapping("splash_potion.minecraft.long_regeneration", 2150), new AlchemyMapping("splash_potion.minecraft.strong_regeneration", 2400), new AlchemyMapping("splash_potion.minecraft.fire_resistance", 1900), new AlchemyMapping("splash_potion.minecraft.long_fire_resistance", 2000), new AlchemyMapping("splash_potion.minecraft.leaping", 1750), new AlchemyMapping("splash_potion.minecraft.long_leaping", 1900), new AlchemyMapping("splash_potion.minecraft.strong_leaping", 2150), new AlchemyMapping("splash_potion.minecraft.night_vision", 1600), new AlchemyMapping("splash_potion.minecraft.long_night_vision", 1750), new AlchemyMapping("splash_potion.minecraft.slowness", 1500), new AlchemyMapping("splash_potion.minecraft.long_slowness", 1600), new AlchemyMapping("splash_potion.minecraft.strong_slowness", 1900), new AlchemyMapping("splash_potion.minecraft.healing", 1450), new AlchemyMapping("splash_potion.minecraft.strong_healing", 1750), new AlchemyMapping("splash_potion.minecraft.harming", 1450), new AlchemyMapping("splash_potion.minecraft.strong_harming", 1750), new AlchemyMapping("splash_potion.minecraft.swiftness", 1450), new AlchemyMapping("splash_potion.minecraft.long_swiftness", 1500), new AlchemyMapping("splash_potion.minecraft.strong_swiftness", 1750), new AlchemyMapping("splash_potion.minecraft.poison", 1450), new AlchemyMapping("splash_potion.minecraft.long_poison", 1500), new AlchemyMapping("splash_potion.minecraft.strong_poison", 1750), new AlchemyMapping("splash_potion.minecraft.strength", 1450), new AlchemyMapping("splash_potion.minecraft.long_strength", 1500), new AlchemyMapping("splash_potion.minecraft.strong_strength", 1750), new AlchemyMapping("lingering_potion.minecraft.turtle_master", 3150), new AlchemyMapping("lingering_potion.minecraft.long_turtle_master", 3250), new AlchemyMapping("lingering_potion.minecraft.strong_turtle_master", 3500), new AlchemyMapping("lingering_potion.minecraft.oozing", 3000), new AlchemyMapping("lingering_potion.minecraft.wind_charged", 2900), new AlchemyMapping("lingering_potion.minecraft.weaving", 2750), new AlchemyMapping("lingering_potion.minecraft.slow_falling", 2600), new AlchemyMapping("lingering_potion.minecraft.long_slow_falling", 2750), new AlchemyMapping("lingering_potion.minecraft.invisibility", 2500), new AlchemyMapping("lingering_potion.minecraft.long_invisibility", 2600), new AlchemyMapping("lingering_potion.minecraft.regeneration", 2400), new AlchemyMapping("lingering_potion.minecraft.long_regeneration", 2500), new AlchemyMapping("lingering_potion.minecraft.strong_regeneration", 2750), new AlchemyMapping("lingering_potion.minecraft.fire_resistance", 2250), new AlchemyMapping("lingering_potion.minecraft.long_fire_resistance", 2400), new AlchemyMapping("lingering_potion.minecraft.leaping", 2150), new AlchemyMapping("lingering_potion.minecraft.long_leaping", 2250), new AlchemyMapping("lingering_potion.minecraft.strong_leaping", 2500), new AlchemyMapping("lingering_potion.minecraft.night_vision", 2000), new AlchemyMapping("lingering_potion.minecraft.long_night_vision", 2150), new AlchemyMapping("lingering_potion.minecraft.slowness", 1900), new AlchemyMapping("lingering_potion.minecraft.long_slowness", 2000), new AlchemyMapping("lingering_potion.minecraft.strong_slowness", 2250), new AlchemyMapping("lingering_potion.minecraft.healing", 1750), new AlchemyMapping("lingering_potion.minecraft.strong_healing", 2150), new AlchemyMapping("lingering_potion.minecraft.harming", 1750), new AlchemyMapping("lingering_potion.minecraft.strong_harming", 2150), new AlchemyMapping("lingering_potion.minecraft.swiftness", 1750), new AlchemyMapping("lingering_potion.minecraft.long_swiftness", 1850), new AlchemyMapping("lingering_potion.minecraft.strong_swiftness", 2150), new AlchemyMapping("lingering_potion.minecraft.poison", 1750), new AlchemyMapping("lingering_potion.minecraft.long_poison", 1850), new AlchemyMapping("lingering_potion.minecraft.strong_poison", 2150), new AlchemyMapping("lingering_potion.minecraft.strength", 1750), new AlchemyMapping("lingering_potion.minecraft.long_strength", 1850), new AlchemyMapping("lingering_potion.minecraft.strong_strength", 2150)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("potion", mapping.potion);
            entry.addProperty("xp", (Number)mapping.xp);
            mappings.add((JsonElement)entry);
        }
        json.add("alchemy_mappings", (JsonElement)mappings);
        return json;
    }

    private static JsonObject getDefaultToolRequirements() {
        record ToolRequirement(String id, String skill, int level) {
        }
        ToolRequirement[] defaults;
        JsonObject json = new JsonObject();
        for (ToolRequirement req : defaults = new ToolRequirement[]{new ToolRequirement("minecraft:wooden_pickaxe", "MINING", 0), new ToolRequirement("minecraft:wooden_axe", "WOODCUTTING", 0), new ToolRequirement("minecraft:wooden_shovel", "EXCAVATING", 0), new ToolRequirement("minecraft:wooden_hoe", "FARMING", 0), new ToolRequirement("minecraft:golden_pickaxe", "MINING", 5), new ToolRequirement("minecraft:golden_axe", "WOODCUTTING", 5), new ToolRequirement("minecraft:golden_shovel", "EXCAVATING", 5), new ToolRequirement("minecraft:golden_hoe", "FARMING", 5), new ToolRequirement("minecraft:stone_pickaxe", "MINING", 10), new ToolRequirement("minecraft:stone_axe", "WOODCUTTING", 10), new ToolRequirement("minecraft:stone_shovel", "EXCAVATING", 10), new ToolRequirement("minecraft:stone_hoe", "FARMING", 10), new ToolRequirement("minecraft:copper_pickaxe", "MINING", 25), new ToolRequirement("minecraft:copper_axe", "WOODCUTTING", 25), new ToolRequirement("minecraft:copper_shovel", "EXCAVATING", 25), new ToolRequirement("minecraft:copper_hoe", "FARMING", 25), new ToolRequirement("minecraft:iron_pickaxe", "MINING", 50), new ToolRequirement("minecraft:iron_axe", "WOODCUTTING", 50), new ToolRequirement("minecraft:iron_shovel", "EXCAVATING", 50), new ToolRequirement("minecraft:iron_hoe", "FARMING", 50), new ToolRequirement("minecraft:diamond_pickaxe", "MINING", 75), new ToolRequirement("minecraft:diamond_axe", "WOODCUTTING", 75), new ToolRequirement("minecraft:diamond_shovel", "EXCAVATING", 75), new ToolRequirement("minecraft:diamond_hoe", "FARMING", 75), new ToolRequirement("minecraft:netherite_pickaxe", "MINING", 99), new ToolRequirement("minecraft:netherite_axe", "WOODCUTTING", 99), new ToolRequirement("minecraft:netherite_shovel", "EXCAVATING", 99), new ToolRequirement("minecraft:netherite_hoe", "FARMING", 99)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("skill", req.skill);
            entry.addProperty("level", (Number)req.level);
            json.add(req.id, (JsonElement)entry);
        }
        return json;
    }

    private static JsonObject getDefaultArmorRequirements() {
        record ArmorRequirement(String id, String skill, int level) {
        }
        ArmorRequirement[] defaults;
        JsonObject json = new JsonObject();
        for (ArmorRequirement req : defaults = new ArmorRequirement[]{new ArmorRequirement("minecraft:leather_helmet", "DEFENSE", 0), new ArmorRequirement("minecraft:leather_chestplate", "DEFENSE", 0), new ArmorRequirement("minecraft:leather_leggings", "DEFENSE", 0), new ArmorRequirement("minecraft:leather_boots", "DEFENSE", 0), new ArmorRequirement("minecraft:golden_helmet", "DEFENSE", 10), new ArmorRequirement("minecraft:golden_chestplate", "DEFENSE", 10), new ArmorRequirement("minecraft:golden_leggings", "DEFENSE", 10), new ArmorRequirement("minecraft:golden_boots", "DEFENSE", 10), new ArmorRequirement("minecraft:copper_helmet", "DEFENSE", 25), new ArmorRequirement("minecraft:copper_chestplate", "DEFENSE", 25), new ArmorRequirement("minecraft:copper_leggings", "DEFENSE", 25), new ArmorRequirement("minecraft:copper_boots", "DEFENSE", 25), new ArmorRequirement("minecraft:turtle_helmet", "DEFENSE", 30), new ArmorRequirement("minecraft:chainmail_helmet", "DEFENSE", 35), new ArmorRequirement("minecraft:chainmail_chestplate", "DEFENSE", 35), new ArmorRequirement("minecraft:chainmail_leggings", "DEFENSE", 35), new ArmorRequirement("minecraft:chainmail_boots", "DEFENSE", 35), new ArmorRequirement("minecraft:iron_helmet", "DEFENSE", 50), new ArmorRequirement("minecraft:iron_chestplate", "DEFENSE", 50), new ArmorRequirement("minecraft:iron_leggings", "DEFENSE", 50), new ArmorRequirement("minecraft:iron_boots", "DEFENSE", 50), new ArmorRequirement("minecraft:diamond_helmet", "DEFENSE", 75), new ArmorRequirement("minecraft:diamond_chestplate", "DEFENSE", 75), new ArmorRequirement("minecraft:diamond_leggings", "DEFENSE", 75), new ArmorRequirement("minecraft:diamond_boots", "DEFENSE", 75), new ArmorRequirement("minecraft:netherite_helmet", "DEFENSE", 99), new ArmorRequirement("minecraft:netherite_chestplate", "DEFENSE", 99), new ArmorRequirement("minecraft:netherite_leggings", "DEFENSE", 99), new ArmorRequirement("minecraft:netherite_boots", "DEFENSE", 99), new ArmorRequirement("minecraft:elytra", "PRAYER", 50)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("skill", req.skill);
            entry.addProperty("level", (Number)req.level);
            json.add(req.id, (JsonElement)entry);
        }
        return json;
    }

    private static JsonObject getDefaultWeaponRequirements() {
        record WeaponRequirement(String id, String skill, int level) {
        }
        WeaponRequirement[] defaults;
        JsonObject json = new JsonObject();
        for (WeaponRequirement req : defaults = new WeaponRequirement[]{new WeaponRequirement("minecraft:wooden_sword", "SLAYING", 0), new WeaponRequirement("minecraft:wooden_axe", "SLAYING", 0), new WeaponRequirement("minecraft:golden_sword", "SLAYING", 5), new WeaponRequirement("minecraft:golden_axe", "SLAYING", 5), new WeaponRequirement("minecraft:stone_sword", "SLAYING", 10), new WeaponRequirement("minecraft:stone_axe", "SLAYING", 10), new WeaponRequirement("minecraft:copper_sword", "SLAYING", 25), new WeaponRequirement("minecraft:copper_axe", "SLAYING", 25), new WeaponRequirement("minecraft:iron_sword", "SLAYING", 50), new WeaponRequirement("minecraft:iron_axe", "SLAYING", 50), new WeaponRequirement("minecraft:diamond_sword", "SLAYING", 75), new WeaponRequirement("minecraft:diamond_axe", "SLAYING", 75), new WeaponRequirement("minecraft:netherite_sword", "SLAYING", 99), new WeaponRequirement("minecraft:netherite_axe", "SLAYING", 99), new WeaponRequirement("minecraft:mace", "SLAYING", 50), new WeaponRequirement("minecraft:crossbow", "RANGED", 0), new WeaponRequirement("minecraft:bow", "RANGED", 30), new WeaponRequirement("minecraft:trident", "RANGED", 99)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("skill", req.skill);
            entry.addProperty("level", (Number)req.level);
            json.add(req.id, (JsonElement)entry);
        }
        return json;
    }

    public static boolean isFishingSpeedBonusEnabled() {
        try {
            JsonObject features;
            if (featureConfig.has("fishing_speed_bonus_enabled")) {
                return featureConfig.get("fishing_speed_bonus_enabled").getAsBoolean();
            }
            if (featureConfig.has("features") && (features = featureConfig.getAsJsonObject("features")) != null && features.has("fishing_speed_bonus_enabled")) {
                return features.get("fishing_speed_bonus_enabled").getAsBoolean();
            }
            return true;
        }
        catch (Exception e) {
            Simpleskills.LOGGER.warn("Error reading fishing_speed_bonus_enabled; defaulting to true");
            return true;
        }
    }

    private static void loadFishingXPConfig() {
        Path filePath = CONFIG_DIR.resolve("fishing_xp.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultFishingXPConfig());
            for (Map.Entry entry : json.entrySet()) {
                String action = (String)entry.getKey();
                int xp = ((JsonElement)entry.getValue()).getAsInt();
                if (xp < 0) continue;
                FISHING_XP_MAP.put(action, xp);
            }
        }
        catch (Exception e) {
            Simpleskills.LOGGER.warn("Error loading fishing_xp.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultFishingXPConfig() {
        JsonObject json = new JsonObject();
        json.addProperty("catch", (Number)750);
        return json;
    }

    private static void loadFishingLootConfig() {
        Path filePath = CONFIG_DIR.resolve("fishing_loot.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultFishingLootConfig());
            for (Map.Entry entry : json.entrySet()) {
                String range = (String)entry.getKey();
                String lootTableStr = ((JsonElement)entry.getValue()).getAsString();
                try {
                    class_2960 id = class_2960.method_60654((String)lootTableStr);
                    FISHING_LOOT_TABLES.put(range, id);
                }
                catch (Exception e) {
                    Simpleskills.LOGGER.warn("Invalid loot table ID {} for range {} in fishing_loot.json", (Object)lootTableStr, (Object)range);
                }
            }
        }
        catch (Exception e) {
            Simpleskills.LOGGER.warn("Error loading fishing_loot.json: {}", (Object)e.getMessage());
        }
    }

    private static void loadFarmingXPConfig() {
        Path filePath = CONFIG_DIR.resolve("farming_xp.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultFarmingXPConfig());
            FARMING_ACTION_XP_MAP.clear();
            FARMING_BLOCK_XP_MAP.clear();
            if (json.has("actions") && json.get("actions").isJsonObject()) {
                JsonObject actions = json.getAsJsonObject("actions");
                for (Map.Entry entry : actions.entrySet()) {
                    int xp = ((JsonElement)entry.getValue()).getAsInt();
                    if (xp < 0) continue;
                    FARMING_ACTION_XP_MAP.put((String)entry.getKey(), xp);
                }
            }
            if (json.has("blocks") && json.get("blocks").isJsonArray()) {
                for (JsonElement element : json.getAsJsonArray("blocks")) {
                    JsonObject mapping = element.getAsJsonObject();
                    String block = mapping.get("block").getAsString();
                    int xp = mapping.get("xp").getAsInt();
                    if (xp < 0) continue;
                    FARMING_BLOCK_XP_MAP.put(block, xp);
                }
            }
            Simpleskills.LOGGER.info("Loaded farming_xp.json");
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in farming_xp.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading farming_xp.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultFarmingXPConfig() {
        record FarmingBlock(String block, int xp) {
        }
        FarmingBlock[] defaults;
        JsonObject json = new JsonObject();
        JsonObject actions = new JsonObject();
        actions.addProperty("animal_feed_breed", (Number)250);
        actions.addProperty("animal_feed_grow", (Number)25);
        actions.addProperty("shear_sheep", (Number)150);
        json.add("actions", (JsonElement)actions);
        JsonArray blocks = new JsonArray();
        for (FarmingBlock fb : defaults = new FarmingBlock[]{new FarmingBlock("block.minecraft.wheat", 275), new FarmingBlock("block.minecraft.carrots", 275), new FarmingBlock("block.minecraft.potatoes", 300), new FarmingBlock("block.minecraft.beetroots", 250), new FarmingBlock("block.minecraft.melon", 100), new FarmingBlock("block.minecraft.nether_wart", 350), new FarmingBlock("block.minecraft.cocoa", 250)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("block", fb.block());
            entry.addProperty("xp", (Number)fb.xp());
            blocks.add((JsonElement)entry);
        }
        json.add("blocks", (JsonElement)blocks);
        return json;
    }

    public static int getFarmingActionXP(String actionKey, Skills skill) {
        return FARMING_ACTION_XP_MAP.getOrDefault(actionKey, ConfigManager.getBaseXP(skill));
    }

    public static int getFarmingBlockXP(String blockTranslationKey) {
        return FARMING_BLOCK_XP_MAP.getOrDefault(blockTranslationKey, 0);
    }

    private static JsonObject getDefaultFishingLootConfig() {
        JsonObject json = new JsonObject();
        json.addProperty("1-24", "simpleskills:fishing/simpleskills_fishing_novice");
        json.addProperty("25-49", "simpleskills:fishing/simpleskills_fishing_journeyman");
        json.addProperty("50-74", "simpleskills:fishing/simpleskills_fishing_artisan");
        json.addProperty("75-98", "simpleskills:fishing/simpleskills_fishing_expert");
        json.addProperty("99-99", "simpleskills:fishing/simpleskills_fishing_grandmaster");
        return json;
    }

    private static JsonObject getDefaultEnchantmentRequirements() {
        record EnchantmentRequirement(String id, String skill, int level, int enchantmentLevel) {
        }
        EnchantmentRequirement[] defaults;
        JsonObject json = new JsonObject();
        for (EnchantmentRequirement req : defaults = new EnchantmentRequirement[]{new EnchantmentRequirement("minecraft:fortune", "ENCHANTING", 25, 3), new EnchantmentRequirement("minecraft:sharpness", "ENCHANTING", 50, 5), new EnchantmentRequirement("minecraft:power", "ENCHANTING", 50, 5), new EnchantmentRequirement("minecraft:efficiency", "ENCHANTING", 75, 5), new EnchantmentRequirement("minecraft:mending", "ENCHANTING", 99, 1)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("skill", req.skill);
            entry.addProperty("level", (Number)req.level);
            if (req.enchantmentLevel > 0) {
                entry.addProperty("enchantmentLevel", (Number)req.enchantmentLevel);
            }
            json.add(req.id, (JsonElement)entry);
        }
        return json;
    }

    private static void loadPrayerSacrifices() {
        Path filePath = CONFIG_DIR.resolve("prayer_sacrifices.json");
        try {
            JsonObject json = ConfigManager.loadJsonFile(filePath, ConfigManager.getDefaultPrayerSacrifices());
            PRAYER_SACRIFICES.clear();
            for (Map.Entry entryElement : json.entrySet()) {
                String itemId = (String)entryElement.getKey();
                JsonObject entry = ((JsonElement)entryElement.getValue()).getAsJsonObject();
                String skillId = entry.get("skill").getAsString();
                Skills skill = Skills.valueOf(skillId.toUpperCase());
                int xp = entry.get("xp").getAsInt();
                int level = entry.get("level").getAsInt();
                String effect = entry.get("effect").getAsString();
                String displayName = entry.has("name") ? entry.get("name").getAsString() : StringUtil.capitalize((String)effect.split(":")[1].replace("_", " "));
                int duration = entry.get("duration").getAsInt();
                int effectLevel = entry.has("effectLevel") ? entry.get("effectLevel").getAsInt() : 1;
                boolean isAmbient = entry.has("isAmbient") && entry.get("isAmbient").getAsBoolean();
                SkillRequirement requirement = new SkillRequirement(skill, level, null);
                PRAYER_SACRIFICES.put(itemId, new PrayerSacrifice(skill, xp, requirement, effect, displayName, duration, effectLevel, isAmbient));
                Simpleskills.LOGGER.debug("Loaded prayer sacrifice: {} -> skill: {}, xp: {}, requirement: {}, effect: {}, displayName: {}, durationTicks: {}, effectLevel: {}, isAmbient: {}", new Object[]{itemId, skill, xp, requirement, effect, displayName, duration, effectLevel, isAmbient});
            }
        }
        catch (JsonSyntaxException e) {
            Simpleskills.LOGGER.error("JSON syntax error in prayer_sacrifices.json: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Error loading prayer_sacrifices.json: {}", (Object)e.getMessage());
        }
    }

    private static JsonObject getDefaultPrayerSacrifices() {
        record PrayerSacrificeConfig(String item, String skill, int xp, int level, String effect, int duration, String name, int effectLevel, boolean isAmbient) {
        }
        PrayerSacrificeConfig[] defaults;
        JsonObject json = new JsonObject();
        for (PrayerSacrificeConfig config : defaults = new PrayerSacrificeConfig[]{new PrayerSacrificeConfig("minecraft:rabbit_foot", "PRAYER", 10000, 0, "minecraft:luck", 144000, "Prayer I: Luck", 1, true), new PrayerSacrificeConfig("minecraft:blue_orchid", "PRAYER", 8000, 0, "minecraft:absorption", 144000, "Prayer I: Absorption", 3, true), new PrayerSacrificeConfig("minecraft:glow_ink_sac", "PRAYER", 8000, 0, "minecraft:dolphins_grace", 144000, "Prayer I: Dolphin's Grace", 1, true), new PrayerSacrificeConfig("minecraft:heart_of_the_sea", "PRAYER", 20000, 25, "minecraft:conduit_power", 288000, "Prayer II: Conduit Power", 1, true), new PrayerSacrificeConfig("minecraft:golden_apple", "PRAYER", 18000, 25, "minecraft:health_boost", 288000, "Prayer II: Health Boost", 1, true), new PrayerSacrificeConfig("minecraft:nautilus_shell", "PRAYER", 18000, 25, "minecraft:water_breathing", 288000, "Prayer II: Water Breathing", 1, true), new PrayerSacrificeConfig("minecraft:phantom_membrane", "PRAYER", 35000, 50, "minecraft:slow_falling", 432000, "Prayer III: Slow Falling", 1, true), new PrayerSacrificeConfig("minecraft:diamond", "PRAYER", 32000, 50, "minecraft:speed", 432000, "Prayer II: Speed", 2, true), new PrayerSacrificeConfig("minecraft:goat_horn", "PRAYER", 35000, 50, "minecraft:jump_boost", 432000, "Prayer III: Jump Boost", 2, true), new PrayerSacrificeConfig("minecraft:pitcher_plant", "PRAYER", 30000, 75, "minecraft:strength", 576000, "Prayer IV: Strength", 2, true), new PrayerSacrificeConfig("minecraft:enchanted_golden_apple", "PRAYER", 80000, 75, "minecraft:resistance", 576000, "Prayer IV: Resistance", 2, true), new PrayerSacrificeConfig("minecraft:wither_skeleton_skull", "PRAYER", 55000, 75, "minecraft:fire_resistance", 576000, "Prayer IV: Fire Resistance", 1, true), new PrayerSacrificeConfig("minecraft:torchflower", "PRAYER", 60000, 99, "minecraft:night_vision", 864000, "Prayer V: Night Vision", 1, true), new PrayerSacrificeConfig("minecraft:totem_of_undying", "PRAYER", 95000, 99, "minecraft:invisibility", 864000, "Prayer V: Invisibility", 1, true), new PrayerSacrificeConfig("minecraft:nether_star", "PRAYER", 170000, 99, "minecraft:haste", 864000, "Prayer V: Haste 2", 2, true)}) {
            JsonObject entry = new JsonObject();
            entry.addProperty("skill", config.skill);
            entry.addProperty("xp", (Number)config.xp);
            entry.addProperty("level", (Number)config.level);
            entry.addProperty("effect", config.effect);
            entry.addProperty("duration", (Number)config.duration);
            entry.addProperty("name", config.name);
            entry.addProperty("effectLevel", (Number)config.effectLevel);
            entry.addProperty("isAmbient", Boolean.valueOf(config.isAmbient));
            json.add(config.item, (JsonElement)entry);
        }
        return json;
    }

    public static String getPrayerName(String effectId) {
        for (PrayerSacrifice sacrifice : PRAYER_SACRIFICES.values()) {
            if (!sacrifice.effect().equals(effectId)) continue;
            return sacrifice.displayName();
        }
        return null;
    }

    public static PrayerSacrifice getPrayerSacrifice(String itemId) {
        return PRAYER_SACRIFICES.get(itemId);
    }

    public static int getBaseXP(Skills skill) {
        return BASE_XP_MAP.getOrDefault((Object)skill, 100);
    }

    public static Skills getBlockSkill(String blockTranslationKey) {
        return BLOCK_SKILL_MAP.get(blockTranslationKey);
    }

    public static int getBlockXP(String blockTranslationKey, Skills skill) {
        return BLOCK_XP_MAP.getOrDefault(blockTranslationKey, ConfigManager.getBaseXP(skill));
    }

    public static SkillRequirement getToolRequirement(String id) {
        return TOOL_REQUIREMENTS.get(id);
    }

    public static SkillRequirement getArmorRequirement(String id) {
        return ARMOR_REQUIREMENTS.get(id);
    }

    public static SkillRequirement getWeaponRequirement(String id) {
        return WEAPON_REQUIREMENTS.get(id);
    }

    public static SkillRequirement getEnchantmentRequirement(String id) {
        return ENCHANTMENT_REQUIREMENTS.get(id);
    }

    public static int getAgilityXP(String action, Skills skill) {
        return AGILITY_XP_MAP.getOrDefault(action, ConfigManager.getBaseXP(skill));
    }

    public static int getFishingXP(String action, Skills skill) {
        return FISHING_XP_MAP.getOrDefault(action, ConfigManager.getBaseXP(skill));
    }

    public static class_2960 getFishingLootTable(int fishingLevel) {
        if (fishingLevel >= 99) {
            return FISHING_LOOT_TABLES.getOrDefault("99-99", class_2960.method_60655((String)"simpleskills", (String)"fishing/simpleskills_fishing_grandmaster"));
        }
        if (fishingLevel >= 75) {
            return FISHING_LOOT_TABLES.getOrDefault("75-98", class_2960.method_60655((String)"simpleskills", (String)"fishing/simpleskills_fishing_expert"));
        }
        if (fishingLevel >= 50) {
            return FISHING_LOOT_TABLES.getOrDefault("50-74", class_2960.method_60655((String)"simpleskills", (String)"fishing/simpleskills_fishing_artisan"));
        }
        if (fishingLevel >= 25) {
            return FISHING_LOOT_TABLES.getOrDefault("25-49", class_2960.method_60655((String)"simpleskills", (String)"fishing/simpleskills_fishing_journeyman"));
        }
        return FISHING_LOOT_TABLES.getOrDefault("1-24", class_2960.method_60655((String)"simpleskills", (String)"fishing/simpleskills_fishing_novice"));
    }

    public static JsonObject getFeatureConfig() {
        return featureConfig;
    }

    public record PrayerSacrifice(Skills skill, int xp, SkillRequirement requirement, String effect, String displayName, int durationTicks, int effectLevel, boolean isAmbient) {
    }
}

