/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.SMITHING;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.requirements.SkillRequirement;
import com.github.ob_yekt.simpleskills.utils.AnvilScreenHandlerAccessor;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3915;
import net.minecraft.class_4861;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8047;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1706.class})
public abstract class AnvilScreenHandlerMixin
extends class_4861
implements AnvilScreenHandlerAccessor {
    @Final
    @Shadow
    private class_3915 field_7770;
    @Shadow
    private int field_7776;
    @Unique
    private int durabilityRepaired;
    @Unique
    private boolean xpGranted = false;

    protected AnvilScreenHandlerMixin(int syncId, class_1657 player) {
        super(null, syncId, player.method_31548(), null, AnvilScreenHandlerMixin.getForgingSlotsManager());
    }

    @Unique
    private static class_8047 getForgingSlotsManager() {
        return class_8047.method_48364().method_48374(0, 27, 47, stack -> true).method_48374(1, 76, 47, stack -> true).method_48373(2, 134, 47).method_48372();
    }

    @Unique
    private float calculateRepairEfficiency(int smithingLevel) {
        if (smithingLevel >= 99) {
            return 1.0f;
        }
        if (smithingLevel >= 75) {
            float progress = (float)(smithingLevel - 75) / 23.0f;
            return 0.65f + 0.1f * progress;
        }
        if (smithingLevel >= 50) {
            float progress = (float)(smithingLevel - 50) / 24.0f;
            return 0.5f + 0.1f * progress;
        }
        if (smithingLevel >= 25) {
            float progress = (float)(smithingLevel - 25) / 24.0f;
            return 0.35f + 0.1f * progress;
        }
        float progress = (float)(smithingLevel - 1) / 23.0f;
        return 0.2f + 0.1f * progress;
    }

    @Inject(method={"updateResult"}, at={@At(value="FIELD", target="Lnet/minecraft/screen/AnvilScreenHandler;repairItemUsage:I", opcode=181, shift=At.Shift.AFTER)})
    private void scaleMaterialRepair(CallbackInfo ci) {
        class_1706 handler = (class_1706)this;
        class_1657 player = this.field_22482;
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1735 inputSlot = handler.method_7611(0);
        class_1735 materialSlot = handler.method_7611(1);
        class_1735 outputSlot = handler.method_7611(2);
        class_1799 inputStack = inputSlot.method_7677();
        class_1799 materialStack = materialSlot.method_7677();
        class_1799 outputStack = outputSlot.method_7677();
        if (inputStack.method_7960() || materialStack.method_7960() || outputStack.method_7960() || class_7923.field_41178.method_10221((Object)inputStack.method_7909()).toString().equals("minecraft:air") || class_7923.field_41178.method_10221((Object)materialStack.method_7909()).toString().equals("minecraft:air") || class_7923.field_41178.method_10221((Object)outputStack.method_7909()).toString().equals("minecraft:air")) {
            Simpleskills.LOGGER.debug("Skipping scaleMaterialRepair for empty or air stack: input={}, material={}, output={}", new Object[]{inputStack, materialStack, outputStack});
            this.durabilityRepaired = 0;
            return;
        }
        if (this.field_7776 <= 0 || !inputStack.method_7963() || !inputStack.method_61655(materialStack)) {
            this.durabilityRepaired = 0;
            return;
        }
        int playerSmithingLevel = XPManager.getSkillLevel(serverPlayer.method_5845(), Skills.SMITHING);
        float repairFraction = this.calculateRepairEfficiency(playerSmithingLevel);
        int maxDamage = inputStack.method_7936();
        int inputDamage = inputStack.method_7919();
        int baseRepairPerMaterial = Math.round((float)maxDamage * 0.25f);
        int repairPerMaterial = Math.round((float)baseRepairPerMaterial * repairFraction);
        int availableMaterials = Math.min(materialStack.method_7947(), 1);
        int newRepaired = Math.min(inputDamage, availableMaterials * repairPerMaterial);
        int newDamage = inputDamage - newRepaired;
        int newUsage = newRepaired >= inputDamage ? (int)Math.ceil((double)inputDamage / (double)repairPerMaterial) : availableMaterials;
        newUsage = Math.min(newUsage, availableMaterials);
        this.durabilityRepaired = inputDamage - newDamage;
        outputStack.method_7974(newDamage);
        this.field_7776 = newUsage;
        outputSlot.method_53512(outputStack);
        this.field_7770.method_17404(1);
        String tierName = this.getTierName(playerSmithingLevel);
        Simpleskills.LOGGER.debug("Scaled material repair for player {} ({} lvl {}): efficiency {}%, usage {} -> {}, damage {} -> {}, durabilityRepaired {}, cost -> 1", new Object[]{serverPlayer.method_5477().getString(), tierName, playerSmithingLevel, Float.valueOf(repairFraction * 100.0f), this.field_7776, newUsage, inputDamage, newDamage, this.durabilityRepaired});
    }

    @Inject(method={"updateResult"}, at={@At(value="TAIL")})
    private void handleEnchantRequirementsAndRepairCost(CallbackInfo ci) {
        class_1706 handler = (class_1706)this;
        class_1657 player = this.field_22482;
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1735 inputSlot = handler.method_7611(0);
        class_1735 materialSlot = handler.method_7611(1);
        class_1735 outputSlot = handler.method_7611(2);
        class_1799 inputStack = inputSlot.method_7677();
        class_1799 materialStack = materialSlot.method_7677();
        class_1799 outputStack = outputSlot.method_7677();
        if (outputStack.method_7960() || class_7923.field_41178.method_10221((Object)outputStack.method_7909()).toString().equals("minecraft:air")) {
            Simpleskills.LOGGER.debug("Skipping handleEnchantRequirementsAndRepairCost for empty or air output: {}", (Object)outputStack);
            return;
        }
        boolean hasRestrictedEnchantment = false;
        for (class_6880 enchantmentEntry : outputStack.method_58657().method_57534()) {
            class_1887 enchantment = (class_1887)enchantmentEntry.comp_349();
            int enchantmentLevel = outputStack.method_58657().method_57536(enchantmentEntry);
            class_2960 enchantmentId = serverPlayer.method_51469().method_30349().method_30530(class_7924.field_41265).method_10221((Object)enchantment);
            if (enchantmentId == null) continue;
            SkillRequirement requirement = ConfigManager.getEnchantmentRequirement(enchantmentId.toString());
            int playerEnchantingLevel = XPManager.getSkillLevel(serverPlayer.method_5845(), Skills.ENCHANTING);
            if (requirement == null || enchantmentLevel < requirement.getEnchantmentLevel() || playerEnchantingLevel >= requirement.getLevel()) continue;
            hasRestrictedEnchantment = true;
            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f You need ENCHANTING level " + requirement.getLevel() + " to apply " + enchantmentId.method_12832() + " level " + enchantmentLevel + "!")), true);
            break;
        }
        if (hasRestrictedEnchantment) {
            this.field_7770.method_17404(9999);
            outputSlot.method_53512(class_1799.field_8037);
            return;
        }
        if (this.field_7776 > 0 && !inputStack.method_7960() && !materialStack.method_7960() && !class_7923.field_41178.method_10221((Object)inputStack.method_7909()).toString().equals("minecraft:air") && !class_7923.field_41178.method_10221((Object)materialStack.method_7909()).toString().equals("minecraft:air") && inputStack.method_7963() && inputStack.method_61655(materialStack)) {
            int smithingLevel = XPManager.getSkillLevel(serverPlayer.method_5845(), Skills.SMITHING);
            float repairFraction = this.calculateRepairEfficiency(smithingLevel);
            int maxDamage = inputStack.method_7936();
            int inputDamage = inputStack.method_7919();
            int repairPerMaterial = Math.round((float)maxDamage * repairFraction);
            int repaired = Math.min(inputDamage, this.field_7776 * repairPerMaterial);
            int newDamage = inputDamage - repaired;
            this.durabilityRepaired = repaired;
            outputStack.method_7974(newDamage);
            this.field_7776 = (int)Math.ceil((double)repaired / (double)repairPerMaterial);
            outputStack.method_57379(class_9334.field_49639, (Object)0);
            this.field_7770.method_17404(1);
            String tierName = this.getTierName(smithingLevel);
            Simpleskills.LOGGER.debug("Scaled material repair for {} ({} lvl {}): efficiency {}%, repaired {}, usage {}, damage {} -> {}", new Object[]{serverPlayer.method_5477().getString(), tierName, smithingLevel, Float.valueOf(repairFraction * 100.0f), repaired, this.field_7776, inputDamage, newDamage});
        }
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/ScreenHandlerContext;run(Ljava/util/function/BiConsumer;)V")}, cancellable=true)
    private void preventAnvilDamageOnRepair(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (this.field_7776 > 0) {
            class_1706 handler;
            class_1799 materialStack;
            ci.cancel();
            if (!player.method_56992()) {
                player.method_7316(-this.field_7770.method_17407());
            }
            if (!(materialStack = (handler = (class_1706)this).method_7611(1).method_7677()).method_7960() && materialStack.method_7947() > this.field_7776) {
                materialStack.method_7934(this.field_7776);
                handler.method_7611(1).method_53512(materialStack);
            } else {
                handler.method_7611(1).method_53512(class_1799.field_8037);
            }
            this.field_7770.method_17404(1);
            handler.method_7611(0).method_53512(class_1799.field_8037);
            this.field_22481.method_17393((world, pos) -> world.method_20290(1030, pos, 0));
        }
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="HEAD")})
    private void onTakeOutput(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (this.xpGranted) {
            return;
        }
        this.xpGranted = true;
        if (stack.method_7960() || class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().equals("minecraft:air")) {
            return;
        }
        this.grantXPForAnvilAction(serverPlayer, stack);
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="TAIL")})
    private void resetXpFlag(class_1657 player, class_1799 stack, CallbackInfo ci) {
        this.xpGranted = false;
    }

    @Unique
    private void grantXPForAnvilAction(class_3222 serverPlayer, class_1799 stack) {
        int enchantingXP;
        boolean isEnchantCombining;
        class_1706 handler = (class_1706)this;
        class_1799 input1 = handler.method_7611(0).method_7677();
        class_1799 input2 = handler.method_7611(1).method_7677();
        if (input1.method_7960() || input2.method_7960() || class_7923.field_41178.method_10221((Object)input1.method_7909()).toString().equals("minecraft:air") || class_7923.field_41178.method_10221((Object)input2.method_7909()).toString().equals("minecraft:air")) {
            Simpleskills.LOGGER.debug("Skipping grantXPForAnvilAction for empty or air inputs: input1={}, input2={}", (Object)input1, (Object)input2);
            return;
        }
        boolean isMaterialRepair = input1.method_7909() == stack.method_7909() && input1.method_7919() > stack.method_7919() && this.field_7776 > 0;
        boolean bl = isEnchantCombining = input2.method_57826(class_9334.field_49643) && !stack.method_58657().method_57534().isEmpty();
        if (isMaterialRepair) {
            class_2960 materialId = serverPlayer.method_51469().method_30349().method_30530(class_7924.field_41197).method_10221((Object)input2.method_7909());
            if (materialId == null) {
                Simpleskills.LOGGER.warn("Invalid material item {} in slot 1 for player {}", (Object)input2.method_7909(), (Object)serverPlayer.method_5477().getString());
                return;
            }
            String action = "repair:" + materialId.toString();
            if (!ConfigManager.getSmithingXPMap().containsKey(action)) {
                Simpleskills.LOGGER.debug("No XP multiplier defined for {} in smithing_xp.json, skipping XP for player {}", (Object)action, (Object)serverPlayer.method_5477().getString());
                this.durabilityRepaired = 0;
                return;
            }
            float xpMultiplier = ConfigManager.getSmithingXP(action, Skills.SMITHING);
            int smithingXP = Math.round((float)this.durabilityRepaired * xpMultiplier);
            if (smithingXP > 0) {
                XPManager.addXPWithNotification(serverPlayer, Skills.SMITHING, smithingXP);
                Simpleskills.LOGGER.debug("Granted {} Smithing XP for material repair with {} (durability {}, multiplier {}) by player {}", new Object[]{smithingXP, materialId, this.durabilityRepaired, Float.valueOf(xpMultiplier), serverPlayer.method_5477().getString()});
            }
            this.durabilityRepaired = 0;
        } else if (isEnchantCombining && (enchantingXP = this.field_7770.method_17407()) > 1) {
            XPManager.addXPWithNotification(serverPlayer, Skills.ENCHANTING, enchantingXP * 100);
            Simpleskills.LOGGER.debug("Granted {} Enchanting XP for combining enchantments by player {} (level {})", new Object[]{enchantingXP, serverPlayer.method_5477().getString(), XPManager.getSkillLevel(serverPlayer.method_5845(), Skills.ENCHANTING)});
        }
    }

    @Unique
    private String getTierName(int smithingLevel) {
        if (smithingLevel >= 99) {
            return "Grandmaster";
        }
        if (smithingLevel >= 75) {
            return "Expert";
        }
        if (smithingLevel >= 50) {
            return "Artisan";
        }
        if (smithingLevel >= 25) {
            return "Journeyman";
        }
        return "Novice";
    }

    @Override
    public int simpleskills$getRepairItemUsage() {
        return this.field_7776;
    }

    @Override
    public int simpleskills$getDurabilityRepaired() {
        return this.durabilityRepaired;
    }

    @Override
    public int simpleskills$getLevelCost() {
        return this.field_7770.method_17407();
    }
}

