/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.SMITHING;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.LoreManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.utils.AnvilScreenHandlerAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4861;
import net.minecraft.class_4862;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4861.class})
public abstract class ForgingScreenHandlerMixin {
    @Shadow
    protected class_1263 field_22480;

    @Inject(method={"quickMove"}, at={@At(value="HEAD")})
    private void handleQuickMoveOperations(class_1657 player, int slotIndex, CallbackInfoReturnable<class_1799> cir) {
        class_1735 resultSlot;
        class_1799 resultStack;
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_4861 handler = (class_4861)this;
        if (slotIndex == handler.method_48360() && !(resultStack = (resultSlot = handler.method_7611(slotIndex)).method_7677()).method_7960()) {
            if (handler instanceof class_4862) {
                this.handleSmithingQuickMove(serverPlayer, (class_4862)handler, resultStack);
            } else if (handler instanceof class_1706) {
                this.handleAnvilQuickMove(serverPlayer, (class_1706)handler, resultStack);
            }
        }
    }

    @Unique
    private void handleSmithingQuickMove(class_3222 serverPlayer, class_4862 handler, class_1799 resultStack) {
        if (this.isNetheriteToolUpgrade(handler, resultStack)) {
            Simpleskills.LOGGER.debug("ForgingScreenHandlerMixin: Handling smithing quick move for player {}, output: {}", (Object)serverPlayer.method_5477().getString(), (Object)resultStack.method_7909());
            XPManager.addXPWithNotification(serverPlayer, Skills.SMITHING, 20000);
            this.applySmithingLore(resultStack, serverPlayer);
            class_1799 scaledStack = this.applySmithingDurabilityScaling(resultStack, serverPlayer, handler);
            if (scaledStack != resultStack) {
                resultStack.method_57379(class_9334.field_50072, (Object)((Integer)scaledStack.method_58695(class_9334.field_50072, null)));
                resultStack.method_57379(class_9334.field_49632, (Object)((class_9290)scaledStack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()))));
            }
        }
    }

    @Unique
    private void handleAnvilQuickMove(class_3222 serverPlayer, class_1706 anvilHandler, class_1799 resultStack) {
        Simpleskills.LOGGER.debug("ForgingScreenHandlerMixin: Handling anvil quick move for player {}, output: {}", (Object)serverPlayer.method_5477().getString(), (Object)resultStack.method_7909());
        if (resultStack.method_7960() || class_7923.field_41178.method_10221((Object)resultStack.method_7909()).toString().equals("minecraft:air")) {
            Simpleskills.LOGGER.debug("Skipping handleAnvilQuickMove for empty or air output: {}", (Object)resultStack);
            return;
        }
        this.grantXPForAnvilAction(serverPlayer, anvilHandler, resultStack);
    }

    @Unique
    private void grantXPForAnvilAction(class_3222 serverPlayer, class_1706 anvilHandler, class_1799 resultStack) {
        boolean isEnchantCombining;
        class_1799 input1 = anvilHandler.method_7611(0).method_7677();
        class_1799 input2 = anvilHandler.method_7611(1).method_7677();
        if (input1.method_7960() || input2.method_7960() || class_7923.field_41178.method_10221((Object)input1.method_7909()).toString().equals("minecraft:air") || class_7923.field_41178.method_10221((Object)input2.method_7909()).toString().equals("minecraft:air")) {
            Simpleskills.LOGGER.debug("Skipping grantXPForAnvilAction for empty or air inputs: input1={}, input2={}", (Object)input1, (Object)input2);
            return;
        }
        int durabilityRepaired = ((AnvilScreenHandlerAccessor)anvilHandler).simpleskills$getDurabilityRepaired();
        int repairItemUsage = ((AnvilScreenHandlerAccessor)anvilHandler).simpleskills$getRepairItemUsage();
        int levelCost = ((AnvilScreenHandlerAccessor)anvilHandler).simpleskills$getLevelCost();
        boolean isMaterialRepair = input1.method_7909() == resultStack.method_7909() && input1.method_7919() > resultStack.method_7919() && repairItemUsage > 0;
        boolean bl = isEnchantCombining = input2.method_57826(class_9334.field_49643) && !resultStack.method_58657().method_57534().isEmpty();
        if (isMaterialRepair) {
            class_2960 materialId = serverPlayer.method_51469().method_30349().method_30530(class_7924.field_41197).method_10221((Object)input2.method_7909());
            if (materialId == null) {
                Simpleskills.LOGGER.warn("Invalid material item {} in slot 1 for player {}", (Object)input2.method_7909(), (Object)serverPlayer.method_5477().getString());
                return;
            }
            String action = "repair:" + materialId.toString();
            if (!ConfigManager.getSmithingXPMap().containsKey(action)) {
                Simpleskills.LOGGER.debug("No XP multiplier defined for {} in smithing_xp.json, skipping XP for player {}", (Object)action, (Object)serverPlayer.method_5477().getString());
                return;
            }
            float xpMultiplier = ConfigManager.getSmithingXP(action, Skills.SMITHING);
            int smithingXP = Math.round((float)durabilityRepaired * xpMultiplier);
            if (smithingXP > 0) {
                XPManager.addXPWithNotification(serverPlayer, Skills.SMITHING, smithingXP);
                Simpleskills.LOGGER.debug("Granted {} Smithing XP for material repair with {} (durability {}, multiplier {}) by player {}", new Object[]{smithingXP, materialId, durabilityRepaired, Float.valueOf(xpMultiplier), serverPlayer.method_5477().getString()});
            }
        } else if (isEnchantCombining && levelCost > 1) {
            XPManager.addXPWithNotification(serverPlayer, Skills.ENCHANTING, levelCost * 100);
            Simpleskills.LOGGER.debug("Granted {} Enchanting XP for combining enchantments by player {} (level {})", new Object[]{levelCost * 100, serverPlayer.method_5477().getString(), XPManager.getSkillLevel(serverPlayer.method_5845(), Skills.ENCHANTING)});
        }
    }

    @Unique
    private boolean isNetheriteToolUpgrade(class_4862 handler, class_1799 outputStack) {
        class_1735 inputSlot0 = handler.method_7611(1);
        class_1735 inputSlot1 = handler.method_7611(2);
        class_1792 outputItem = outputStack.method_7909();
        class_1792 inputItem0 = inputSlot0.method_7677().method_7909();
        class_1792 inputItem1 = inputSlot1.method_7677().method_7909();
        boolean isUpgrade = inputItem1 == class_1802.field_22020;
        Simpleskills.LOGGER.debug("isNetheriteToolUpgrade: output={}, input0={}, input1={}, result={}", new Object[]{outputItem, inputItem0, inputItem1, isUpgrade});
        return isUpgrade;
    }

    @Unique
    private class_1799 applySmithingDurabilityScaling(class_1799 stack, class_3222 player, class_4862 handler) {
        int vanillaDiamondDurability;
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: Empty stack or no MAX_DAMAGE for {}", (Object)stack.method_7909());
            return stack;
        }
        int vanillaNetheriteDurability = this.getVanillaDurability(stack.method_7909());
        if (vanillaNetheriteDurability == 0) {
            Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: No valid vanilla durability for {}", (Object)stack.method_7909());
            return stack;
        }
        Integer inputDurability = this.getInputDurability(handler);
        if (inputDurability == null || inputDurability == 0) {
            Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: No valid input durability for input item");
            return stack;
        }
        class_1792 diamondEquivalent = this.getDiamondEquivalent(stack.method_7909());
        int n = vanillaDiamondDurability = diamondEquivalent != null ? this.getVanillaDurability(diamondEquivalent) : 0;
        if (vanillaDiamondDurability == 0) {
            Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: No valid vanilla diamond durability for {}", (Object)diamondEquivalent);
            return stack;
        }
        int craftingBonus = inputDurability - vanillaDiamondDurability;
        int smithingLevel = XPManager.getSkillLevel(player.method_5845(), Skills.SMITHING);
        float smithingMultiplier = ConfigManager.getSmithingMultiplier(smithingLevel);
        int newMax = Math.max(1, Math.round((float)(vanillaNetheriteDurability + craftingBonus) * smithingMultiplier));
        Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: Input durability={}, Vanilla diamond durability={}, Crafting bonus={}, Vanilla Netherite durability={}, Final durability={} for {} (player={}, smithing lvl={}, smithing multiplier={})", new Object[]{inputDurability, vanillaDiamondDurability, craftingBonus, vanillaNetheriteDurability, newMax, class_7923.field_41178.method_10221((Object)stack.method_7909()).toString(), player.method_5477().getString(), smithingLevel, Float.valueOf(smithingMultiplier)});
        class_1799 newStack = stack.method_7972();
        newStack.method_57379(class_9334.field_50072, (Object)newMax);
        return newStack;
    }

    @Unique
    private Integer getInputDurability(class_4862 handler) {
        class_1799 inputStack = handler.method_7611(1).method_7677();
        return (Integer)inputStack.method_58695(class_9334.field_50072, null);
    }

    @Unique
    private int getVanillaDurability(class_1792 item) {
        class_1799 tempStack = new class_1799((class_1935)item);
        Integer durability = (Integer)tempStack.method_58695(class_9334.field_50072, null);
        return durability != null ? durability : 0;
    }

    @Unique
    private class_1792 getDiamondEquivalent(class_1792 netheriteItem) {
        if (netheriteItem == class_1802.field_22024) {
            return class_1802.field_8377;
        }
        if (netheriteItem == class_1802.field_22025) {
            return class_1802.field_8556;
        }
        if (netheriteItem == class_1802.field_22023) {
            return class_1802.field_8250;
        }
        if (netheriteItem == class_1802.field_22026) {
            return class_1802.field_8527;
        }
        if (netheriteItem == class_1802.field_22022) {
            return class_1802.field_8802;
        }
        if (netheriteItem == class_1802.field_22027) {
            return class_1802.field_8805;
        }
        if (netheriteItem == class_1802.field_22028) {
            return class_1802.field_8058;
        }
        if (netheriteItem == class_1802.field_22029) {
            return class_1802.field_8348;
        }
        if (netheriteItem == class_1802.field_22030) {
            return class_1802.field_8285;
        }
        return null;
    }

    @Unique
    private void applySmithingLore(class_1799 stack, class_3222 player) {
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.SMITHING);
        LoreManager.TierInfo tierInfo = LoreManager.getTierName(level);
        class_9290 currentLoreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
        ArrayList<class_5250> currentLore = new ArrayList<class_5250>(currentLoreComponent.comp_2400());
        class_5250 smithingLore = class_2561.method_43470((String)("Upgraded by " + player.method_5477().getString() + " (" + tierInfo.name() + " Smith)")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_36139(tierInfo.color()));
        currentLore.addFirst(smithingLore);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(currentLore));
    }
}

