/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.utils;

import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.LoreManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public final class CraftingCommon {
    private static final String AIR_ID = "minecraft:air";

    private CraftingCommon() {
    }

    public static boolean isValidStack(class_1799 stack) {
        return !stack.method_7960() && !AIR_ID.equals(class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
    }

    public static boolean isCraftableItem(class_1799 stack) {
        return stack.method_58694(class_9334.field_50072) != null;
    }

    public static boolean isCookableFoodItem(class_1799 stack) {
        String itemKey = stack.method_7909().method_7876();
        return ConfigManager.getCookingXP(itemKey, Skills.COOKING) > 0;
    }

    public static void grantCraftingXP(class_3222 player, class_1799 stack) {
        if (!CraftingCommon.isValidStack(stack) || !CraftingCommon.isCraftableItem(stack)) {
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        int xpPerItem = ConfigManager.getCraftingXP(itemId.toString(), Skills.CRAFTING);
        if (xpPerItem <= 0) {
            return;
        }
        int totalXP = xpPerItem * stack.method_7947();
        XPManager.addXPWithNotification(player, Skills.CRAFTING, totalXP);
    }

    public static void grantCookingXP(class_3222 player, class_1799 stack) {
        if (!CraftingCommon.isValidStack(stack)) {
            return;
        }
        String itemKey = stack.method_7909().method_7876();
        int xpPerItem = ConfigManager.getCookingXP(itemKey, Skills.COOKING);
        if (xpPerItem <= 0) {
            return;
        }
        int totalXP = xpPerItem * stack.method_7947();
        XPManager.addXPWithNotification(player, Skills.COOKING, totalXP);
    }

    public static void applyCraftingLore(class_1799 stack, class_3222 player) {
        if (!CraftingCommon.isValidStack(stack) || !CraftingCommon.isCraftableItem(stack)) {
            return;
        }
        if (!CraftingCommon.isCraftingLoreInTooltipsEnabled()) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.CRAFTING);
        LoreManager.TierInfo tierInfo = LoreManager.getTierName(level);
        CraftingCommon.applyPlayerLore(stack, player, tierInfo, "Crafter");
    }

    public static void applyCookingLore(class_1799 stack, class_3222 player) {
        if (!CraftingCommon.isValidStack(stack)) {
            return;
        }
        if (!CraftingCommon.isCraftingLoreInTooltipsEnabled()) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.COOKING);
        LoreManager.TierInfo tierInfo = LoreManager.getTierName(level);
        CraftingCommon.applyPlayerLore(stack, player, tierInfo, "Cook");
    }

    private static void applyPlayerLore(class_1799 stack, class_3222 player, LoreManager.TierInfo tierInfo, String profession) {
        class_9290 currentLore = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
        ArrayList<class_5250> loreLines = new ArrayList<class_5250>(currentLore.comp_2400());
        class_5250 newLore = class_2561.method_43470((String)String.format("%sed by %s (%s %s)", profession.equals("Cook") ? "Cook" : "Craft", player.method_5477().getString(), tierInfo.name(), profession)).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_36139(tierInfo.color()));
        loreLines.addFirst(newLore);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(loreLines));
    }

    public static void applyCraftingScaling(class_1799 stack, class_3222 player) {
        if (!CraftingCommon.isValidStack(stack) || !CraftingCommon.isCraftableItem(stack)) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.CRAFTING);
        float multiplier = ConfigManager.getCraftingDurabilityMultiplier(level);
        Integer originalDurability = (Integer)stack.method_58694(class_9334.field_50072);
        if (originalDurability == null) {
            return;
        }
        int newDurability = Math.max(1, Math.round((float)originalDurability.intValue() * multiplier));
        stack.method_57379(class_9334.field_50072, (Object)newDurability);
    }

    public static void applyCookingScaling(class_1799 stack, class_3222 player) {
        if (!CraftingCommon.isValidStack(stack)) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.COOKING);
        float multiplier = ConfigManager.getCookingMultiplier(level);
        class_4174 originalFood = (class_4174)stack.method_58694(class_9334.field_50075);
        if (originalFood == null) {
            return;
        }
        int newHunger = Math.max(1, Math.round((float)originalFood.comp_2491() * multiplier));
        float newSaturation = originalFood.comp_2492() * multiplier;
        class_4174 scaledFood = new class_4174.class_4175().method_19238(newHunger).method_19237(newSaturation).method_19242();
        stack.method_57379(class_9334.field_50075, (Object)scaledFood);
    }

    private static boolean isCraftingLoreInTooltipsEnabled() {
        return ConfigManager.getFeatureConfig().get("crafting_lore_in_tooltips_enabled").getAsBoolean();
    }
}

