/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("simpleskills_client.json");
    private static Config config = new Config();

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                Config loadedConfig = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (loadedConfig != null) {
                    config = loadedConfig;
                }
            }
            catch (IOException e) {
                Simpleskills.LOGGER.error("Failed to load client config: {}", (Object)e.getMessage());
            }
        }
        ClientConfig.save();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Simpleskills.LOGGER.error("Failed to save client config: {}", (Object)e.getMessage());
        }
    }

    public static HudPosition getHudPosition() {
        return ClientConfig.config.hudPosition;
    }

    public static void setHudPosition(HudPosition position) {
        ClientConfig.config.hudPosition = position;
        ClientConfig.save();
    }

    public static void cycleHudPosition() {
        HudPosition[] positions = HudPosition.values();
        int currentIndex = ClientConfig.config.hudPosition.ordinal();
        int nextIndex = (currentIndex + 1) % positions.length;
        ClientConfig.config.hudPosition = positions[nextIndex];
        ClientConfig.save();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Config {
        public HudPosition hudPosition = HudPosition.TOP_LEFT;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum HudPosition {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_LEFT,
        MIDDLE_CENTER,
        MIDDLE_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

