/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.managers;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.DatabaseManager;
import java.util.Map;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class AttributeManager {
    private static final class_2960 IRONMAN_HEALTH_MODIFIER_ID = class_2960.method_60655((String)"simpleskills", (String)"ironman_health_reduction");

    public static void registerPlayerEvents() {
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (newPlayer == null) {
                Simpleskills.LOGGER.warn("Null newPlayer in respawn event.");
                return;
            }
            AttributeManager.refreshAllAttributes(newPlayer);
            Simpleskills.LOGGER.debug("Reapplied attributes for player {} on respawn", (Object)newPlayer.method_5477().getString());
        });
    }

    public static void refreshAllAttributes(class_3222 player) {
        if (player == null) {
            Simpleskills.LOGGER.warn("Null player in refreshAllAttributes.");
            return;
        }
        String playerUuid = player.method_5845();
        AttributeManager.clearSkillAttributes(player);
        AttributeManager.clearIronmanAttributes(player);
        AttributeManager.refreshSkillAttributes(player);
        if (DatabaseManager.getInstance().isPlayerInIronmanMode(playerUuid)) {
            AttributeManager.applyIronmanAttributes(player);
        }
        Simpleskills.LOGGER.debug("Refreshed all attributes for player: {}", (Object)player.method_5477().getString());
    }

    public static void clearSkillAttributes(class_3222 player) {
        if (player == null) {
            return;
        }
        class_1324 moveSpeed = player.method_5996(class_5134.field_23719);
        if (moveSpeed != null) {
            moveSpeed.method_6200(class_2960.method_60654((String)"simpleskills:agility_bonus"));
        }
    }

    public static void applyIronmanAttributes(class_3222 player) {
        if (player == null) {
            return;
        }
        class_1324 healthAttribute = player.method_5996(class_5134.field_23716);
        if (healthAttribute != null) {
            healthAttribute.method_6200(IRONMAN_HEALTH_MODIFIER_ID);
            double healthReduction = ConfigManager.getFeatureConfig().get("ironman_health_reduction") != null ? ConfigManager.getFeatureConfig().get("ironman_health_reduction").getAsDouble() : -10.0;
            healthAttribute.method_26837(new class_1322(IRONMAN_HEALTH_MODIFIER_ID, healthReduction, class_1322.class_1323.field_6328));
        }
    }

    public static void clearIronmanAttributes(class_3222 player) {
        if (player == null) {
            return;
        }
        class_1324 healthAttribute = player.method_5996(class_5134.field_23716);
        if (healthAttribute != null) {
            healthAttribute.method_6200(IRONMAN_HEALTH_MODIFIER_ID);
        }
    }

    public static void refreshSkillAttributes(class_3222 player) {
        if (player == null) {
            return;
        }
        String playerUuid = player.method_5845();
        Map<String, DatabaseManager.SkillData> skills = DatabaseManager.getInstance().getAllSkills(playerUuid);
        for (Skills skill : Skills.values()) {
            AttributeManager.updatePlayerAttributes(player, skill, skills.getOrDefault(skill.getId(), new DatabaseManager.SkillData(0, 1)));
        }
    }

    public static void updatePlayerAttributes(class_3222 player, Skills skill, DatabaseManager.SkillData skillData) {
        if (player == null || skillData == null) {
            return;
        }
        int skillLevel = skillData.level();
        switch (skill) {
            case AGILITY: {
                class_1324 moveSpeed = player.method_5996(class_5134.field_23719);
                if (moveSpeed == null) break;
                moveSpeed.method_6200(class_2960.method_60654((String)"simpleskills:agility_bonus"));
                double bonusSpeed = (double)skillLevel * 0.001;
                moveSpeed.method_26837(new class_1322(class_2960.method_60654((String)"simpleskills:agility_bonus"), bonusSpeed, class_1322.class_1323.field_6330));
                break;
            }
        }
    }
}

