/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.requirements.SkillRequirement;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1743.class})
public class AxeItemMixin {
    @Inject(method={"useOnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkToolAndSkillRequirement(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        int playerLevel;
        class_1657 class_16572;
        class_1937 world = context.method_8045();
        if (world.method_8608() || !((class_16572 = context.method_8036()) instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_16572;
        String toolName = context.method_8041().method_7909().toString();
        SkillRequirement requirement = ConfigManager.getToolRequirement(toolName);
        if (requirement != null && requirement.getSkill() == Skills.WOODCUTTING && (playerLevel = XPManager.getSkillLevel(player.method_5845(), Skills.WOODCUTTING)) < requirement.getLevel()) {
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a76[simpleskills]\u00a7f You need %s level %d to use this tool!", Skills.WOODCUTTING.getDisplayName(), requirement.getLevel())), true);
            cir.setReturnValue((Object)class_1269.field_5814);
            cir.cancel();
            Simpleskills.LOGGER.debug("Prevented player {} from using axe {} due to insufficient Woodcutting level (required: {}, actual: {})", new Object[]{player.method_5477().getString(), toolName, requirement.getLevel(), playerLevel});
        }
    }

    @Inject(method={"useOnBlock"}, at={@At(value="RETURN")})
    private void grantWoodcuttingXPOnStripLog(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        class_3222 player;
        class_1937 world;
        block5: {
            block4: {
                class_1657 class_16572;
                world = context.method_8045();
                if (world.method_8608() || !((class_16572 = context.method_8036()) instanceof class_3222)) break block4;
                player = (class_3222)class_16572;
                if (cir.getReturnValue() == class_1269.field_5812) break block5;
            }
            return;
        }
        String blockTranslationKey = world.method_8320(context.method_8037()).method_26204().method_63499();
        if (AxeItemMixin.isStrippableLog(blockTranslationKey)) {
            Objects.requireNonNull(world.method_8503()).execute(() -> {
                String newBlockTranslationKey = world.method_8320(context.method_8037()).method_26204().method_63499();
                if (newBlockTranslationKey.contains("stripped_")) {
                    int xp = ConfigManager.getBlockXP(blockTranslationKey, Skills.WOODCUTTING);
                    XPManager.addXPWithNotification(player, Skills.WOODCUTTING, xp / 6);
                    Simpleskills.LOGGER.debug("Granted {} Woodcutting XP to {} for stripping log {}", new Object[]{xp, player.method_5477().getString(), blockTranslationKey});
                }
            });
        }
    }

    @Unique
    private static boolean isStrippableLog(String blockTranslationKey) {
        return blockTranslationKey.contains("log") || blockTranslationKey.contains("stem") || blockTranslationKey.contains("wood") || blockTranslationKey.contains("hyphae") && !blockTranslationKey.contains("copper");
    }
}

