/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.DEFENSE;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.requirements.SkillRequirement;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class ArmorRestrictionMixin {
    @Inject(method={"equipStack"}, at={@At(value="HEAD")}, cancellable=true)
    private void restrictArmorEquip(class_1304 slot, class_1799 stack, CallbackInfo ci) {
        ArmorRestrictionMixin armorRestrictionMixin = this;
        if (!(armorRestrictionMixin instanceof class_3222)) {
            Simpleskills.LOGGER.debug("Skipping armor restriction for non-player entity: {}", (Object)this.getClass().getName());
            return;
        }
        class_3222 player = (class_3222)armorRestrictionMixin;
        Simpleskills.LOGGER.info("Mixin applied to ServerPlayerEntity, class: {}", (Object)this.getClass().getName());
        Simpleskills.LOGGER.debug("Processing for player: {}", (Object)player.method_5477().getString());
        if (!slot.method_46643() || stack.method_7960()) {
            Simpleskills.LOGGER.debug("Not an armor slot or stack is empty, skipping: slot={}, stack={}", (Object)slot, (Object)stack);
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        Simpleskills.LOGGER.debug("Checking item: {}", (Object)itemId);
        SkillRequirement requirement = ConfigManager.getArmorRequirement(itemId.toString());
        if (requirement == null) {
            Simpleskills.LOGGER.debug("No skill requirement for item: {}", (Object)itemId);
            return;
        }
        String playerUuid = player.method_5845();
        String skill = requirement.getSkill().getId();
        int playerLevel = XPManager.getSkillLevel(playerUuid, requirement.getSkill());
        int requiredLevel = requirement.getLevel();
        Simpleskills.LOGGER.debug("Player {} level for skill {}: {}, required: {}", new Object[]{playerUuid, skill, playerLevel, requiredLevel});
        if (playerLevel < requiredLevel) {
            String preventReason = String.format("\u00a76[simpleskills]\u00a7f You need %s level %d to equip this item!", requirement.getSkill().getDisplayName(), requiredLevel);
            player.method_7353((class_2561)class_2561.method_43470((String)preventReason), true);
            player.method_7328(stack.method_7972(), false);
            ci.cancel();
            Simpleskills.LOGGER.info("Prevented player {} from equipping {} due to insufficient {} level (required: {}, actual: {})", new Object[]{player.method_5477().getString(), itemId, requirement.getSkill().getDisplayName(), requiredLevel, playerLevel});
        }
    }
}

