/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.utils;

import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public final class FurnaceCommon {
    private static final String AIR_ID = "minecraft:air";

    private FurnaceCommon() {
    }

    public static boolean isValidStack(class_1799 stack) {
        return !stack.method_7960() && !AIR_ID.equals(class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
    }

    public static boolean isCookableFoodItem(class_1799 stack) {
        String itemKey = stack.method_7909().method_7876();
        return ConfigManager.getCookingXP(itemKey, Skills.COOKING) > 0 && stack.method_58694(class_9334.field_50075) != null;
    }

    public static void grantCookingXP(class_3222 player, class_1799 stack) {
        if (!FurnaceCommon.isValidStack(stack)) {
            return;
        }
        String itemKey = stack.method_7909().method_7876();
        int xpPerItem = ConfigManager.getCookingXP(itemKey, Skills.COOKING);
        if (xpPerItem <= 0) {
            return;
        }
        int totalXP = xpPerItem * stack.method_7947();
        XPManager.addXPWithNotification(player, Skills.COOKING, totalXP);
    }

    public static void grantSmeltingCraftingXP(class_3222 player, class_1799 stack) {
        if (!FurnaceCommon.isValidStack(stack)) {
            return;
        }
        String itemKey = stack.method_7909().method_7876();
        int xpPerItem = ConfigManager.getSmeltingCraftingXP(itemKey, Skills.CRAFTING);
        if (xpPerItem <= 0) {
            return;
        }
        int totalXP = xpPerItem * stack.method_7947();
        XPManager.addXPWithNotification(player, Skills.CRAFTING, totalXP);
    }
}

