/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.LoreManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2589;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2589.class})
public abstract class AlchemyXPMixin {
    @Unique
    private class_3222 lastPlayer;

    @Inject(method={"createScreenHandler"}, at={@At(value="RETURN")})
    private void onCreateScreenHandler(int syncId, class_1661 playerInventory, CallbackInfoReturnable<class_1703> cir) {
        class_1657 class_16572 = playerInventory.field_7546;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer;
            this.lastPlayer = serverPlayer = (class_3222)class_16572;
            Simpleskills.LOGGER.debug("Updated last player for BrewingStand at {} to {}", (Object)((class_2589)this).method_11016(), (Object)serverPlayer.method_5477().getString());
        }
    }

    @Inject(method={"craft"}, at={@At(value="TAIL")})
    private static void onCraft(class_1937 world, class_2338 pos, class_2371<class_1799> slots, CallbackInfo ci) {
        if (world.method_8608()) {
            return;
        }
        class_2589 blockEntity = (class_2589)world.method_8321(pos);
        if (blockEntity == null) {
            return;
        }
        class_3222 player = ((AlchemyXPMixin)blockEntity).lastPlayer;
        if (player == null) {
            Simpleskills.LOGGER.debug("No player associated with BrewingStand at {}, no Alchemy XP granted", (Object)pos);
            return;
        }
        for (int i = 0; i < 3; ++i) {
            class_5321 potionKey;
            class_6880 potionEntry;
            String potionPrefix;
            class_1799 stack = (class_1799)slots.get(i);
            if (!stack.method_31574(class_1802.field_8574) && !stack.method_31574(class_1802.field_8436) && !stack.method_31574(class_1802.field_8150)) continue;
            class_1844 potionContents = (class_1844)stack.method_58694(class_9334.field_49651);
            Object potionTranslationKey = "potion.minecraft.unknown";
            String string = stack.method_31574(class_1802.field_8574) ? "potion" : (potionPrefix = stack.method_31574(class_1802.field_8436) ? "splash_potion" : "lingering_potion");
            if (potionContents != null && (potionEntry = (class_6880)potionContents.comp_2378().orElse(null)) != null && (potionKey = (class_5321)potionEntry.method_40230().orElse(null)) != null) {
                String effectId = potionKey.method_29177().toString();
                potionTranslationKey = potionPrefix + ".minecraft." + effectId.replace("minecraft:", "");
            }
            Simpleskills.LOGGER.debug("Identified potion at slot {}: {} (item: {})", new Object[]{i, potionTranslationKey, stack.method_7909().method_7876()});
            int xpPerItem = ConfigManager.getAlchemyXP((String)potionTranslationKey, Skills.ALCHEMY);
            if (xpPerItem <= 0) {
                Simpleskills.LOGGER.debug("No XP defined for potion {}, skipping XP grant", potionTranslationKey);
                continue;
            }
            int totalXP = xpPerItem * stack.method_7947();
            XPManager.addXPWithNotification(player, Skills.ALCHEMY, totalXP);
            Simpleskills.LOGGER.debug("Granted {} Alchemy XP for {}x {} to player {}", new Object[]{totalXP, stack.method_7947(), potionTranslationKey, player.method_5477().getString()});
            AlchemyXPMixin.applyPotionScalingAndLore(stack, player);
        }
    }

    @Unique
    private static void applyPotionScalingAndLore(class_1799 stack, class_3222 player) {
        if (stack.method_7960()) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.ALCHEMY);
        float multiplier = ConfigManager.getAlchemyMultiplier(level);
        if (multiplier == 1.0f) {
            return;
        }
        LoreManager.TierInfo tierInfo = LoreManager.getTierName(level);
        class_1844 contents = (class_1844)stack.method_58694(class_9334.field_49651);
        if (contents == null) {
            return;
        }
        List baseEffects = contents.comp_2378().map(potionEntry -> ((class_1842)potionEntry.comp_349()).method_8049()).orElse(List.of());
        ArrayList<class_1293> scaledEffects = new ArrayList<class_1293>();
        for (class_1293 effect : baseEffects) {
            scaledEffects.add(new class_1293(effect.method_5579(), Math.max(1, Math.round((float)effect.method_5584() * multiplier)), effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()));
        }
        for (class_1293 effect : contents.comp_2380()) {
            scaledEffects.add(new class_1293(effect.method_5579(), Math.max(1, Math.round((float)effect.method_5584() * multiplier)), effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()));
        }
        class_1844 scaled = new class_1844(contents.comp_2378(), contents.comp_2379(), scaledEffects, contents.comp_3209());
        stack.method_57379(class_9334.field_49651, (Object)scaled);
        class_9290 currentLoreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
        ArrayList<class_5250> currentLore = new ArrayList<class_5250>(currentLoreComponent.comp_2400());
        class_5250 alchemyLore = class_2561.method_43470((String)("Brewed by " + player.method_5477().getString() + " (" + tierInfo.name() + " Alchemist)")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_36139(tierInfo.color()));
        currentLore.addFirst(alchemyLore);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(currentLore));
        Simpleskills.LOGGER.debug("Scaled potion {} effects x{} and added lore for player {} (lvl {}, tier {})", new Object[]{stack.method_7909().method_7876(), Float.valueOf(multiplier), player.method_5477().getString(), level, tierInfo.name()});
    }
}

