/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.CRAFTING;

import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.mixin.CRAFTING.AbstractCraftingScreenHandlerAccessor;
import com.github.ob_yekt.simpleskills.utils.CraftingCommon;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1657;
import net.minecraft.class_1714;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import net.minecraft.class_9884;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1714.class})
public abstract class CraftingScreenHandlerMixin
extends class_9884 {
    @Unique
    private final class_8566 craftingInventory = this.getCraftingInventory();
    @Unique
    private final class_1799[] originalInputs = new class_1799[9];

    protected CraftingScreenHandlerMixin(class_3917<?> type, int syncId, int gridWidth, int gridHeight) {
        super(type, syncId, gridWidth, gridHeight);
    }

    @Unique
    private class_8566 getCraftingInventory() {
        return ((AbstractCraftingScreenHandlerAccessor)((Object)this)).getCraftingInventory();
    }

    @Inject(method={"quickMove"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/Item;onCraftByPlayer(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/PlayerEntity;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onQuickMoveCraft(class_1657 player, int slotIndex, CallbackInfoReturnable<class_1799> cir, @Local(ordinal=0) class_1799 itemStack, @Local class_1735 slot, @Local(ordinal=1) class_1799 itemStack2) {
        if (slotIndex == 0 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (itemStack2.method_7960() || class_7923.field_41178.method_10221((Object)itemStack2.method_7909()).toString().equals("minecraft:air")) {
                return;
            }
            for (int i = 0; i < 9; ++i) {
                this.originalInputs[i] = this.craftingInventory.method_5438(i).method_7972();
            }
            if (CraftingCommon.isCraftableItem(itemStack2)) {
                CraftingCommon.applyCraftingLore(itemStack2, serverPlayer);
                CraftingCommon.applyCraftingScaling(itemStack2, serverPlayer);
            } else if (CraftingCommon.isCookableFoodItem(itemStack2)) {
                CraftingCommon.applyCookingLore(itemStack2, serverPlayer);
                CraftingCommon.applyCookingScaling(itemStack2, serverPlayer);
            }
        }
    }

    @Inject(method={"quickMove"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/slot/Slot;onQuickTransfer(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onQuickMoveAfterTransfer(class_1657 player, int slotIndex, CallbackInfoReturnable<class_1799> cir, @Local(ordinal=0) class_1799 itemStack, @Local class_1735 slot, @Local(ordinal=1) class_1799 itemStack2) {
        if (slotIndex == 0 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (itemStack.method_7960() || class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString().equals("minecraft:air")) {
                return;
            }
            int movedCount = itemStack.method_7947() - (itemStack2.method_7960() ? 0 : itemStack2.method_7947());
            if (movedCount > 0) {
                class_1799 movedStack = itemStack.method_7972();
                movedStack.method_7939(movedCount);
                if (CraftingCommon.isCraftableItem(movedStack)) {
                    CraftingCommon.grantCraftingXP(serverPlayer, movedStack);
                }
                if (CraftingCommon.isCookableFoodItem(movedStack)) {
                    CraftingCommon.grantCookingXP(serverPlayer, movedStack);
                }
                this.applyMaterialRecovery(serverPlayer, itemStack);
            }
        }
    }

    @Unique
    private void applyMaterialRecovery(class_3222 player, class_1799 outputStack) {
        String itemId = class_7923.field_41178.method_10221((Object)outputStack.method_7909()).toString();
        if (ConfigManager.isRecipeBlacklisted(itemId)) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.CRAFTING);
        float recoveryChance = ConfigManager.getCraftingRecoveryChance(level);
        if (recoveryChance <= 0.0f) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 original = this.originalInputs[i];
            class_1799 current = this.craftingInventory.method_5438(i);
            if (original.method_7960() || current.method_7947() >= original.method_7947() || !(player.method_59922().method_43057() < recoveryChance)) continue;
            class_1799 recovered = original.method_7972();
            recovered.method_7939(1);
            if (player.method_31548().method_7394(recovered)) continue;
            player.method_7328(recovered, false);
        }
    }
}

