/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.SMITHING;

import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.requirements.SkillRequirement;
import com.github.ob_yekt.simpleskills.utils.AnvilScreenHandlerAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3544;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8047;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1706.class})
public abstract class AnvilScreenHandlerMixin
extends class_4861
implements AnvilScreenHandlerAccessor {
    @Final
    @Shadow
    private class_3915 field_7770;
    @Shadow
    private int field_7776;
    @Shadow
    @Nullable
    private String field_7774;
    @Unique
    private int durabilityRepaired;
    @Unique
    private boolean simpleskills$isPureRepair = false;

    protected AnvilScreenHandlerMixin(class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context) {
        super(type, syncId, playerInventory, context, AnvilScreenHandlerMixin.getForgingSlotsManager());
    }

    @Unique
    private static class_8047 getForgingSlotsManager() {
        return class_8047.method_48364().method_48374(0, 27, 47, stack -> true).method_48374(1, 76, 47, stack -> true).method_48373(2, 134, 47).method_48372();
    }

    @Inject(method={"canTakeOutput"}, at={@At(value="HEAD")}, cancellable=true)
    protected void simpleskills_canTakeOutput(class_1657 player, boolean present, CallbackInfoReturnable<Boolean> cir) {
        if (this.simpleskills$isPureRepair) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"updateResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void simpleskills_handlePureRepair(CallbackInfo ci) {
        boolean hasNameChange;
        boolean isItemCombinationRepair;
        class_1799 input1 = this.field_22480.method_5438(0);
        class_1799 input2 = this.field_22480.method_5438(1);
        this.simpleskills$isPureRepair = false;
        this.durabilityRepaired = 0;
        if (input1.method_7960() || !input1.method_7963() || input1.method_7919() <= 0) {
            return;
        }
        boolean isMaterialRepair = input1.method_61655(input2);
        boolean bl = isItemCombinationRepair = input1.method_31574(input2.method_7909()) && input2.method_7963();
        if (input2.method_31574(class_1802.field_8598) && !isMaterialRepair) {
            return;
        }
        if (!isMaterialRepair && !isItemCombinationRepair) {
            return;
        }
        if (this.hasNewEnchantsApplied(input1, input2)) {
            return;
        }
        this.simpleskills$isPureRepair = true;
        ci.cancel();
        class_1799 resultStack = input1.method_7972();
        int maxDamage = resultStack.method_7936();
        int initialDamage = resultStack.method_7919();
        this.field_7776 = 0;
        if (isMaterialRepair) {
            int smithingLevel = XPManager.getSkillLevel(this.field_22482.method_5845(), Skills.SMITHING);
            float efficiency = this.calculateRepairEfficiency(smithingLevel);
            float scaledRepair = (float)maxDamage * efficiency;
            int unitsAvailable = input2.method_7947();
            float damageToRepair = initialDamage;
            float unitsNeededF = damageToRepair / scaledRepair;
            int unitsNeeded = (int)Math.ceil(unitsNeededF);
            this.field_7776 = Math.min(unitsAvailable, unitsNeeded);
            this.durabilityRepaired = Math.min((int)((float)this.field_7776 * scaledRepair), initialDamage);
        } else if (isItemCombinationRepair) {
            int durabilityFromInput2 = maxDamage - input2.method_7919();
            int bonusRepair = maxDamage * 12 / 100;
            int totalRepair = durabilityFromInput2 + bonusRepair;
            this.durabilityRepaired = Math.min(totalRepair, initialDamage);
            this.field_7776 = 1;
        }
        boolean bl2 = hasNameChange = this.field_7774 != null && !class_3544.method_57181((String)this.field_7774) && !this.field_7774.equals(input1.method_7964().getString());
        if (this.durabilityRepaired <= 0 && !hasNameChange) {
            this.field_22479.method_5447(0, class_1799.field_8037);
            this.field_7770.method_17404(0);
            this.method_7623();
            return;
        }
        resultStack.method_7974(initialDamage - this.durabilityRepaired);
        if (hasNameChange) {
            resultStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)this.field_7774));
        } else if (input1.method_57826(class_9334.field_49631)) {
            resultStack.method_57381(class_9334.field_49631);
        }
        this.field_7770.method_17404(-1);
        this.field_22479.method_5447(0, resultStack);
        this.method_7623();
    }

    @Inject(method={"updateResult"}, at={@At(value="TAIL")})
    private void simpleskills_checkEnchantmentRequirements(CallbackInfo ci) {
        if (this.simpleskills$isPureRepair) {
            return;
        }
        class_1657 class_16572 = this.field_22482;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        class_1735 outputSlot = this.method_7611(2);
        class_1799 outputStack = outputSlot.method_7677();
        if (outputStack.method_7960()) {
            return;
        }
        boolean hasRestrictedEnchantment = false;
        for (class_6880 enchantmentEntry : outputStack.method_58657().method_57534()) {
            class_1887 enchantment = (class_1887)enchantmentEntry.comp_349();
            int enchantmentLevel = outputStack.method_58657().method_57536(enchantmentEntry);
            class_2960 enchantmentId = serverPlayer.method_51469().method_30349().method_30530(class_7924.field_41265).method_10221((Object)enchantment);
            if (enchantmentId == null) continue;
            SkillRequirement requirement = ConfigManager.getEnchantmentRequirement(enchantmentId.toString());
            int playerEnchantingLevel = XPManager.getSkillLevel(serverPlayer.method_5845(), Skills.ENCHANTING);
            if (requirement == null || enchantmentLevel < requirement.getEnchantmentLevel() || playerEnchantingLevel >= requirement.getLevel()) continue;
            hasRestrictedEnchantment = true;
            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f You need ENCHANTING level " + requirement.getLevel() + " to apply " + enchantmentId.method_12832() + " level " + enchantmentLevel + "!")), true);
            break;
        }
        if (hasRestrictedEnchantment) {
            outputSlot.method_53512(class_1799.field_8037);
        }
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;addExperienceLevels(I)V", shift=At.Shift.BEFORE)}, cancellable=true)
    private void simpleskills_preventLevelChangeOnPureRepair(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (this.simpleskills$isPureRepair && this.field_7770.method_17407() == -1) {
            ci.cancel();
        }
    }

    @Redirect(method={"onTakeOutput"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/ScreenHandlerContext;run(Ljava/util/function/BiConsumer;)V"))
    private void simpleskills_preventAllAnvilDamage(class_3914 instance, BiConsumer<class_1937, class_2338> action) {
        instance.method_17393((world, pos) -> world.method_20290(1030, pos, 0));
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="HEAD")})
    private void simpleskills_grantXpOnTakeOutput(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (this.simpleskills$isPureRepair) {
            this.grantSmithingXP(serverPlayer, this.field_22480.method_5438(1));
            this.durabilityRepaired = 0;
            this.simpleskills$isPureRepair = false;
            return;
        }
        if (this.field_7770.method_17407() > 0 && this.hasNewEnchantsApplied(this.field_22480.method_5438(0), stack, this.field_22480.method_5438(1))) {
            int enchantingXP = this.field_7770.method_17407();
            XPManager.addXPWithNotification(serverPlayer, Skills.ENCHANTING, enchantingXP * 500);
        }
        this.durabilityRepaired = 0;
        this.simpleskills$isPureRepair = false;
    }

    @Unique
    private boolean hasNewEnchantsApplied(class_1799 baseItem, class_1799 materialItem) {
        class_9304 enchantsOnMaterial = materialItem.method_31574(class_1802.field_8598) ? (class_9304)materialItem.method_58695(class_9334.field_49643, (Object)class_9304.field_49385) : (class_9304)materialItem.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        if (enchantsOnMaterial.method_57543()) {
            return false;
        }
        class_9304 enchantsOnBase = class_1890.method_57532((class_1799)baseItem);
        for (Object2IntMap.Entry entry : enchantsOnMaterial.method_57539()) {
            class_6880 enchantmentEntry = (class_6880)entry.getKey();
            if (!((class_1887)enchantmentEntry.comp_349()).method_8192(baseItem)) continue;
            int baseLevel = enchantsOnBase.method_57536(enchantmentEntry);
            int materialLevel = entry.getIntValue();
            if (materialLevel > baseLevel) {
                return true;
            }
            if (materialLevel != baseLevel || materialLevel >= ((class_1887)enchantmentEntry.comp_349()).method_8183()) continue;
            return true;
        }
        return false;
    }

    @Unique
    private boolean hasNewEnchantsApplied(class_1799 input, class_1799 output, class_1799 material) {
        class_9304 enchantsOnMaterial = material.method_31574(class_1802.field_8598) ? (class_9304)material.method_58695(class_9334.field_49643, (Object)class_9304.field_49385) : (class_9304)material.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        if (enchantsOnMaterial.method_57543() && !material.method_31574(input.method_7909())) {
            return false;
        }
        class_9304 outputEnchants = output.method_58657();
        class_9304 inputEnchants = input.method_58657();
        for (class_6880 enchantEntry : outputEnchants.method_57534()) {
            int inputLevel;
            int outputLevel = outputEnchants.method_57536(enchantEntry);
            if (outputLevel <= (inputLevel = inputEnchants.method_57536(enchantEntry))) continue;
            return true;
        }
        return false;
    }

    @Unique
    private void grantSmithingXP(class_3222 serverPlayer, class_1799 material) {
        float xpMultiplier;
        int smithingXP;
        if (this.durabilityRepaired <= 0) {
            return;
        }
        class_2960 materialId = class_7923.field_41178.method_10221((Object)material.method_7909());
        String action = "repair:" + String.valueOf(materialId);
        if (!ConfigManager.getSmithingXPMap().containsKey(action)) {
            action = "repair:" + String.valueOf(class_7923.field_41178.method_10221((Object)this.field_22480.method_5438(0).method_7909()));
            if (!ConfigManager.getSmithingXPMap().containsKey(action)) {
                return;
            }
        }
        if ((smithingXP = Math.round((float)this.durabilityRepaired * (xpMultiplier = ConfigManager.getSmithingXP(action, Skills.SMITHING)))) > 0) {
            XPManager.addXPWithNotification(serverPlayer, Skills.SMITHING, smithingXP);
        }
    }

    @Unique
    private float calculateRepairEfficiency(int smithingLevel) {
        if (smithingLevel >= 99) {
            return 1.0f;
        }
        if (smithingLevel >= 75) {
            return 0.55f;
        }
        if (smithingLevel >= 50) {
            return 0.45f;
        }
        if (smithingLevel >= 25) {
            return 0.35f;
        }
        return 0.25f;
    }

    @Override
    public int simpleskills$getRepairItemUsage() {
        return this.field_7776;
    }

    @Override
    public int simpleskills$getDurabilityRepaired() {
        return this.durabilityRepaired;
    }

    @Override
    public int simpleskills$getLevelCost() {
        return this.field_7770.method_17407();
    }
}

