/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.SMITHING;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.LoreManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_4861;
import net.minecraft.class_4862;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4861.class})
public abstract class ForgingScreenHandlerMixin {
    @Shadow
    protected class_1263 field_22480;

    @Inject(method={"quickMove"}, at={@At(value="HEAD")})
    private void handleQuickMoveOperations(class_1657 player, int slotIndex, CallbackInfoReturnable<class_1799> cir) {
        class_1735 resultSlot;
        class_1799 resultStack;
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_4861 handler = (class_4861)this;
        if (slotIndex == handler.method_48360() && !(resultStack = (resultSlot = handler.method_7611(slotIndex)).method_7677()).method_7960() && handler instanceof class_4862) {
            this.handleSmithingQuickMove(serverPlayer, (class_4862)handler, resultStack);
        }
    }

    @Unique
    private void handleSmithingQuickMove(class_3222 serverPlayer, class_4862 handler, class_1799 resultStack) {
        if (this.isNetheriteToolUpgrade(handler, resultStack)) {
            Simpleskills.LOGGER.debug("ForgingScreenHandlerMixin: Handling smithing quick move for player {}, output: {}", (Object)serverPlayer.method_5477().getString(), (Object)resultStack.method_7909());
            XPManager.addXPWithNotification(serverPlayer, Skills.SMITHING, 20000);
            this.applySmithingLore(resultStack, serverPlayer);
            class_1799 scaledStack = this.applySmithingDurabilityScaling(resultStack, serverPlayer, handler);
            if (scaledStack != resultStack) {
                resultStack.method_57379(class_9334.field_50072, (Object)((Integer)scaledStack.method_58695(class_9334.field_50072, null)));
                resultStack.method_57379(class_9334.field_49632, (Object)((class_9290)scaledStack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()))));
            }
        }
    }

    @Unique
    private boolean isNetheriteToolUpgrade(class_4862 handler, class_1799 outputStack) {
        class_1735 inputSlot1 = handler.method_7611(2);
        return inputSlot1.method_7677().method_31574(class_1802.field_22020);
    }

    @Unique
    private class_1799 applySmithingDurabilityScaling(class_1799 stack, class_3222 player, class_4862 handler) {
        int vanillaDiamondDurability;
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            return stack;
        }
        int vanillaNetheriteDurability = this.getVanillaDurability(stack.method_7909());
        if (vanillaNetheriteDurability == 0) {
            return stack;
        }
        Integer inputDurability = this.getInputDurability(handler);
        if (inputDurability == null || inputDurability == 0) {
            return stack;
        }
        class_1792 diamondEquivalent = this.getDiamondEquivalent(stack.method_7909());
        int n = vanillaDiamondDurability = diamondEquivalent != null ? this.getVanillaDurability(diamondEquivalent) : 0;
        if (vanillaDiamondDurability == 0) {
            return stack;
        }
        int craftingBonus = inputDurability - vanillaDiamondDurability;
        int smithingLevel = XPManager.getSkillLevel(player.method_5845(), Skills.SMITHING);
        float smithingMultiplier = ConfigManager.getSmithingMultiplier(smithingLevel);
        int newMax = Math.max(1, Math.round((float)(vanillaNetheriteDurability + craftingBonus) * smithingMultiplier));
        Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: Input durability={}, Vanilla diamond durability={}, Crafting bonus={}, Vanilla Netherite durability={}, Final durability={} for {} (player={}, smithing lvl={}, smithing multiplier={})", new Object[]{inputDurability, vanillaDiamondDurability, craftingBonus, vanillaNetheriteDurability, newMax, class_7923.field_41178.method_10221((Object)stack.method_7909()).toString(), player.method_5477().getString(), smithingLevel, Float.valueOf(smithingMultiplier)});
        class_1799 newStack = stack.method_7972();
        newStack.method_57379(class_9334.field_50072, (Object)newMax);
        return newStack;
    }

    @Unique
    private Integer getInputDurability(class_4862 handler) {
        class_1799 inputStack = handler.method_7611(1).method_7677();
        return (Integer)inputStack.method_58695(class_9334.field_50072, null);
    }

    @Unique
    private int getVanillaDurability(class_1792 item) {
        class_1799 tempStack = new class_1799((class_1935)item);
        Integer durability = (Integer)tempStack.method_58695(class_9334.field_50072, null);
        return durability != null ? durability : 0;
    }

    @Unique
    private class_1792 getDiamondEquivalent(class_1792 netheriteItem) {
        if (netheriteItem == class_1802.field_22024) {
            return class_1802.field_8377;
        }
        if (netheriteItem == class_1802.field_22025) {
            return class_1802.field_8556;
        }
        if (netheriteItem == class_1802.field_22023) {
            return class_1802.field_8250;
        }
        if (netheriteItem == class_1802.field_22026) {
            return class_1802.field_8527;
        }
        if (netheriteItem == class_1802.field_22022) {
            return class_1802.field_8802;
        }
        if (netheriteItem == class_1802.field_22027) {
            return class_1802.field_8805;
        }
        if (netheriteItem == class_1802.field_22028) {
            return class_1802.field_8058;
        }
        if (netheriteItem == class_1802.field_22029) {
            return class_1802.field_8348;
        }
        if (netheriteItem == class_1802.field_22030) {
            return class_1802.field_8285;
        }
        return null;
    }

    @Unique
    private void applySmithingLore(class_1799 stack, class_3222 player) {
        if (stack.method_7960()) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.SMITHING);
        LoreManager.TierInfo tierInfo = LoreManager.getTierName(level);
        class_9290 currentLoreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
        ArrayList<class_5250> currentLore = new ArrayList<class_5250>(currentLoreComponent.comp_2400());
        class_5250 smithingLore = class_2561.method_43470((String)("Upgraded by " + player.method_5477().getString() + " (" + tierInfo.name() + " Smith)")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_36139(tierInfo.color()));
        currentLore.addFirst(smithingLore);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(currentLore));
    }
}

