/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    private boolean customLootEnabled = true;

    public void onLoad(String mixinPackage) {
        Path configDir = FabricLoader.getInstance().getConfigDir().resolve("simpleskills");
        Path configPath = configDir.resolve("config.json");
        if (Files.exists(configPath, new LinkOption[0])) {
            try (FileReader reader = new FileReader(configPath.toFile());){
                JsonObject features;
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                if (json.has("custom_fishing_loot_enabled")) {
                    this.customLootEnabled = json.get("custom_fishing_loot_enabled").getAsBoolean();
                } else if (json.has("features") && (features = json.getAsJsonObject("features")) != null && features.has("custom_fishing_loot_enabled")) {
                    this.customLootEnabled = features.get("custom_fishing_loot_enabled").getAsBoolean();
                }
                Simpleskills.LOGGER.info("Loaded custom_fishing_loot_enabled: {}", (Object)this.customLootEnabled);
            }
            catch (Exception e) {
                Simpleskills.LOGGER.error("Error reading config.json in mixin plugin: {}", (Object)e.getMessage());
            }
        } else {
            Simpleskills.LOGGER.warn("config.json not found; defaulting custom_fishing_loot_enabled to true");
        }
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.equals("com.github.ob_yekt.simpleskills.mixin.FISHING.FishingBobberLootMixin")) {
            return this.customLootEnabled;
        }
        return true;
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

