/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.commands;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.AttributeManager;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.DatabaseManager;
import com.github.ob_yekt.simpleskills.managers.IronmanManager;
import com.github.ob_yekt.simpleskills.managers.NamePrefixManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.ui.SkillTabMenu;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class SimpleskillsCommands {
    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"simpleskills").requires(source -> source.method_9259(0))).then(class_2170.method_9247((String)"togglehud").executes(context -> {
            SkillTabMenu.toggleTabMenuVisibility((class_2168)context.getSource());
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ironman").then(class_2170.method_9247((String)"enable").executes(SimpleskillsCommands::enableIronman))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"disable").requires(source -> source.method_9259(2))).executes(SimpleskillsCommands::disableIronman)))).then(class_2170.method_9247((String)"prestige").executes(SimpleskillsCommands::prestige))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(2))).executes(context -> {
            ConfigManager.initialize();
            XPManager.reloadConfig();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Configs reloaded."), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"username", (ArgumentType)StringArgumentType.string()).requires(source -> source.method_9259(2))).suggests((context, builder) -> class_2172.method_9265(SimpleskillsCommands.getOnlinePlayerNames((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(SimpleskillsCommands::resetSkillsForPlayer))).executes(SimpleskillsCommands::resetSkillsForPlayer))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"addxp").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"targets", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(SimpleskillsCommands.getOnlinePlayerNames((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"skill", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(SimpleskillsCommands.getValidSkills(), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(SimpleskillsCommands::addXP)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setlevel").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"targets", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(SimpleskillsCommands.getOnlinePlayerNames((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"skill", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(SimpleskillsCommands.getValidSkills(), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)XPManager.getMaxLevel())).executes(SimpleskillsCommands::setLevel)))))).then(class_2170.method_9247((String)"query").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(SimpleskillsCommands.getOnlinePlayerNames((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).then(class_2170.method_9247((String)"TOTAL").executes(SimpleskillsCommands::queryTotalLevel))).then(class_2170.method_9244((String)"skill", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(SimpleskillsCommands.getValidSkills(), (SuggestionsBuilder)builder)).executes(SimpleskillsCommands::querySkill))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"leaderboard").then(class_2170.method_9247((String)"TOTAL").executes(SimpleskillsCommands::showTotalLevelLeaderboard))).then(class_2170.method_9244((String)"skill", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(SimpleskillsCommands.getValidSkills(), (SuggestionsBuilder)builder)).executes(SimpleskillsCommands::showSkillLeaderboard)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"leaderboardironman").then(class_2170.method_9247((String)"TOTAL").executes(SimpleskillsCommands::showIronmanTotalLevelLeaderboard))).then(class_2170.method_9244((String)"skill", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(SimpleskillsCommands.getValidSkills(), (SuggestionsBuilder)builder)).executes(SimpleskillsCommands::showIronmanSkillLeaderboard)))));
    }

    private static int prestige(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f This command can only be used by players.").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        String playerUuid = player.method_5845();
        DatabaseManager db = DatabaseManager.getInstance();
        db.ensurePlayerInitialized(playerUuid);
        boolean allMaxed = db.getAllSkills(playerUuid).values().stream().allMatch(s -> s.level() >= XPManager.getMaxLevel());
        if (!allMaxed) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f You must reach level " + XPManager.getMaxLevel() + " in all skills to prestige.")), false);
            return 0;
        }
        db.incrementPrestige(playerUuid);
        db.resetPlayerSkills(playerUuid);
        AttributeManager.refreshAllAttributes(player);
        SkillTabMenu.updateTabMenu(player);
        NamePrefixManager.updatePlayerNameDecorations(player);
        int newPrestige = db.getPrestige(playerUuid);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f You prestiged to \u00a76\u2605" + newPrestige + "\u00a7f! Skills reset to 1.")), false);
        Simpleskills.LOGGER.info("Player {} prestiged to {}", (Object)player.method_5477().getString(), (Object)newPrestige);
        return 1;
    }

    private static int enableIronman(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f This command can only be used by players.").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        String playerUuid = player.method_5845();
        DatabaseManager db = DatabaseManager.getInstance();
        db.ensurePlayerInitialized(playerUuid);
        int totalLevels = db.getTotalSkillLevel(playerUuid);
        int expectedTotalLevels = Skills.values().length;
        if (totalLevels > expectedTotalLevels || DatabaseManager.getInstance().getPrestige(playerUuid) > 0) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f You must reset your skills using /simpleskills reset before enabling Ironman Mode.").method_27692(class_124.field_1061), false);
            Simpleskills.LOGGER.debug("Player {} attempted to enable Ironman Mode but has {} total levels (expected {}).", new Object[]{player.method_5477().getString(), totalLevels, expectedTotalLevels});
            return 0;
        }
        if (db.isPlayerInIronmanMode(playerUuid)) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f You have already enabled Ironman Mode.").method_27692(class_124.field_1061), false);
            return 0;
        }
        db.setIronmanMode(playerUuid, true);
        IronmanManager.applyIronmanMode(player);
        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f You have enabled Ironman Mode!").method_27692(class_124.field_1054), false);
        class_3218 world = player.method_51469();
        world.method_65096((class_2394)class_2398.field_11220, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 50, 0.5, 0.5, 0.5, 0.1);
        world.method_8396(null, player.method_24515(), class_3417.field_14865, class_3419.field_15248, 0.7f, 1.3f);
        Simpleskills.LOGGER.info("Player {} enabled Ironman Mode.", (Object)player.method_5477().getString());
        return 1;
    }

    private static int disableIronman(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f This command can only be used by players.").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        if (!DatabaseManager.getInstance().isPlayerInIronmanMode(player.method_5845())) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f You are not in Ironman Mode.").method_27692(class_124.field_1061), false);
            return 0;
        }
        IronmanManager.disableIronmanMode(player);
        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f You have disabled Ironman Mode.").method_27692(class_124.field_1054), false);
        Simpleskills.LOGGER.info("Player {} disabled Ironman Mode.", (Object)player.method_5477().getString());
        return 1;
    }

    private static int resetSkillsForPlayer(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String playerName = source.method_9228() instanceof class_3222 ? Objects.requireNonNull(source.method_44023()).method_7334().name() : StringArgumentType.getString(context, (String)"username");
        class_3222 targetPlayer = source.method_9211().method_3760().method_14566(playerName);
        if (targetPlayer == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Player '" + playerName + "' not found.")));
            return 0;
        }
        DatabaseManager db = DatabaseManager.getInstance();
        String playerUuid = targetPlayer.method_5845();
        db.resetPlayerSkills(playerUuid);
        db.setPrestige(playerUuid, 0);
        AttributeManager.refreshAllAttributes(targetPlayer);
        SkillTabMenu.updateTabMenu(targetPlayer);
        NamePrefixManager.updatePlayerNameDecorations(targetPlayer);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Reset skills and prestige for " + playerName + ".")), true);
        targetPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Your skills and prestige have been reset!"), false);
        Simpleskills.LOGGER.debug("Reset skills for player {}", (Object)playerName);
        return 1;
    }

    private static int addXP(CommandContext<class_2168> context) {
        Skills skill;
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"targets");
        String skillName = StringArgumentType.getString(context, (String)"skill");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        class_3222 targetPlayer = source.method_9211().method_3760().method_14566(playerName);
        if (targetPlayer == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Player '" + playerName + "' not found.")));
            return 0;
        }
        DatabaseManager db = DatabaseManager.getInstance();
        String playerUuid = targetPlayer.method_5845();
        db.ensurePlayerInitialized(playerUuid);
        try {
            skill = Skills.valueOf(skillName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Invalid skill '" + skillName + "'.")));
            return 0;
        }
        XPManager.addXPWithNotification(targetPlayer, skill, amount);
        AttributeManager.refreshAllAttributes(targetPlayer);
        SkillTabMenu.updateTabMenu(targetPlayer);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Added " + amount + " XP to " + playerName + "'s '" + skill.getDisplayName() + "'.")), true);
        targetPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f You gained " + amount + " XP in " + skill.getDisplayName() + "!")), false);
        Simpleskills.LOGGER.debug("Added {} XP to skill {} for player {}", new Object[]{amount, skill.getDisplayName(), playerName});
        return 1;
    }

    private static int setLevel(CommandContext<class_2168> context) {
        Skills skill;
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"targets");
        String skillName = StringArgumentType.getString(context, (String)"skill");
        int newLevel = IntegerArgumentType.getInteger(context, (String)"level");
        class_3222 targetPlayer = source.method_9211().method_3760().method_14566(playerName);
        if (targetPlayer == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Player '" + playerName + "' not found.")));
            return 0;
        }
        DatabaseManager db = DatabaseManager.getInstance();
        String playerUuid = targetPlayer.method_5845();
        db.ensurePlayerInitialized(playerUuid);
        try {
            skill = Skills.valueOf(skillName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Invalid skill '" + skillName + "'.")));
            return 0;
        }
        int newXP = XPManager.getExperienceForLevel(newLevel);
        db.savePlayerSkill(playerUuid, skill.getId(), newXP, newLevel);
        AttributeManager.refreshAllAttributes(targetPlayer);
        SkillTabMenu.updateTabMenu(targetPlayer);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Set " + playerName + "'s '" + skill.getDisplayName() + "' to level " + newLevel + ".")), true);
        targetPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Your skill '" + skill.getDisplayName() + "' is now level " + newLevel + "!")), false);
        Simpleskills.LOGGER.debug("Set skill {} to level {} for player {}", new Object[]{skill.getDisplayName(), newLevel, playerName});
        return 1;
    }

    private static int querySkill(CommandContext<class_2168> context) {
        Skills skill;
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"targets");
        String skillName = StringArgumentType.getString(context, (String)"skill");
        class_3222 targetPlayer = source.method_9211().method_3760().method_14566(playerName);
        if (targetPlayer == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Player '" + playerName + "' not found.")));
            return 0;
        }
        DatabaseManager db = DatabaseManager.getInstance();
        String playerUuid = targetPlayer.method_5845();
        db.ensurePlayerInitialized(playerUuid);
        try {
            skill = Skills.valueOf(skillName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Invalid skill '" + skillName + "'.")));
            return 0;
        }
        int level = XPManager.getSkillLevel(playerUuid, skill);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f " + playerName + "'s '" + skill.getDisplayName() + "' level: " + level)), false);
        Simpleskills.LOGGER.debug("Queried skill {} for player {}: level {}", new Object[]{skill.getDisplayName(), playerName, level});
        return 1;
    }

    private static int queryTotalLevel(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"targets");
        class_3222 targetPlayer = source.method_9211().method_3760().method_14566(playerName);
        if (targetPlayer == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Player '" + playerName + "' not found.")));
            return 0;
        }
        DatabaseManager db = DatabaseManager.getInstance();
        String playerUuid = targetPlayer.method_5845();
        db.ensurePlayerInitialized(playerUuid);
        int totalLevel = db.getTotalSkillLevel(playerUuid);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f " + playerName + "'s total skill level: " + totalLevel)), false);
        Simpleskills.LOGGER.debug("Queried total level for player {}: {}", (Object)playerName, (Object)totalLevel);
        return 1;
    }

    private static int showSkillLeaderboard(CommandContext<class_2168> context) {
        Skills skill;
        class_2168 source = (class_2168)context.getSource();
        String skillName = StringArgumentType.getString(context, (String)"skill");
        try {
            skill = Skills.valueOf(skillName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Invalid skill '" + skillName + "'.")));
            return 0;
        }
        DatabaseManager db = DatabaseManager.getInstance();
        List<DatabaseManager.LeaderboardEntry> leaderboard = db.getSkillLeaderboard(skill.getId(), 5);
        StringBuilder message = new StringBuilder();
        message.append("\u00a76[simpleskills]\u00a7f Top 5 - ").append(skill.getDisplayName()).append(" Leaderboard\n");
        message.append("\u00a78\u00a7m---------------------------------------\n");
        for (int i = 0; i < leaderboard.size(); ++i) {
            DatabaseManager.LeaderboardEntry entry = leaderboard.get(i);
            boolean isIronman = db.isPlayerInIronmanMode(entry.playerUuid());
            String star = entry.prestige() > 0 ? "\u00a76\u2605" + entry.prestige() + " \u00a7f" : "";
            String namePrefix = (isIronman ? "\u00a7c\u00a7l\u2620 \u00a7f" : "\u00a7f") + star;
            message.append(String.format("\u00a7e%d. %s%s - Level \u00a7b%d \u00a77[\u00a7f%,d XP\u00a77]\n", i + 1, namePrefix, entry.playerName(), entry.level(), entry.xp()));
        }
        if (leaderboard.isEmpty()) {
            message.append("\u00a77No players found for this skill.\n");
        }
        message.append("\u00a78\u00a7m---------------------------------------");
        source.method_9226(() -> class_2561.method_43470((String)message.toString()), false);
        Simpleskills.LOGGER.debug("Displayed leaderboard for skill {}", (Object)skill.getDisplayName());
        return 1;
    }

    private static int showTotalLevelLeaderboard(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        DatabaseManager db = DatabaseManager.getInstance();
        List<DatabaseManager.LeaderboardEntry> leaderboard = db.getTotalLevelLeaderboard(5);
        StringBuilder message = new StringBuilder();
        message.append("\u00a76[simpleskills]\u00a7f Top 5 - Total Level Leaderboard\n");
        message.append("\u00a78\u00a7m---------------------------------------\n");
        for (int i = 0; i < leaderboard.size(); ++i) {
            DatabaseManager.LeaderboardEntry entry = leaderboard.get(i);
            boolean isIronman = db.isPlayerInIronmanMode(entry.playerUuid());
            String star = entry.prestige() > 0 ? "\u00a76\u2605" + entry.prestige() + " \u00a7f" : "";
            String namePrefix = (isIronman ? "\u00a7c\u00a7l\u2620 \u00a7f" : "\u00a7f") + star;
            message.append(String.format("\u00a7e%d. %s%s - Total Level \u00a7b%d\n", i + 1, namePrefix, entry.playerName(), entry.level()));
        }
        if (leaderboard.isEmpty()) {
            message.append("\u00a77No players found.\n");
        }
        message.append("\u00a78\u00a7m---------------------------------------");
        source.method_9226(() -> class_2561.method_43470((String)message.toString()), false);
        Simpleskills.LOGGER.debug("Displayed total level leaderboard");
        return 1;
    }

    private static int showIronmanSkillLeaderboard(CommandContext<class_2168> context) {
        Skills skill;
        class_2168 source = (class_2168)context.getSource();
        String skillName = StringArgumentType.getString(context, (String)"skill");
        try {
            skill = Skills.valueOf(skillName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a76[simpleskills]\u00a7f Invalid skill '" + skillName + "'.")));
            return 0;
        }
        DatabaseManager db = DatabaseManager.getInstance();
        List<DatabaseManager.LeaderboardEntry> leaderboard = db.getIronmanSkillLeaderboard(skill.getId(), 5);
        StringBuilder message = new StringBuilder();
        message.append("\u00a76[simpleskills]\u00a7f Top 5 - Ironman ").append(skill.getDisplayName()).append(" Leaderboard\n");
        message.append("\u00a78\u00a7m---------------------------------------\n");
        for (int i = 0; i < leaderboard.size(); ++i) {
            DatabaseManager.LeaderboardEntry entry = leaderboard.get(i);
            String star = entry.prestige() > 0 ? "\u00a76\u2605" + entry.prestige() + " \u00a7f" : "";
            message.append(String.format("\u00a7e%d. \u00a7c\u00a7l\u2620 \u00a7f%s%s - Level \u00a7b%d \u00a77[\u00a7f%,d XP\u00a77]\n", i + 1, star, entry.playerName(), entry.level(), entry.xp()));
        }
        if (leaderboard.isEmpty()) {
            message.append("\u00a77No Ironman players found for this skill.\n");
        }
        message.append("\u00a78\u00a7m---------------------------------------");
        source.method_9226(() -> class_2561.method_43470((String)message.toString()), false);
        Simpleskills.LOGGER.debug("Displayed Ironman leaderboard for skill {}", (Object)skill.getDisplayName());
        return 1;
    }

    private static int showIronmanTotalLevelLeaderboard(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        DatabaseManager db = DatabaseManager.getInstance();
        List<DatabaseManager.LeaderboardEntry> leaderboard = db.getIronmanTotalLevelLeaderboard(5);
        StringBuilder message = new StringBuilder();
        message.append("\u00a76[simpleskills]\u00a7f Top 5 - Ironman Total Level Leaderboard\n");
        message.append("\u00a78\u00a7m---------------------------------------\n");
        for (int i = 0; i < leaderboard.size(); ++i) {
            DatabaseManager.LeaderboardEntry entry = leaderboard.get(i);
            String star = entry.prestige() > 0 ? "\u00a76\u2605" + entry.prestige() + " \u00a7f" : "";
            message.append(String.format("\u00a7e%d. \u00a7c\u00a7l\u2620 \u00a7f%s%s - Total Level \u00a7b%d\n", i + 1, star, entry.playerName(), entry.level()));
        }
        if (leaderboard.isEmpty()) {
            message.append("\u00a77No Ironman players found.\n");
        }
        message.append("\u00a78\u00a7m---------------------------------------");
        source.method_9226(() -> class_2561.method_43470((String)message.toString()), false);
        Simpleskills.LOGGER.debug("Displayed Ironman total level leaderboard");
        return 1;
    }

    private static List<String> getOnlinePlayerNames(CommandContext<class_2168> context) {
        return ((class_2168)context.getSource()).method_9211().method_3760().method_14571().stream().map(player -> player.method_7334().name()).collect(Collectors.toList());
    }

    private static List<String> getValidSkills() {
        return Stream.of(Skills.values()).map(Skills::getId).toList();
    }
}

