/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.managers;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.AttributeManager;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.DatabaseManager;
import com.github.ob_yekt.simpleskills.ui.SkillTabMenu;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_124;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class XPManager {
    private static final int MAX_LEVEL = 99;
    private static BiConsumer<class_3222, Skills> onXPChangeListener;
    private static double STANDARD_XP_MULTIPLIER;
    private static double IRONMAN_XP_MULTIPLIER;
    private static boolean XP_NOTIFICATIONS_ENABLED;
    private static int XP_NOTIFICATION_THRESHOLD;
    private static boolean LEVEL_UP_EFFECTS_ENABLED;
    private static boolean LEVEL_UP_NOTIFICATIONS_ENABLED;
    private static final double EXPONENT_P = 2.45;
    private static final double SCALING_A = 300.0;
    private static final double FLOOR_B = 500.0;

    public static int getMaxLevel() {
        return 99;
    }

    public static void setOnXPChangeListener(BiConsumer<class_3222, Skills> listener) {
        onXPChangeListener = listener;
    }

    public static int getSkillLevel(String playerUuid, Skills skill) {
        if (playerUuid == null || skill == null) {
            Simpleskills.LOGGER.error("Invalid input for getSkillLevel: playerUuid or skill is null");
            return 1;
        }
        DatabaseManager db = DatabaseManager.getInstance();
        Map<String, DatabaseManager.SkillData> skills = db.getAllSkills(playerUuid);
        DatabaseManager.SkillData skillData = skills.get(skill.getId());
        if (skillData != null) {
            return skillData.level();
        }
        return 1;
    }

    public static int getExperienceForLevel(int level) {
        if (level <= 1) {
            return 0;
        }
        double L = level - 1;
        return (int)Math.floor(300.0 * Math.pow(L, 2.45) + 500.0 * L);
    }

    public static int getLevelForExperience(int experience) {
        if (experience <= 0) {
            return 1;
        }
        int low = 1;
        int high = 99;
        while (low < high) {
            int mid = low + high + 1 >>> 1;
            int xpForMid = XPManager.getExperienceForLevel(mid);
            if (xpForMid <= experience) {
                low = mid;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    public static void addXPSilent(class_3222 player, Skills skill, int xpToAdd) {
        XPManager.updatePlayerSkill(player, skill, xpToAdd, false, false);
    }

    public static void addXPWithNotification(class_3222 player, Skills skill, int xpToAdd) {
        XPManager.updatePlayerSkill(player, skill, xpToAdd, true, true);
    }

    private static void updatePlayerSkill(class_3222 player, Skills skill, int xpToAdd, boolean notifyXP, boolean notifyLevelUp) {
        if (player == null || skill == null) {
            Simpleskills.LOGGER.error("Invalid input: player or skill is null");
            return;
        }
        if (xpToAdd <= 0) {
            Simpleskills.LOGGER.warn("Invalid xpToAdd: {} for player UUID: {}, skill: {}", new Object[]{xpToAdd, player.method_5845(), skill.getId()});
            return;
        }
        String playerUuid = player.method_5845();
        DatabaseManager db = DatabaseManager.getInstance();
        double multiplier = db.isPlayerInIronmanMode(playerUuid) ? IRONMAN_XP_MULTIPLIER : STANDARD_XP_MULTIPLIER;
        xpToAdd = (int)((double)xpToAdd * multiplier);
        db.ensurePlayerInitialized(playerUuid);
        Map<String, DatabaseManager.SkillData> skills = db.getAllSkills(playerUuid);
        DatabaseManager.SkillData skillData = skills.getOrDefault(skill.getId(), new DatabaseManager.SkillData(0, 0));
        int currentXP = skillData.xp();
        int currentLevel = skillData.level();
        int newXP = currentXP + xpToAdd;
        int newLevel = XPManager.getLevelForExperience(newXP);
        try {
            db.savePlayerSkill(playerUuid, skill.getId(), newXP, newLevel);
        }
        catch (Exception e) {
            Simpleskills.LOGGER.error("Failed to save player skill data for UUID: {}, skill: {}", new Object[]{playerUuid, skill.getId(), e});
            return;
        }
        if (notifyXP && XP_NOTIFICATIONS_ENABLED && xpToAdd >= XP_NOTIFICATION_THRESHOLD) {
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("Gained %d XP in %s!", xpToAdd, skill.getDisplayName())).method_27692(class_124.field_1065), true);
        }
        if (notifyLevelUp && newLevel > currentLevel) {
            XPManager.triggerLevelUpEffects(player, skill, newLevel);
        }
        AttributeManager.updatePlayerAttributes(player, skill, new DatabaseManager.SkillData(newXP, newLevel));
        SkillTabMenu.updateTabMenu(player);
        if (onXPChangeListener != null) {
            onXPChangeListener.accept(player, skill);
        }
    }

    private static void triggerLevelUpEffects(class_3222 player, Skills skill, int newLevel) {
        boolean isMaxLevel;
        class_3218 serverWorld = player.method_51469();
        boolean bl = isMaxLevel = newLevel == 99;
        if (isMaxLevel) {
            String levelUpMessage = String.format("Congratulations! You have reached max level in %s!", skill.getDisplayName());
            if (LEVEL_UP_NOTIFICATIONS_ENABLED) {
                player.method_7353((class_2561)class_2561.method_43470((String)levelUpMessage).method_27692(class_124.field_1065), false);
            }
            if (LEVEL_UP_EFFECTS_ENABLED) {
                serverWorld.method_8396(null, player.method_24515(), class_3417.field_15195, class_3419.field_15248, 0.9f, 1.2f);
            }
        } else {
            String levelUpMessage = String.format("You leveled up in %s! New level: %d", skill.getDisplayName(), newLevel);
            if (LEVEL_UP_NOTIFICATIONS_ENABLED) {
                player.method_7353((class_2561)class_2561.method_43470((String)levelUpMessage).method_27692(class_124.field_1065), false);
            }
            if (LEVEL_UP_EFFECTS_ENABLED) {
                serverWorld.method_8396(null, player.method_24515(), class_3417.field_14709, class_3419.field_15248, 0.7f, 1.3f);
            }
        }
        if (LEVEL_UP_EFFECTS_ENABLED) {
            XPManager.spawnConfettiParticles(serverWorld, player.method_23317(), player.method_23318(), player.method_23321(), isMaxLevel);
        }
    }

    private static void spawnConfettiParticles(class_3218 serverWorld, double x, double y, double z, boolean isMaxLevel) {
        class_2394[] particles = new class_2394[]{class_2398.field_11211, class_2398.field_11208, class_2398.field_11248, class_2398.field_11205};
        int count = isMaxLevel ? 200 : 75;
        double spread = isMaxLevel ? 2.0 : 1.0;
        for (class_2394 particle : particles) {
            serverWorld.method_65096(particle, x, y + 1.5, z, count / particles.length, spread, spread, spread, 0.05);
        }
        if (isMaxLevel) {
            serverWorld.method_65096((class_2394)class_2398.field_11248, x, y + 1.5, z, 50, 1.5, 1.5, 1.5, 0.1);
        }
    }

    public static void reloadConfig() {
        JsonObject config = ConfigManager.getFeatureConfig();
        STANDARD_XP_MULTIPLIER = XPManager.getConfigDouble(config, "standard_xp_multiplier", 1.0);
        IRONMAN_XP_MULTIPLIER = XPManager.getConfigDouble(config, "ironman_xp_multiplier", 0.2);
        XP_NOTIFICATIONS_ENABLED = XPManager.getConfigBoolean(config, "xp_notifications_enabled", true);
        XP_NOTIFICATION_THRESHOLD = XPManager.getConfigInt(config, "xp_notification_threshold", 10);
        LEVEL_UP_EFFECTS_ENABLED = XPManager.getConfigBoolean(config, "level_up_effects_enabled", true);
        LEVEL_UP_NOTIFICATIONS_ENABLED = XPManager.getConfigBoolean(config, "level_up_notifications_enabled", true);
        Simpleskills.LOGGER.info("Reloaded XPManager config values.");
    }

    private static double getConfigDouble(JsonObject config, String key, double defaultValue) {
        if (config.has(key) && config.get(key).isJsonPrimitive() && config.getAsJsonPrimitive(key).isNumber()) {
            return config.get(key).getAsDouble();
        }
        Simpleskills.LOGGER.warn("Invalid or missing config key '{}', using default: {}", (Object)key, (Object)defaultValue);
        return defaultValue;
    }

    private static int getConfigInt(JsonObject config, String key, int defaultValue) {
        if (config.has(key) && config.get(key).isJsonPrimitive() && config.getAsJsonPrimitive(key).isNumber()) {
            return config.get(key).getAsInt();
        }
        Simpleskills.LOGGER.warn("Invalid or missing config key '{}', using default: {}", (Object)key, (Object)defaultValue);
        return defaultValue;
    }

    private static boolean getConfigBoolean(JsonObject config, String key, boolean defaultValue) {
        if (config.has(key) && config.get(key).isJsonPrimitive() && config.getAsJsonPrimitive(key).isBoolean()) {
            return config.get(key).getAsBoolean();
        }
        Simpleskills.LOGGER.warn("Invalid or missing config key '{}', using default: {}", (Object)key, (Object)defaultValue);
        return defaultValue;
    }

    static {
        JsonObject config = ConfigManager.getFeatureConfig();
        STANDARD_XP_MULTIPLIER = XPManager.getConfigDouble(config, "standard_xp_multiplier", 1.0);
        IRONMAN_XP_MULTIPLIER = XPManager.getConfigDouble(config, "ironman_xp_multiplier", 0.2);
        XP_NOTIFICATIONS_ENABLED = XPManager.getConfigBoolean(config, "xp_notifications_enabled", true);
        XP_NOTIFICATION_THRESHOLD = XPManager.getConfigInt(config, "xp_notification_threshold", 10);
        LEVEL_UP_EFFECTS_ENABLED = XPManager.getConfigBoolean(config, "level_up_effects_enabled", true);
        LEVEL_UP_NOTIFICATIONS_ENABLED = XPManager.getConfigBoolean(config, "level_up_notifications_enabled", true);
    }
}

