/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.DatabaseManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class SkillHudRenderer
implements HudElement {
    private static final class_2960 HUD_ID = class_2960.method_60655((String)"simpleskills", (String)"skill_hud");
    private static final Map<UUID, Boolean> playerHudVisibility = new HashMap<UUID, Boolean>();
    private static final int MAX_SKILL_NAME_LENGTH = SkillHudRenderer.getMaxSkillNameLength();
    private static final int PANEL_WIDTH = 275;
    private static final int PANEL_HEIGHT = 220;
    private static final int PADDING = 5;
    private static final int LINE_HEIGHT = 10;
    private static final int BACKGROUND_COLOR = Integer.MIN_VALUE;
    private static final int BORDER_COLOR = -10496;
    private static final int TEXT_COLOR = -1;
    private static final int HEADER_COLOR = -48060;
    private static final int LEVEL_COLOR = -11141121;
    private static final int XP_COLOR = -7798904;
    private static final int PROGRESS_FILLED_COLOR = -11141291;
    private static final int PROGRESS_EMPTY_COLOR = -11184811;

    public static void register() {
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.BOSS_BAR, (class_2960)HUD_ID, (HudElement)new SkillHudRenderer());
    }

    private static int getMaxSkillNameLength() {
        int maxLength = 0;
        for (Skills skill : Skills.values()) {
            maxLength = Math.max(maxLength, skill.getDisplayName().length());
        }
        return maxLength;
    }

    public static void toggleHudVisibility() {
        UUID playerUuid;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        boolean isVisible = playerHudVisibility.getOrDefault(playerUuid = client.field_1724.method_5667(), DatabaseManager.getInstance().isTabMenuVisible(playerUuid.toString()));
        playerHudVisibility.put(playerUuid, !isVisible);
        DatabaseManager.getInstance().setTabMenuVisibility(playerUuid.toString(), !isVisible);
        if (!isVisible) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Skill HUD enabled."), false);
        } else {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Skill HUD disabled."), false);
        }
    }

    private boolean shouldRenderHud() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return false;
        }
        boolean isSingleplayer = client.method_1496();
        if (!isSingleplayer) {
            return false;
        }
        UUID playerUuid = client.field_1724.method_5667();
        return playerHudVisibility.getOrDefault(playerUuid, DatabaseManager.getInstance().isTabMenuVisible(playerUuid.toString()));
    }

    public void render(class_332 context, class_9779 tickCounter) {
        if (!this.shouldRenderHud()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        int x = 10;
        int y = 10;
        try {
            this.renderSkillPanel(context, x, y, client.field_1724.method_5667());
        }
        catch (Exception e) {
            Simpleskills.LOGGER.error("Failed to render skill HUD: {}", (Object)e.getMessage());
        }
    }

    private void renderSkillPanel(class_332 context, int x, int y, UUID playerUuid) {
        DatabaseManager db = DatabaseManager.getInstance();
        String playerUuidStr = playerUuid.toString();
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (db.getAllSkills(playerUuidStr).isEmpty()) {
            db.initializePlayer(playerUuidStr);
        }
        context.method_25294(x, y, x + 275, y + 220, Integer.MIN_VALUE);
        context.method_51738(x, x + 275 - 1, y, -10496);
        context.method_51738(x, x + 275 - 1, y + 220 - 1, -10496);
        context.method_51742(x, y, y + 220 - 1, -10496);
        context.method_51742(x + 275 - 1, y, y + 220 - 1, -10496);
        int currentY = y + 5;
        String headerText = "\u2694 Skills \u2694";
        int headerX = x + (275 - textRenderer.method_1727(headerText)) / 2;
        context.method_51433(textRenderer, headerText, headerX, currentY, -48060, true);
        currentY += 13;
        boolean isIronman = db.isPlayerInIronmanMode(playerUuidStr);
        if (isIronman) {
            String ironmanText = "Ironman Mode Enabled";
            context.method_51433(textRenderer, ironmanText, x + 5, currentY, -48060, false);
            currentY += 12;
        }
        context.method_51738(x + 5, x + 275 - 5, currentY, -10066330);
        currentY += 5;
        Map<String, DatabaseManager.SkillData> skills = db.getAllSkills(playerUuidStr);
        int totalLevels = skills.values().stream().mapToInt(DatabaseManager.SkillData::level).sum();
        for (Skills skillEnum : Skills.values()) {
            String skillName = skillEnum.getId();
            DatabaseManager.SkillData skill = skills.get(skillName);
            if (skill == null) {
                skill = new DatabaseManager.SkillData(0, 1);
            }
            currentY = this.renderSkillLine(context, x + 5, currentY, skill, skillEnum.getDisplayName());
            ++currentY;
        }
        context.method_51738(x + 5, x + 275 - 5, currentY += 3, -10066330);
        String totalText = String.format("Total: %d", totalLevels);
        context.method_51433(textRenderer, totalText, x + 5, currentY += 5, -11141121, true);
    }

    private int renderSkillLine(class_332 context, int x, int y, DatabaseManager.SkillData skill, String skillDisplayName) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (skill.level() == XPManager.getMaxLevel()) {
            String skillText = String.format("\u2605 %-" + MAX_SKILL_NAME_LENGTH + "s Lvl 99", skillDisplayName);
            String xpText = String.format("XP: %,d", skill.xp());
            context.method_51433(textRenderer, skillText, x, y, -10496, false);
            context.method_51433(textRenderer, xpText, x + 120, y, -1, false);
            return y + 10;
        }
        int XPForCurrentLevel = XPManager.getExperienceForLevel(skill.level());
        int XPToNextLevel = XPManager.getExperienceForLevel(skill.level() + 1) - XPForCurrentLevel;
        int progressToNextLevel = skill.xp() - XPForCurrentLevel;
        String skillText = String.format("%-" + MAX_SKILL_NAME_LENGTH + "s Lvl %d", skillDisplayName, skill.level());
        context.method_51433(textRenderer, skillText, x, y, -1, false);
        int barX = x + 120;
        int barY = y + 2;
        int barWidth = 60;
        int barHeight = 6;
        this.renderProgressBar(context, barX, barY, barWidth, barHeight, progressToNextLevel, XPToNextLevel);
        String xpText = String.format("%,d/%,d", progressToNextLevel, XPToNextLevel);
        int xpTextX = barX + barWidth + 5;
        context.method_51433(textRenderer, xpText, xpTextX, y, -7798904, false);
        return y + 10;
    }

    private void renderProgressBar(class_332 context, int x, int y, int width, int height, int progress, int total) {
        if (total <= 0) {
            total = 1;
        }
        progress = Math.max(0, Math.min(progress, total));
        context.method_25294(x, y, x + width, y + height, -11184811);
        int filledWidth = (int)((double)progress / (double)total * (double)width);
        if (filledWidth > 0) {
            context.method_25294(x, y, x + filledWidth, y + height, -11141291);
        }
        context.method_51738(x, x + width - 1, y, -7829368);
        context.method_51738(x, x + width - 1, y + height - 1, -7829368);
        context.method_51742(x, y, y + height - 1, -7829368);
        context.method_51742(x + width - 1, y, y + height - 1, -7829368);
    }

    public static void clearPlayerVisibility(UUID playerUuid) {
        playerHudVisibility.remove(playerUuid);
        Simpleskills.LOGGER.debug("Cleared HUD visibility for player UUID: {}", (Object)playerUuid);
    }
}

