/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.CRAFTING;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.LoreManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1734;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1734.class})
public abstract class CraftingResultSlotMixin {
    @Shadow
    @Final
    private class_1657 field_7868;
    @Shadow
    @Final
    private class_8566 field_7870;
    @Unique
    private final class_1799[] originalInputs = new class_1799[9];

    @Inject(method={"onTakeItem"}, at={@At(value="HEAD")})
    private void onTakeItemHead(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (stack.method_7960() || class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().equals("minecraft:air")) {
                Simpleskills.LOGGER.debug("Skipping onTakeItem for empty or air stack: {}", (Object)stack);
                return;
            }
            for (int i = 0; i < 9; ++i) {
                this.originalInputs[i] = this.field_7870.method_5438(i).method_7972();
            }
            this.grantCraftingXP(serverPlayer, stack);
            this.applyCraftingLore(stack, serverPlayer);
            this.applyCraftingScaling(stack, serverPlayer);
        }
    }

    @Inject(method={"onTakeItem"}, at={@At(value="TAIL")})
    private void onTakeItemTail(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (stack.method_7960() || class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().equals("minecraft:air")) {
                Simpleskills.LOGGER.debug("Skipping material recovery for empty or air stack: {}", (Object)stack);
                return;
            }
            this.applyMaterialRecovery(serverPlayer, stack);
        }
    }

    @Unique
    private void grantCraftingXP(class_3222 player, class_1799 stack) {
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            return;
        }
        String itemKey = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        int xpPerItem = ConfigManager.getCraftingXP(itemKey, Skills.CRAFTING);
        if (xpPerItem <= 0) {
            return;
        }
        int totalXP = xpPerItem * stack.method_7947();
        XPManager.addXPWithNotification(player, Skills.CRAFTING, totalXP);
        Simpleskills.LOGGER.debug("Granted {} Crafting XP for {}x {} to player {}", new Object[]{totalXP, stack.method_7947(), itemKey, player.method_5477().getString()});
    }

    @Unique
    private void applyCraftingLore(class_1799 stack, class_3222 player) {
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.CRAFTING);
        LoreManager.TierInfo tierInfo = LoreManager.getTierName(level);
        class_9290 currentLoreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
        ArrayList<class_5250> currentLore = new ArrayList<class_5250>(currentLoreComponent.comp_2400());
        class_5250 craftingLore = class_2561.method_43470((String)("Crafted by " + player.method_5477().getString() + " (" + tierInfo.name() + " Crafter)")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_36139(tierInfo.color()));
        currentLore.addFirst(craftingLore);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(currentLore));
    }

    @Unique
    private void applyCraftingScaling(class_1799 stack, class_3222 player) {
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.CRAFTING);
        float multiplier = this.getDurabilityMultiplier(level);
        Integer original = (Integer)stack.method_58694(class_9334.field_50072);
        if (original == null) {
            return;
        }
        int newMax = Math.max(1, Math.round((float)original.intValue() * multiplier));
        stack.method_57379(class_9334.field_50072, (Object)newMax);
        Simpleskills.LOGGER.debug("Scaled durability for {} from {} -> {} for player {} (lvl {}, multiplier {})", new Object[]{class_7923.field_41178.method_10221((Object)stack.method_7909()).toString(), original, newMax, player.method_5477().getString(), level, Float.valueOf(multiplier)});
    }

    @Unique
    private void applyMaterialRecovery(class_3222 player, class_1799 outputStack) {
        String itemId = class_7923.field_41178.method_10221((Object)outputStack.method_7909()).toString();
        Simpleskills.LOGGER.info("=== MATERIAL RECOVERY DEBUG (Regular Click) ===");
        Simpleskills.LOGGER.info("Player: {}", (Object)player.method_5477().getString());
        Simpleskills.LOGGER.info("Output item: {}", (Object)itemId);
        Simpleskills.LOGGER.info("Is blacklisted: {}", (Object)ConfigManager.isRecipeBlacklisted(itemId));
        if (ConfigManager.isRecipeBlacklisted(itemId)) {
            Simpleskills.LOGGER.info("Skipping material recovery for blacklisted item: {}", (Object)itemId);
            return;
        }
        Simpleskills.LOGGER.info("Proceeding with recovery check for: {}", (Object)itemId);
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.CRAFTING);
        float recoveryChance = this.getRecoveryChance(level);
        Simpleskills.LOGGER.info("Recovery chance: {} for level {}", (Object)Float.valueOf(recoveryChance), (Object)level);
        if (recoveryChance <= 0.0f) {
            Simpleskills.LOGGER.info("No recovery possible (chance <= 0)");
            return;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 original = this.originalInputs[i];
            class_1799 current = this.field_7870.method_5438(i);
            Simpleskills.LOGGER.info("Slot {}: Original count: {}, Current count: {}", new Object[]{i, original.method_7947(), current.method_7947()});
            if (original.method_7960() || current.method_7947() >= original.method_7947() || !(player.method_59922().method_43057() < recoveryChance)) continue;
            class_1799 recovered = original.method_7972();
            recovered.method_7939(1);
            if (!player.method_31548().method_7394(recovered)) {
                player.method_7328(recovered, false);
            }
            Simpleskills.LOGGER.info("Recovered {} for player {} (lvl {}, chance {})", new Object[]{recovered.method_7909().method_7876(), player.method_5477().getString(), level, Float.valueOf(recoveryChance)});
        }
    }

    @Unique
    private float getDurabilityMultiplier(int level) {
        return ConfigManager.getCraftingDurabilityMultiplier(level);
    }

    @Unique
    private float getRecoveryChance(int level) {
        return ConfigManager.getCraftingRecoveryChance(level);
    }
}

