/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.FURNACES;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.LoreManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1720;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1720.class})
public abstract class AbstractFurnaceScreenHandlerMixin {
    @Inject(method={"quickMove"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/AbstractFurnaceScreenHandler;insertItem(Lnet/minecraft/item/ItemStack;IIZ)Z", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onQuickMoveBeforeInsert(class_1657 player, int slotIndex, CallbackInfoReturnable<class_1799> cir, @Local(ordinal=0) class_1799 itemStack, @Local class_1735 slot, @Local(ordinal=1) class_1799 itemStack2) {
        if (slotIndex == 2 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (itemStack2.method_7960() || class_7923.field_41178.method_10221((Object)itemStack2.method_7909()).toString().equals("minecraft:air")) {
                Simpleskills.LOGGER.debug("Skipping onQuickMoveBeforeInsert for empty or air stack: {}", (Object)itemStack2);
                return;
            }
            if (this.isCookableFoodItem(itemStack2)) {
                this.applyCookingLore(itemStack2, serverPlayer);
                this.applyCookingScaling(itemStack2, serverPlayer);
            }
        }
    }

    @Inject(method={"quickMove"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/slot/Slot;onQuickTransfer(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onQuickMoveAfterTransfer(class_1657 player, int slotIndex, CallbackInfoReturnable<class_1799> cir, @Local(ordinal=0) class_1799 itemStack, @Local class_1735 slot, @Local(ordinal=1) class_1799 itemStack2) {
        if (slotIndex == 2 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (itemStack.method_7960() || class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString().equals("minecraft:air")) {
                Simpleskills.LOGGER.debug("Skipping onQuickMoveAfterTransfer for empty or air stack: {}", (Object)itemStack);
                return;
            }
            int movedCount = itemStack.method_7947() - (itemStack2.method_7960() ? 0 : itemStack2.method_7947());
            if (movedCount > 0) {
                class_1799 movedStack = itemStack.method_7972();
                movedStack.method_7939(movedCount);
                this.grantCookingXP(serverPlayer, movedStack);
                this.grantCraftingXP(serverPlayer, movedStack);
            }
        }
    }

    @Unique
    private boolean isCookableFoodItem(class_1799 stack) {
        String itemKey = stack.method_7909().method_7876();
        return ConfigManager.getCookingXP(itemKey, Skills.COOKING) > 0 && stack.method_58694(class_9334.field_50075) != null;
    }

    @Unique
    private void grantCookingXP(class_3222 player, class_1799 stack) {
        if (stack.method_7960() || class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().equals("minecraft:air")) {
            return;
        }
        String itemKey = stack.method_7909().method_7876();
        int xpPerItem = ConfigManager.getCookingXP(itemKey, Skills.COOKING);
        if (xpPerItem <= 0) {
            return;
        }
        int totalXP = xpPerItem * stack.method_7947();
        XPManager.addXPWithNotification(player, Skills.COOKING, totalXP);
        Simpleskills.LOGGER.debug("Granted {} Cooking XP for {}x {} to player {}", new Object[]{totalXP, stack.method_7947(), itemKey, player.method_5477().getString()});
    }

    @Unique
    private void grantCraftingXP(class_3222 player, class_1799 stack) {
        if (stack.method_7960() || class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().equals("minecraft:air")) {
            return;
        }
        String itemKey = stack.method_7909().method_7876();
        int xpPerItem = ConfigManager.getSmeltingCraftingXP(itemKey, Skills.CRAFTING);
        if (xpPerItem <= 0) {
            return;
        }
        int totalXP = xpPerItem * stack.method_7947();
        XPManager.addXPWithNotification(player, Skills.CRAFTING, totalXP);
        Simpleskills.LOGGER.debug("Granted {} Crafting XP for {}x {} to player {}", new Object[]{totalXP, stack.method_7947(), itemKey, player.method_5477().getString()});
    }

    @Unique
    private void applyCookingLore(class_1799 stack, class_3222 player) {
        if (stack.method_7960() || class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().equals("minecraft:air")) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.COOKING);
        LoreManager.TierInfo tierInfo = LoreManager.getTierName(level);
        class_9290 currentLoreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
        ArrayList<class_5250> currentLore = new ArrayList<class_5250>(currentLoreComponent.comp_2400());
        class_5250 cookingLore = class_2561.method_43470((String)("Cooked by " + player.method_5477().getString() + " (" + tierInfo.name() + " Cook)")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_36139(tierInfo.color()));
        currentLore.addFirst(cookingLore);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(currentLore));
    }

    @Unique
    private void applyCookingScaling(class_1799 stack, class_3222 player) {
        if (stack.method_7960() || class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().equals("minecraft:air")) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.COOKING);
        float multiplier = ConfigManager.getCookingMultiplier(level);
        class_4174 original = (class_4174)stack.method_58694(class_9334.field_50075);
        if (original == null) {
            return;
        }
        int newHunger = Math.max(1, Math.round((float)original.comp_2491() * multiplier));
        float newSaturation = original.comp_2492() * multiplier;
        class_4174 scaledFood = new class_4174.class_4175().method_19238(newHunger).method_19237(newSaturation).method_19242();
        stack.method_57379(class_9334.field_50075, (Object)scaledFood);
        Simpleskills.LOGGER.debug("Scaled food {} -> hunger {} sat {} for player {} (lvl {}, multiplier {})", new Object[]{stack.method_7909().method_7876(), newHunger, Float.valueOf(newSaturation), player.method_5477().getString(), level, Float.valueOf(multiplier)});
    }
}

