/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.requirements.SkillRequirement;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1794.class})
public class HoeItemMixin {
    @Unique
    private String lastBlockKey;

    @Inject(method={"useOnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkToolAndSkillRequirement(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        int playerLevel;
        class_1657 class_16572;
        class_1937 world = context.method_8045();
        if (world.method_8608() || !((class_16572 = context.method_8036()) instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_16572;
        String toolName = context.method_8041().method_7909().toString();
        SkillRequirement requirement = ConfigManager.getToolRequirement(toolName);
        if (requirement != null && requirement.getSkill() == Skills.FARMING && (playerLevel = XPManager.getSkillLevel(player.method_5845(), Skills.FARMING)) < requirement.getLevel()) {
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a76[simpleskills]\u00a7f You need %s level %d to use this tool!", Skills.FARMING.getDisplayName(), requirement.getLevel())), true);
            cir.setReturnValue((Object)class_1269.field_5814);
            cir.cancel();
            Simpleskills.LOGGER.debug("Prevented player {} from using hoe {} due to insufficient Farming level (required: {}, actual: {})", new Object[]{player.method_5477().getString(), toolName, requirement.getLevel(), playerLevel});
        }
    }

    @Inject(method={"useOnBlock"}, at={@At(value="HEAD")})
    private void captureOriginalBlock(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        this.lastBlockKey = context.method_8045().method_8320(context.method_8037()).method_26204().method_63499();
    }

    @Inject(method={"useOnBlock"}, at={@At(value="RETURN")})
    private void grantFarmingXPOnTill(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        class_1657 class_16572;
        class_1937 world = context.method_8045();
        if (world.method_8608() || !((class_16572 = context.method_8036()) instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_16572;
        if (cir.getReturnValue() != class_1269.field_5812) {
            return;
        }
        Objects.requireNonNull(world.method_8503()).execute(() -> {
            if (world.method_8320(context.method_8037()).method_27852(class_2246.field_10362)) {
                int xp = ConfigManager.getBlockXP(this.lastBlockKey, Skills.FARMING);
                XPManager.addXPWithNotification(player, Skills.FARMING, xp / 5);
                Simpleskills.LOGGER.debug("Granted {} Farming XP to {} for tilling {}", new Object[]{xp, player.method_5477().getString(), this.lastBlockKey});
            }
        });
    }
}

