/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.managers;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.managers.AttributeManager;
import com.github.ob_yekt.simpleskills.managers.DatabaseManager;
import com.github.ob_yekt.simpleskills.ui.SkillTabMenu;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2995;
import net.minecraft.class_3222;

public class IronmanManager {
    private static final String IRONMAN_TEAM_NAME = "ironman";

    public static void init() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (DatabaseManager.getInstance().isPlayerInIronmanMode(player.method_5845())) {
                IronmanManager.applyIronmanMode(player);
            }
        });
    }

    public static void applyIronmanMode(class_3222 player) {
        if (player == null) {
            return;
        }
        IronmanManager.assignPlayerToIronmanTeam(player);
        AttributeManager.applyIronmanAttributes(player);
        SkillTabMenu.updateTabMenu(player);
        Simpleskills.LOGGER.debug("Applied Ironman mode for player: {}", (Object)player.method_5477().getString());
    }

    public static void disableIronmanMode(class_3222 player) {
        if (player == null) {
            return;
        }
        DatabaseManager.getInstance().setIronmanMode(player.method_5845(), false);
        IronmanManager.removePlayerFromIronmanTeam(player);
        AttributeManager.clearIronmanAttributes(player);
        SkillTabMenu.updateTabMenu(player);
        Simpleskills.LOGGER.debug("Disabled Ironman mode for player: {}", (Object)player.method_5477().getString());
    }

    private static void createIronmanTeam(class_2995 scoreboard) {
        class_268 ironmanTeam = scoreboard.method_1153(IRONMAN_TEAM_NAME);
        if (ironmanTeam == null) {
            ironmanTeam = scoreboard.method_1171(IRONMAN_TEAM_NAME);
            ironmanTeam.method_1138((class_2561)class_2561.method_43470((String)"\u2620 ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
            ironmanTeam.method_1135(false);
            ironmanTeam.method_1143(true);
            Simpleskills.LOGGER.debug("Created Ironman team.");
        }
    }

    public static void assignPlayerToIronmanTeam(class_3222 player) {
        if (player == null) {
            return;
        }
        class_2995 scoreboard = Objects.requireNonNull(player.method_51469().method_8503()).method_3845();
        IronmanManager.createIronmanTeam(scoreboard);
        class_268 ironmanTeam = scoreboard.method_1153(IRONMAN_TEAM_NAME);
        if (ironmanTeam != null) {
            scoreboard.method_1172(player.method_5820(), ironmanTeam);
            Simpleskills.LOGGER.debug("Added player {} to Ironman team.", (Object)player.method_5477().getString());
        }
    }

    public static void removePlayerFromIronmanTeam(class_3222 player) {
        if (player == null) {
            return;
        }
        class_2995 scoreboard = Objects.requireNonNull(player.method_51469().method_8503()).method_3845();
        class_268 ironmanTeam = scoreboard.method_1153(IRONMAN_TEAM_NAME);
        if (ironmanTeam != null) {
            scoreboard.method_1157(player.method_5820(), ironmanTeam);
            Simpleskills.LOGGER.debug("Removed player {} from Ironman team.", (Object)player.method_5477().getString());
        }
    }
}

