/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class AgilityXPMixin {
    @Unique
    private static final Map<UUID, Map<String, Long>> lastActionTimes = new HashMap<UUID, Map<String, Long>>();
    @Unique
    private static final Map<String, Long> COOLDOWN_TICKS = new HashMap<String, Long>();

    @Unique
    private boolean canAwardXP(class_3222 player, String action) {
        long cooldown;
        Map playerTimes;
        long lastActionTick;
        long currentTick = player.method_51469().method_8510();
        if (currentTick - (lastActionTick = (playerTimes = lastActionTimes.computeIfAbsent(player.method_5667(), k -> new HashMap())).getOrDefault(action, 0L).longValue()) >= (cooldown = COOLDOWN_TICKS.getOrDefault(action, 20L).longValue())) {
            playerTimes.put(action, currentTick);
            return true;
        }
        return false;
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    private void onDamage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = (class_3222)this;
        if (source == player.method_48923().method_48827() && ((Boolean)cir.getReturnValue()).booleanValue() && this.canAwardXP(player, "fall_damage")) {
            int xp = (int)(amount * (float)ConfigManager.getAgilityXP("fall_damage", Skills.AGILITY) / 2.0f);
            XPManager.addXPSilent(player, Skills.AGILITY, xp);
        }
    }

    @Inject(method={"jump"}, at={@At(value="TAIL")})
    private void onJump(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        if (this.canAwardXP(player, "jump")) {
            int xp = ConfigManager.getAgilityXP("jump", Skills.AGILITY);
            XPManager.addXPSilent(player, Skills.AGILITY, xp);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTickAgility(CallbackInfo ci) {
        int xp;
        class_3222 player = (class_3222)this;
        if (player.method_5681() && this.canAwardXP(player, "swim")) {
            xp = ConfigManager.getAgilityXP("swim", Skills.AGILITY);
            XPManager.addXPSilent(player, Skills.AGILITY, xp);
        }
        if (player.method_5624() && this.canAwardXP(player, "sprint")) {
            xp = ConfigManager.getAgilityXP("sprint", Skills.AGILITY);
            XPManager.addXPSilent(player, Skills.AGILITY, xp);
        }
        if (player.method_5715() && this.canAwardXP(player, "sneak")) {
            xp = ConfigManager.getAgilityXP("sneak", Skills.AGILITY);
            XPManager.addXPSilent(player, Skills.AGILITY, xp);
        }
    }

    @Inject(method={"onDisconnect"}, at={@At(value="HEAD")})
    private void onDisconnect(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        lastActionTimes.remove(player.method_5667());
        Simpleskills.LOGGER.debug("Cleared agility cooldowns for player {}", (Object)player.method_5477().getString());
    }

    static {
        COOLDOWN_TICKS.put("fall_damage", 20L);
        COOLDOWN_TICKS.put("jump", 20L);
        COOLDOWN_TICKS.put("swim", 40L);
        COOLDOWN_TICKS.put("sprint", 40L);
        COOLDOWN_TICKS.put("sneak", 40L);
    }
}

