/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.FISHING;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.mixin.FISHING.FishingBobberEntityAccessor;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9383;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1536.class})
public abstract class FishingBobberEntityMixin {
    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z", shift=At.Shift.AFTER)})
    private void simpleskills$grantFishingXp(class_1799 usedItem, CallbackInfoReturnable<Integer> cir) {
        class_1536 self = (class_1536)this;
        class_1657 player = self.method_6947();
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            if (!player.method_73183().method_8608()) {
                int xp = ConfigManager.getFishingXP("catch", Skills.FISHING);
                XPManager.addXPWithNotification(sp, Skills.FISHING, xp);
                Simpleskills.LOGGER.debug("Granted {} Fishing XP for {}.", (Object)xp, (Object)player.method_5477().getString());
            }
        }
    }

    @Inject(method={"tickFishingLogic"}, at={@At(value="TAIL")})
    private void simpleskills$applyFishingLevelBonus(CallbackInfo ci) {
        double mult;
        int adjusted;
        class_3222 sp;
        class_1657 player;
        class_1536 self;
        block5: {
            block4: {
                self = (class_1536)this;
                player = self.method_6947();
                if (!(player instanceof class_3222)) break block4;
                sp = (class_3222)player;
                if (!player.method_73183().method_8608()) break block5;
            }
            return;
        }
        int level = XPManager.getSkillLevel(sp.method_5845(), Skills.FISHING);
        int wait = ((FishingBobberEntityAccessor)self).getWaitCountdown();
        if (wait > 0 && level > 0 && (adjusted = (int)((double)wait * Math.max(0.2, mult = 1.0 - (double)level * 0.005))) < wait) {
            ((FishingBobberEntityAccessor)self).setWaitCountdown(adjusted);
            Simpleskills.LOGGER.debug("Fishing waitCountdown -> {} (lvl {}) for {}", new Object[]{adjusted, level, player.method_5477().getString()});
        }
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/registry/ReloadableRegistries$Lookup;getLootTable(Lnet/minecraft/registry/RegistryKey;)Lnet/minecraft/loot/LootTable;"))
    private class_52 simpleskills$redirectGetLootTable(class_9383.class_9385 lookup, class_5321<class_52> original) {
        class_1536 self = (class_1536)this;
        class_1657 player = self.method_6947();
        class_5321 key = original;
        Simpleskills.LOGGER.debug("Original loot table: {}", (Object)original.method_29177());
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            int level = XPManager.getSkillLevel(sp.method_5845(), Skills.FISHING);
            class_2960 customId = ConfigManager.getFishingLootTable(level);
            if (customId != null) {
                key = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)customId);
                Simpleskills.LOGGER.debug("Attempting custom loot table: {}", (Object)customId);
                class_52 lootTable = lookup.method_58295(key);
                if (lootTable == class_52.field_948) {
                    Simpleskills.LOGGER.warn("Loot table {} is empty or invalid for player {} (lvl {})", new Object[]{customId, player.method_5477().getString(), level});
                    return lookup.method_58295(original);
                }
                Simpleskills.LOGGER.debug("Using custom fishing loot table {} for {} (lvl {})", new Object[]{customId, player.method_5477().getString(), level});
                return lootTable;
            }
            Simpleskills.LOGGER.warn("No custom loot table for level {}, falling back to vanilla", (Object)level);
        } else {
            Simpleskills.LOGGER.debug("Player {} is not a ServerPlayerEntity, using vanilla loot table {}", (Object)player, original);
        }
        return lookup.method_58295(key);
    }
}

