/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.ui;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.DatabaseManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2772;
import net.minecraft.class_3222;

public class SkillTabMenu {
    private static final Map<UUID, Boolean> playerTabMenuVisibility = new HashMap<UUID, Boolean>();
    private static final int MAX_SKILL_NAME_LENGTH = SkillTabMenu.getMaxSkillNameLength();

    private static int getMaxSkillNameLength() {
        int maxLength = 0;
        for (Skills skill : Skills.values()) {
            maxLength = Math.max(maxLength, skill.getDisplayName().length());
        }
        return maxLength;
    }

    public static void toggleTabMenuVisibility(class_2168 source) {
        UUID playerUuid;
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f This command can only be used by players."));
            return;
        }
        boolean isVisible = playerTabMenuVisibility.getOrDefault(playerUuid = player.method_5667(), DatabaseManager.getInstance().isTabMenuVisible(playerUuid.toString()));
        playerTabMenuVisibility.put(playerUuid, !isVisible);
        DatabaseManager.getInstance().setTabMenuVisibility(playerUuid.toString(), !isVisible);
        if (!isVisible) {
            SkillTabMenu.updateTabMenu(player);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Skill HUD enabled."), false);
        } else {
            player.field_13987.method_14364((class_2596)new class_2772(class_2561.method_30163((String)""), class_2561.method_30163((String)"")));
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Skill HUD disabled."), false);
        }
    }

    public static void updateTabMenu(class_3222 player) {
        String playerUuidStr;
        UUID playerUuid = player.method_5667();
        boolean isVisible = playerTabMenuVisibility.getOrDefault(playerUuid, DatabaseManager.getInstance().isTabMenuVisible(playerUuid.toString()));
        if (!isVisible) {
            player.field_13987.method_14364((class_2596)new class_2772(class_2561.method_30163((String)""), class_2561.method_30163((String)"")));
            return;
        }
        DatabaseManager db = DatabaseManager.getInstance();
        if (db.getAllSkills(playerUuidStr = playerUuid.toString()).isEmpty()) {
            db.initializePlayer(playerUuidStr);
            Simpleskills.LOGGER.debug("Initialized skills for player {} due to tab menu update.", (Object)player.method_5477().getString());
        }
        StringBuilder skillInfo = new StringBuilder();
        try {
            skillInfo.append("\u00a76\u00a7m=======================================\n").append("\u00a7c\u00a7l\u2694 Skills Overview \u2694\u00a7r\n").append("\u00a76\u00a7m=======================================\n\n");
            boolean isIronman = db.isPlayerInIronmanMode(playerUuidStr);
            int prestige = db.getPrestige(playerUuidStr);
            if (isIronman) {
                skillInfo.append("\u00a7cIronman Mode: \u00a7aENABLED\n\n");
            }
            if (prestige > 0) {
                skillInfo.append(String.format("\u00a76Prestige: \u00a7e\u2605%d\n\n", prestige));
            }
            Map<String, DatabaseManager.SkillData> skills = db.getAllSkills(playerUuidStr);
            int totalLevels = skills.values().stream().mapToInt(DatabaseManager.SkillData::level).sum();
            skillInfo.append("\u00a78\u00a7m---------------------------------------\n\n");
            for (Skills skillEnum : Skills.values()) {
                String skillName = skillEnum.getId();
                DatabaseManager.SkillData skill = skills.get(skillName);
                if (skill != null) {
                    SkillTabMenu.appendSkillInfo(skillInfo, skill, skillEnum.getDisplayName());
                    continue;
                }
                Simpleskills.LOGGER.warn("Skill {} not found for player {}. Using default.", (Object)skillName, (Object)player.method_5477().getString());
                SkillTabMenu.appendSkillInfo(skillInfo, new DatabaseManager.SkillData(0, 1), skillEnum.getDisplayName());
            }
            skillInfo.append("\n\u00a78\u00a7m---------------------------------------\n").append(String.format("\u00a7b\u00a7lTotal Level: \u00a7a%d\n", totalLevels)).append("\u00a76\u00a7m=======================================");
            player.field_13987.method_14364((class_2596)new class_2772(class_2561.method_30163((String)skillInfo.toString()), class_2561.method_30163((String)"")));
        }
        catch (Exception e) {
            Simpleskills.LOGGER.error("Failed to update tab menu for player {}: {}", (Object)player.method_5477().getString(), (Object)e.getMessage());
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Error: Failed to load skill data."), false);
        }
    }

    private static void appendSkillInfo(StringBuilder skillInfo, DatabaseManager.SkillData skill, String skillDisplayName) {
        String line;
        if (skill.level() == XPManager.getMaxLevel()) {
            line = String.format("\u00a76\u2b50 \u00a7e%s \u00a7eLevel %2d \u00a77[\u00a7f%,d\u00a77]", skillDisplayName, skill.level(), skill.xp());
        } else {
            String progressBar = SkillTabMenu.createProgressBar(skill);
            int xpForCurrentLevel = XPManager.getExperienceForLevel(skill.level());
            int xpToNextLevel = XPManager.getExperienceForLevel(skill.level() + 1) - xpForCurrentLevel;
            int progressToNextLevel = skill.xp() - xpForCurrentLevel;
            line = String.format("\u00a7a%s \u00a7fLevel \u00a7b%2d %s \u00a77[\u00a7f%,d\u00a77/\u00a7f%,d\u00a77]", skillDisplayName, skill.level(), progressBar, progressToNextLevel, xpToNextLevel);
        }
        String leftAlignedLine = SkillTabMenu.addLeftAlignmentPadding(line);
        skillInfo.append(leftAlignedLine).append("\n");
    }

    private static String addLeftAlignmentPadding(String line) {
        int estimatedWidth = SkillTabMenu.calculateApproximateWidth(line);
        int tabMenuWidth = 70;
        int padding = Math.max(0, (tabMenuWidth - estimatedWidth) / 2);
        padding = Math.max(0, padding - 20);
        return " ".repeat(padding) + line;
    }

    private static int calculateApproximateWidth(String text) {
        String cleanText = text.replaceAll("\u00a7[0-9a-fklmnor]", "");
        int width = 0;
        block10: for (char c : cleanText.toCharArray()) {
            switch (c) {
                case '!': 
                case ',': 
                case '.': 
                case ':': 
                case ';': 
                case 'I': 
                case 'f': 
                case 'i': 
                case 'l': 
                case 't': 
                case '|': {
                    width += 2;
                    continue block10;
                }
                case 'M': 
                case 'W': 
                case 'm': 
                case 'w': {
                    width += 6;
                    continue block10;
                }
                case ' ': 
                case 'r': 
                case 's': {
                    width += 3;
                    continue block10;
                }
                case '\u2b50': {
                    width += 8;
                    continue block10;
                }
                case '\u2588': {
                    width += 4;
                    continue block10;
                }
                case '\u2592': {
                    width += 4;
                    continue block10;
                }
                case '(': 
                case ')': 
                case '[': 
                case ']': {
                    width += 3;
                    continue block10;
                }
                case '/': {
                    width += 2;
                    continue block10;
                }
                default: {
                    width += 4;
                }
            }
        }
        return width;
    }

    private static String createProgressBar(DatabaseManager.SkillData skill) {
        int barLength = 10;
        if (skill.level() == XPManager.getMaxLevel()) {
            return "";
        }
        int xpForCurrentLevel = XPManager.getExperienceForLevel(skill.level());
        int xpToNextLevel = XPManager.getExperienceForLevel(skill.level() + 1) - xpForCurrentLevel;
        int progressToNextLevel = skill.xp() - xpForCurrentLevel;
        if (xpToNextLevel <= 0) {
            xpToNextLevel = 1;
        }
        progressToNextLevel = Math.max(0, Math.min(progressToNextLevel, xpToNextLevel));
        int filled = (int)((double)progressToNextLevel / (double)xpToNextLevel * (double)barLength);
        int empty = barLength - filled;
        return "\u00a7a" + "\u2588".repeat(filled) + "\u00a77" + "\u2592".repeat(empty);
    }

    public static void clearPlayerVisibility(UUID playerUuid) {
        playerTabMenuVisibility.remove(playerUuid);
        Simpleskills.LOGGER.debug("Cleared tab menu visibility for player UUID: {}", (Object)playerUuid);
    }
}

