/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills;

import com.github.ob_yekt.simpleskills.ClientConfig;
import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.DatabaseManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class SkillHudRenderer
implements HudElement {
    private static final class_2960 HUD_ID = class_2960.method_60655((String)"simpleskills", (String)"skill_hud");
    private static final Map<UUID, Boolean> playerHudVisibility = new HashMap<UUID, Boolean>();
    private static final int MAX_SKILL_NAME_LENGTH = SkillHudRenderer.getMaxSkillNameLength();
    private static final int PADDING = 3;
    private static final int LINE_HEIGHT = 8;
    private static final int BAR_WIDTH = 40;
    private static final int BAR_HEIGHT = 4;
    private static final int ELEMENT_SPACING = 5;
    private static final int BACKGROUND_COLOR = Integer.MIN_VALUE;
    private static final int BORDER_COLOR = -10496;
    private static final int TEXT_COLOR = -1;
    private static final int HEADER_COLOR = -48060;
    private static final int LEVEL_COLOR = -11141121;
    private static final int XP_COLOR = -7798904;
    private static final int PROGRESS_FILLED_COLOR = -11141291;
    private static final int PROGRESS_EMPTY_COLOR = -11184811;

    public static void register() {
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.BOSS_BAR, (class_2960)HUD_ID, (HudElement)new SkillHudRenderer());
    }

    private static int getMaxSkillNameLength() {
        int maxLength = 0;
        for (Skills skill : Skills.values()) {
            maxLength = Math.max(maxLength, skill.getDisplayName().length());
        }
        return maxLength;
    }

    public static void toggleHudVisibility() {
        UUID playerUuid;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        boolean isVisible = playerHudVisibility.getOrDefault(playerUuid = client.field_1724.method_5667(), DatabaseManager.getInstance().isTabMenuVisible(playerUuid.toString()));
        playerHudVisibility.put(playerUuid, !isVisible);
        DatabaseManager.getInstance().setTabMenuVisibility(playerUuid.toString(), !isVisible);
        if (!isVisible) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Skill HUD enabled."), false);
        } else {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Skill HUD disabled."), false);
        }
    }

    private boolean shouldRenderHud() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return false;
        }
        boolean isSingleplayer = client.method_1496();
        if (!isSingleplayer) {
            return false;
        }
        UUID playerUuid = client.field_1724.method_5667();
        return playerHudVisibility.getOrDefault(playerUuid, DatabaseManager.getInstance().isTabMenuVisible(playerUuid.toString()));
    }

    private HudSize calculateHudSize(UUID playerUuid) {
        DatabaseManager db = DatabaseManager.getInstance();
        String playerUuidStr = playerUuid.toString();
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (db.getAllSkills(playerUuidStr).isEmpty()) {
            db.initializePlayer(playerUuidStr);
        }
        boolean isIronman = db.isPlayerInIronmanMode(playerUuidStr);
        Map<String, DatabaseManager.SkillData> skills = db.getAllSkills(playerUuidStr);
        int maxWidth = 0;
        int height = 3;
        String headerText = "\u2694 Skills \u2694";
        maxWidth = Math.max(maxWidth, textRenderer.method_1727(headerText));
        height += 10;
        if (isIronman) {
            Skills[] ironmanText = "Ironman Mode";
            maxWidth = Math.max(maxWidth, textRenderer.method_1727((String)ironmanText));
            height += 9;
        }
        height += 3;
        for (Skills skillEnum : Skills.values()) {
            int lineWidth;
            String skillName = skillEnum.getId();
            DatabaseManager.SkillData skill = skills.getOrDefault(skillName, new DatabaseManager.SkillData(0, 1));
            String skillDisplayName = skillEnum.getDisplayName();
            if (skill.level() == XPManager.getMaxLevel()) {
                String skillText = String.format("\u2605 %-" + MAX_SKILL_NAME_LENGTH + "s Lvl 99", skillDisplayName);
                String xpText = String.format("XP: %,d", skill.xp());
                lineWidth = textRenderer.method_1727(skillText) + 5 + textRenderer.method_1727(xpText);
            } else {
                int XPForCurrentLevel = XPManager.getExperienceForLevel(skill.level());
                int XPToNextLevel = XPManager.getExperienceForLevel(skill.level() + 1) - XPForCurrentLevel;
                int progressToNextLevel = skill.xp() - XPForCurrentLevel;
                String skillText = String.format("%-" + MAX_SKILL_NAME_LENGTH + "s Lvl %d", skillDisplayName, skill.level());
                String xpText = String.format("%,d/%,d", progressToNextLevel, XPToNextLevel);
                lineWidth = textRenderer.method_1727(skillText) + 5 + 40 + 5 + textRenderer.method_1727(xpText);
            }
            maxWidth = Math.max(maxWidth, lineWidth);
            height += 9;
        }
        int totalLevels = skills.values().stream().mapToInt(DatabaseManager.SkillData::level).sum();
        String totalText = String.format("Total: %d", totalLevels);
        maxWidth = Math.max(maxWidth, textRenderer.method_1727(totalText));
        height += 13;
        int panelWidth = maxWidth + 16;
        return new HudSize(panelWidth, height += 3);
    }

    private int[] getHudPosition(int panelWidth, int panelHeight) {
        int x;
        class_310 client = class_310.method_1551();
        int windowWidth = client.method_22683().method_4486();
        int windowHeight = client.method_22683().method_4502();
        int margin = 10;
        ClientConfig.HudPosition position = ClientConfig.getHudPosition();
        return new int[]{x, switch (position) {
            case ClientConfig.HudPosition.TOP_LEFT -> {
                x = margin;
                yield margin;
            }
            case ClientConfig.HudPosition.TOP_CENTER -> {
                x = (windowWidth - panelWidth) / 2;
                yield margin;
            }
            case ClientConfig.HudPosition.TOP_RIGHT -> {
                x = windowWidth - panelWidth - margin;
                yield margin;
            }
            case ClientConfig.HudPosition.MIDDLE_LEFT -> {
                x = margin;
                yield (windowHeight - panelHeight) / 2;
            }
            case ClientConfig.HudPosition.MIDDLE_CENTER -> {
                x = (windowWidth - panelWidth) / 2;
                yield (windowHeight - panelHeight) / 2;
            }
            case ClientConfig.HudPosition.MIDDLE_RIGHT -> {
                x = windowWidth - panelWidth - margin;
                yield (windowHeight - panelHeight) / 2;
            }
            case ClientConfig.HudPosition.BOTTOM_LEFT -> {
                x = margin;
                yield windowHeight - panelHeight - margin;
            }
            case ClientConfig.HudPosition.BOTTOM_CENTER -> {
                x = (windowWidth - panelWidth) / 2;
                yield windowHeight - panelHeight - margin;
            }
            case ClientConfig.HudPosition.BOTTOM_RIGHT -> {
                x = windowWidth - panelWidth - margin;
                yield windowHeight - panelHeight - margin;
            }
            default -> {
                x = margin;
                yield margin;
            }
        }};
    }

    public void render(class_332 context, class_9779 tickCounter) {
        if (!this.shouldRenderHud()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        UUID playerUuid = client.field_1724.method_5667();
        HudSize size = this.calculateHudSize(playerUuid);
        int[] pos = this.getHudPosition(size.width, size.height);
        int x = pos[0];
        int y = pos[1];
        try {
            this.renderSkillPanel(context, x, y, size.width, size.height, playerUuid);
        }
        catch (Exception e) {
            Simpleskills.LOGGER.error("Failed to render skill HUD: {}", (Object)e.getMessage());
        }
    }

    private void renderSkillPanel(class_332 context, int x, int y, int panelWidth, int panelHeight, UUID playerUuid) {
        DatabaseManager db = DatabaseManager.getInstance();
        String playerUuidStr = playerUuid.toString();
        class_327 textRenderer = class_310.method_1551().field_1772;
        context.method_51738(x, x + panelWidth - 1, y, -10496);
        context.method_51738(x, x + panelWidth - 1, y + panelHeight - 1, -10496);
        context.method_51742(x, y, y + panelHeight - 1, -10496);
        context.method_51742(x + panelWidth - 1, y, y + panelHeight - 1, -10496);
        int currentY = y + 3;
        String headerText = "\u2694 Skills \u2694";
        int headerX = x + (panelWidth - textRenderer.method_1727(headerText)) / 2;
        context.method_51433(textRenderer, headerText, headerX, currentY, -48060, true);
        currentY += 10;
        boolean isIronman = db.isPlayerInIronmanMode(playerUuidStr);
        if (isIronman) {
            String ironmanText = "Ironman Mode";
            context.method_51433(textRenderer, ironmanText, x + 3, currentY, -48060, false);
            currentY += 9;
        }
        context.method_51738(x + 3, x + panelWidth - 3, currentY, -10066330);
        currentY += 3;
        Map<String, DatabaseManager.SkillData> skills = db.getAllSkills(playerUuidStr);
        for (Skills skillEnum : Skills.values()) {
            String skillName = skillEnum.getId();
            DatabaseManager.SkillData skill = skills.getOrDefault(skillName, new DatabaseManager.SkillData(0, 1));
            currentY = this.renderSkillLine(context, x + 3, currentY, skill, skillEnum.getDisplayName());
            ++currentY;
        }
        context.method_51738(x + 3, x + panelWidth - 3, currentY += 2, -10066330);
        int totalLevels = skills.values().stream().mapToInt(DatabaseManager.SkillData::level).sum();
        String totalText = String.format("Total: %d", totalLevels);
        context.method_51433(textRenderer, totalText, x + 3, currentY += 3, -11141121, true);
    }

    private int renderSkillLine(class_332 context, int x, int y, DatabaseManager.SkillData skill, String skillDisplayName) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (skill.level() == XPManager.getMaxLevel()) {
            String skillText = String.format("\u2605 %-" + MAX_SKILL_NAME_LENGTH + "s Lvl 99", skillDisplayName);
            String xpText = String.format("XP: %,d", skill.xp());
            context.method_51433(textRenderer, skillText, x, y, -10496, false);
            int xpTextX = x + textRenderer.method_1727(skillText) + 5;
            context.method_51433(textRenderer, xpText, xpTextX, y, -1, false);
            return y + 8;
        }
        int XPForCurrentLevel = XPManager.getExperienceForLevel(skill.level());
        int XPToNextLevel = XPManager.getExperienceForLevel(skill.level() + 1) - XPForCurrentLevel;
        int progressToNextLevel = skill.xp() - XPForCurrentLevel;
        String skillText = String.format("%-" + MAX_SKILL_NAME_LENGTH + "s Lvl %d", skillDisplayName, skill.level());
        context.method_51433(textRenderer, skillText, x, y, -1, false);
        int barX = x + textRenderer.method_1727(skillText) + 5;
        int barY = y + 2;
        this.renderProgressBar(context, barX, barY, 40, 4, progressToNextLevel, XPToNextLevel);
        String xpText = String.format("%,d/%,d", progressToNextLevel, XPToNextLevel);
        int xpTextX = barX + 40 + 5;
        context.method_51433(textRenderer, xpText, xpTextX, y, -7798904, false);
        return y + 8;
    }

    private void renderProgressBar(class_332 context, int x, int y, int width, int height, int progress, int total) {
        if (total <= 0) {
            total = 1;
        }
        progress = Math.max(0, Math.min(progress, total));
        context.method_25294(x, y, x + width, y + height, -11184811);
        int filledWidth = (int)((double)progress / (double)total * (double)width);
        if (filledWidth > 0) {
            context.method_25294(x, y, x + filledWidth, y + height, -11141291);
        }
        context.method_51738(x, x + width - 1, y, -7829368);
        context.method_51738(x, x + width - 1, y + height - 1, -7829368);
        context.method_51742(x, y, y + height - 1, -7829368);
        context.method_51742(x + width - 1, y, y + height - 1, -7829368);
    }

    public static void clearPlayerVisibility(UUID playerUuid) {
        playerHudVisibility.remove(playerUuid);
        Simpleskills.LOGGER.debug("Cleared HUD visibility for player UUID: {}", (Object)playerUuid);
    }

    @Environment(value=EnvType.CLIENT)
    private static class HudSize {
        int width;
        int height;

        HudSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

