/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.CRAFTING;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.LoreManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.mixin.CRAFTING.AbstractCraftingScreenHandlerAccessor;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1714;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.class_9884;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1714.class})
public abstract class CraftingScreenHandlerMixin
extends class_9884 {
    @Unique
    private final class_8566 craftingInventory = this.getCraftingInventory();
    @Unique
    private final class_1799[] originalInputs = new class_1799[9];

    protected CraftingScreenHandlerMixin(class_3917<?> type, int syncId, int gridWidth, int gridHeight) {
        super(type, syncId, gridWidth, gridHeight);
    }

    @Unique
    private class_8566 getCraftingInventory() {
        return ((AbstractCraftingScreenHandlerAccessor)((Object)this)).getCraftingInventory();
    }

    @Inject(method={"quickMove"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/Item;onCraftByPlayer(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/PlayerEntity;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onQuickMoveCraft(class_1657 player, int slotIndex, CallbackInfoReturnable<class_1799> cir, @Local(ordinal=0) class_1799 itemStack, @Local class_1735 slot, @Local(ordinal=1) class_1799 itemStack2) {
        if (slotIndex == 0 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (itemStack2.method_7960() || class_7923.field_41178.method_10221((Object)itemStack2.method_7909()).toString().equals("minecraft:air")) {
                Simpleskills.LOGGER.debug("Skipping onQuickMoveCraft for empty or air stack: {}", (Object)itemStack2);
                return;
            }
            for (int i = 0; i < 9; ++i) {
                this.originalInputs[i] = this.craftingInventory.method_5438(i).method_7972();
            }
            if (itemStack2.method_58694(class_9334.field_50072) != null) {
                this.applyCraftingLore(itemStack2, serverPlayer);
                this.applyCraftingScaling(itemStack2, serverPlayer);
            } else if (this.isCookableFoodItem(itemStack2)) {
                this.applyCookingLore(itemStack2, serverPlayer);
                this.applyCookingScaling(itemStack2, serverPlayer);
            }
        }
    }

    @Inject(method={"quickMove"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/slot/Slot;onQuickTransfer(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onQuickMoveAfterTransfer(class_1657 player, int slotIndex, CallbackInfoReturnable<class_1799> cir, @Local(ordinal=0) class_1799 itemStack, @Local class_1735 slot, @Local(ordinal=1) class_1799 itemStack2) {
        if (slotIndex == 0 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (itemStack.method_7960() || class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString().equals("minecraft:air")) {
                Simpleskills.LOGGER.debug("Skipping onQuickMoveAfterTransfer for empty or air stack: {}", (Object)itemStack);
                return;
            }
            int movedCount = itemStack.method_7947() - (itemStack2.method_7960() ? 0 : itemStack2.method_7947());
            if (movedCount > 0) {
                class_1799 movedStack = itemStack.method_7972();
                movedStack.method_7939(movedCount);
                this.grantCraftingXP(serverPlayer, movedStack);
                if (this.isCookableFoodItem(movedStack)) {
                    this.grantCookingXP(serverPlayer, movedStack);
                }
                this.applyMaterialRecovery(serverPlayer, itemStack);
            }
        }
    }

    @Unique
    private boolean isCookableFoodItem(class_1799 stack) {
        String itemKey = stack.method_7909().method_7876();
        return ConfigManager.getCookingXP(itemKey, Skills.COOKING) > 0;
    }

    @Unique
    private void grantCraftingXP(class_3222 player, class_1799 stack) {
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            return;
        }
        String itemKey = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        int xpPerItem = ConfigManager.getCraftingXP(itemKey, Skills.CRAFTING);
        if (xpPerItem <= 0) {
            return;
        }
        int totalXP = xpPerItem * stack.method_7947();
        XPManager.addXPWithNotification(player, Skills.CRAFTING, totalXP);
        Simpleskills.LOGGER.debug("Granted {} Crafting XP for {}x {} to player {}", new Object[]{totalXP, stack.method_7947(), itemKey, player.method_5477().getString()});
    }

    @Unique
    private void grantCookingXP(class_3222 player, class_1799 stack) {
        if (stack.method_7960() || class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().equals("minecraft:air")) {
            return;
        }
        String itemKey = stack.method_7909().method_7876();
        int xpPerItem = ConfigManager.getCookingXP(itemKey, Skills.COOKING);
        if (xpPerItem <= 0) {
            return;
        }
        int totalXP = xpPerItem * stack.method_7947();
        XPManager.addXPWithNotification(player, Skills.COOKING, totalXP);
        Simpleskills.LOGGER.debug("Granted {} Cooking XP for {}x {} to player {}", new Object[]{totalXP, stack.method_7947(), itemKey, player.method_5477().getString()});
    }

    @Unique
    private void applyCraftingLore(class_1799 stack, class_3222 player) {
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.CRAFTING);
        LoreManager.TierInfo tierInfo = LoreManager.getTierName(level);
        class_9290 currentLoreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
        ArrayList<class_5250> currentLore = new ArrayList<class_5250>(currentLoreComponent.comp_2400());
        class_5250 craftingLore = class_2561.method_43470((String)("Crafted by " + player.method_5477().getString() + " (" + tierInfo.name() + " Crafter)")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_36139(tierInfo.color()));
        currentLore.addFirst(craftingLore);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(currentLore));
    }

    @Unique
    private void applyCraftingScaling(class_1799 stack, class_3222 player) {
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.CRAFTING);
        float multiplier = this.getDurabilityMultiplier(level);
        Integer original = (Integer)stack.method_58694(class_9334.field_50072);
        if (original == null) {
            return;
        }
        int newMax = Math.max(1, Math.round((float)original.intValue() * multiplier));
        stack.method_57379(class_9334.field_50072, (Object)newMax);
        Simpleskills.LOGGER.debug("Scaled durability for {} from {} -> {} for player {} (lvl {}, multiplier {})", new Object[]{class_7923.field_41178.method_10221((Object)stack.method_7909()).toString(), original, newMax, player.method_5477().getString(), level, Float.valueOf(multiplier)});
    }

    @Unique
    private void applyCookingLore(class_1799 stack, class_3222 player) {
        if (stack.method_7960() || class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().equals("minecraft:air")) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.COOKING);
        LoreManager.TierInfo tierInfo = LoreManager.getTierName(level);
        class_9290 currentLoreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
        ArrayList<class_5250> currentLore = new ArrayList<class_5250>(currentLoreComponent.comp_2400());
        class_5250 cookingLore = class_2561.method_43470((String)("Cooked by " + player.method_5477().getString() + " (" + tierInfo.name() + " Cook)")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_36139(tierInfo.color()));
        currentLore.addFirst(cookingLore);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(currentLore));
    }

    @Unique
    private void applyCookingScaling(class_1799 stack, class_3222 player) {
        if (stack.method_7960() || class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().equals("minecraft:air")) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.COOKING);
        float multiplier = ConfigManager.getCookingMultiplier(level);
        class_4174 original = (class_4174)stack.method_58694(class_9334.field_50075);
        if (original == null) {
            return;
        }
        int newHunger = Math.max(1, Math.round((float)original.comp_2491() * multiplier));
        float newSaturation = original.comp_2492() * multiplier;
        class_4174 scaledFood = new class_4174.class_4175().method_19238(newHunger).method_19237(newSaturation).method_19242();
        stack.method_57379(class_9334.field_50075, (Object)scaledFood);
        Simpleskills.LOGGER.debug("Scaled food {} -> hunger {} sat {} for player {} (lvl {}, multiplier {})", new Object[]{stack.method_7909().method_7876(), newHunger, Float.valueOf(newSaturation), player.method_5477().getString(), level, Float.valueOf(multiplier)});
    }

    @Unique
    private void applyMaterialRecovery(class_3222 player, class_1799 outputStack) {
        String itemId = class_7923.field_41178.method_10221((Object)outputStack.method_7909()).toString();
        Simpleskills.LOGGER.info("=== MATERIAL RECOVERY DEBUG (Shift-Click) ===");
        Simpleskills.LOGGER.info("Player: {}", (Object)player.method_5477().getString());
        Simpleskills.LOGGER.info("Output item: {}", (Object)itemId);
        Simpleskills.LOGGER.info("Is blacklisted: {}", (Object)ConfigManager.isRecipeBlacklisted(itemId));
        if (ConfigManager.isRecipeBlacklisted(itemId)) {
            Simpleskills.LOGGER.info("Skipping material recovery for blacklisted item: {}", (Object)itemId);
            return;
        }
        Simpleskills.LOGGER.info("Proceeding with recovery check for: {}", (Object)itemId);
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.CRAFTING);
        float recoveryChance = this.getRecoveryChance(level);
        Simpleskills.LOGGER.info("Recovery chance: {} for level {}", (Object)Float.valueOf(recoveryChance), (Object)level);
        if (recoveryChance <= 0.0f) {
            Simpleskills.LOGGER.info("No recovery possible (chance <= 0)");
            return;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 original = this.originalInputs[i];
            class_1799 current = this.craftingInventory.method_5438(i);
            Simpleskills.LOGGER.info("Slot {}: Original count: {}, Current count: {}", new Object[]{i, original.method_7947(), current.method_7947()});
            if (original.method_7960() || current.method_7947() >= original.method_7947() || !(player.method_59922().method_43057() < recoveryChance)) continue;
            class_1799 recovered = original.method_7972();
            recovered.method_7939(1);
            if (!player.method_31548().method_7394(recovered)) {
                player.method_7328(recovered, false);
            }
            Simpleskills.LOGGER.info("Recovered {} for player {} (lvl {}, chance {})", new Object[]{recovered.method_7909().method_7876(), player.method_5477().getString(), level, Float.valueOf(recoveryChance)});
        }
    }

    @Unique
    private float getDurabilityMultiplier(int level) {
        return ConfigManager.getCraftingDurabilityMultiplier(level);
    }

    @Unique
    private float getRecoveryChance(int level) {
        return ConfigManager.getCraftingRecoveryChance(level);
    }
}

