/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.managers.AttributeManager;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.DatabaseManager;
import com.github.ob_yekt.simpleskills.managers.IronmanManager;
import com.github.ob_yekt.simpleskills.ui.SkillTabMenu;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public class ServerPlayerEntityMixin {
    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void onDeath(class_1282 source, CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        String playerUuid = player.method_5845();
        DatabaseManager db = DatabaseManager.getInstance();
        if (db.isPlayerInIronmanMode(playerUuid)) {
            player.method_31548().method_5448();
            player.method_14252(0);
            player.method_14228(0);
            int totalLevels = db.getAllSkills(playerUuid).values().stream().mapToInt(DatabaseManager.SkillData::level).sum();
            IronmanManager.disableIronmanMode(player);
            db.resetPlayerSkills(playerUuid);
            db.ensurePlayerInitialized(playerUuid);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Your deal with death has cost you all skill levels. Ironman mode has been disabled.").method_27692(class_124.field_1054), false);
            if (ConfigManager.getFeatureConfig().get("broadcast_ironman_death") != null && ConfigManager.getFeatureConfig().get("broadcast_ironman_death").getAsBoolean()) {
                Objects.requireNonNull(player.method_51469().method_8503()).method_3760().method_43514((class_2561)class_2561.method_43470((String)String.format("\u00a76[simpleskills]\u00a7f %s has died in Ironman mode with a total level of \u00a76%d\u00a7f.", player.method_5477().getString(), totalLevels)), false);
            }
            Simpleskills.LOGGER.debug("Processed Ironman death for player: {}", (Object)player.method_5477().getString());
        } else {
            AttributeManager.clearSkillAttributes(player);
            AttributeManager.clearIronmanAttributes(player);
        }
        AttributeManager.refreshAllAttributes(player);
        SkillTabMenu.updateTabMenu(player);
        Simpleskills.LOGGER.debug("Processed death for player: {}", (Object)player.method_5477().getString());
    }
}

