/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.ui;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.DatabaseManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2772;
import net.minecraft.class_3222;

public class SkillTabMenu {
    private static final Map<UUID, Boolean> playerTabMenuVisibility = new HashMap<UUID, Boolean>();
    private static final int MAX_SKILL_NAME_LENGTH = SkillTabMenu.getMaxSkillNameLength();

    private static int getMaxSkillNameLength() {
        int maxLength = 0;
        for (Skills skill : Skills.values()) {
            maxLength = Math.max(maxLength, skill.getDisplayName().length());
        }
        return maxLength;
    }

    public static void toggleTabMenuVisibility(class_2168 source) {
        UUID playerUuid;
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f This command can only be used by players."));
            return;
        }
        boolean isVisible = playerTabMenuVisibility.getOrDefault(playerUuid = player.method_5667(), DatabaseManager.getInstance().isTabMenuVisible(playerUuid.toString()));
        playerTabMenuVisibility.put(playerUuid, !isVisible);
        DatabaseManager.getInstance().setTabMenuVisibility(playerUuid.toString(), !isVisible);
        if (!isVisible) {
            SkillTabMenu.updateTabMenu(player);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Skill HUD enabled."), false);
        } else {
            player.field_13987.method_14364((class_2596)new class_2772(class_2561.method_30163((String)""), class_2561.method_30163((String)"")));
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Skill HUD disabled."), false);
        }
    }

    public static void updateTabMenu(class_3222 player) {
        String playerUuidStr;
        UUID playerUuid = player.method_5667();
        boolean isVisible = playerTabMenuVisibility.getOrDefault(playerUuid, DatabaseManager.getInstance().isTabMenuVisible(playerUuid.toString()));
        if (!isVisible) {
            player.field_13987.method_14364((class_2596)new class_2772(class_2561.method_30163((String)""), class_2561.method_30163((String)"")));
            return;
        }
        DatabaseManager db = DatabaseManager.getInstance();
        if (db.getAllSkills(playerUuidStr = playerUuid.toString()).isEmpty()) {
            db.initializePlayer(playerUuidStr);
            Simpleskills.LOGGER.debug("Initialized skills for player {} due to tab menu update.", (Object)player.method_5477().getString());
        }
        StringBuilder skillInfo = new StringBuilder();
        try {
            skillInfo.append("\u00a76\u00a7m=======================================\n").append("\u00a7c\u00a7l\u2694 Skills Overview \u2694\u00a7r\n").append("\u00a76\u00a7m=======================================\n\n");
            boolean isIronman = db.isPlayerInIronmanMode(playerUuidStr);
            if (isIronman) {
                skillInfo.append("\u00a7cIronman Mode: \u00a7aENABLED\n\n");
            }
            Map<String, DatabaseManager.SkillData> skills = db.getAllSkills(playerUuidStr);
            int totalLevels = skills.values().stream().mapToInt(DatabaseManager.SkillData::level).sum();
            skillInfo.append("\u00a78\u00a7m---------------------------------------\n\n");
            for (Skills skillEnum : Skills.values()) {
                String skillName = skillEnum.getId();
                DatabaseManager.SkillData skill = skills.get(skillName);
                if (skill != null) {
                    SkillTabMenu.appendSkillInfo(skillInfo, skill, skillEnum.getDisplayName());
                    continue;
                }
                Simpleskills.LOGGER.warn("Skill {} not found for player {}. Using default.", (Object)skillName, (Object)player.method_5477().getString());
                SkillTabMenu.appendSkillInfo(skillInfo, new DatabaseManager.SkillData(0, 1), skillEnum.getDisplayName());
            }
            skillInfo.append("\n\u00a78\u00a7m---------------------------------------\n").append(String.format("\u00a7b\u00a7lTotal Level: \u00a7a%d\n", totalLevels)).append("\u00a76\u00a7m=======================================");
            player.field_13987.method_14364((class_2596)new class_2772(class_2561.method_30163((String)skillInfo.toString()), class_2561.method_30163((String)"")));
        }
        catch (Exception e) {
            Simpleskills.LOGGER.error("Failed to update tab menu for player {}: {}", (Object)player.method_5477().getString(), (Object)e.getMessage());
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[simpleskills]\u00a7f Error: Failed to load skill data."), false);
        }
    }

    private static void appendSkillInfo(StringBuilder skillInfo, DatabaseManager.SkillData skill, String skillDisplayName) {
        String line;
        String paddedSkillName = String.format("%-" + MAX_SKILL_NAME_LENGTH + "s", skillDisplayName);
        String levelText = String.format("Level %2d", skill.level());
        String progressBar = SkillTabMenu.createProgressBar(skill);
        if (skill.level() == XPManager.getMaxLevel()) {
            line = String.format("\u00a76\u2b50 \u00a7e%s \u00a7e%s %s \u00a77[\u00a7f%,d\u00a77]", paddedSkillName, levelText, progressBar, skill.xp());
        } else {
            int xpForCurrentLevel = XPManager.getExperienceForLevel(skill.level());
            int xpToNextLevel = XPManager.getExperienceForLevel(skill.level() + 1) - xpForCurrentLevel;
            int progressToNextLevel = skill.xp() - xpForCurrentLevel;
            line = String.format("\u00a7a%s \u00a7fLevel \u00a7b%2d %s \u00a77[\u00a7f%,d\u00a77/\u00a7f%,d\u00a77]", paddedSkillName, skill.level(), progressBar, progressToNextLevel, xpToNextLevel);
        }
        skillInfo.append(line).append("\n");
    }

    private static String createProgressBar(DatabaseManager.SkillData skill) {
        int barLength = 10;
        if (skill.level() == XPManager.getMaxLevel()) {
            return "\u00a7a" + "\u2588".repeat(barLength);
        }
        int xpForCurrentLevel = XPManager.getExperienceForLevel(skill.level());
        int xpToNextLevel = XPManager.getExperienceForLevel(skill.level() + 1) - xpForCurrentLevel;
        int progressToNextLevel = skill.xp() - xpForCurrentLevel;
        if (xpToNextLevel <= 0) {
            xpToNextLevel = 1;
        }
        progressToNextLevel = Math.max(0, Math.min(progressToNextLevel, xpToNextLevel));
        int filled = (int)((double)progressToNextLevel / (double)xpToNextLevel * (double)barLength);
        int empty = barLength - filled;
        return "\u00a7a" + "\u2588".repeat(filled) + "\u00a77" + "\u2592".repeat(empty);
    }

    public static void clearPlayerVisibility(UUID playerUuid) {
        playerTabMenuVisibility.remove(playerUuid);
        Simpleskills.LOGGER.debug("Cleared tab menu visibility for player UUID: {}", (Object)playerUuid);
    }
}

