/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.managers;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.requirements.SkillRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class LoreManager {
    private static final String LORE_PREFIX = "Requires";
    private static final String TO_USE = " to use";
    private static final String TO_SACRIFICE = " to sacrifice";

    public static void initialize() {
    }

    public static void applySkillLore(class_1799 stack) {
        LoreManager.applyLoreToStack(stack);
    }

    public static void applyLoreToStack(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        if (!LoreManager.isItemRequirementsInTooltipsEnabled()) {
            return;
        }
        String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        ArrayList<Object> newLore = new ArrayList<Object>();
        SkillRequirement requirement = LoreManager.getItemRequirement(itemId);
        if (requirement != null) {
            boolean isSacrifice = ConfigManager.PRAYER_SACRIFICES.containsKey(itemId);
            String action = isSacrifice ? TO_SACRIFICE : TO_USE;
            String skillName = requirement.getSkill().getId().substring(0, 1).toUpperCase() + requirement.getSkill().getId().substring(1).toLowerCase();
            String loreText = String.format("Requires %d %s%s", requirement.getLevel(), skillName, action);
            class_9290 currentLoreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
            boolean loreExists = currentLoreComponent.comp_2400().stream().anyMatch(text -> text.getString().equals(loreText));
            if (loreExists) {
                return;
            }
            newLore.add(class_2561.method_43470((String)loreText).method_27692(class_124.field_1080));
        }
        if (!newLore.isEmpty()) {
            List currentLore = ((class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()))).comp_2400();
            List<class_2561> filteredLore = currentLore.stream().filter(text -> !text.getString().contains(LORE_PREFIX)).toList();
            newLore.addAll(0, filteredLore);
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(newLore));
            Simpleskills.LOGGER.debug("Applied lore to item: {}", (Object)itemId);
        }
    }

    public static void applyLoreToInventory(class_1263 inventory) {
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            LoreManager.applyLoreToStack(stack);
        }
    }

    private static SkillRequirement getItemRequirement(String itemId) {
        SkillRequirement toolReq = ConfigManager.getToolRequirement(itemId);
        if (toolReq != null) {
            return toolReq;
        }
        SkillRequirement armorReq = ConfigManager.getArmorRequirement(itemId);
        if (armorReq != null) {
            return armorReq;
        }
        SkillRequirement weaponReq = ConfigManager.getWeaponRequirement(itemId);
        if (weaponReq != null) {
            return weaponReq;
        }
        if (ConfigManager.PRAYER_SACRIFICES.containsKey(itemId)) {
            return ConfigManager.PRAYER_SACRIFICES.get(itemId).requirement();
        }
        return null;
    }

    public static TierInfo getTierName(int level) {
        if (level >= 99) {
            return new TierInfo("Grandmaster", 0xFF8000);
        }
        if (level >= 75) {
            return new TierInfo("Expert", 10696174);
        }
        if (level >= 50) {
            return new TierInfo("Artisan", 28893);
        }
        if (level >= 25) {
            return new TierInfo("Journeyman", 2031360);
        }
        return new TierInfo("Novice", 0x9D9D9D);
    }

    private static boolean isItemRequirementsInTooltipsEnabled() {
        return ConfigManager.getFeatureConfig().get("item_requirements_in_tooltips_enabled").getAsBoolean();
    }

    public record TierInfo(String name, int color) {
    }
}

