/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.CRAFTING;

import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import com.github.ob_yekt.simpleskills.utils.CraftingCommon;
import net.minecraft.class_1657;
import net.minecraft.class_1734;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1734.class})
public abstract class CraftingResultSlotMixin {
    @Shadow
    @Final
    private class_1657 field_7868;
    @Shadow
    @Final
    private class_8566 field_7870;
    @Unique
    private final class_1799[] originalInputs = new class_1799[9];

    @Inject(method={"onTakeItem"}, at={@At(value="HEAD")})
    private void onTakeItemHead(class_1657 player, class_1799 stack, CallbackInfo ci) {
        class_3222 serverPlayer;
        block8: {
            block7: {
                if (!(player instanceof class_3222)) break block7;
                serverPlayer = (class_3222)player;
                if (CraftingCommon.isValidStack(stack)) break block8;
            }
            return;
        }
        for (int i = 0; i < 9; ++i) {
            this.originalInputs[i] = this.field_7870.method_5438(i).method_7972();
        }
        if (CraftingCommon.isCraftableItem(stack)) {
            CraftingCommon.grantCraftingXP(serverPlayer, stack);
            CraftingCommon.applyCraftingLore(stack, serverPlayer);
            CraftingCommon.applyCraftingScaling(stack, serverPlayer);
        } else if (CraftingCommon.isCookableFoodItem(stack)) {
            CraftingCommon.grantCookingXP(serverPlayer, stack);
            CraftingCommon.applyCookingLore(stack, serverPlayer);
            CraftingCommon.applyCookingScaling(stack, serverPlayer);
        }
    }

    @Inject(method={"onTakeItem"}, at={@At(value="TAIL")})
    private void onTakeItemTail(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (CraftingCommon.isValidStack(stack)) {
                this.applyMaterialRecovery(serverPlayer, stack);
            }
        }
    }

    @Unique
    private void applyMaterialRecovery(class_3222 player, class_1799 outputStack) {
        String itemId = class_7923.field_41178.method_10221((Object)outputStack.method_7909()).toString();
        if (ConfigManager.isRecipeBlacklisted(itemId)) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.CRAFTING);
        float recoveryChance = ConfigManager.getCraftingRecoveryChance(level);
        if (recoveryChance <= 0.0f) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 original = this.originalInputs[i];
            class_1799 current = this.field_7870.method_5438(i);
            if (original.method_7960() || current.method_7947() >= original.method_7947() || !(player.method_59922().method_43057() < recoveryChance)) continue;
            class_1799 recovered = original.method_7972();
            recovered.method_7939(1);
            if (player.method_31548().method_7394(recovered)) continue;
            player.method_7328(recovered, false);
        }
    }
}

