/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simpleskills.mixin.SMITHING;

import com.github.ob_yekt.simpleskills.Simpleskills;
import com.github.ob_yekt.simpleskills.Skills;
import com.github.ob_yekt.simpleskills.managers.ConfigManager;
import com.github.ob_yekt.simpleskills.managers.LoreManager;
import com.github.ob_yekt.simpleskills.managers.XPManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_4862;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4862.class})
public abstract class SmithingScreenHandlerMixin
extends class_4861 {
    protected SmithingScreenHandlerMixin(class_3917<?> type, int syncId, class_1657 player) {
        super(type, syncId, player.method_31548(), null, null);
    }

    @Inject(method={"updateResult"}, at={@At(value="TAIL")})
    private void onUpdateResult(CallbackInfo ci) {
        class_1657 class_16572 = this.field_22482;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        Simpleskills.LOGGER.debug("SmithingScreenHandlerMixin: updateResult triggered for player {}", (Object)serverPlayer.method_5477().getString());
        class_4862 handler = (class_4862)this;
        class_1799 outputStack = handler.method_7611(3).method_7677();
        if (this.isNetheriteToolUpgrade(outputStack)) {
            class_1799 newStack = this.applySmithingDurabilityScaling(outputStack, serverPlayer);
            handler.method_7611(3).method_53512(newStack);
        } else {
            Simpleskills.LOGGER.debug("updateResult: Not a netherite tool or armor upgrade for output: {}", (Object)outputStack.method_7909());
        }
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="HEAD")})
    private void onTakeOutput(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        Simpleskills.LOGGER.debug("SmithingScreenHandlerMixin: onTakeOutput triggered for player {}, output: {}", (Object)serverPlayer.method_5477().getString(), (Object)stack.method_7909());
        this.processSmithingOperation(serverPlayer, stack);
    }

    @Unique
    private void processSmithingOperation(class_3222 serverPlayer, class_1799 stack) {
        if (!this.isNetheriteToolUpgrade(stack)) {
            Simpleskills.LOGGER.debug("processSmithingOperation: Not a netherite upgrade, skipping");
            return;
        }
        if (this.hasSmithingLore(stack)) {
            Simpleskills.LOGGER.debug("processSmithingOperation: Item already has smithing lore, skipping");
            return;
        }
        XPManager.addXPWithNotification(serverPlayer, Skills.SMITHING, 20000);
        this.applySmithingLore(stack, serverPlayer);
        class_1799 newStack = this.applySmithingDurabilityScaling(stack, serverPlayer);
        class_4862 handler = (class_4862)this;
        handler.method_7611(3).method_53512(newStack);
        if (stack != newStack) {
            stack.method_57379(class_9334.field_50072, (Object)((Integer)newStack.method_58695(class_9334.field_50072, null)));
            stack.method_57379(class_9334.field_49632, (Object)((class_9290)newStack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()))));
        }
    }

    @Unique
    private boolean isNetheriteToolUpgrade(class_1799 outputStack) {
        class_4862 handler = (class_4862)this;
        class_1735 templateSlot = handler.method_7611(0);
        class_1735 materialSlot = handler.method_7611(2);
        class_1792 templateItem = templateSlot.method_7677().method_7909();
        class_1792 materialItem = materialSlot.method_7677().method_7909();
        boolean isUpgrade = templateItem == class_1802.field_41946 && materialItem == class_1802.field_22020;
        Simpleskills.LOGGER.debug("isNetheriteToolUpgrade: output={}, template={}, material={}, result={}", new Object[]{outputStack.method_7909(), templateItem, materialItem, isUpgrade});
        return isUpgrade;
    }

    @Unique
    private boolean hasSmithingLore(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_9290 loreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
        List loreLines = loreComponent.comp_2400();
        for (class_2561 line : loreLines) {
            String loreText = line.getString();
            if (!loreText.contains("Upgraded by") || !loreText.contains("Smith)")) continue;
            return true;
        }
        return false;
    }

    @Unique
    private class_1799 applySmithingDurabilityScaling(class_1799 stack, class_3222 player) {
        int vanillaDiamondDurability;
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: Empty stack or no MAX_DAMAGE for {}", (Object)stack.method_7909());
            return stack;
        }
        int vanillaNetheriteDurability = this.getVanillaDurability(stack.method_7909());
        if (vanillaNetheriteDurability == 0) {
            Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: No valid vanilla durability for {}", (Object)stack.method_7909());
            return stack;
        }
        Integer inputDurability = this.getInputDurability();
        if (inputDurability == null || inputDurability == 0) {
            Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: No valid input durability for input item");
            return stack;
        }
        class_1792 diamondEquivalent = this.getDiamondEquivalent(stack.method_7909());
        int n = vanillaDiamondDurability = diamondEquivalent != null ? this.getVanillaDurability(diamondEquivalent) : 0;
        if (vanillaDiamondDurability == 0) {
            Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: No valid vanilla diamond durability for {}", (Object)diamondEquivalent);
            return stack;
        }
        int craftingBonus = inputDurability - vanillaDiamondDurability;
        int smithingLevel = XPManager.getSkillLevel(player.method_5845(), Skills.SMITHING);
        float smithingMultiplier = ConfigManager.getSmithingMultiplier(smithingLevel);
        int newMax = Math.max(1, Math.round((float)(vanillaNetheriteDurability + craftingBonus) * smithingMultiplier));
        Simpleskills.LOGGER.debug("applySmithingDurabilityScaling: Input durability={}, Vanilla diamond durability={}, Crafting bonus={}, Vanilla Netherite durability={}, Final durability={} for {} (player={}, smithing lvl={}, smithing multiplier={})", new Object[]{inputDurability, vanillaDiamondDurability, craftingBonus, vanillaNetheriteDurability, newMax, class_7923.field_41178.method_10221((Object)stack.method_7909()).toString(), player.method_5477().getString(), smithingLevel, Float.valueOf(smithingMultiplier)});
        class_1799 newStack = stack.method_7972();
        newStack.method_57379(class_9334.field_50072, (Object)newMax);
        return newStack;
    }

    @Unique
    private Integer getInputDurability() {
        class_4862 handler = (class_4862)this;
        class_1799 inputStack = handler.method_7611(1).method_7677();
        return (Integer)inputStack.method_58695(class_9334.field_50072, null);
    }

    @Unique
    private int getVanillaDurability(class_1792 item) {
        class_1799 tempStack = new class_1799((class_1935)item);
        Integer durability = (Integer)tempStack.method_58695(class_9334.field_50072, null);
        return durability != null ? durability : 0;
    }

    @Unique
    private class_1792 getDiamondEquivalent(class_1792 netheriteItem) {
        if (netheriteItem == class_1802.field_22024) {
            return class_1802.field_8377;
        }
        if (netheriteItem == class_1802.field_22025) {
            return class_1802.field_8556;
        }
        if (netheriteItem == class_1802.field_22023) {
            return class_1802.field_8250;
        }
        if (netheriteItem == class_1802.field_22026) {
            return class_1802.field_8527;
        }
        if (netheriteItem == class_1802.field_22022) {
            return class_1802.field_8802;
        }
        if (netheriteItem == class_1802.field_22027) {
            return class_1802.field_8805;
        }
        if (netheriteItem == class_1802.field_22028) {
            return class_1802.field_8058;
        }
        if (netheriteItem == class_1802.field_22029) {
            return class_1802.field_8348;
        }
        if (netheriteItem == class_1802.field_22030) {
            return class_1802.field_8285;
        }
        return null;
    }

    @Unique
    private void applySmithingLore(class_1799 stack, class_3222 player) {
        if (stack.method_7960() || stack.method_58694(class_9334.field_50072) == null) {
            return;
        }
        int level = XPManager.getSkillLevel(player.method_5845(), Skills.SMITHING);
        LoreManager.TierInfo tierInfo = LoreManager.getTierName(level);
        class_9290 currentLoreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)new class_9290(List.of()));
        ArrayList<class_5250> currentLore = new ArrayList<class_5250>(currentLoreComponent.comp_2400());
        class_5250 smithingLore = class_2561.method_43470((String)("Upgraded by " + player.method_5477().getString() + " (" + tierInfo.name() + " Smith)")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_36139(tierInfo.color()));
        currentLore.addFirst(smithingLore);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(currentLore));
    }
}

