/*
 * Decompiled with CFR 0.152.
 */
package com.uavwaffle.tameableendermen.mixin;

import com.uavwaffle.tameableendermen.entity.custom.FollowState;
import com.uavwaffle.tameableendermen.entity.custom.TameableEnderManInterface;
import com.uavwaffle.tameableendermen.entity.custom.goal.EnderFollowOwnerGoal;
import com.uavwaffle.tameableendermen.entity.custom.goal.EnderSitWhenOrderedToGoal;
import com.uavwaffle.tameableendermen.entity.custom.goal.WaterAvoidingRandomStrollWithinRadiusGoal;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderMan.class})
public abstract class EndermanMixin
extends Monster
implements NeutralMob,
TameableEnderManInterface {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42730_, Items.f_42410_});
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(EnderMan.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_ID_OWNER_UUID = SynchedEntityData.m_135353_(EnderMan.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final int FLAG_TAME = 2;
    private Vec3 lastInteractPos = new Vec3(1.0, 1.0, 1.0);
    private FollowState followState = FollowState.SIT;

    public EndermanMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void EnderMan(EntityType pEntityType, Level pLevel, CallbackInfo ci) {
        this.setTamed(false);
    }

    @Inject(at={@At(value="HEAD")}, method={"registerGoals"})
    protected void registerGoals(CallbackInfo ci) {
        this.f_21345_.m_25352_(2, (Goal)new EnderSitWhenOrderedToGoal(this, (EnderMan)this));
        this.f_21345_.m_25352_(6, (Goal)new EnderFollowOwnerGoal(this, (EnderMan)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollWithinRadiusGoal(this, (EnderMan)this, 1.0, 0.0f));
    }

    @Override
    public boolean getFlag(int pFlagId) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & pFlagId) != 0;
    }

    @Override
    public void setFlag(int pFlagId, boolean pValue) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (pValue) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | pFlagId)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & ~pFlagId)));
        }
    }

    @Override
    public FollowState getFollowState() {
        return this.followState;
    }

    @Override
    public void setFollowState(FollowState followState) {
        this.followState = followState;
    }

    @Override
    public void setFollowState(String followState) {
        switch (followState) {
            case "SIT": {
                this.followState = FollowState.SIT;
                break;
            }
            case "FOLLOW": {
                this.followState = FollowState.FOLLOW;
                break;
            }
            case "WANDER": {
                this.followState = FollowState.WANDER;
                break;
            }
            default: {
                this.followState = FollowState.WANDER;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"teleport()Z"})
    protected void teleport(CallbackInfoReturnable<Boolean> cir) {
        this.followState = FollowState.WANDER;
    }

    @Inject(at={@At(value="HEAD")}, method={"isLookingAtMe"}, cancellable=true)
    void isLookingAtMe(Player pPlayer, CallbackInfoReturnable<Boolean> cir) {
        if (this.isTamed()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"customServerAiStep"}, cancellable=true)
    protected void customServerAiStep(CallbackInfo ci) {
        if (this.isTamed()) {
            super.m_8024_();
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD"), @At(value="RETURN")}, method={"hurt"}, cancellable=true)
    public void hurt(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        if (this.isTamed()) {
            this.m_21662_();
        }
        if (this.isTamed() && pSource.m_19385_().equals("drown") && this.m_20285_() && !this.m_20072_()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean m_20285_() {
        BlockPos blockpos = this.m_20183_();
        return this.f_19853_.m_46758_(blockpos) || this.f_19853_.m_46758_(new BlockPos((double)blockpos.m_123341_(), this.m_20191_().f_82292_, (double)blockpos.m_123343_()));
    }

    @Override
    public boolean isTamed() {
        return this.getFlag(2);
    }

    @Override
    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.getOwner();
    }

    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.isTamed() && (livingentity = this.getOwner()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity pEntity) {
        if (this.isTamed()) {
            LivingEntity livingentity = this.getOwner();
            if (pEntity == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(pEntity);
            }
        }
        return super.m_7307_(pEntity);
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_ID_OWNER_UUID)).orElse(null);
    }

    @Override
    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_ID_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Override
    public void setTamed(boolean pTamed) {
        this.setFlag(2, pTamed);
    }

    @Override
    public boolean tame(Player pPlayer) {
        this.setOwnerUUID(pPlayer.m_20148_());
        this.setTamed(true);
        this.f_19853_.m_7605_((Entity)this, (byte)7);
        return true;
    }

    @Override
    public Vec3 getLastInteractPos() {
        return this.lastInteractPos;
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41619_() && this.isTamed()) {
            InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.isOwnedBy((LivingEntity)pPlayer)) {
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.followState = this.followState.switchFollowState();
                pPlayer.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(this.followState.getFollowStateText())), true);
                this.lastInteractPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (!itemstack.m_41619_()) {
            if (this.isFood(itemstack)) {
                return this.fedFood(pPlayer, itemstack);
            }
            if (itemstack.m_150930_(Items.f_42402_) && this.isTamed()) {
                this.m_20225_(!this.m_20067_());
                pPlayer.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Silenced: " + this.m_20067_())), true);
            }
            if (itemstack.m_150930_(Items.f_42731_) && !this.m_21660_() && !this.isTamed()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.tame(pPlayer);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.tameableendermen$setOrderedToSit(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    @Override
    public boolean isFood(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    @Override
    public InteractionResult fedFood(Player pPlayer, ItemStack pStack) {
        boolean flag = this.handleEating(pPlayer, pStack);
        if (!pPlayer.m_150110_().f_35937_ && flag) {
            pStack.m_41774_(1);
        }
        if (this.f_19853_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public boolean handleEating(Player pPlayer, ItemStack pStack) {
        float f = 0.0f;
        if (pStack.m_150930_(Items.f_42730_)) {
            f = 10.0f;
        } else if (pStack.m_150930_(Items.f_42410_)) {
            f = 5.0f;
        }
        if (this.m_21223_() < this.m_21233_() && f > 0.0f) {
            this.m_5634_(f);
        }
        this.eating();
        this.m_146850_(GameEvent.f_157806_);
        return true;
    }

    @Override
    public void eating() {
        if (this.m_20067_()) {
            return;
        }
        SoundEvent soundevent = this.getEatingSound();
        if (soundevent == null) {
            return;
        }
        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
    }

    public int m_8132_() {
        return this.isInSittingPose() ? 20 : super.m_8132_();
    }

    @Override
    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    @Override
    public void setInSittingPose(boolean pSitting) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (pSitting) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    public boolean tameableendermen$isOrderedToSit() {
        return this.followState.name().equals("SIT");
    }

    @Override
    public void tameableendermen$setOrderedToSit(boolean pOrderedToSit) {
        if (pOrderedToSit) {
            this.followState = FollowState.SIT;
            return;
        }
        this.followState = FollowState.FOLLOW;
    }

    @Override
    @Nullable
    public SoundEvent getEatingSound() {
        return SoundEvents.f_11899_;
    }

    @Override
    public void m_6043_() {
        if (this.isTamed()) {
            return;
        }
        super.m_6043_();
    }

    @Override
    @Inject(at={@At(value="HEAD")}, method={"defineSynchedData"})
    public void defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_OWNER_UUID, Optional.empty());
    }

    @Override
    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    public void addAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.m_128379_("Tame", this.isTamed());
        if (this.getOwnerUUID() != null) {
            pCompound.m_128362_("Owner", this.getOwnerUUID());
        }
        pCompound.m_128359_("FollowState", this.followState.name());
        pCompound.m_128365_("LastInteractPos", (Tag)this.m_20063_(new double[]{this.lastInteractPos.m_7096_(), this.lastInteractPos.m_7098_(), this.lastInteractPos.m_7094_()}));
    }

    @Override
    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    public void readAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        UUID uuid;
        this.setTamed(pCompound.m_128471_("Tame"));
        if (pCompound.m_128403_("Owner")) {
            uuid = pCompound.m_128342_("Owner");
        } else {
            String s = pCompound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
        this.setFollowState(pCompound.m_128461_("FollowState"));
        ListTag listTag = pCompound.m_128437_("LastInteractPos", 6);
        this.lastInteractPos = new Vec3(listTag.m_128772_(0), listTag.m_128772_(1), listTag.m_128772_(2));
    }

    @Override
    public void spawnTamingParticles(boolean pTamed) {
        SimpleParticleType particleoptions = pTamed ? ParticleTypes.f_123750_ : ParticleTypes.f_123762_;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    @Override
    public void m_7822_(byte pId) {
        if (pId == 7) {
            this.spawnTamingParticles(true);
        } else if (pId == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.m_7822_(pId);
        }
    }
}

