package rs.onako2.iwie.entity;

import net.minecraft.class_10255;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1391;
import net.minecraft.class_1477;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;
import rs.onako2.iwie.IWantItEarlier;

public class NautilusEntity extends AbstractNautilusEntity {
    private static final class_2940<Boolean> CHILD = class_2945.method_12791(NautilusEntity.class, class_2943.field_13323);
    private static final class_2940<Boolean> SADDLED =
            class_2945.method_12791(NautilusEntity.class, class_2943.field_13323);
    public int harnessColor = -2;
    public boolean hasPassenger = false;
    public boolean isTempted = false;
    protected int breedingAge;
    protected int forcedAge;

    public NautilusEntity(class_1299<? extends class_1477> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_5782() || this.method_6109()) {
            return super.method_5992(player, hand);
        } else {
            class_1799 itemStack = player.method_5998(hand);
            if (!itemStack.method_7960()) {
                class_1269 actionResult = itemStack.method_7920(player, this, hand);
                if (player.method_5998(hand).method_31574(class_1802.field_8175) && !this.method_66672()) {
                    this.equipSaddle(itemStack);
                    return class_1269.field_5812;
                }

                if (!this.method_56677()) {
                    this.equipNautilusArmor(player, itemStack);
                    return class_1269.field_5812;
                }

                if (actionResult.method_23665()) {
                    return actionResult;
                }
            }

            if (this.field_56535.method_66659(class_1304.field_55946) != null && this.field_56535.method_66659(class_1304.field_55946).method_7947() >= 1) {
                this.putPlayerOnBack(player);
            }
            return class_1269.field_5812;
        }
    }

    public void equipSaddle(class_1799 stack) {
        this.method_24834(class_1304.field_55946, stack);
    }

    public void equipNautilusArmor(class_1657 player, class_1799 stack) {
        if (this.method_63623(stack, class_1304.field_48824)) {
            this.method_56678(stack.method_60504(1, player));
        }
    }

    protected void method_5619() {
        if (!this.method_6109() && this.method_5765() && this.method_5854() instanceof class_10255 abstractBoatEntity && !abstractBoatEntity.method_64488(this)) {
            this.method_5848();
        }
    }

    @Override
    public boolean method_6109() {
        return this.method_5618() < 0;
    }

    @Override
    public void method_7217(boolean baby) {
        this.method_5614(baby ? -24000 : 0);
    }

    protected void putPlayerOnBack(class_1657 player) {
        if (!this.method_37908().field_9236) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804(this);
        }
    }


    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (entityData == null) {
            entityData = new class_1296.class_4697(true);
        }

        class_1296.class_4697 passiveData = (class_1296.class_4697) entityData;
        if (passiveData.method_22436() && passiveData.method_22432() > 0 && world.method_8409().method_43057() <= passiveData.method_22437()) {
            this.method_5614(-24000);
        }

        passiveData.method_22435();
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void method_5674(class_2940<?> data) {
        if (CHILD.equals(data)) {
            this.method_18382();
        }

        super.method_5674(data);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CHILD, false);
        builder.method_56912(SADDLED, false);
    }

    @Override
    public boolean method_5782() {
        return hasPassenger || super.method_5782();
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201
                .method_6277(
                        0,
                        new class_1391(
                                this, 1.0, stack -> stack.method_31574(class_1802.field_8323), false, 3.0
                        ) {
                            @Override
                            protected void method_70684(class_1657 player) {
                                class_243 vec3d = player.method_19538().method_1020(this.field_6616.method_19538());
                                vec3d = vec3d.method_1029().method_1021(0.1);
                                this.field_6616.method_5784(class_1313.field_6308, vec3d);
                            }

                            @Override
                            public boolean method_6264() {
                                return super.method_6264() && this.field_6616.method_6057(this.field_6617);
                            }

                            @Override
                            public void method_6269() {
                                NautilusEntity.this.isTempted = true;
                                NautilusEntity.this.field_54298 = class_243.field_1353;
                                super.method_6269();
                            }

                            @Override
                            public void method_6270() {
                                NautilusEntity.this.isTempted = false;
                                NautilusEntity.this.field_54298 = class_243.field_1353;
                                super.method_6270();
                            }
                        }
                );
    }

    public boolean canBeSaddled() {
        return !method_6109() && !isSaddled();
    }

    public boolean isSaddled() {
        return this.field_6011.method_12789(SADDLED);
    }

    public void saddle(@Nullable class_3419 sound) {
        this.field_6011.method_12778(SADDLED, true);
    }

    @Override
    public void method_5773() {
        if (method_5782()) {
            if (method_31483() instanceof class_1657 player) {
                if (player.method_5869()) {
                    player.method_6092(new class_1293(IWantItEarlier.BREATH_OF_NAUTILUS, 39, 0, true, false, true));
                }
            }
        }
        super.method_5773();
    }

    public int method_5618() {
        if (this.method_37908().field_9236) {
            return this.field_6011.method_12789(CHILD) ? -1 : 1;
        } else {
            return this.field_5950;
        }
    }

    public void method_5614(int age) {
        int i = this.method_5618();
        this.field_5950 = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.field_6011.method_12778(CHILD, age < 0);
            this.method_5619();
        }
    }

    public void method_5620(int age, boolean overGrow) {
        int i = this.method_5618();
        i += age * 20;
        if (i > 0) {
            i = 0;
        }

        int k = 0;
        this.method_5614(i);
        if (overGrow) {
            this.field_5948 += k;
        }

        if (this.method_5618() == 0) {
            this.method_5614(this.field_5948);
        }
    }

    public void method_5615(int age) {
        this.method_5620(age, false);
    }

    @Override
    public void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71465("Age", this.method_5618());
        view.method_71465("ForcedAge", this.field_5948);
        view.method_71472("Saddled", this.isSaddled());
    }

    @Override
    public void method_5749(class_11368 view) {
        super.method_5749(view);
        this.method_5614(view.method_71424("Age", 0));
        this.field_5948 = view.method_71424("ForcedAge", 0);
    }

    public static class SwimGoal extends class_1477.class_1479 {
        private final NautilusEntity squid;

        public SwimGoal(class_1477 squid) {
            super(squid);
            this.squid = (NautilusEntity) squid;
        }

        @Override
        public boolean method_6264() {
            return !squid.method_5782() && !squid.isTempted;
        }

        @Override
        public void method_6268() {
            if (squid.isTempted) {
                method_6270();
                return;
            }
            super.method_6268();
        }

        @Override
        public void method_6270() {
            super.method_6270();
            squid.field_54298 = class_243.field_1353;
        }
    }
}
