/*
 * Decompiled with CFR 0.152.
 */
package rs.onako2.iwie.entity;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_10131;
import net.minecraft.class_10255;
import net.minecraft.class_10583;
import net.minecraft.class_10599;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1477;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import rs.onako2.iwie.IWantItEarlier;
import rs.onako2.iwie.entity.AbstractNautilusEntity;

public class NautilusEntity
extends AbstractNautilusEntity {
    private static final class_2940<Boolean> CHILD = class_2945.method_12791(NautilusEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SADDLED = class_2945.method_12791(NautilusEntity.class, (class_2941)class_2943.field_13323);
    public boolean hasPassenger = false;
    public boolean isTempted = false;
    protected int breedingAge;
    protected int forcedAge;
    private int loveTicks = 0;
    @Nullable
    private class_10583<class_3222> lovingPlayer;
    protected class_1277 field_6962;

    public NautilusEntity(class_1299<? extends class_1477> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void breed(class_3218 world, NautilusEntity other) {
        class_1296 passiveEntity = this.method_5613(world, (class_1296)other);
        if (passiveEntity != null) {
            passiveEntity.method_7217(true);
            passiveEntity.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), 0.0f, 0.0f);
            this.breed(world, other, passiveEntity);
            world.method_30771((class_1297)passiveEntity);
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)IWantItEarlier.NAUTILUS_ENTITY.method_5883((class_1937)world, class_3730.field_16466);
    }

    public void resetLoveTicks() {
        this.loveTicks = 0;
    }

    @Nullable
    public class_3222 getLovingPlayer() {
        try {
            return (class_3222)this.field_6002.method_18470(this.lovingPlayer.method_66263());
        }
        catch (NoClassDefFoundError | NullPointerException e) {
            return null;
        }
    }

    public void breed(class_3218 world, NautilusEntity other, @Nullable class_1296 baby) {
        Optional.ofNullable(this.getLovingPlayer()).or(() -> Optional.ofNullable(other.getLovingPlayer())).ifPresent(player -> player.method_7281(class_3468.field_15410));
        this.method_5614(6000);
        other.method_5614(6000);
        this.resetLoveTicks();
        other.resetLoveTicks();
        world.method_8421((class_1297)this, (byte)18);
        if (world.method_64395().method_8355(class_1928.field_19391)) {
            world.method_8649((class_1297)new class_1303((class_1937)world, this.method_23317(), this.method_23318(), this.method_23321(), this.method_59922().method_43048(7) + 1));
        }
    }

    public boolean isBreedingItem(class_1799 stack) {
        return stack.method_31574(class_1802.field_8323);
    }

    protected void method_6475(class_1657 player, class_1268 hand, class_1799 stack) {
        int i = stack.method_7947();
        class_10131 useRemainderComponent = null;
        try {
            useRemainderComponent = (class_10131)stack.method_58694(class_9334.field_53965);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        stack.method_57008(1, (class_1309)player);
        if (useRemainderComponent != null) {
            class_1799 itemStack = useRemainderComponent.method_62863(stack, i, player.method_56992(), arg_0 -> ((class_1657)player).method_64399(arg_0));
            player.method_6122(hand, itemStack);
        } else {
            player.method_6122(hand, stack);
        }
    }

    public void lovePlayer(@Nullable class_1657 player) {
        this.loveTicks = 600;
        if (player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            try {
                this.lovingPlayer = class_10583.method_73299((class_10599)serverPlayerEntity);
            }
            catch (NoClassDefFoundError | NoSuchMethodError e) {
                try {
                    this.lovingPlayer = (class_10583)class_10583.class.getDeclaredConstructor(UUID.class).newInstance(serverPlayerEntity.method_5667());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        this.field_6002.method_8421((class_1297)this, (byte)18);
    }

    protected void playEatSound() {
        this.method_5783(class_3417.field_16439, 0.9f, 1.0f);
    }

    public boolean canEat() {
        return this.loveTicks <= 0;
    }

    public boolean isInLove() {
        return this.loveTicks > 0;
    }

    public boolean method_66672() {
        try {
            return super.method_66672();
        }
        catch (NoSuchMethodError e) {
            return this.isSaddled();
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isBreedingItem(itemStack)) {
            int i = this.method_5618();
            if (player instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)player;
                if (i == 0 && this.canEat()) {
                    this.method_6475(player, hand, itemStack);
                    this.lovePlayer((class_1657)serverPlayerEntity);
                    this.playEatSound();
                    NautilusEntity entity = this.field_6002.method_8333((class_1297)this, this.method_5829().method_1009(32.0, 32.0, 32.0), entityx -> entityx instanceof NautilusEntity && ((NautilusEntity)((Object)entityx)).isInLove()).stream().findAny().orElse(null);
                    if (entity != null) {
                        this.breed((class_3218)this.field_6002, entity);
                    }
                    return class_1269.field_52422;
                }
            }
            if (this.method_6109()) {
                this.method_6475(player, hand, itemStack);
                this.method_5620(NautilusEntity.method_41321((int)(-i)), true);
                this.playEatSound();
                return class_1269.field_5812;
            }
            if (this.field_6002.field_9236) {
                return class_1269.field_21466;
            }
        }
        if (this.method_5782() || this.method_6109()) {
            return super.method_5992(player, hand);
        }
        if (!itemStack.method_7960()) {
            class_1269 actionResult = itemStack.method_7920(player, (class_1309)this, hand);
            if (player.method_5998(hand).method_31574(class_1802.field_8175) && !this.method_66672()) {
                this.equipSaddle(itemStack);
                return class_1269.field_5812;
            }
            if (!this.method_56677()) {
                this.equipNautilusArmor(player, itemStack);
                return class_1269.field_5812;
            }
            if (actionResult.method_23665()) {
                return actionResult;
            }
        }
        if (this.isSaddled()) {
            this.putPlayerOnBack(player);
        }
        return class_1269.field_5812;
    }

    public void equipSaddle(class_1799 stack) {
        try {
            this.method_24834(class_1304.field_55946, stack);
        }
        catch (NoSuchFieldError | NoSuchMethodError e) {
            this.saddle(null);
        }
    }

    public void equipNautilusArmor(class_1657 player, class_1799 stack) {
        if (this.method_63623(stack, class_1304.field_48824)) {
            this.method_56678(stack.method_60504(1, (class_1309)player));
        }
    }

    protected void method_5619() {
        class_10255 abstractBoatEntity;
        class_1297 class_12972;
        if (!this.method_6109() && this.method_5765() && (class_12972 = this.method_5854()) instanceof class_10255 && !(abstractBoatEntity = (class_10255)class_12972).method_64488((class_1297)this)) {
            this.method_5848();
        }
    }

    public boolean method_6109() {
        return this.method_5618() < 0;
    }

    public void method_7217(boolean baby) {
        this.method_5614(baby ? -24000 : 0);
    }

    protected void putPlayerOnBack(class_1657 player) {
        if (!this.field_6002.field_9236) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804((class_1297)this);
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1296.class_4697 passiveData;
        if (entityData == null) {
            entityData = new class_1296.class_4697(true);
        }
        if ((passiveData = (class_1296.class_4697)entityData).method_22436() && passiveData.method_22432() > 0 && world.method_8409().method_43057() <= passiveData.method_22437()) {
            this.method_5614(-24000);
        }
        passiveData.method_22435();
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void method_5674(class_2940<?> data) {
        if (CHILD.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CHILD, (Object)false);
        builder.method_56912(SADDLED, (Object)false);
    }

    public boolean method_5782() {
        return this.hasPassenger || super.method_5782();
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new NautilusTemptGoal((class_1314)this, 1.0, stack -> stack.method_31574(class_1802.field_8323), false, 3.0));
    }

    public boolean canBeSaddled() {
        return !this.method_6109() && !this.isSaddled();
    }

    public boolean isSaddled() {
        try {
            return this.field_56535.method_66659(class_1304.field_55946) != null && this.field_56535.method_66659(class_1304.field_55946).method_7947() >= 1 || (Boolean)this.field_6011.method_12789(SADDLED) != false;
        }
        catch (NoSuchFieldError e) {
            return (Boolean)this.field_6011.method_12789(SADDLED);
        }
    }

    public void saddle(@Nullable class_3419 sound) {
        this.field_6011.method_12778(SADDLED, (Object)true);
    }

    public void method_5773() {
        class_1657 player;
        class_1297 class_12972;
        if (this.method_5782() && (class_12972 = this.method_31483()) instanceof class_1657 && (player = (class_1657)class_12972).method_5869()) {
            player.method_6092(new class_1293(IWantItEarlier.BREATH_OF_NAUTILUS, 39, 0, true, false, true));
        }
        super.method_5773();
    }

    public int method_5618() {
        if (this.field_6002.field_9236) {
            return (Boolean)this.field_6011.method_12789(CHILD) != false ? -1 : 1;
        }
        return this.breedingAge;
    }

    public void method_5614(int age) {
        int i = this.method_5618();
        this.breedingAge = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.field_6011.method_12778(CHILD, (Object)(age < 0 ? 1 : 0));
            this.method_5619();
        }
    }

    public void method_5620(int age, boolean overGrow) {
        int i = this.method_5618();
        if ((i += age * 20) > 0) {
            i = 0;
        }
        int k = 0;
        this.method_5614(i);
        if (overGrow) {
            this.forcedAge += k;
        }
        if (this.method_5618() == 0) {
            this.method_5614(this.forcedAge);
        }
    }

    public void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71465("Age", this.method_5618());
        view.method_71465("ForcedAge", this.forcedAge);
        view.method_71472("Saddled", this.isSaddled());
        view.method_71465("InLove", this.loveTicks);
        class_10583.method_71612(this.lovingPlayer, (class_11372)view, (String)"LoveCause");
    }

    public void method_5749(class_11368 view) {
        super.method_5749(view);
        this.method_5614(view.method_71424("Age", 0));
        this.forcedAge = view.method_71424("ForcedAge", 0);
        this.loveTicks = view.method_71424("InLove", 0);
        this.lovingPlayer = class_10583.method_66262((class_11368)view, (String)"LoveCause");
    }

    public void method_5652(class_2487 nbt) {
        try {
            Method method = ((Object)((Object)this)).getClass().getSuperclass().getMethod("writeCustomDataToNbt", class_2487.class);
            method.invoke((Object)this, nbt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nbt.method_10569("Age", this.method_5618());
        nbt.method_10569("ForcedAge", this.forcedAge);
        nbt.method_10556("Saddled", this.isSaddled());
        nbt.method_10569("InLove", this.loveTicks);
    }

    public void method_5749(class_2487 nbt) {
        try {
            Method method = ((Object)((Object)this)).getClass().getSuperclass().getMethod("readCustomDataFromNbt", class_2487.class);
            method.invoke((Object)this, nbt);
        }
        catch (Exception method) {
            // empty catch block
        }
        try {
            this.method_5614(nbt.method_68083("Age", 0));
            this.forcedAge = nbt.method_68083("ForcedAge", 0);
            this.loveTicks = nbt.method_68083("InLove", 0);
        }
        catch (NoSuchMethodError e) {
            try {
                this.method_5614(this.getOldInt(nbt, "Age"));
                this.forcedAge = this.getOldInt(nbt, "ForcedAge");
                this.loveTicks = this.getOldInt(nbt, "InLove");
            }
            catch (IllegalAccessException | NoSuchMethodError | NoSuchMethodException | InvocationTargetException eMogus) {
                e.printStackTrace();
                eMogus.printStackTrace();
            }
        }
    }

    private int getOldInt(class_2487 nbt, String key) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = class_2487.class.getMethod("method_10550", String.class);
        return (Integer)method.invoke((Object)nbt, key);
    }

    public class NautilusTemptGoal
    extends class_1391 {
        private final double range;

        public NautilusTemptGoal(class_1314 entity, double speed, Predicate<class_1799> foodPredicate, boolean canBeScared, double range) {
            super(entity, speed, foodPredicate, canBeScared);
            this.range = range;
        }

        protected void method_70684(class_1657 player) {
            class_243 vec3d = player.field_22467.method_1020(NautilusEntity.this.field_22467);
            vec3d = vec3d.method_1029().method_1021(0.1);
            NautilusEntity.this.method_5784(class_1313.field_6308, vec3d);
        }

        public void method_6268() {
            NautilusEntity.this.method_5988().method_6226((class_1297)this.field_6617, (float)(NautilusEntity.this.method_5986() + 20), (float)NautilusEntity.this.method_5978());
            if (NautilusEntity.this.method_5858((class_1297)this.field_6617) < this.range * this.range) {
                try {
                    this.method_70685();
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                this.method_70684(this.field_6617);
            }
        }

        public boolean method_6264() {
            return super.method_6264() && NautilusEntity.this.method_6057((class_1297)this.field_6617);
        }

        public void method_6269() {
            NautilusEntity.this.isTempted = true;
            NautilusEntity.this.field_54298 = class_243.field_1353;
            super.method_6269();
        }

        public void method_6270() {
            NautilusEntity.this.isTempted = false;
            NautilusEntity.this.field_54298 = class_243.field_1353;
            super.method_6270();
        }
    }

    public static class SwimGoal
    extends class_1477.class_1479 {
        private final NautilusEntity nautilus;

        public SwimGoal(class_1477 nautilus) {
            super(nautilus);
            this.nautilus = (NautilusEntity)nautilus;
        }

        public boolean method_6264() {
            return !this.nautilus.method_5782() && !this.nautilus.isTempted;
        }

        public void method_6268() {
            if (this.nautilus.isTempted) {
                this.method_6270();
                return;
            }
            super.method_6268();
        }

        public void method_6270() {
            super.method_6270();
            this.nautilus.field_54298 = class_243.field_1353;
        }
    }
}

