package rs.onako2.iwie.entity;

import org.jetbrains.annotations.Nullable;
import rs.onako2.iwie.IWantItEarlier;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_10131;
import net.minecraft.class_10255;
import net.minecraft.class_10583;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1391;
import net.minecraft.class_1477;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_6024;
import net.minecraft.class_9334;

public class NautilusEntity extends AbstractNautilusEntity {
    private static final class_2940<Boolean> CHILD = class_2945.method_12791(NautilusEntity.class, class_2943.field_13323);
    private static final class_2940<Boolean> SADDLED =
            class_2945.method_12791(NautilusEntity.class, class_2943.field_13323);
    public boolean hasPassenger = false;
    public boolean isTempted = false;
    protected int breedingAge;
    protected int forcedAge;
    private int loveTicks = 0;
    @Nullable
    private class_10583<class_3222> lovingPlayer;

    public NautilusEntity(class_1299<? extends class_1477> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void breed(class_3218 world, NautilusEntity other) {
        class_1296 passiveEntity = this.method_5613(world, other);
        if (passiveEntity != null) {
            passiveEntity.method_7217(true);
            passiveEntity.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), 0.0F, 0.0F);
            this.breed(world, other, passiveEntity);
            world.method_30771(passiveEntity);
        }
    }


    @Override
    public @Nullable class_1296 method_5613(class_3218 world, class_1296 entity) {
        return IWantItEarlier.NAUTILUS_ENTITY.method_5883(world, class_3730.field_16466);
    }

    public void resetLoveTicks() {
        this.loveTicks = 0;
    }

    @Nullable
    public class_3222 getLovingPlayer() {
        return (class_3222) method_37908().method_18470(Objects.requireNonNull(lovingPlayer).method_66263());
    }

    public void breed(class_3218 world, NautilusEntity other, @Nullable class_1296 baby) {
        Optional.ofNullable(this.getLovingPlayer()).or(() -> Optional.ofNullable(other.getLovingPlayer())).ifPresent(player -> {
            player.method_7281(class_3468.field_15410);
        });
        this.method_5614(6000);
        other.method_5614(6000);
        this.resetLoveTicks();
        other.resetLoveTicks();
        world.method_8421(this, class_6024.field_30043);
        if (world.method_64395().method_8355(class_1928.field_19391)) {
            world.method_8649(new class_1303(world, this.method_23317(), this.method_23318(), this.method_23321(), this.method_59922().method_43048(7) + 1));
        }
    }

    public boolean isBreedingItem(class_1799 stack) {
        return stack.method_31574(class_1802.field_8323);
    }

    protected void eat(class_1657 player, class_1268 hand, class_1799 stack) {
        int i = stack.method_7947();
        class_10131 useRemainderComponent = stack.method_58694(class_9334.field_53965);
        stack.method_57008(1, player);
        if (useRemainderComponent != null) {
            class_1799 itemStack = useRemainderComponent.method_62863(stack, i, player.method_56992(), player::method_64399);
            player.method_6122(hand, itemStack);
        }
    }

    public void lovePlayer(@Nullable class_1657 player) {
        this.loveTicks = 600;
        if (player instanceof class_3222 serverPlayerEntity) {
            this.lovingPlayer = new class_10583<>(serverPlayerEntity);
        }

        this.method_37908().method_8421(this, class_6024.field_30043);
    }

    protected void playEatSound() {
        this.method_5783(class_3417.field_16439, 0.9F, 1.0F);
    }

    public boolean canEat() {
        return this.loveTicks <= 0;
    }

    public boolean isInLove() {
        return this.loveTicks > 0;
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);

        if (this.isBreedingItem(itemStack)) {
            int i = this.method_5618();
            if (player instanceof class_3222 serverPlayerEntity && i == 0 && this.canEat()) {
                this.eat(player, hand, itemStack);
                this.lovePlayer(serverPlayerEntity);
                this.playEatSound();
                NautilusEntity entity = (NautilusEntity) method_37908().method_8333(this, this.method_5829().method_1009(32, 32, 32), entityx -> entityx instanceof NautilusEntity && ((NautilusEntity) entityx).isInLove()).stream().findAny().orElse(null);
                if (entity != null) {
                    breed((class_3218) method_37908(), entity);
                }
                return class_1269.field_52422;
            }

            if (this.method_6109()) {
                this.eat(player, hand, itemStack);
                this.method_5620(method_41321(-i), true);
                this.playEatSound();
                return class_1269.field_5812;
            }

            if (this.method_37908().field_9236) {
                return class_1269.field_21466;
            }
        }
        if (this.method_5782() || this.method_6109()) {
            return super.method_5992(player, hand);
        } else {
            if (!itemStack.method_7960()) {
                class_1269 actionResult = itemStack.method_7920(player, this, hand);
                if (player.method_5998(hand).method_31574(class_1802.field_8175) && !this.method_66672()) {
                    this.equipSaddle(itemStack);
                    return class_1269.field_5812;
                }

                if (!this.method_56677()) {
                    this.equipNautilusArmor(player, itemStack);
                    return class_1269.field_5812;
                }

                if (actionResult.method_23665()) {
                    return actionResult;
                }
            }

            if (isSaddled()) {
                this.putPlayerOnBack(player);
            }
            return class_1269.field_5812;
        }
    }

    public void equipSaddle(class_1799 stack) {
        this.method_24834(class_1304.field_55946, stack);
    }

    public void equipNautilusArmor(class_1657 player, class_1799 stack) {
        if (this.method_63623(stack, class_1304.field_48824)) {
            this.method_56678(stack.method_60504(1, player));
        }
    }

    protected void method_5619() {
        if (!this.method_6109() && this.method_5765() && this.method_5854() instanceof class_10255 abstractBoatEntity && !abstractBoatEntity.method_64488(this)) {
            this.method_5848();
        }
    }

    @Override
    public boolean method_6109() {
        return this.method_5618() < 0;
    }

    @Override
    public void method_7217(boolean baby) {
        this.method_5614(baby ? -24000 : 0);
    }

    protected void putPlayerOnBack(class_1657 player) {
        if (!this.method_37908().field_9236) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804(this);
        }
    }


    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (entityData == null) {
            entityData = new class_1296.class_4697(true);
        }

        class_1296.class_4697 passiveData = (class_1296.class_4697) entityData;
        if (passiveData.method_22436() && passiveData.method_22432() > 0 && world.method_8409().method_43057() <= passiveData.method_22437()) {
            this.method_5614(-24000);
        }

        passiveData.method_22435();
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void method_5674(class_2940<?> data) {
        if (CHILD.equals(data)) {
            this.method_18382();
        }

        super.method_5674(data);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CHILD, false);
        builder.method_56912(SADDLED, false);
    }

    @Override
    public boolean method_5782() {
        return hasPassenger || super.method_5782();
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201
                .method_6277(
                        0,
                        new NautilusTemptGoal(
                                this, 1.0, stack -> stack.method_31574(class_1802.field_8323), false, 3.0
                        )
                );
    }

    public boolean canBeSaddled() {
        return !method_6109() && !isSaddled();
    }

    public boolean isSaddled() {
        return this.field_56535.method_66659(class_1304.field_55946) != null && this.field_56535.method_66659(class_1304.field_55946).method_7947() >= 1;
    }

    public void saddle(@Nullable class_3419 sound) {
        this.field_6011.method_12778(SADDLED, true);
    }

    @Override
    public void method_5773() {
        if (method_5782()) {
            if (method_31483() instanceof class_1657 player) {
                if (player.method_5869()) {
                    player.method_6092(new class_1293(IWantItEarlier.BREATH_OF_NAUTILUS, 39, 0, true, false, true));
                }
            }
        }
        super.method_5773();
    }

    public int method_5618() {
        if (this.method_37908().field_9236) {
            return this.field_6011.method_12789(CHILD) ? -1 : 1;
        } else {
            return this.field_5950;
        }
    }

    public void method_5614(int age) {
        int i = this.method_5618();
        this.field_5950 = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.field_6011.method_12778(CHILD, age < 0);
            this.method_5619();
        }
    }

    public void method_5620(int age, boolean overGrow) {
        int i = this.method_5618();
        i += age * 20;
        if (i > 0) {
            i = 0;
        }

        int k = 0;
        this.method_5614(i);
        if (overGrow) {
            this.field_5948 += k;
        }

        if (this.method_5618() == 0) {
            this.method_5614(this.field_5948);
        }
    }

    @Override
    public void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71465("Age", this.method_5618());
        view.method_71465("ForcedAge", this.field_5948);
        view.method_71472("Saddled", this.isSaddled());
        view.method_71465("InLove", this.loveTicks);
        class_10583.method_71612(this.lovingPlayer, view, "LoveCause");
    }

    @Override
    public void method_5749(class_11368 view) {
        super.method_5749(view);
        this.method_5614(view.method_71424("Age", 0));
        this.field_5948 = view.method_71424("ForcedAge", 0);
        this.loveTicks = view.method_71424("InLove", 0);
        this.lovingPlayer = class_10583.method_66262(view, "LoveCause");
    }

    // writeCustomDataToNbt 1.21.5 and lower support
    public void method_5652(class_2487 nbt) {
        try {
            Method method = this.getClass().getSuperclass().getMethod("writeCustomDataToNbt", class_2487.class);
            method.invoke(this, nbt);
        } catch (Exception ignored) {}

        nbt.method_10569("Age", this.method_5618());
        nbt.method_10569("ForcedAge", this.field_5948);
        nbt.method_10556("Saddled", this.isSaddled());
        nbt.method_10569("InLove", this.loveTicks);
        // bruh too complicated, trust me brother
        //LazyEntityReference.writeData(this.lovingPlayer, view, "LoveCause");
    }

    // readCustomDataFromNbt 1.21.5 and lower support
    public void method_5749(class_2487 nbt) {
        try {
            Method method = this.getClass().getSuperclass().getMethod("readCustomDataFromNbt", class_2487.class);
            method.invoke(this, nbt);
        } catch (Exception ignored) {}

        this.method_5614(nbt.method_68083("Age", 0));
        this.field_5948 = nbt.method_68083("ForcedAge", 0);
        this.loveTicks = nbt.method_68083("InLove", 0);
        // bruh too complicated, trust me brother
        //this.lovingPlayer = LazyEntityReference.fromData(nbt, "LoveCause");
    }

    public static class SwimGoal extends class_1477.class_1479 {
        private final NautilusEntity nautilus;

        public SwimGoal(class_1477 nautilus) {
            super(nautilus);
            this.nautilus = (NautilusEntity) nautilus;
        }

        @Override
        public boolean method_6264() {
            return !nautilus.method_5782() && !nautilus.isTempted;
        }

        @Override
        public void method_6268() {
            if (nautilus.isTempted) {
                method_6270();
                return;
            }
            super.method_6268();
        }

        @Override
        public void method_6270() {
            super.method_6270();
            nautilus.field_54298 = class_243.field_1353;
        }
    }

    public class NautilusTemptGoal extends class_1391 {
        private final double range;

        public NautilusTemptGoal(class_1314 entity, double speed, Predicate<class_1799> foodPredicate, boolean canBeScared, double range) {
            super(entity, speed, foodPredicate, canBeScared);
            this.range = range;
        }

        protected void method_70684(class_1657 player) {
            class_243 vec3d = player.method_19538().method_1020(NautilusEntity.this.method_19538());
            vec3d = vec3d.method_1029().method_1021(0.1);
            NautilusEntity.this.method_5784(class_1313.field_6308, vec3d);
        }

        @Override
        public void method_6268() {
            NautilusEntity.this.method_5988().method_6226(this.field_6617, NautilusEntity.this.method_5986() + 20, NautilusEntity.this.method_5978());
            if (NautilusEntity.this.method_5858(this.field_6617) < this.range * this.range) {
                try {
                    this.method_70685();
                } catch (NoSuchMethodError e) {
                    // we don't care about this anyway but better be safe than sorry
                }
            } else {
                this.method_70684(this.field_6617);
            }
        }

        @Override
        public boolean method_6264() {
            return super.method_6264() && NautilusEntity.this.method_6057(this.field_6617);
        }

        @Override
        public void method_6269() {
            NautilusEntity.this.isTempted = true;
            NautilusEntity.this.field_54298 = class_243.field_1353;
            super.method_6269();
        }

        @Override
        public void method_6270() {
            NautilusEntity.this.isTempted = false;
            NautilusEntity.this.field_54298 = class_243.field_1353;
            super.method_6270();
        }
    }
}
