/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.enhanced_nature.main;

import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import xxrexraptorxx.enhanced_nature.blocks.BlockQuicksand;

public class ModBlocks {
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"enhanced_nature");
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"enhanced_nature");
    public static final DeferredBlock<BlockQuicksand> QUICK_SAND = ModBlocks.registerBlock("quicksand", properties -> new BlockQuicksand(properties.strength(0.65f, 0.0f).sound(SoundType.SAND).mapColor(MapColor.SAND).noOcclusion().instrument(NoteBlockInstrument.SNARE)));

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
    }

    public static <T extends Block> DeferredBlock<T> registerBlock(String name, Function<BlockBehaviour.Properties, T> blockCreator) {
        DeferredBlock toReturn = BLOCKS.register(name, () -> (Block)blockCreator.apply(BlockBehaviour.Properties.of().setId(ModBlocks.blockId(name))));
        ModBlocks.registerBlockItems(name, toReturn);
        return toReturn;
    }

    public static <T extends Block> void registerBlockItems(String name, DeferredBlock<T> block) {
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().setId(ModBlocks.itemId(name)).useBlockDescriptionPrefix()));
    }

    public static ResourceKey<Block> blockId(String name) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enhanced_nature", (String)name));
    }

    public static ResourceKey<Item> itemId(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enhanced_nature", (String)name));
    }
}

