/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.blocks.door;

import com.hfr.blocks.ModBlocks;
import com.hfr.tileentity.machine.TileEntityHatch;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockSeal
extends Block {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;

    public BlockSeal(Material p_i45394_1_) {
        super(p_i45394_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconTop = iconRegister.func_94245_a("hfr:seal_frame");
        this.field_149761_L = iconRegister.func_94245_a("hfr:seal_controller");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if ((metadata %= 4) == 0 || metadata == 1) {
            metadata += 4;
        }
        return side == 1 ? this.iconTop : (side == 0 ? this.iconTop : (metadata == 0 && side == 3 ? this.field_149761_L : (side == metadata ? this.field_149761_L : this.iconTop)));
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.func_150898_a((Block)this);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block1 = world.func_147439_a(x, y, z - 1);
            Block block2 = world.func_147439_a(x, y, z + 1);
            Block block3 = world.func_147439_a(x - 1, y, z);
            Block block4 = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (block1.func_149730_j() && !block2.func_149730_j()) {
                b0 = 3;
            }
            if (block2.func_149730_j() && !block1.func_149730_j()) {
                b0 = 2;
            }
            if (block3.func_149730_j() && !block4.func_149730_j()) {
                b0 = 1;
            }
            if (block4.func_149730_j() && !block3.func_149730_j()) {
                b0 = 0;
            }
            world.func_72921_c(x, y, z, b0, 2);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (i == 1) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        if (i == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (i == 3) {
            world.func_72921_c(x, y, z, 0, 2);
        }
    }

    public static int getFrameSize(World world, int x, int y, int z) {
        int max = 7;
        for (int size = 1; size < max; ++size) {
            int Z;
            int X;
            boolean valid = true;
            int xOff = 0;
            int zOff = 0;
            if (world.func_72805_g(x, y, z) % 4 == 2) {
                zOff += size;
            }
            if (world.func_72805_g(x, y, z) % 4 == 3) {
                zOff -= size;
            }
            if (world.func_72805_g(x, y, z) % 4 == 0) {
                xOff += size;
            }
            if (world.func_72805_g(x, y, z) % 4 == 1) {
                xOff -= size;
            }
            for (X = x - size; X <= x + size; ++X) {
                if (world.func_147439_a(X + xOff, y, z + size + zOff) == ModBlocks.seal_frame || world.func_147439_a(X + xOff, y, z + size + zOff) == ModBlocks.seal_controller) continue;
                valid = false;
            }
            for (X = x - size; X <= x + size; ++X) {
                if (world.func_147439_a(X + xOff, y, z - size + zOff) == ModBlocks.seal_frame || world.func_147439_a(X + xOff, y, z - size + zOff) == ModBlocks.seal_controller) continue;
                valid = false;
            }
            for (Z = z - size; Z <= z + size; ++Z) {
                if (world.func_147439_a(x - size + xOff, y, Z + zOff) == ModBlocks.seal_frame || world.func_147439_a(x - size + xOff, y, Z + zOff) == ModBlocks.seal_controller) continue;
                valid = false;
            }
            for (Z = z - size; Z <= z + size; ++Z) {
                if (world.func_147439_a(x + size + xOff, y, Z + zOff) == ModBlocks.seal_frame || world.func_147439_a(x + size + xOff, y, Z + zOff) == ModBlocks.seal_controller) continue;
                valid = false;
            }
            if (!valid) continue;
            return size;
        }
        return 0;
    }

    public static void closeSeal(World world, int x, int y, int z, int size) {
        int xOff = 0;
        int zOff = 0;
        if (world.func_72805_g(x, y, z) % 4 == 2) {
            zOff += size;
        }
        if (world.func_72805_g(x, y, z) % 4 == 3) {
            zOff -= size;
        }
        if (world.func_72805_g(x, y, z) % 4 == 0) {
            xOff += size;
        }
        if (world.func_72805_g(x, y, z) % 4 == 1) {
            xOff -= size;
        }
        for (int X = x - size + 1; X <= x + size - 1; ++X) {
            for (int Z = z - size + 1; Z <= z + size - 1; ++Z) {
                if (world.func_147439_a(X + xOff, y, Z + zOff) != Blocks.field_150350_a || world.field_72995_K) continue;
                world.func_147449_b(X + xOff, y, Z + zOff, ModBlocks.seal_hatch);
                TileEntity te = world.func_147438_o(X + xOff, y, Z + zOff);
                if (te == null || !(te instanceof TileEntityHatch)) continue;
                ((TileEntityHatch)te).setControllerPos(x, y, z);
            }
        }
    }

    public static void openSeal(World world, int x, int y, int z, int size) {
        int xOff = 0;
        int zOff = 0;
        if (world.func_72805_g(x, y, z) % 4 == 2) {
            zOff += size;
        }
        if (world.func_72805_g(x, y, z) % 4 == 3) {
            zOff -= size;
        }
        if (world.func_72805_g(x, y, z) % 4 == 0) {
            xOff += size;
        }
        if (world.func_72805_g(x, y, z) % 4 == 1) {
            xOff -= size;
        }
        for (int X = x - size + 1; X <= x + size - 1; ++X) {
            for (int Z = z - size + 1; Z <= z + size - 1; ++Z) {
                if (world.func_147439_a(X + xOff, y, Z + zOff) != ModBlocks.seal_hatch || world.field_72995_K) continue;
                world.func_147449_b(X + xOff, y, Z + zOff, Blocks.field_150350_a);
            }
        }
    }

    public static boolean isSealClosed(World world, int x, int y, int z, int size) {
        int xOff = 0;
        int zOff = 0;
        if (world.func_72805_g(x, y, z) % 4 == 2) {
            zOff += size;
        }
        if (world.func_72805_g(x, y, z) % 4 == 3) {
            zOff -= size;
        }
        if (world.func_72805_g(x, y, z) % 4 == 0) {
            xOff += size;
        }
        if (world.func_72805_g(x, y, z) % 4 == 1) {
            xOff -= size;
        }
        for (int X = x - size + 1; X <= x + size - 1; ++X) {
            for (int Z = z - size + 1; Z <= z + size - 1; ++Z) {
                if (world.func_147439_a(X + xOff, y, Z + zOff) != ModBlocks.seal_hatch) continue;
                return true;
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (world.field_72995_K) {
            return;
        }
        if (world.func_72864_z(x, y, z)) {
            int meta = world.func_72805_g(x, y, z);
            if (meta < 4) {
                world.func_72921_c(x, y, z, meta + 4, 2);
                int i = BlockSeal.getFrameSize(world, x, y, z);
                if (i != 0) {
                    if (BlockSeal.isSealClosed(world, x, y, z, i)) {
                        BlockSeal.openSeal(world, x, y, z, i);
                    } else {
                        BlockSeal.closeSeal(world, x, y, z, i);
                    }
                }
            }
        } else {
            int meta = world.func_72805_g(x, y, z);
            if (meta >= 4) {
                world.func_72921_c(x, y, z, meta % 4, 2);
            }
        }
    }
}

