/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.clowder;

import com.hfr.blocks.BlockDummyable;
import com.hfr.blocks.ModBlocks;
import com.hfr.clowder.ClowderFlag;
import com.hfr.clowder.ClowderTerritory;
import com.hfr.command.CommandClowder;
import com.hfr.data.ClowderData;
import com.hfr.data.MarketData;
import com.hfr.main.MainRegistry;
import com.hfr.tileentity.prop.TileEntityProp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Clowder {
    public static HashSet<Integer> colours = new HashSet();
    private static float prestigeCap = 1000.0f;
    private static float prestigeGenCap = 500.0f;
    public String uuid;
    public String name;
    public String motd;
    public ClowderFlag flag;
    public int color;
    public boolean canChangeColour = true;
    public boolean canDisband = false;
    public int homeX;
    public int homeY;
    public int homeZ;
    public HashMap<String, int[]> warps = new HashMap();
    public HashMap<MarketData.Offer, Integer> offerHistory = new HashMap();
    public int bonusPoints = 0;
    public Clowder enemy = null;
    public String enemyS = "nobody2584369";
    public Clowder suzerain = null;
    public String suzerainS = "nobody2584369";
    public static boolean forceOnline = false;
    public String treaty1 = "nobody2584369";
    public String treaty2 = "nobody2584369";
    public String treaty3 = "nobody2584369";
    public String treaty4 = "nobody2584369";
    public String treaty5 = "nobody2584369";
    public String treaty6 = "nobody2584369";
    public String treaty7 = "nobody2584369";
    public float treatyTime1 = 0.0f;
    public float treatyTime2 = 0.0f;
    public float treatyTime3 = 0.0f;
    public float treatyTime4 = 0.0f;
    public float treatyTime5 = 0.0f;
    public float treatyTime6 = 0.0f;
    public float treatyTime7 = 0.0f;
    public float sethomeDelay = 0.0f;
    public boolean vassalTarget = false;
    public boolean hungaryTarget = false;
    public boolean overtime = false;
    public String leader;
    public Set<String> officers = new HashSet<String>();
    public HashMap<String, Long> members = new HashMap();
    public Set<String> applications = new HashSet<String>();
    public int flags = 0;
    public Set<String> potentialFriends = new HashSet<String>();
    public HashMap<Clowder, Long> allies = new HashMap();
    public HashMap<String, Long> alliesS = new HashMap();
    public int allyWarpX;
    public int allyWarpY;
    public int allyWarpZ;
    public static List<Clowder> clowders = new ArrayList<Clowder>();
    public static HashMap<String, Clowder> inverseMap = new HashMap();
    public static HashSet<String> retreating = new HashSet();
    public static HashMap<Long, ScheduledTeleport> teleports = new HashMap();
    private float prestige = 0.0f;
    private float prestigeGen = 0.0f;
    private float prestigeReq = 0.0f;
    private float fabricateTime = 0.0f;
    private float canDeclareTime = 0.0f;
    private float warTime = 0.0f;
    public static final float tentRate = 0.1f;
    public static final float statueRate = 0.5f;
    public static final float flagRate = 0.1f;
    public static final float flagReq = 1.0f;

    public static void updateWars(World world) {
        for (Clowder clowder : clowders) {
            boolean isDivisibleBy5fab = clowder.getFabricatetime() % 5.0f == 0.0f;
            clowder.suzerain = clowder.suzerainS == "nobody2584369" ? null : Clowder.getClowderFromName(clowder.suzerainS);
            clowder.enemy = clowder.enemyS == "nobody2584369" ? null : Clowder.getClowderFromName(clowder.enemyS);
            if (clowder.treaty1 == "") {
                clowder.treaty1 = "nobody2584369";
                clowder.treatyTime1 = 0.0f;
            }
            if (clowder.treaty2 == "") {
                clowder.treaty2 = "nobody2584369";
                clowder.treatyTime2 = 0.0f;
            }
            if (clowder.treaty3 == "") {
                clowder.treaty3 = "nobody2584369";
                clowder.treatyTime3 = 0.0f;
            }
            if (clowder.treaty4 == "") {
                clowder.treaty4 = "nobody2584369";
                clowder.treatyTime4 = 0.0f;
            }
            if (clowder.treaty5 == "") {
                clowder.treaty5 = "nobody2584369";
                clowder.treatyTime5 = 0.0f;
            }
            if (clowder.treaty6 == "") {
                clowder.treaty6 = "nobody2584369";
                clowder.treatyTime6 = 0.0f;
            }
            if (clowder.treaty7 == "") {
                clowder.treaty7 = "nobody2584369";
                clowder.treatyTime7 = 0.0f;
            }
            if (clowder.sethomeDelay > 0.0f) {
                clowder.addSethomeDelay(-1.0f, world);
            } else {
                clowder.sethomeDelay = 0.0f;
            }
            if (clowder.treatyTime1 > 0.0f) {
                clowder.treatyTime1 -= 1.0f;
            }
            if (clowder.treatyTime2 > 0.0f) {
                clowder.treatyTime2 -= 1.0f;
            }
            if (clowder.treatyTime3 > 0.0f) {
                clowder.treatyTime3 -= 1.0f;
            }
            if (clowder.treatyTime4 > 0.0f) {
                clowder.treatyTime4 -= 1.0f;
            }
            if (clowder.treatyTime5 > 0.0f) {
                clowder.treatyTime5 -= 1.0f;
            }
            if (clowder.treatyTime6 > 0.0f) {
                clowder.treatyTime6 -= 1.0f;
            }
            if (clowder.treatyTime7 > 0.0f) {
                clowder.treatyTime7 -= 1.0f;
            }
            if (clowder.treatyTime1 <= 1.0f && clowder.treaty1 != "nobody2584369") {
                clowder.treaty1 = "nobody2584369";
            }
            if (clowder.treatyTime2 <= 1.0f && clowder.treaty2 != "nobody2584369") {
                clowder.treaty2 = "nobody2584369";
            }
            if (clowder.treatyTime3 <= 1.0f && clowder.treaty3 != "nobody2584369") {
                clowder.treaty3 = "nobody2584369";
            }
            if (clowder.treatyTime4 <= 1.0f && clowder.treaty4 != "nobody2584369") {
                clowder.treaty4 = "nobody2584369";
            }
            if (clowder.treatyTime5 <= 1.0f && clowder.treaty5 != "nobody2584369") {
                clowder.treaty5 = "nobody2584369";
            }
            if (clowder.treatyTime6 <= 1.0f && clowder.treaty6 != "nobody2584369") {
                clowder.treaty6 = "nobody2584369";
            }
            if (clowder.treatyTime7 <= 1.0f && clowder.treaty7 != "nobody2584369") {
                clowder.treaty7 = "nobody2584369";
            }
            clowder.save(world);
            if (clowder.getFabricatetime() > -1.0f && clowder.enemy != null && clowder.getWartime() <= 0.0f && clowder.getCanDeclareTime() <= 0.0f && clowder.enemy != clowder.suzerain) {
                if (clowder.getFabricatetime() < 5.0f && clowder.getFabricatetime() > 2.0f && clowder.getCanDeclareTime() == 0.0f && clowder.getWartime() == 0.0f && clowder.enemy != clowder.suzerain) {
                    clowder.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "War declaration will be ready in " + (int)(clowder.getFabricatetime() - 2.0f) + " minutes!"));
                    clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + clowder.name + " will be able to attack us in " + (int)(clowder.getFabricatetime() - 2.0f) + " minute(s)!"));
                }
                clowder.addFabricateTime(-1.0f, world);
            }
            if (clowder.getFabricatetime() > 0.0f && clowder.enemy != null && clowder.getWartime() <= 0.0f && clowder.getCanDeclareTime() <= 0.0f && clowder.enemy == clowder.suzerain) {
                clowder.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "If our oppressors don't strike back, we will be free in " + (int)(clowder.getFabricatetime() - 1.0f) + " minutes!"));
                clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.ERROR + clowder.name + " will break free from us in " + (int)(clowder.getFabricatetime() - 1.0f) + " minute(s)!"));
                clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + " Use /c suppress " + clowder.name + " to forcefully stop them! (Will start civil-war)"));
                clowder.addFabricateTime(-1.0f, world);
            }
            if (isDivisibleBy5fab && clowder.valid() && clowder.getFabricatetime() > -1.0f && clowder.enemy != null && clowder.getCanDeclareTime() == 0.0f && clowder.getWartime() == 0.0f) {
                if (clowder.enemy != clowder.suzerain) {
                    clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + clowder.name + " will be able to attack us in " + (int)(clowder.getFabricatetime() - 1.0f) + " minute(s)!"));
                }
                if (clowder.getFabricatetime() > 10.0f && clowder.enemy != clowder.suzerain) {
                    clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.TITLE + "Officers can use /c retreat to try to cancel this attack!"));
                    clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.TITLE + "Retreating makes you the aggressor's bitch, so choose wisely!"));
                }
            }
            if (clowder.valid() && clowder.getFabricatetime() > -1.0f && (double)clowder.getFabricatetime() <= 1.5 && clowder.enemy != null && clowder.getCanDeclareTime() == 0.0f && clowder.getWartime() == 0.0f) {
                if (clowder.enemy != clowder.suzerain) {
                    clowder.endFabricateTime(world);
                    clowder.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "War declaration is ready! Officers can /c declare for the next 4 hours!"));
                } else if (clowder.enemy == clowder.suzerain && clowder.getFabricatetime() == 0.0f && clowder.getWartime() == 0.0f) {
                    clowder.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "Our former masters lacked the will to oppose us! We have peacefully broken free of their grasp!"));
                    clowder.notifyAll(world, new ChatComponentText(CommandClowder.INFO + "We also get back some prestige!"));
                    clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + clowder.name + " is no longer our vassal!"));
                    clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.ERROR + "This shameful setback will cost us some prestige..."));
                    clowder.breakFree(world);
                }
            }
            if (clowder.valid() && (double)clowder.getWartime() <= 1.5 && clowder.enemy != null && clowder.getCanDeclareTime() == 0.0f && clowder.getFabricatetime() == 0.0f && clowder.enemy != clowder.suzerain) {
                if (clowder.treaty1 == "nobody2584369" && clowder.treaty1 != clowder.enemy.name) {
                    clowder.treaty1 = clowder.enemy.name;
                    clowder.treatyTime1 = 90.0f;
                } else if (clowder.treaty2 == "nobody2584369" && clowder.treaty2 != clowder.enemy.name) {
                    clowder.treaty2 = clowder.enemy.name;
                    clowder.treatyTime2 = 90.0f;
                } else if (clowder.treaty3 == "nobody2584369" && clowder.treaty3 != clowder.enemy.name) {
                    clowder.treaty3 = clowder.enemy.name;
                    clowder.treatyTime3 = 90.0f;
                } else if (clowder.treaty4 == "nobody2584369" && clowder.treaty4 != clowder.enemy.name) {
                    clowder.treaty4 = clowder.enemy.name;
                    clowder.treatyTime4 = 90.0f;
                } else if (clowder.treaty5 == "nobody2584369" && clowder.treaty5 != clowder.enemy.name) {
                    clowder.treaty5 = clowder.enemy.name;
                    clowder.treatyTime5 = 90.0f;
                } else if (clowder.treaty6 == "nobody2584369" && clowder.treaty6 != clowder.enemy.name) {
                    clowder.treaty6 = clowder.enemy.name;
                    clowder.treatyTime6 = 90.0f;
                } else if (clowder.treaty7 == "nobody2584369" && clowder.treaty7 != clowder.enemy.name) {
                    clowder.treaty7 = clowder.enemy.name;
                    clowder.treatyTime7 = 90.0f;
                }
                clowder.endWarTime(world);
                clowder.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "The war period has ended! Pack it up boys!"));
                clowder.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + clowder.enemy.name + " also gets a 1.5 hour grace period."));
                clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + clowder.name + "'s war against us has ended!"));
                clowder.vassalTarget = false;
                clowder.enemy = null;
                clowder.enemyS = "nobody2584369";
                if (clowder.suzerain != null) {
                    clowder.suzerain.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "Our vassal, " + clowder.name + ", has finished their war!"));
                }
                clowder.overtime = false;
                clowder.bonusPoints = 0;
            }
            if (clowder.valid() && clowder.getWartime() >= 60.0f && clowder.enemy == clowder.suzerain && clowder.getCanDeclareTime() == 0.0f && clowder.getFabricatetime() == 0.0f) {
                clowder.endWarTime(world);
                clowder.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "Our revolt has succeeded. We are now independent!"));
                clowder.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "We also get back our prestige!"));
                clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + clowder.name + "'s revolt against us has cost us too much."));
                clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "We have no choice but to let them leave the alliance. (for now)"));
                clowder.enemy = null;
                clowder.enemyS = "nobody2584369";
                clowder.suzerain = null;
                clowder.suzerainS = "nobody2584369";
            }
            if (clowder.valid() && (double)clowder.getCanDeclareTime() <= 1.5 && clowder.enemy != null && clowder.getWartime() <= 0.0f && clowder.getFabricatetime() <= 0.0f && clowder.enemy != clowder.suzerain) {
                clowder.vassalTarget = false;
                clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + clowder.name + "'s war fabrication against us has expired!"));
                clowder.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "Too late! War fabrication has expired!"));
                clowder.notifyAll(world, new ChatComponentText(CommandClowder.TITLE + "We also get most of our prestige back!"));
                clowder.enemy = null;
                clowder.enemyS = "nobody2584369";
            }
            if (clowder.valid() && clowder.getWartime() > 0.0f && clowder.enemy != null) {
                clowder.addWarTime(-1.0f, world);
            }
            if (!clowder.valid() || !(clowder.getCanDeclareTime() > 0.0f) || clowder.enemy == null) continue;
            clowder.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + "Our officers have " + (int)(clowder.getCanDeclareTime() - 1.0f) + " minutes to officially declare war with /c declare!"));
            clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.CRITICAL + clowder.name + " can declare war against us for the next " + (int)(clowder.getCanDeclareTime() - 1.0f) + " minutes!"));
            clowder.enemy.notifyAll(world, new ChatComponentText(CommandClowder.TITLE + "We can start the war now with /c preemptive " + clowder.name));
            clowder.addCanDeclareTime(-1.0f, world);
        }
    }

    public void pussy(World world) {
        this.fabricateTime = 0.0f;
        this.canDeclareTime = 0.0f;
        this.enemy = null;
        this.enemyS = "nobody2584369";
        this.warTime = 0.0f;
        this.overtime = false;
        this.bonusPoints = 0;
        this.vassalTarget = false;
        this.save(world);
    }

    public static void initializeDiplomacy(World world) {
        for (Clowder clowder : clowders) {
            clowder.suzerain = clowder.suzerainS == "nobody2584369" ? null : Clowder.getClowderFromName(clowder.suzerainS);
            clowder.enemy = clowder.enemyS == "nobody2584369" ? null : Clowder.getClowderFromName(clowder.enemyS);
            if (clowder.treaty1 == "") {
                clowder.treaty1 = "nobody2584369";
                clowder.treatyTime1 = 0.0f;
            }
            if (clowder.treaty2 == "") {
                clowder.treaty2 = "nobody2584369";
                clowder.treatyTime2 = 0.0f;
            }
            if (clowder.treaty3 == "") {
                clowder.treaty3 = "nobody2584369";
                clowder.treatyTime3 = 0.0f;
            }
            if (clowder.treaty4 == "") {
                clowder.treaty4 = "nobody2584369";
                clowder.treatyTime4 = 0.0f;
            }
            if (clowder.treaty5 == "") {
                clowder.treaty5 = "nobody2584369";
                clowder.treatyTime5 = 0.0f;
            }
            if (clowder.treaty6 == "") {
                clowder.treaty6 = "nobody2584369";
                clowder.treatyTime6 = 0.0f;
            }
            if (clowder.treaty7 == "") {
                clowder.treaty7 = "nobody2584369";
                clowder.treatyTime7 = 0.0f;
            }
            for (String friend : clowder.alliesS.keySet()) {
                Clowder ally = Clowder.getClowderFromName(friend);
                if (ally == null) continue;
                clowder.allies.put(ally, Clowder.time());
            }
        }
        System.out.println("Initializing LabJac's poorly coded clowder diplomacy systems");
    }

    public void notifyCapture(World world, int x, int z, String type) {
        this.notifyAll(world, new ChatComponentText(EnumChatFormatting.RED + "One of your " + type + " at X:" + x + " / Z:" + z + " is under attack!"));
        this.notifyAll(world, new ChatComponentText(EnumChatFormatting.YELLOW + "If this is a defensive war, the enemy gained 1 minute of extra war-time from taking that chunk!"));
        if (!this.warps.isEmpty()) {
            double dist = Double.POSITIVE_INFINITY;
            String closest = "";
            for (String key : this.warps.keySet()) {
                double d;
                int[] pos = this.warps.get(key);
                if (pos == null || !((d = Math.sqrt(Math.pow(x - pos[0], 2.0) + Math.pow(z - pos[2], 2.0))) < dist)) continue;
                dist = d;
                closest = key;
            }
            this.notifyAll(world, new ChatComponentText(EnumChatFormatting.RED + "Your closest warp is " + closest + " (" + (int)dist + "m)"));
        }
    }

    public void addWarTime(float f, World world) {
        this.warTime += f;
        if (this.warTime < 0.0f) {
            this.warTime = 0.0f;
        }
        this.save(world);
    }

    public void addFabricateTime(float f, World world) {
        this.fabricateTime += f;
        if (this.fabricateTime < 0.0f) {
            this.fabricateTime = 0.0f;
        }
        this.save(world);
    }

    public void addCanDeclareTime(float f, World world) {
        this.canDeclareTime += f;
        if (this.canDeclareTime < 0.0f) {
            this.canDeclareTime = 0.0f;
        }
        this.save(world);
    }

    public void endFabricateTime(World world) {
        this.fabricateTime = 0.0f;
        this.canDeclareTime = 241.0f;
        this.save(world);
    }

    public void breakFree(World world) {
        this.fabricateTime = 0.0f;
        this.enemy = null;
        this.enemyS = "nobody2584369";
        this.suzerainS = "nobody2584369";
        this.suzerain = null;
        this.warTime = 0.0f;
        this.save(world);
    }

    public void endDeclareTime(World world) {
        this.fabricateTime = 0.0f;
        this.canDeclareTime = 0.0f;
        this.save(world);
    }

    public void endWarTime(World world) {
        this.warTime = 0.0f;
        this.save(world);
    }

    public void addSethomeDelay(float f, World world) {
        this.sethomeDelay += f;
        if (this.sethomeDelay < 0.0f) {
            this.sethomeDelay = 0.0f;
        }
        this.save(world);
    }

    public String getDecoratedName() {
        String n = this.name.replace("_", " ").trim();
        n = this.getPrestige() < 25.0f ? n + " - Unorganized Mob" : (this.getPrestige() < 50.0f ? n + " - Clan" : (this.getPrestige() < 75.0f ? n + " - Tribe" : (this.getPrestige() < 100.0f ? n + " - Chiefdom" : (this.getPrestige() < 125.0f ? n + " - City-State" : (this.getPrestige() < 150.0f ? n + " - Sheikhdom" : (this.getPrestige() < 250.0f ? n + " - Emirate" : (this.getPrestige() < 500.0f ? n + " - Sultanate" : (this.getPrestige() < 750.0f ? n + " - Empire" : n + " - Caliphate"))))))));
        return n;
    }

    public boolean vassalize(World world, String Master, String Vassal) {
        if (Clowder.getClowderFromName(Master) == null || Clowder.getClowderFromName(Vassal) == null) {
            return false;
        }
        Clowder.getClowderFromName((String)Vassal).suzerainS = Master;
        Clowder.getClowderFromName((String)Vassal).suzerain = Clowder.getClowderFromName(Master);
        ClowderData.getData(world).func_76185_a();
        return true;
    }

    public boolean markEnemy(World world, String Attacker, String Target) {
        if (Clowder.getClowderFromName(Attacker) == null || Clowder.getClowderFromName(Target) == null) {
            return false;
        }
        Clowder.getClowderFromName((String)Attacker).enemyS = Target;
        Clowder.getClowderFromName((String)Attacker).enemy = Clowder.getClowderFromName(Target);
        ClowderData.getData(world).func_76185_a();
        return true;
    }

    public boolean addAlly(World world, Clowder friend) {
        if (!friend.valid()) {
            return false;
        }
        if (this.allies.get(friend) != null) {
            return false;
        }
        this.allies.put(friend, Clowder.time());
        this.alliesS.put(friend.name, Clowder.time());
        ClowderData.getData(world).func_76185_a();
        return true;
    }

    public boolean addMember(World world, String name) {
        if (world.func_72924_a(name) == null) {
            return false;
        }
        if (inverseMap.containsKey(name) || this.members.get(name) != null) {
            return false;
        }
        this.members.put(name, Clowder.time());
        inverseMap.put(name, this);
        ClowderData.getData(world).func_76185_a();
        return true;
    }

    public boolean removeMember(World world, String name) {
        if (!inverseMap.containsKey(name) && this.members.get(name) == null) {
            return false;
        }
        this.members.remove(name);
        this.officers.remove(name);
        inverseMap.remove(name);
        ClowderData.getData(world).func_76185_a();
        return true;
    }

    public boolean removeAlly(World world, String name) {
        Clowder formerAlly = Clowder.getClowderFromName(name);
        if (this.allies.get(formerAlly) == null) {
            return false;
        }
        this.allies.remove(formerAlly);
        ClowderData.getData(world).func_76185_a();
        return true;
    }

    public void becomeVassal(Clowder vassal, EntityPlayer player, Clowder suzerain) {
        vassal.suzerain = suzerain;
        ClowderData.getData(player.field_70170_p).func_76185_a();
    }

    public float getFabricatetime() {
        return this.fabricateTime;
    }

    public float getWartime() {
        return this.warTime;
    }

    public float getCanDeclareTime() {
        return this.canDeclareTime;
    }

    public boolean transferOwnership(World world, String key) {
        if (this.members.get(key) == null) {
            return false;
        }
        this.officers.remove(key);
        this.leader = key;
        ClowderData.getData(world).func_76185_a();
        return true;
    }

    public void promote(World world, String name) {
        if (!this.members.containsKey(name)) {
            return;
        }
        this.officers.add(name);
        this.save(world);
    }

    public void demote(World world, String name) {
        if (!this.members.containsKey(name)) {
            return;
        }
        this.officers.remove(name);
        this.save(world);
    }

    public int getPermLevel(String name) {
        if (this.leader.equals(name)) {
            return 3;
        }
        if (this.officers.contains(name)) {
            return 2;
        }
        if (this.members.get(name) != null) {
            return 1;
        }
        return 0;
    }

    public void setHome(double x, double y, double z, EntityPlayer player) {
        this.homeX = (int)x;
        this.homeY = (int)y;
        this.homeZ = (int)z;
        ClowderData.getData(player.field_70170_p).func_76185_a();
    }

    public void setAllyWarp(double x, double y, double z, EntityPlayer player) {
        this.allyWarpX = (int)x;
        this.allyWarpY = (int)y;
        this.allyWarpZ = (int)z;
        ClowderData.getData(player.field_70170_p).func_76185_a();
    }

    public void rename(String name, EntityPlayer player) {
        this.name = name;
        ClowderData.getData(player.field_70170_p).func_76185_a();
    }

    public void setMotd(String motd, EntityPlayer player) {
        this.motd = motd;
        ClowderData.getData(player.field_70170_p).func_76185_a();
    }

    public void setColor(int color, EntityPlayer player) {
        this.color = color;
        ClowderData.getData(player.field_70170_p).func_76185_a();
    }

    public void save(World world) {
        if (world == null) {
            return;
        }
        ClowderData.getData(world).func_76185_a();
    }

    public int tryAddWarp(EntityPlayer player, int x, int y, int z, String name) {
        World world = player.field_70170_p;
        if (!ClowderTerritory.isPlayerHome(player)) {
            return 1;
        }
        Clowder clowder = Clowder.getClowderFromPlayer(player);
        for (int i = 2; i <= 5; ++i) {
            int[] pos;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            Block block = world.func_147439_a(x + dir.offsetX * 2, y, z + dir.offsetZ * 2);
            if (block != ModBlocks.tp_tent || (pos = ((BlockDummyable)ModBlocks.tp_tent).findCore(world, x + dir.offsetX * 2, y, z + dir.offsetZ * 2)) == null) continue;
            TileEntityProp tent = (TileEntityProp)world.func_147438_o(pos[0], pos[1], pos[2]);
            if (!tent.warp.isEmpty() || !tent.operational()) continue;
            tent.warp = name;
            tent.func_70296_d();
            clowder.warps.put(name, new int[]{x, y + 1, z});
            ClowderData.getData(world).func_76185_a();
            return 0;
        }
        return 2;
    }

    public boolean isOwner(EntityPlayer player) {
        String key = player.getDisplayName();
        return this.leader.equals(key);
    }

    public boolean disbandClowder(EntityPlayer player) {
        if (!this.isOwner(player)) {
            return false;
        }
        clowders.remove(this);
        Clowder.recalculateIMap();
        this.leader = "";
        ClowderData.getData(player.field_70170_p).func_76185_a();
        return true;
    }

    public boolean disbandClowder(World world) {
        clowders.remove(this);
        Clowder.recalculateIMap();
        this.leader = "";
        this.members.clear();
        this.allies.clear();
        ClowderData.getData(world).func_76185_a();
        return true;
    }

    public boolean valid() {
        return this.leader != "" && clowders.contains(this);
    }

    public boolean isRaidable() {
        if (MainRegistry.freeRaid) {
            return true;
        }
        if (forceOnline) {
            return true;
        }
        int online = 0;
        int members = this.members.size();
        for (String s : this.members.keySet()) {
            Long l = this.members.get(s);
            if (l <= System.currentTimeMillis()) continue;
            ++online;
        }
        if (members >= 6) {
            return online >= 3;
        }
        if (members >= 3) {
            return online >= 2;
        }
        return online >= 1;
    }

    public int getPlayersOnline() {
        int online = 0;
        int members = this.members.size();
        for (String s : this.members.keySet()) {
            Long l = this.members.get(s);
            if (l <= System.currentTimeMillis()) continue;
            ++online;
        }
        return online;
    }

    public static String round(float f) {
        return "" + Math.floor((double)f * 10.0) / 10.0;
    }

    public float getPrestige() {
        return this.prestige;
    }

    public float getPrestigeGen() {
        return this.prestigeGen;
    }

    public float getPrestigeReq() {
        return this.prestigeReq;
    }

    public void addPrestige(float f, World world) {
        this.prestige += f;
        if (this.prestige < 0.0f) {
            this.prestige = 0.0f;
        }
        this.prestige = Math.min(this.prestige, prestigeCap);
        this.save(world);
    }

    public void addPrestigeGen(float f, World world) {
        this.prestigeGen += f;
        if (this.prestigeGen < 0.0f) {
            this.prestigeGen = 0.0f;
        }
        this.prestigeGen = Math.min(this.prestigeGen, prestigeGenCap);
        this.save(world);
    }

    public void addPrestigeReq(float f, World world) {
        this.prestigeReq += f;
        if (this.prestigeReq < 0.0f) {
            this.prestigeReq = 0.0f;
        }
        this.save(world);
    }

    public void multPrestige(float f, World world) {
        this.prestige *= f;
        this.prestige = (float)(Math.floor((double)this.prestige * 10.0) / 10.0);
        if (this.prestige < 0.0f) {
            this.prestige = 0.0f;
        }
        this.save(world);
    }

    public void freeWarTime(World world) {
        this.warTime = 10.0f;
        this.save(world);
    }

    public void saveClowder(int i, NBTTagCompound nbt) {
        int j;
        nbt.func_74778_a(i + "_uuid", this.uuid);
        nbt.func_74778_a(i + "_name", this.name);
        nbt.func_74778_a(i + "_motd", this.motd);
        nbt.func_74768_a(i + "_flag", this.flag.ordinal());
        nbt.func_74768_a(i + "_color", this.color);
        nbt.func_74757_a(i + "_canChange", this.canChangeColour);
        nbt.func_74757_a(i + "_canDisband", this.canDisband);
        nbt.func_74768_a(i + "_homeX", this.homeX);
        nbt.func_74768_a(i + "_homeY", this.homeY);
        nbt.func_74768_a(i + "_homeZ", this.homeZ);
        nbt.func_74768_a(i + "_allyWarpX", this.allyWarpX);
        nbt.func_74768_a(i + "_allyWarpY", this.allyWarpY);
        nbt.func_74768_a(i + "_allyWarpZ", this.allyWarpZ);
        nbt.func_74776_a(i + "_prestige", this.prestige);
        nbt.func_74776_a(i + "_prestigeGen", this.prestigeGen);
        nbt.func_74776_a(i + "_prestigeReq", this.prestigeReq);
        nbt.func_74768_a(i + "_flags", this.flags);
        nbt.func_74776_a(i + "_fabricateTime", this.fabricateTime);
        nbt.func_74776_a(i + "_warTime", this.warTime);
        nbt.func_74776_a(i + "_canDeclareTime", this.canDeclareTime);
        nbt.func_74757_a(i + "_vassalTarget", this.vassalTarget);
        nbt.func_74757_a(i + "_forceOnline", forceOnline);
        nbt.func_74757_a(i + "_overtime", this.overtime);
        nbt.func_74778_a(i + "_enemy", this.enemyS);
        nbt.func_74778_a(i + "_suzerain", this.suzerainS);
        nbt.func_74778_a(i + "_leader", this.leader);
        nbt.func_74768_a(i + "_members", this.members.size());
        nbt.func_74768_a(i + "_officers", this.officers.size());
        nbt.func_74768_a(i + "_warps", this.warps.size());
        nbt.func_74776_a(i + "_bonusPoints", (float)this.bonusPoints);
        for (j = 0; j < this.members.keySet().size(); ++j) {
            nbt.func_74778_a(i + "_" + j, (String)this.members.keySet().toArray()[j]);
        }
        for (j = 0; j < this.alliesS.keySet().size(); ++j) {
            nbt.func_74778_a(i + "_" + j + "_ally", (String)this.alliesS.keySet().toArray()[j]);
        }
        for (j = 0; j < this.officers.size(); ++j) {
            nbt.func_74778_a(i + "_" + j + "_off", (String)this.officers.toArray()[j]);
        }
        for (j = 0; j < this.warps.keySet().size(); ++j) {
            String name = (String)this.warps.keySet().toArray()[j];
            int[] coords = this.warps.get(name);
            nbt.func_74778_a(i + "_" + j + "_name", name);
            nbt.func_74768_a(i + "_" + j + "_x", coords[0]);
            nbt.func_74768_a(i + "_" + j + "_y", coords[1]);
            nbt.func_74768_a(i + "_" + j + "_z", coords[2]);
        }
    }

    public static Clowder loadClowder(int i, NBTTagCompound nbt) {
        int j;
        Clowder c = new Clowder();
        c.uuid = nbt.func_74779_i(i + "_uuid");
        if (c.uuid.isEmpty()) {
            c.uuid = UUID.randomUUID().toString();
        }
        c.name = nbt.func_74779_i(i + "_name");
        c.motd = nbt.func_74779_i(i + "_motd");
        c.flag = ClowderFlag.values()[nbt.func_74762_e(i + "_flag")];
        c.color = nbt.func_74762_e(i + "_color");
        c.canChangeColour = nbt.func_74767_n(i + "_canChange");
        c.canDisband = nbt.func_74767_n(i + "_canDisband");
        c.homeX = nbt.func_74762_e(i + "_homeX");
        c.homeY = nbt.func_74762_e(i + "_homeY");
        c.homeZ = nbt.func_74762_e(i + "_homeZ");
        c.allyWarpX = nbt.func_74762_e(i + "_allyWarpX");
        c.allyWarpY = nbt.func_74762_e(i + "_allyWarpY");
        c.allyWarpZ = nbt.func_74762_e(i + "_allyWarpZ");
        c.prestige = Math.max(nbt.func_74760_g(i + "_prestige"), 1.0f);
        c.canDeclareTime = Math.max(nbt.func_74760_g(i + "_canDeclareTime"), 0.0f);
        c.fabricateTime = Math.max(nbt.func_74760_g(i + "_fabricateTime"), 0.0f);
        c.warTime = Math.max(nbt.func_74760_g(i + "_warTime"), 0.0f);
        c.prestigeGen = Math.max(nbt.func_74760_g(i + "_prestigeGen"), 0.0f);
        c.prestigeReq = Math.max(nbt.func_74760_g(i + "_prestigeReq"), 0.0f);
        c.flags = nbt.func_74762_e(i + "_flags");
        forceOnline = nbt.func_74767_n(i + "_forceOnline");
        c.overtime = nbt.func_74767_n(i + "_overtime");
        c.enemy = Clowder.getClowderFromName(nbt.func_74779_i(i + "_enemy"));
        c.suzerain = Clowder.getClowderFromName(nbt.func_74779_i(i + "_suzerain"));
        c.enemyS = nbt.func_74779_i(i + "_enemy");
        c.suzerainS = nbt.func_74779_i(i + "_suzerain");
        c.vassalTarget = nbt.func_74767_n(i + "_vassalTarget");
        c.treaty1 = nbt.func_74779_i(i + "_treaty1");
        c.treaty2 = nbt.func_74779_i(i + "_treaty2");
        c.treaty3 = nbt.func_74779_i(i + "_treaty3");
        c.treaty4 = nbt.func_74779_i(i + "_treaty4");
        c.treaty5 = nbt.func_74779_i(i + "_treaty5");
        c.treaty6 = nbt.func_74779_i(i + "_treaty6");
        c.treaty7 = nbt.func_74779_i(i + "_treaty7");
        c.treatyTime1 = Math.max(nbt.func_74760_g(i + "_treatyTime1"), 0.0f);
        c.treatyTime2 = Math.max(nbt.func_74760_g(i + "_treatyTime2"), 0.0f);
        c.treatyTime3 = Math.max(nbt.func_74760_g(i + "_treatyTime3"), 0.0f);
        c.treatyTime4 = Math.max(nbt.func_74760_g(i + "_treatyTime4"), 0.0f);
        c.treatyTime5 = Math.max(nbt.func_74760_g(i + "_treatyTime5"), 0.0f);
        c.treatyTime6 = Math.max(nbt.func_74760_g(i + "_treatyTime6"), 0.0f);
        c.treatyTime7 = Math.max(nbt.func_74760_g(i + "_treatyTime7"), 0.0f);
        c.bonusPoints = nbt.func_74762_e(i + "_bonusPoints");
        c.leader = nbt.func_74779_i(i + "_leader");
        int count = nbt.func_74762_e(i + "_members");
        int co = nbt.func_74762_e(i + "_officers");
        int cwarp = nbt.func_74762_e(i + "_warps");
        for (j = 0; j < count; ++j) {
            c.members.put(nbt.func_74779_i(i + "_" + j), Clowder.time());
        }
        for (j = 0; j < count; ++j) {
            c.alliesS.put(nbt.func_74779_i(i + "_" + j + "_ally"), Clowder.time());
        }
        for (j = 0; j < co; ++j) {
            c.officers.add(nbt.func_74779_i(i + "_" + j + "_off"));
        }
        for (j = 0; j < cwarp; ++j) {
            String name = nbt.func_74779_i(i + "_" + j + "_name");
            int[] coord = new int[]{nbt.func_74762_e(i + "_" + j + "_x"), nbt.func_74762_e(i + "_" + j + "_y"), nbt.func_74762_e(i + "_" + j + "_z")};
            c.warps.put(name, coord);
        }
        return c;
    }

    public void notifyLeader(World world, ChatComponentText message) {
        this.notifyPlayer(world, this.leader, message);
    }

    public void notifyAll(World world, ChatComponentText message) {
        for (String player : this.members.keySet()) {
            this.notifyPlayer(world, player, message);
        }
    }

    public void notifyPlayer(World world, String player, ChatComponentText message) {
        EntityPlayer notif = world.func_72924_a(player);
        if (notif != null) {
            notif.func_145747_a((IChatComponent)message);
        }
    }

    public void restockMarkets() {
        this.offerHistory.clear();
    }

    public static void recalculateIMap() {
        inverseMap.clear();
        for (Clowder clowder : clowders) {
            for (String member : clowder.members.keySet()) {
                inverseMap.put(member, clowder);
            }
        }
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        colours.add(0xFF8000);
        colours.add(0xFF0000);
        colours.add(0xFFFFFF);
        clowders.clear();
        int count = nbt.func_74762_e("clowderCount");
        for (int i = 0; i < count; ++i) {
            clowders.add(Clowder.loadClowder(i, nbt));
        }
        Clowder.recalculateIMap();
    }

    public static void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("clowderCount", clowders.size());
        for (int i = 0; i < clowders.size(); ++i) {
            clowders.get(i).saveClowder(i, nbt);
        }
    }

    public static boolean areFriends(EntityPlayer player1, EntityPlayer player2) {
        if (player1 == null) {
            return false;
        }
        if (player2 == null) {
            return false;
        }
        Clowder c1 = Clowder.getClowderFromPlayer(player1);
        Clowder c2 = Clowder.getClowderFromPlayer(player2);
        if (c1 == null) {
            return false;
        }
        return c1 == c2;
    }

    public static Clowder getClowderFromPlayer(EntityPlayer player) {
        return Clowder.getClowderFromPlayerName(player.getDisplayName());
    }

    public static Clowder getClowderFromPlayerName(String key) {
        return inverseMap.get(key);
    }

    public static Clowder getClowderFromName(String name) {
        name = name.toLowerCase();
        for (Clowder clowder : clowders) {
            if (!clowder.name.toLowerCase().equals(name)) continue;
            return clowder;
        }
        return null;
    }

    public static Clowder getClowderFromUUID(String uuid) {
        uuid = uuid.toLowerCase();
        for (Clowder clowder : clowders) {
            if (!clowder.uuid.toLowerCase().equals(uuid)) continue;
            return clowder;
        }
        return null;
    }

    public static void createClowder(EntityPlayer player, String name) {
        String leader = player.getDisplayName();
        Clowder c = new Clowder();
        c.uuid = UUID.randomUUID().toString();
        c.name = name;
        c.leader = leader;
        c.members.put(leader, Clowder.time());
        int colour = player.func_70681_au().nextInt(0x1000000);
        while (colours.contains(colour)) {
            colour = player.func_70681_au().nextInt(0x1000000);
        }
        c.color = colour;
        colours.add(colour);
        c.setHome(player.field_70165_t, player.field_70163_u, player.field_70161_v, player);
        c.setAllyWarp(player.field_70165_t, player.field_70163_u, player.field_70161_v, player);
        c.motd = "Message of the day!";
        c.flag = ClowderFlag.TRICOLOR;
        c.prestige = 25.0f;
        c.addPrestigeGen(3.0f, player.field_70170_p);
        clowders.add(c);
        inverseMap.put(leader, c);
        ClowderData.getData(player.field_70170_p).func_76185_a();
    }

    public static void updatePrestige(World world) {
        for (Clowder clowder : clowders) {
            if (!clowder.valid()) continue;
            float prestige = clowder.getPrestigeGen();
            float loss = clowder.getPrestigeReq();
            clowder.addPrestige(-1.0f * loss, world);
            if (clowder.suzerain == null) {
                clowder.addPrestige(prestige, world);
                continue;
            }
            clowder.suzerain.addPrestige((float)((double)prestige * 0.1), world);
            clowder.suzerain.notifyAll(world, new ChatComponentText(CommandClowder.TITLE + "We have received " + prestige * 0.1f + " extra prestige as tribute from " + clowder.name));
        }
    }

    public static long time() {
        return System.currentTimeMillis();
    }

    public static class ScheduledTeleport {
        int posX;
        int posY;
        int posZ;
        String player;
        String warp;
        boolean home;
        boolean rendezvous = false;
        String allyName;

        public ScheduledTeleport(int posX, int posY, int posZ, String player, String warp) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.player = player;
            this.warp = warp;
        }

        public ScheduledTeleport(int posX, int posY, int posZ, String player, boolean home) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.player = player;
            this.home = home;
        }

        public ScheduledTeleport(int posX, int posY, int posZ, String player, boolean home, boolean rendezvous, String allyName) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.player = player;
            this.home = home;
            this.rendezvous = rendezvous;
            this.allyName = allyName;
        }
    }
}

