/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.clowder;

import com.hbm.extprop.HbmLivingProps;
import com.hbm.potion.HbmPotion;
import com.hfr.blocks.BlockDummyable;
import com.hfr.blocks.ModBlocks;
import com.hfr.clowder.Clowder;
import com.hfr.clowder.ClowderTerritory;
import com.hfr.clowder.ReflectionUtils;
import com.hfr.command.CommandClowder;
import com.hfr.command.CommandClowderChat;
import com.hfr.command.MuteManager;
import com.hfr.data.ClowderData;
import com.hfr.handler.BobbyBreaker;
import com.hfr.handler.ExplosionSound;
import com.hfr.items.ItemMace;
import com.hfr.items.ModItems;
import com.hfr.main.MainRegistry;
import com.hfr.packet.PacketDispatcher;
import com.hfr.packet.effect.ClowderBorderPacket;
import com.hfr.packet.effect.ClowderFlagPacket;
import com.hfr.tileentity.prop.TileEntityProp;
import com.hfr.tileentity.prop.TileEntityStatue;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ClowderEvents {
    public static final Class<?> MCH_CONFIG = ReflectionUtils.getClass("mcheli.MCH_Config");
    public static final Class<?> MCH_ENTITY_BULLET = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityBullet");
    public static final Class<?> MCH_ENTITY_AIRCRAFT = ReflectionUtils.getClass("mcheli.aircraft.MCH_EntityAircraft");
    public static final Class<?> MCH_ENTITY_BASE_BULLET = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityBaseBullet");
    public static final Class<?> MCH_ENTITY_ROCKET = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityRocket");
    public static final String NBTKEY = "lastClowder";
    int delay = 0;
    int hour = 0;

    @SubscribeEvent
    public void clowderLoadEvent(WorldEvent.Load event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            if (MCH_ENTITY_AIRCRAFT != null) {
                System.out.println("[Clowder] MCH_EntityAircraft class is available.");
            }
            ClowderData.getData(event.world);
        }
    }

    @SubscribeEvent
    public void clowderLoadEvent(WorldEvent.Unload event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            if (MCH_ENTITY_AIRCRAFT != null) {
                System.out.println("[Clowder] MCH_EntityAircraft is still available during world unload.");
            }
            ClowderData.getData(event.world).func_76185_a();
        }
    }

    @SubscribeEvent
    public void handleChatServer(ServerChatEvent event) {
        Clowder clowder = Clowder.getClowderFromPlayer((EntityPlayer)event.player);
        if (clowder != null) {
            if (event.player.getEntityData().func_74762_e("clowderChat") == 1) {
                this.sendToTeam(clowder, (EntityPlayer)event.player, event.message);
                event.setCanceled(true);
                return;
            }
            if (event.player.getEntityData().func_74762_e("clowderChat") == 2) {
                this.sendToAlliance(clowder, (EntityPlayer)event.player, event.message);
                event.setCanceled(true);
                return;
            }
            if (!MuteManager.isMuted(event.player.toString())) {
                String name = clowder.getDecoratedName();
                String message = EnumChatFormatting.DARK_GREEN + "[ " + name + " Citizen ]";
                if (clowder.getPermLevel(event.player.getDisplayName()) > 1) {
                    message = EnumChatFormatting.BLUE + "[ " + name + " Officer ]";
                }
                if (clowder.getPermLevel(event.player.getDisplayName()) > 2) {
                    message = EnumChatFormatting.GOLD + "[ " + name + " Leader ]";
                }
                MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(message));
            } else {
                event.setCanceled(true);
            }
        }
    }

    private void sendToTeam(Clowder clowder, EntityPlayer player, String message) {
        String name = "";
        if (clowder.getPermLevel(player.getDisplayName()) > 2) {
            name = name + "<Leader> ";
        } else if (clowder.getPermLevel(player.getDisplayName()) > 1) {
            name = name + "<Officer> ";
        } else if (clowder.getPermLevel(player.getDisplayName()) > 0) {
            name = name + "<Citizen> ";
        }
        name = name + "[" + player.getDisplayName() + "]";
        clowder.notifyAll(player.field_70170_p, new ChatComponentText(CommandClowderChat.HELP + name + " " + message));
        System.out.println(name + " " + message);
    }

    private void sendToAlliance(Clowder clowder, EntityPlayer player, String message) {
        String name = "";
        if (clowder.getPermLevel(player.getDisplayName()) > 2) {
            name = name + "<Leader> ";
        } else if (clowder.getPermLevel(player.getDisplayName()) > 1) {
            name = name + "<Officer> ";
        } else if (clowder.getPermLevel(player.getDisplayName()) > 0) {
            name = name + "<Citizen> ";
        }
        name = name + "[" + player.getDisplayName() + "]";
        clowder.notifyAll(player.field_70170_p, new ChatComponentText(CommandClowderChat.LIST + name + " " + message));
        System.out.println(name + " " + message);
        for (Clowder a : clowder.allies.keySet()) {
            a.notifyAll(player.field_70170_p, new ChatComponentText(CommandClowderChat.LIST + "<Ally> [" + player.getDisplayName() + "] " + message));
        }
    }

    @SubscribeEvent
    public void clowderBlockEvent(BlockEvent event) {
        if (event instanceof BlockEvent.BreakEvent || event instanceof BlockEvent.PlaceEvent) {
            Clowder clowder;
            EntityPlayer player;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            Block b = event.world.func_147439_a(x, y, z);
            ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts(x, z);
            if (event instanceof BlockEvent.BreakEvent) {
                player = ((BlockEvent.BreakEvent)event).getPlayer();
                if (this.canBreak(player, clowder = Clowder.getClowderFromPlayer(player), owner, b, x, y, z)) {
                    this.onBreak(event.world, b, x, y, z, owner);
                    BobbyBreaker.handleDigEvent((BlockEvent.BreakEvent)event);
                } else {
                    event.setCanceled(true);
                    return;
                }
            }
            if (event instanceof BlockEvent.PlaceEvent) {
                player = ((BlockEvent.PlaceEvent)event).player;
                clowder = Clowder.getClowderFromPlayer(player);
                if (!this.canPlace(player, clowder, owner, b, x, y, z)) {
                    event.setCanceled(true);
                    return;
                }
                if (!(player.field_71071_by.func_146028_b(ModItems.debug) || owner != null && owner.zone != ClowderTerritory.Zone.WILDERNESS || b != Blocks.field_150486_ae && b != Blocks.field_150447_bR)) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(CommandClowder.ERROR + "Chests are disabled outside of claims."));
                    player.func_145747_a((IChatComponent)new ChatComponentText(CommandClowder.ERROR + "For temporary storage, use cardboard boxes (crafable with chests)"));
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    private void onBreak(World world, Block b, int x, int y, int z, ClowderTerritory.Ownership owner) {
        if (owner != null && owner.zone == ClowderTerritory.Zone.FACTION && owner.owner != null) {
            TileEntity prop;
            int[] loc;
            if ((b == ModBlocks.med_tent || b == ModBlocks.med_tent) && (loc = ((BlockDummyable)b).findCoreRec(world, x, y, z)) != null && (prop = (TileEntityProp)world.func_147438_o(loc[0], loc[1], loc[2])) != null && prop.operational()) {
                owner.owner.multPrestige(0.975f, world);
            }
            if (b == ModBlocks.statue && (loc = ((BlockDummyable)b).findCoreRec(world, x, y, z)) != null && (prop = (TileEntityStatue)world.func_147438_o(loc[0], loc[1], loc[2])) != null && prop.operational()) {
                owner.owner.multPrestige(0.975f, world);
            }
        }
    }

    private boolean canBreak(EntityPlayer player, Clowder clowder, ClowderTerritory.Ownership owner, Block b, int x, int y, int z) {
        if (player.field_71071_by.func_146028_b(ModItems.debug)) {
            return true;
        }
        if (owner.zone == ClowderTerritory.Zone.SAFEZONE || owner.zone == ClowderTerritory.Zone.WARZONE) {
            return false;
        }
        if (owner.zone == ClowderTerritory.Zone.FACTION) {
            if (clowder != owner.owner) {
                if (clowder != null && !clowder.isRaidable()) {
                    return false;
                }
                if (!owner.owner.isRaidable()) {
                    return false;
                }
                if (player.func_70694_bm() == null) {
                    return false;
                }
                return player.func_70694_bm().func_77973_b() == ModItems.mace && ItemMace.breakOverride.contains(b);
            }
            if (player.field_70170_p.func_147439_a(x, y, z) == ModBlocks.officer_chest && clowder.getPermLevel(player.getDisplayName()) < 2) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You lack the permissions to destroy this chest."));
                return false;
            }
            if (player.field_70170_p.func_147439_a(x, y, z) != ModBlocks.clowder_flag) {
                for (int i = x - 2; i <= x + 2; ++i) {
                    for (int j = z - 2; j <= z + 2; ++j) {
                        if (player.field_70170_p.func_147439_a(i, y + 1, j) != ModBlocks.clowder_flag) continue;
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Please refrain from breaking the flag's foundation."));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean canPlace(EntityPlayer player, Clowder clowder, ClowderTerritory.Ownership owner, Block b, int x, int y, int z) {
        if (player.field_71071_by.func_146028_b(ModItems.debug)) {
            return true;
        }
        if (owner.zone == ClowderTerritory.Zone.SAFEZONE || owner.zone == ClowderTerritory.Zone.WARZONE) {
            return false;
        }
        if (owner.zone == ClowderTerritory.Zone.FACTION) {
            if (ItemMace.placeOverride.contains(b)) {
                return true;
            }
            if (clowder != owner.owner && !clowder.isRaidable()) {
                return false;
            }
            if (player.field_70170_p.func_147439_a(x, y, z) != ModBlocks.clowder_flag) {
                for (int i = x - 2; i <= x + 2; ++i) {
                    for (int j = z - 2; j <= z + 2; ++j) {
                        int h = player.field_70170_p.func_72976_f(i, j);
                        if (player.field_70170_p.func_147439_a(i, h, j) != ModBlocks.clowder_flag && player.field_70170_p.func_147439_a(i, h - 2, j) != ModBlocks.clowder_flag) continue;
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Please refrain from obstructing the flag."));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @SubscribeEvent
    public void clowderExplosionEvent(ExplosionEvent.Detonate event) {
        boolean bb = true;
        int x = (int)event.explosion.field_77284_b;
        int y = (int)event.explosion.field_77285_c;
        int z = (int)event.explosion.field_77282_d;
        ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts(x, z);
        if (!ClowderEvents.canExplode(owner, event.world, x, y, z)) {
            event.getAffectedBlocks().clear();
            bb = false;
        }
        ExplosionSound.handleExplosion(event.world, event.explosion);
    }

    public static boolean canExplode(ClowderTerritory.Ownership owner, World world, int x, int y, int z) {
        if (owner.zone == ClowderTerritory.Zone.SAFEZONE || owner.zone == ClowderTerritory.Zone.WARZONE) {
            return false;
        }
        if (owner.zone == ClowderTerritory.Zone.FACTION) {
            if (!owner.owner.isRaidable()) {
                return false;
            }
            for (int i = x - 2; i <= x + 2; ++i) {
                for (int j = z - 2; j <= z + 2; ++j) {
                    if (world.func_147439_a(i, y + 1, j) != ModBlocks.clowder_flag) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @SubscribeEvent
    public void clowderContainerEvent(PlayerInteractEvent event) {
        int x = event.x;
        int y = event.y;
        int z = event.z;
        EntityPlayer player = event.entityPlayer;
        Block b = event.world.func_147439_a(x, y, z);
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            Clowder clowder;
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.debug) {
                return;
            }
            ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts(x, z);
            if (owner != null && !this.canInteract(player, clowder = Clowder.getClowderFromPlayer(event.entityPlayer), owner, b, event)) {
                event.setCanceled(true);
            }
        }
    }

    private boolean canInteract(EntityPlayer player, Clowder clowder, ClowderTerritory.Ownership owner, Block b, PlayerInteractEvent event) {
        if (player.field_71071_by.func_146028_b(ModItems.debug)) {
            return true;
        }
        if (owner.zone == ClowderTerritory.Zone.FACTION && clowder != owner.owner) {
            if (clowder == null || !clowder.isRaidable() || !owner.owner.isRaidable()) {
                return false;
            }
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.mace && ItemMace.interactOverride.contains(b) && owner.owner.isRaidable()) {
                return true;
            }
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Item.func_150898_a((Block)ModBlocks.clowder_conquerer)) {
                return true;
            }
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Item.func_150898_a((Block)ModBlocks.barricade)) {
                int x = event.x;
                int y = event.y;
                y -= 8;
                int z = event.z;
                z -= 8;
                for (int u = x -= 8; u < x + 16; ++u) {
                    for (int v = y; v < y + 16; ++v) {
                        for (int w = z; w < z + 16; ++w) {
                            if (player.field_70170_p.func_147439_a(u, v, w) != ModBlocks.clowder_conquerer) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }
        return true;
    }

    private void flagPopup(World world, EntityPlayer player) {
        String past;
        ClowderTerritory.TerritoryMeta meta = ClowderTerritory.getMetaFromIntCoords((int)player.field_70165_t, (int)player.field_70161_v - 1);
        ClowderTerritory.Ownership owner = meta == null ? ClowderTerritory.WILDERNESS : meta.owner;
        String name = owner.zone.toString();
        if (owner.zone == ClowderTerritory.Zone.FACTION) {
            name = owner.owner.name;
        }
        if (meta != null) {
            name = name + meta.name;
        }
        if ((past = player.getEntityData().func_74779_i(NBTKEY)).isEmpty()) {
            player.getEntityData().func_74778_a(NBTKEY, name);
            return;
        }
        if (!name.equals(past)) {
            if (owner.zone == ClowderTerritory.Zone.FACTION) {
                String title = meta == null ? "" : meta.name;
                PacketDispatcher.wrapper.sendTo((IMessage)new ClowderFlagPacket(owner.owner, title), (EntityPlayerMP)player);
                Clowder mine = Clowder.getClowderFromPlayer(player);
                if (player.field_71071_by.func_146028_b(ModItems.mace) && mine != owner.owner) {
                    owner.owner.notifyAll(player.field_70170_p, new ChatComponentText(CommandClowder.ERROR + "A raider has just entered your territory!"));
                }
            } else {
                PacketDispatcher.wrapper.sendTo((IMessage)new ClowderFlagPacket(name), (EntityPlayerMP)player);
            }
        }
        player.getEntityData().func_74778_a(NBTKEY, name);
    }

    private static void particleBorder2(World world, EntityPlayer player) {
        if (world.field_73012_v.nextInt(3) != 0) {
            return;
        }
        int ox = (int)player.field_70165_t / 16 * 16;
        int oz = (int)player.field_70161_v / 16 * 16;
        int range = 4;
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                ClowderTerritory.Ownership center = ClowderTerritory.getOwnerFromInts(ox + x * 16 + 1, oz + z * 16);
                ClowderTerritory.Ownership north = ClowderTerritory.getOwnerFromInts(ox + (x + ForgeDirection.NORTH.offsetX) * 16 + 1, oz + (z + ForgeDirection.NORTH.offsetZ) * 16);
                ClowderTerritory.Ownership west = ClowderTerritory.getOwnerFromInts(ox + (x + ForgeDirection.WEST.offsetX) * 16 + 1, oz + (z + ForgeDirection.WEST.offsetZ) * 16);
                ClowderTerritory.Ownership none = ClowderTerritory.WILDERNESS;
                boolean n = ClowderEvents.isTerritoryDifferent(north, center);
                boolean w = ClowderEvents.isTerritoryDifferent(west, center);
                int nc = ((center != none ? center.getColor() : (north != none ? north.getColor() : 0)) + (north != none ? north.getColor() : (center != none ? center.getColor() : 0))) / 2;
                int wc = ((center != none ? center.getColor() : (west != none ? west.getColor() : 0)) + (west != none ? west.getColor() : (center != none ? center.getColor() : 0))) / 2;
                if (n) {
                    PacketDispatcher.wrapper.sendTo((IMessage)new ClowderBorderPacket(ox + x * 16, oz + z * 16, ox + (x - ForgeDirection.WEST.offsetX) * 16, oz + (z - ForgeDirection.WEST.offsetZ) * 16, nc), (EntityPlayerMP)player);
                }
                if (!w) continue;
                PacketDispatcher.wrapper.sendTo((IMessage)new ClowderBorderPacket(ox + x * 16, oz + z * 16, ox + (x - ForgeDirection.NORTH.offsetX) * 16, oz + (z - ForgeDirection.NORTH.offsetZ) * 16, wc), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void entityInit(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        Class<?> MCH_EntityBaseBullet = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityBaseBullet");
        Class<?> MCH_EntityBullet = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityBullet");
        Class<?> MCH_EntityRocket = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityRocket");
        if (!(MCH_EntityBaseBullet.isInstance(entity) || MCH_EntityBullet.isInstance(entity) || MCH_EntityRocket.isInstance(entity))) {
            return;
        }
        ClowderTerritory.Ownership owner = ClowderTerritory.getOwner((int)entity.field_70165_t, (int)entity.field_70161_v);
        if (owner.zone == ClowderTerritory.Zone.SAFEZONE) {
            entity.func_70106_y();
            event.setCanceled(true);
        }
    }

    private static boolean isTerritoryDifferent(ClowderTerritory.Ownership one, ClowderTerritory.Ownership two) {
        if (one == null && two != null) {
            return true;
        }
        if (one != null && two == null) {
            return true;
        }
        if (one != null && two != null) {
            if (one.zone != two.zone) {
                return true;
            }
            if (one.owner != two.owner) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        if (entity instanceof EntityArrow || entity instanceof EntityThrowable || entity instanceof EntityFireball) {
            ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts((int)entity.field_70165_t, (int)entity.field_70161_v);
            if (owner != null && owner.zone == ClowderTerritory.Zone.SAFEZONE) {
                event.setCanceled(true);
                entity.func_70106_y();
                return;
            }
        } else {
            ClowderTerritory.Ownership owner;
            Class<?> MCH_EntityBullet = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityBullet");
            Class<?> MCH_EntityBaseBullet = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityBaseBullet");
            Class<?> MCH_EntityRocket = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityRocket");
            if ((MCH_EntityBullet != null && MCH_EntityBullet.isInstance(entity) || MCH_EntityBaseBullet != null && MCH_EntityBaseBullet.isInstance(entity) || MCH_EntityRocket != null && MCH_EntityRocket.isInstance(entity)) && (owner = ClowderTerritory.getOwnerFromInts((int)entity.field_70165_t, (int)entity.field_70161_v)) != null && owner.zone == ClowderTerritory.Zone.SAFEZONE) {
                event.setCanceled(true);
                entity.func_70106_y();
                return;
            }
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingAttackEvent event) {
        EntityLivingBase e = event.entityLiving;
        DamageSource dmg = event.source;
        ClowderTerritory.Ownership owner = ClowderTerritory.getOwner((int)e.field_70165_t, (int)e.field_70161_v);
        if (e instanceof EntityPlayer && owner != null && owner.zone == ClowderTerritory.Zone.SAFEZONE) {
            event.setCanceled(true);
        }
    }

    private void checkAndDeleteProjectile(Entity entity) {
        if (entity instanceof EntityArrow || entity instanceof EntityThrowable || entity instanceof EntityFireball) {
            ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts((int)entity.field_70165_t, (int)entity.field_70161_v);
            if (owner != null && owner.zone == ClowderTerritory.Zone.SAFEZONE) {
                entity.func_70106_y();
            }
        } else {
            ClowderTerritory.Ownership owner;
            Class<?> MCH_EntityBullet = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityBullet");
            Class<?> MCH_EntityBaseBullet = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityBaseBullet");
            Class<?> MCH_EntityRocket = ReflectionUtils.getClass("mcheli.weapon.MCH_EntityRocket");
            if ((MCH_EntityBullet != null && MCH_EntityBullet.isInstance(entity) || MCH_EntityBaseBullet != null && MCH_EntityBaseBullet.isInstance(entity) || MCH_EntityRocket != null && MCH_EntityRocket.isInstance(entity)) && (owner = ClowderTerritory.getOwnerFromInts((int)entity.field_70165_t, (int)entity.field_70161_v)) != null && owner.zone == ClowderTerritory.Zone.SAFEZONE) {
                try {
                    if (MCH_EntityBullet.isInstance(entity) || MCH_EntityBaseBullet.isInstance(entity)) {
                        ReflectionUtils.setFieldValue(entity, "explosionPower", 0);
                        ReflectionUtils.setFieldValue(entity, "explosionPowerInWater", 0);
                        ReflectionUtils.setFieldValue(entity, "piercing", 0);
                        ReflectionUtils.invokeMethod(entity, "setPower", new Class[]{Integer.TYPE}, 0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                entity.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingHurtEvent event) {
        EntityLivingBase e = event.entityLiving;
        DamageSource dmg = event.source;
        if (e instanceof EntityPlayer) {
            int x = (int)e.field_70165_t;
            int y = (int)e.field_70163_u;
            int z = (int)e.field_70161_v;
            ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts(x, z);
            if (owner != null && owner.zone == ClowderTerritory.Zone.SAFEZONE) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase e = event.entityLiving;
        if (e instanceof EntityPlayer) {
            int x = (int)e.field_70165_t;
            int y = (int)e.field_70163_u;
            int z = (int)e.field_70161_v;
            ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts(x, z);
            if (owner != null && owner.zone == ClowderTerritory.Zone.SAFEZONE) {
                e.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 40));
                e.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40));
                e.func_70691_i(5.0f);
                e.func_70690_d(new PotionEffect(HbmPotion.radaway.field_76415_H, 50));
                e.func_70690_d(new PotionEffect(HbmPotion.radx.field_76415_H, 110));
                HbmLivingProps.incrementRadiation((EntityLivingBase)e, (float)(-HbmLivingProps.getRadiation((EntityLivingBase)e)));
                e.func_82170_o(HbmPotion.radiation.field_76415_H);
                IAttributeInstance knockbackResistance = e.func_110148_a(SharedMonsterAttributes.field_111266_c);
                if (knockbackResistance != null) {
                    knockbackResistance.func_111128_a(1.0);
                }
            } else {
                IAttributeInstance knockbackResistance = e.func_110148_a(SharedMonsterAttributes.field_111266_c);
                if (knockbackResistance != null) {
                    knockbackResistance.func_111128_a(0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        int z;
        World world = event.world;
        Explosion explosion = event.explosion;
        Vec3 explosionPos = Vec3.func_72443_a((double)explosion.field_77284_b, (double)explosion.field_77285_c, (double)explosion.field_77282_d);
        int x = MathHelper.func_76128_c((double)explosionPos.field_72450_a);
        ClowderTerritory.Ownership owner = ClowderTerritory.getOwner(x, z = MathHelper.func_76128_c((double)explosionPos.field_72449_c));
        if (owner != null && owner.zone == ClowderTerritory.Zone.SAFEZONE) {
            event.getAffectedBlocks().clear();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        ClowderTerritory.Ownership owner = ClowderTerritory.getOwner(x, z);
        if (owner != null && owner.zone == ClowderTerritory.Zone.SAFEZONE) {
            EntityPlayer entity = event.getPlayer();
            Class<?> MCH_EntityAircraft = ReflectionUtils.getClass("mcheli.MCH_EntityAircraft");
            if (MCH_EntityAircraft != null && MCH_EntityAircraft.isInstance(entity)) {
                event.setCanceled(true);
            }
            event.setCanceled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        String name = player.getDisplayName();
        if (!player.field_70170_p.field_72995_K) {
            ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts((int)player.field_70165_t, (int)player.field_70161_v - 1);
            this.flagPopup(player.field_70170_p, player);
            Clowder clowder = Clowder.getClowderFromPlayer(player);
            if (clowder != null && clowder.members.get(name) != null) {
                EntityPlayerMP mp = (EntityPlayerMP)player;
                if (!mp.field_71135_a.field_147371_a.func_150724_d()) {
                    System.out.println("Player " + player.getDisplayName() + " has been ticked, even though they are disconnected!");
                    return;
                }
                if (Clowder.retreating.contains(name)) {
                    // empty if block
                }
            } else if (owner != null && owner.zone == ClowderTerritory.Zone.FACTION) {
                player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 20, 2));
                player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 20, 2));
                player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 20, 1));
            }
            ClowderEvents.particleBorder2(player.field_70170_p, player);
            if (player.field_71071_by.field_70460_b[0] != null && player.field_71071_by.field_70460_b[0].func_77973_b() == ModItems.clowder_banner) {
                ItemStack banner = player.field_71071_by.field_70460_b[0];
                if (clowder != null) {
                    if (!banner.func_77942_o()) {
                        banner.field_77990_d = new NBTTagCompound();
                    }
                    banner.field_77990_d.func_74768_a("flag", clowder.flag.ordinal());
                    banner.field_77990_d.func_74768_a("color", clowder.color);
                }
            }
        }
    }

    @SubscribeEvent
    public void myBonesHurtEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        String name = player.getDisplayName();
        Clowder clowder = Clowder.getClowderFromPlayer(player);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            List entities = event.world.field_72996_f;
            for (Entity entity : entities) {
                this.checkAndDeleteProjectile(entity);
            }
        }
        World world = event.world;
        if (world.field_72995_K || world.field_73011_w.field_76574_g != 0 || event.phase == TickEvent.Phase.END) {
            return;
        }
        if (this.hour > 0) {
            --this.hour;
        } else {
            this.hour = MainRegistry.prestigeDelay;
            Clowder.updatePrestige(world);
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.delay = MainRegistry.territoryDelay;
        ArrayList<Long> rem = new ArrayList<Long>();
        for (Long time : Clowder.teleports.keySet()) {
            Clowder.ScheduledTeleport tp = Clowder.teleports.get(time);
            EntityPlayer player = world.func_72924_a(tp.player);
            if (player == null) continue;
            if (time < System.currentTimeMillis()) {
                ClowderTerritory.Ownership owner = ClowderTerritory.getOwnerFromInts(tp.posX, tp.posZ);
                Clowder me = Clowder.getClowderFromPlayer(player);
                if (owner == null || owner.zone != ClowderTerritory.Zone.FACTION || owner.owner != me) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(CommandClowder.ERROR + "Warp destination appears to be outside of your territory."));
                    player.func_145747_a((IChatComponent)new ChatComponentText(CommandClowder.ERROR + "Warp aborted."));
                } else if (player instanceof EntityPlayerMP) {
                    EntityPlayerMP playermp = (EntityPlayerMP)player;
                    playermp.func_70078_a(null);
                    playermp.field_71135_a.func_147364_a((double)tp.posX + 0.5, (double)tp.posY, (double)tp.posZ + 0.5, player.field_70177_z, player.field_70125_A);
                    if (!tp.home) {
                        me.notifyAll(world, new ChatComponentText(CommandClowder.INFO + "Player " + player.getDisplayName() + " is warping to " + tp.warp + "!"));
                    } else {
                        me.notifyAll(world, new ChatComponentText(CommandClowder.INFO + "Player " + player.getDisplayName() + " is warping home!"));
                        playermp.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 60, 9));
                    }
                }
                rem.add(time);
                continue;
            }
            if (player.field_70165_t == player.field_70142_S && player.field_70161_v == player.field_70136_U) continue;
            rem.add(time);
            player.func_145747_a((IChatComponent)new ChatComponentText(CommandClowder.ERROR + "Warp aborted!"));
        }
        for (Long time : rem) {
            Clowder.teleports.remove(time);
        }
    }

    @SubscribeEvent
    public void yeetEvent(ItemTossEvent event) {
        try {
            if (event.entityItem.func_92059_d().func_77973_b() == ModItems.capsule) {
                event.player.field_71071_by.func_70441_a(new ItemStack(ModItems.capsule));
                event.player.field_71071_by.func_70441_a(new ItemStack(ModItems.capsule));
                event.setCanceled(true);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    static {
        if (MCH_CONFIG == null || MCH_ENTITY_BULLET == null || MCH_ENTITY_AIRCRAFT == null || MCH_ENTITY_BASE_BULLET == null || MCH_ENTITY_ROCKET == null) {
            System.out.println("[Clowder] Warning: One or more MCHeli classes could not be found. Ensure MCHeli is installed.");
        } else {
            System.out.println("[Clowder] Successfully loaded MCHeli classes via reflection.");
        }
    }
}

