/*
 * Decompiled with CFR 0.152.
 */
package com.hfr.clowder;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public enum ClowderFlag {
    NONE("none", false),
    TRICOLOR("tri"),
    TRICOLOR_VERTICAL("vtri"),
    BCROSS("bcross"),
    WCROSS("wcross"),
    JULIA("julia"),
    USSR("ussr"),
    ASTERISK("asterisk"),
    PONYCUM("pc", false);

    public String name = "";
    public boolean show = true;
    private ResourceLocation flag;
    private ResourceLocation overlay;
    public static final ResourceLocation WILDERNESS;
    public static final ResourceLocation SAFEZONE;
    public static final ResourceLocation WARZONE;

    private ClowderFlag(String name) {
        this.name = name;
        this.flag = new ResourceLocation(this.getLoc() + ".png");
        this.overlay = new ResourceLocation(this.getLoc() + "_overlay.png");
    }

    private ClowderFlag(String name, boolean show) {
        this.name = name;
        this.show = show;
        this.flag = new ResourceLocation(this.getLoc() + ".png");
        this.overlay = new ResourceLocation(this.getLoc() + "_overlay.png");
    }

    private ClowderFlag(String name, boolean show, boolean base, boolean over) {
        this.name = name;
        this.show = show;
        this.flag = base ? new ResourceLocation(this.getCustomLoc() + ".png") : new ResourceLocation("hfr:textures/flags/flag_blank.png");
        this.overlay = over ? new ResourceLocation(this.getCustomLoc() + "_overlay.png") : new ResourceLocation("hfr:textures/flags/flag_blank.png");
    }

    private String getLoc() {
        return "hfr:textures/flags/flag_" + this.name;
    }

    private String getCustomLoc() {
        return "hfr:textures/customflags/flag_" + this.name;
    }

    public ResourceLocation getFlag() {
        return this.flag;
    }

    public ResourceLocation getFlagOverlay() {
        return this.overlay;
    }

    public static ClowderFlag getFromName(String name) {
        for (ClowderFlag flag : ClowderFlag.values()) {
            if (!flag.name.toLowerCase().equals(name.toLowerCase())) continue;
            return flag;
        }
        return NONE;
    }

    public static List<String> getFlags() {
        ArrayList<String> list = new ArrayList<String>();
        for (ClowderFlag flag : ClowderFlag.values()) {
            if (!flag.show) continue;
            list.add(flag.name);
        }
        return list;
    }

    static {
        WILDERNESS = new ResourceLocation("hfr:textures/flags/special_wilderness.png");
        SAFEZONE = new ResourceLocation("hfr:textures/flags/special_safezone.png");
        WARZONE = new ResourceLocation("hfr:textures/flags/special_warzone.png");
    }
}

